/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.common;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.chronos.common.IOUtil;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.JDOMException;

public class TestDataDirectory {
    private File dataDirectory;
    public static final String GC_FILE_PREFIX = "gc";
    public static final String XML_FILE_EXTENSION = "xml";
    private static final String PERFORMANCESAMPLE_FILE_PREFIX = "perf";
    private String name;
    private Log log;

    TestDataDirectory(File chronosDir, String dataId, Log log) {
        this.dataDirectory = new File(chronosDir, dataId);
        this.name = dataId;
        this.log = log;
    }

    public String getDataId() {
        return this.name;
    }

    public GCSamples readGCSamples() throws JDOMException, IOException {
        File[] gcFiles = this.listFilesWith(GC_FILE_PREFIX, XML_FILE_EXTENSION);
        GCSamples samples = new GCSamples();
        if (gcFiles != null) {
            for (File gcFile : gcFiles) {
                GCSamples tmp = GCSamples.fromXML(gcFile);
                samples.addAll(tmp);
            }
        }
        return samples;
    }

    public GroupedResponsetimeSamples readResponsetimeSamples() throws JDOMException, IOException {
        File[] dirContent = this.listFilesWith(PERFORMANCESAMPLE_FILE_PREFIX, XML_FILE_EXTENSION);
        GroupedResponsetimeSamples result = new GroupedResponsetimeSamples();
        for (File file : dirContent) {
            result.addAll(GroupedResponsetimeSamples.fromXmlFile(file));
        }
        return result;
    }

    public File[] listFilesWith(final String prefix, final String extension) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File parentDir, String name) {
                return name.startsWith(prefix + "-") && name.endsWith("." + extension);
            }
        };
        return IOUtil.listFiles(this.dataDirectory, filenameFilter);
    }

    public void writeResponsetimeSamples(String jtlName, Element samplesElement) throws IOException {
        this.ensure();
        File performanceSamplesXml = new File(this.dataDirectory, IOUtil.getAdjustedFileName(jtlName, PERFORMANCESAMPLE_FILE_PREFIX, XML_FILE_EXTENSION));
        DocType docType = new DocType("responsetimesamples", "SYSTEM", "chronos-responsetimesamples.dtd");
        IOUtil.writeXmlToFile(performanceSamplesXml, samplesElement, docType);
    }

    public void writeGCLog(Element gcSamplesXml) throws IOException {
        this.ensure();
        File file = new File(this.dataDirectory, "gc-" + this.name + '.' + XML_FILE_EXTENSION);
        this.log.debug((CharSequence)("Writing garbage collection log to " + file));
        IOUtil.writeXmlToFile(file, gcSamplesXml, new DocType("gcsamples", "SYSTEM", "chronos-gc.dtd"));
    }

    public TestDataDirectory ensure() {
        IOUtil.ensureDir(this.dataDirectory);
        return this;
    }

    public File getDirectory() {
        return this.dataDirectory;
    }
}

