/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.chronos.common.IOUtil;
import org.codehaus.mojo.chronos.common.ProjectBaseDir;
import org.codehaus.mojo.chronos.common.TestDataDirectory;
import org.codehaus.mojo.chronos.jmeter.JMeterMojo;
import org.codehaus.mojo.chronos.jmeter.JMeterOutputMojo;
import org.codehaus.mojo.chronos.jmeter.JavaCommand;
import org.codehaus.plexus.util.cli.CommandLineException;

public class JMeterTestMojo
extends JMeterMojo {
    public MavenProject project;
    private File input;
    private String dataid;
    private boolean loggc;
    private File gclogfile;
    private List gcargs;
    private String bootstrapper;
    private Properties jmeterVariables;

    public void setInput(File input) {
        this.input = input;
    }

    public void setDataid(String dataId) {
        this.dataid = dataId;
    }

    public void setLoggc(boolean loggc) {
        this.loggc = loggc;
    }

    public void setGclogfile(File gclogfile) {
        this.gclogfile = gclogfile;
    }

    public void execute() throws MojoExecutionException {
        if (!this.input.exists()) {
            throw new MojoExecutionException("Invalid argument 'input', " + this.input.getPath() + " does not exist.");
        }
        ProjectBaseDir projectBaseDir = new ProjectBaseDir(this.project, this.getLog());
        TestDataDirectory dir = projectBaseDir.getDataDirectory(this.dataid).ensure();
        if (this.input.isDirectory()) {
            File[] jmxFiles = IOUtil.listFilesWithExtension((File)this.input, (String)"jmx");
            for (int i = 0; i < jmxFiles.length; ++i) {
                File outputJtlFile = this.getOutputJtlFile(dir, jmxFiles[i]);
                this.executeJMeterIfNecessary(jmxFiles[i], outputJtlFile);
            }
        } else if (this.isJmxFile(this.input)) {
            File outputJtlFile = this.getOutputJtlFile(dir, this.input);
            this.executeJMeterIfNecessary(this.input, outputJtlFile);
        } else {
            this.getLog().info((CharSequence)("jtl file " + this.input.getAbsolutePath() + " specified as input. Skipping jmeter..."));
        }
    }

    private void executeJMeterIfNecessary(File inputJmxFile, File outputJtlFile) throws MojoExecutionException {
        if (outputJtlFile.exists() && inputJmxFile.lastModified() > outputJtlFile.lastModified()) {
            this.getLog().info((CharSequence)"clearing old testlog");
            outputJtlFile.delete();
        }
        if (!outputJtlFile.exists()) {
            this.ensureJMeter();
            if (this.bootstrapper != null) {
                this.getLog().info((CharSequence)("Launching bootstrapClassName " + this.bootstrapper));
                this.getBootstrapLauncher(this.bootstrapper).exe();
            } else {
                this.getLog().info((CharSequence)"No bootstrapper class found");
            }
            this.getLog().info((CharSequence)("Excuting test " + inputJmxFile.getPath()));
            this.getJMeterLauncher(inputJmxFile, outputJtlFile).exe();
        } else {
            this.getLog().info((CharSequence)("jtl file " + outputJtlFile.getAbsolutePath() + " up-to-date, skipping..."));
        }
        ProjectBaseDir projectBaseDir = new ProjectBaseDir(this.project, this.getLog());
        TestDataDirectory testDataDirectory = projectBaseDir.getDataDirectory(this.dataid);
        JMeterOutputMojo.parseJMeterOutput(testDataDirectory, outputJtlFile);
        JMeterOutputMojo.parseGCLog(testDataDirectory, this.getGcLogFile());
    }

    private CommandLauncher getBootstrapLauncher(final String bootstrapClassName) {
        return new CommandLauncher(){

            public void exe() throws MojoExecutionException {
                JavaCommand bootstrapCmd = new JavaCommand(JMeterTestMojo.this.project.getBasedir().getAbsolutePath(), JMeterTestMojo.this.getLog());
                bootstrapCmd.addArgument("-cp");
                StringBuffer classPath = new StringBuffer();
                Iterator it = JMeterTestMojo.this.getDependencyUtil().getDependencies(JMeterTestMojo.this.project).iterator();
                while (it.hasNext()) {
                    Artifact artifact = (Artifact)it.next();
                    classPath.append(artifact.getFile());
                    if (!it.hasNext()) continue;
                    classPath.append(File.pathSeparatorChar);
                }
                bootstrapCmd.addArgument(classPath.toString());
                bootstrapCmd.addArgument(bootstrapClassName);
                try {
                    int result = bootstrapCmd.execute();
                    if (result != 0) {
                        throw new MojoExecutionException("Result of " + bootstrapCmd + " execution is: '" + result + "'.");
                    }
                }
                catch (CommandLineException e) {
                    throw new MojoExecutionException("Could not create bootstrapClassName", (Exception)((Object)e));
                }
            }
        };
    }

    private CommandLauncher getJMeterLauncher(final File inputJmxFile, final File outputJtlFile) {
        return new CommandLauncher(){

            public void exe() throws MojoExecutionException {
                JavaCommand java = JMeterTestMojo.this.getJavaLauncher();
                java.addArgument("-jar");
                String jmeterJar = JMeterTestMojo.this.getJmeterJar().getAbsolutePath();
                java.addArgument(jmeterJar);
                java.addArgument("-n");
                java.addArgument("-t");
                java.addArgument(inputJmxFile.getAbsolutePath());
                java.addArgument("-l");
                java.addArgument(outputJtlFile.getAbsolutePath());
                java.addArgument("-j");
                java.addArgument("target/jmeter.log");
                if (JMeterTestMojo.this.jmeterVariables != null) {
                    Enumeration<?> variableNames = JMeterTestMojo.this.jmeterVariables.propertyNames();
                    while (variableNames.hasMoreElements()) {
                        String name = (String)variableNames.nextElement();
                        String value = JMeterTestMojo.this.jmeterVariables.getProperty(name);
                        java.addNameValue("-J" + name, value);
                    }
                }
                JMeterTestMojo.this.executeJmeter(java);
            }
        };
    }

    private boolean isJmxFile(File input) {
        return input.getName().endsWith(".jmx");
    }

    private File getOutputJtlFile(TestDataDirectory dir, File inputFile) {
        String inputName = IOUtil.removeExtension((String)inputFile.getName());
        return new File(dir.getDirectory(), inputName + ".jtl");
    }

    private final File getGcLogFile() {
        if (!this.loggc) {
            return null;
        }
        if (this.gclogfile != null) {
            return this.gclogfile;
        }
        File chronosDir = new ProjectBaseDir(this.getProject().getBasedir(), this.getLog()).getDataDirectory(this.dataid).getDirectory();
        File defaultGCLog = new File(chronosDir, "gclog-" + this.dataid + ".txt");
        return defaultGCLog;
    }

    protected final MavenProject getProject() {
        return this.project;
    }

    protected final void appendGcArgs(JavaCommand java) {
        File gclog = this.getGcLogFile();
        if (gclog != null) {
            if (this.isSupportingVerboseGc()) {
                java.addArgument("-verbose:gc");
                java.addArgument("-Xloggc:" + gclog.getAbsolutePath());
            } else if (this.gcargs != null) {
                Iterator iterator = this.gcargs.iterator();
                while (iterator.hasNext()) {
                    java.addArgument((String)iterator.next());
                }
            }
        }
    }

    private boolean isSupportingVerboseGc() {
        String jvmVendor = System.getProperty("java.vendor");
        return jvmVendor.startsWith("Sun ") || jvmVendor.startsWith("Apple");
    }

    static interface CommandLauncher {
        public void exe() throws MojoExecutionException;
    }
}

