/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:chronos-jmeter-maven-plugin:1.0-beta-3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Chronos JMeter", 0);
        this.append(sb, "Plugin for testing performance with jmeter", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "chronos-jmeter:check", 0);
            this.append(sb, "Checks the latest performancetests to verify that performance targets have been met. Extends abstract baseclass inside the reporting plugin to avoid duplication of code.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "averageduration (Default: 20000)", 2);
                this.append(sb, "The timeinterval to base moving average calculations on (in millis).", 3);
                this.append(sb, "", 0);
                this.append(sb, "collectedprsecond", 2);
                this.append(sb, "The maximum memory (in kb) garbagecollected pr second.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dataid (Default: performancetest)", 2);
                this.append(sb, "The id of the JMeter test", 3);
                this.append(sb, "", 0);
                this.append(sb, "gctimeratio", 2);
                this.append(sb, "The maximum allowed ratio of time spent garbage collecting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxthroughput", 2);
                this.append(sb, "The minimum required maximum throughput (in requests/sec).", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The current maven project.", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "responsetime95", 2);
                this.append(sb, "The maximum acceptable 95 percentage responsetime (in millis).", 3);
                this.append(sb, "", 0);
                this.append(sb, "responsetime99", 2);
                this.append(sb, "The maximum acceptable 99 percentage responsetime (in millis).", 3);
                this.append(sb, "", 0);
                this.append(sb, "responsetimeaverage", 2);
                this.append(sb, "The maximum acceptable average responsetime (in millis).", 3);
                this.append(sb, "", 0);
                this.append(sb, "responsetimemax", 2);
                this.append(sb, "The maximum acceptable responsetime (in millis).", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopOnFailed (Default: false)", 2);
                this.append(sb, "Determines if the build should fail if at least one of the samples failed.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "chronos-jmeter:help", 0);
            this.append(sb, "Display help information on chronos-jmeter-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0chronos-jmeter:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jmeter".equals(this.goal)) {
            this.append(sb, "chronos-jmeter:jmeter", 0);
            this.append(sb, "Invokes JMeter.\nJMeter is invoked by spawning a separate process to make it possible to control startup parameters. Can also be used by specifying a .jtl file as input and (possibly) a garbage collection logfile.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "bootstrapper", 2);
                this.append(sb, "Clasname of an (optional) bootstrapperclass. The purpose is to allow bootstrapping the proces eg. by initializing testdata in a relational database without measuring the time.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dataid (Default: performancetest)", 2);
                this.append(sb, "The id of the jmeter invocation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gcargs", 2);
                this.append(sb, "Configuration parameters used for configurating the .", 3);
                this.append(sb, "", 0);
                this.append(sb, "gclogfile", 2);
                this.append(sb, "The name of an (optional) garbage collection logfile. Only used when loggc is set to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "heap (Default: 256m)", 2);
                this.append(sb, "The heapsize (both initial and max) of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "input", 2);
                this.append(sb, "The inputfile. This could either be a .jmx file or a folder containing .jmx files. jmeter is invoked, and corresponding .jtl file(s) generated.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmeterhome", 2);
                this.append(sb, "The path to the jmeter installation. The recommended way to set this is by specifying a property jmeter.home in the pom.xml or settings.xml.\n", 3);
                this.append(sb, "Expression: ${project.basedir}/jmeter", 3);
                this.append(sb, "", 0);
                this.append(sb, "jMeterRemoteLocation (Default: http://www.eu.apache.org/dist/jakarta/jmeter/binaries/jakarta-jmeter-2.5.1.zip)", 2);
                this.append(sb, "The URL from where jMeter can be downloaded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmeterVariables", 2);
                this.append(sb, "Additional arguments supplied to jmeter. like invoking the jmeter startup script with using jmeterargumensts like -Jvariable=value", 3);
                this.append(sb, "", 0);
                this.append(sb, "loggc (Default: true)", 2);
                this.append(sb, "Will garbage collections be logged? Note that this is really only relevant if your tests are junitsamples in jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxliveobjectevacuationratio", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxtenuringthreshold (Default: 2)", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "newsize (Default: 128m)", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Optional Miscellaneous configuration parameters used when launching JMeter", 3);
                this.append(sb, "", 0);
                this.append(sb, "permsize (Default: 64m)", 2);
                this.append(sb, "The size of the part of the spawned jmeter jvm's memory, where classes e.g. are stored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The current maven project.", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rmigcinterval (Default: 600000)", 2);
                this.append(sb, "How often will rmi garbage collections be performed? JVM option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "survivorratio", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sysproperties", 2);
                this.append(sb, "System-properties to the launched jvm.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetsurvivorratio", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jmetergui".equals(this.goal)) {
            this.append(sb, "chronos-jmeter:jmetergui", 0);
            this.append(sb, "Invokes the JMeter gui.\nThe purpose is to create a testplan with the artifacts of the current project in the classpath.\nThis is necessary if the testplan should contain unittests or javaclases from the project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "executedproject", 2);
                this.append(sb, "The 'current' maven project as executed by the package phase.\nWe use this to find dependencies and paths.", 3);
                this.append(sb, "Expression: ${executedProject}", 3);
                this.append(sb, "", 0);
                this.append(sb, "heap (Default: 256m)", 2);
                this.append(sb, "The heapsize (both initial and max) of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmeterhome", 2);
                this.append(sb, "The path to the jmeter installation. The recommended way to set this is by specifying a property jmeter.home in the pom.xml or settings.xml.\n", 3);
                this.append(sb, "Expression: ${project.basedir}/jmeter", 3);
                this.append(sb, "", 0);
                this.append(sb, "jMeterRemoteLocation (Default: http://www.eu.apache.org/dist/jakarta/jmeter/binaries/jakarta-jmeter-2.5.1.zip)", 2);
                this.append(sb, "The URL from where jMeter can be downloaded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxliveobjectevacuationratio", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxtenuringthreshold (Default: 2)", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "newsize (Default: 128m)", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Optional Miscellaneous configuration parameters used when launching JMeter", 3);
                this.append(sb, "", 0);
                this.append(sb, "permsize (Default: 64m)", 2);
                this.append(sb, "The size of the part of the spawned jmeter jvm's memory, where classes e.g. are stored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rmigcinterval (Default: 600000)", 2);
                this.append(sb, "How often will rmi garbage collections be performed? JVM option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "survivorratio", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sysproperties", 2);
                this.append(sb, "System-properties to the launched jvm.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetsurvivorratio", 2);
                this.append(sb, "Specifies the corresponding jvm option of the spawned jvm invoking jmeter.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jmeteroutput".equals(this.goal)) {
            this.append(sb, "chronos-jmeter:jmeteroutput", 0);
            this.append(sb, "Analyzes output from JMeter.\nIs used by specifying one or more .jtl files as input and (possibly) a garbage collection logfile.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dataid (Default: performancetest)", 2);
                this.append(sb, "The id of the jmeter invocation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gclogfile", 2);
                this.append(sb, "The name of an (optional) garbage collection logfile. Only used when loggc is set to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jmeterOutput", 2);
                this.append(sb, "The inputfile of the type .jtl. Will be parsed.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The current maven project.", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "savehistory".equals(this.goal)) {
            this.append(sb, "chronos-jmeter:savehistory", 0);
            this.append(sb, "Save a snapshot of the currently executed test to enable later historic reports.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dataid (Default: performancetest)", 2);
                this.append(sb, "The id of the currently executed performancetest.", 3);
                this.append(sb, "", 0);
                this.append(sb, "historydir", 2);
                this.append(sb, "The directory where historic data are stored.", 3);
                this.append(sb, "Expression: ${basedir}/target/chronos-history", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The current maven project.", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

