/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.jmeter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Content;
import org.jdom.Element;

public final class GCLogParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element convertToChronosFormat(File gcLogFile) throws IOException {
        FileReader fileReader = new FileReader(gcLogFile);
        LineNumberReader reader = new LineNumberReader(fileReader);
        Element xml = new Element("gcsamples");
        ArrayList<Element> sampleXmlList = new ArrayList<Element>();
        StringBuffer concatLines = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                concatLines.append(line);
                if (line.indexOf("]") <= -1) continue;
                Element sampleXml = this.parseGCLogItem(concatLines.toString());
                sampleXmlList.add(sampleXml);
                concatLines.setLength(0);
            }
        }
        finally {
            reader.close();
        }
        for (Element sampleXml : sampleXmlList) {
            xml.addContent((Content)sampleXml);
        }
        return xml;
    }

    private Element parseGCLogItem(String source) {
        String timeinstant = null;
        String heapbeforeStr = null;
        String heapafterStr = null;
        String totalheap = null;
        String processingtimeStr = null;
        Pattern pattern = Pattern.compile("[0-9]*\\.[0-9]*:|[0-9]*K|[0-9]*\\.[0-9]*");
        Matcher matcher = pattern.matcher(source);
        int index = 0;
        while (matcher.find()) {
            if (matcher.group().length() <= 0) continue;
            switch (index) {
                case 0: {
                    timeinstant = matcher.group();
                    timeinstant = timeinstant.substring(0, timeinstant.length() - 1);
                    break;
                }
                case 1: {
                    heapbeforeStr = matcher.group();
                    heapbeforeStr = heapbeforeStr.substring(0, heapbeforeStr.length() - 1);
                    break;
                }
                case 2: {
                    heapafterStr = matcher.group();
                    heapafterStr = heapafterStr.substring(0, heapafterStr.length() - 1);
                    break;
                }
                case 3: {
                    totalheap = matcher.group();
                    totalheap = totalheap.substring(0, totalheap.length() - 1);
                    break;
                }
                case 4: {
                    processingtimeStr = matcher.group();
                    processingtimeStr = matcher.group();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++index;
        }
        Element xml = new Element("gcsample");
        xml.setAttribute("timestamp", timeinstant);
        xml.setAttribute("heapBefore", heapbeforeStr);
        xml.setAttribute("heapAfter", heapafterStr);
        xml.setAttribute("heapTotal", totalheap);
        xml.setAttribute("processingTime", processingtimeStr);
        return xml;
    }
}

