/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.svnlib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.plugin.logging.Log;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

class SvnChangeLogParser
implements ChangeLogParser {
    private static final SimpleDateFormat SVN_TIMESTAMP = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzzzzzzzz");
    private static final Log LOG = ChangeLog.getLog();
    private static final int GET_HEADER = 1;
    private static final int GET_FILE = 2;
    private static final int GET_COMMENT = 3;
    private static final String FILE_BEGIN_TOKEN = " ";
    private static final String FILE_END_TOKEN = "";
    private static final int FILE_START_INDEX = 5;
    private static final String COMMENT_END_TOKEN = "------------------------------------------------------------------------";
    private static final String pattern = "^r(\\d+)\\s+\\|\\s+(\\(\\S+\\s+\\S+\\)|\\S+)\\s+\\|\\s+(\\d+-\\d+-\\d+ \\d+:\\d+:\\d+) ([\\-+])(\\d\\d)(\\d\\d)";
    private int status = 1;
    private Collection entries = new ArrayList();
    private ChangeLogEntry currentLogEntry;
    private String currentRevision;
    private StringBuffer currentComment;
    private RE headerRegexp;
    private ChangeLog changeLog;

    public SvnChangeLogParser() {
        try {
            this.headerRegexp = new RE(pattern);
        }
        catch (RESyntaxException ignored) {
            LOG.error((CharSequence)"Could not create regexp to parse svn log file", (Throwable)ignored);
        }
    }

    public void init(ChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    public void cleanup() {
    }

    public Collection parse(InputStream anInputStream) throws IOException {
        BufferedReader stream = new BufferedReader(new InputStreamReader(anInputStream));
        String line = null;
        block5: while ((line = stream.readLine()) != null) {
            switch (this.status) {
                case 1: {
                    this.processGetHeader(line);
                    continue block5;
                }
                case 2: {
                    this.processGetFile(line);
                    continue block5;
                }
                case 3: {
                    this.processGetComment(line);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown state: " + this.status);
        }
        return this.entries;
    }

    private void processGetHeader(String line) {
        if (!this.headerRegexp.match(line)) {
            return;
        }
        this.currentRevision = this.headerRegexp.getParen(1);
        this.currentLogEntry = new ChangeLogEntry();
        this.currentLogEntry.setAuthor(this.headerRegexp.getParen(2));
        this.currentLogEntry.setDate(this.parseDate());
        this.status = 2;
    }

    private void processGetFile(String line) {
        if (line.startsWith(FILE_BEGIN_TOKEN)) {
            String name = line.substring(5);
            this.currentLogEntry.addFile(new ChangeLogFile(name, this.currentRevision));
            this.status = 2;
        } else if (line.equals(FILE_END_TOKEN)) {
            this.currentComment = new StringBuffer();
            this.status = 3;
        }
    }

    private void processGetComment(String line) {
        if (line.equals(COMMENT_END_TOKEN)) {
            this.currentLogEntry.setComment(this.currentComment.toString());
            this.entries.add(this.currentLogEntry);
            this.status = 1;
        } else {
            this.currentComment.append(line).append('\n');
        }
    }

    private Date parseDate() {
        try {
            StringBuffer date = new StringBuffer().append(this.headerRegexp.getParen(3)).append(" GMT").append(this.headerRegexp.getParen(4)).append(this.headerRegexp.getParen(5)).append(':').append(this.headerRegexp.getParen(6));
            return SVN_TIMESTAMP.parse(date.toString());
        }
        catch (ParseException e) {
            LOG.error((CharSequence)"ParseException Caught", (Throwable)e);
            return null;
        }
    }

    public void setDateFormatInFile(String dateFormat) {
    }
}

