/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFactory;
import org.apache.maven.changelog.ChangeLogGenerator;
import org.apache.maven.changelog.ChangeLogHandler;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.changelog.ChangeLogSet;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChangeLog {
    private String type;
    private String range;
    private String date;
    private String tag;
    private String markerStart;
    private String markerEnd;
    private String dateFormat;
    private File base;
    private String clFactoryClass = null;
    private static final Map FACTORIES = new HashMap();
    private String connection;
    private List developers;
    private Collection sets;
    private static Log LOG = ChangeLog.getLog();
    private File output;
    private String outputEncoding;
    private String commentFormat;

    public void setFactory(String factoryClassName) {
        this.clFactoryClass = factoryClassName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type == null) {
            this.type = "range";
        }
        return this.type;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public String getRange() {
        return this.range;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDate() {
        return this.date;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setMarkerStart(String marker) {
        this.markerStart = marker;
    }

    public String getMarkerStart() {
        return this.markerStart;
    }

    public void setMarkerEnd(String marker) {
        this.markerEnd = marker;
    }

    public String getMarkerEnd() {
        return this.markerEnd;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setBasedir(File base) {
        this.base = base;
    }

    public File getBasedir() {
        return this.base;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public String getRepositoryConnection() {
        return this.connection;
    }

    public void setRepositoryConnection(String aString) {
        this.connection = aString;
    }

    public void doExecute() throws FileNotFoundException, IOException, UnsupportedEncodingException {
        this.generateSets();
        this.replaceAuthorIdWithName();
        if (this.output == null) {
            return;
        }
        this.createDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSets() throws IOException {
        ChangeLogFactory factory = this.createFactory();
        String markers = "";
        markers = this.getType().equalsIgnoreCase("tag") ? this.getTag() : (this.getType().equalsIgnoreCase("date") ? this.getDate() : this.getRange());
        StringTokenizer tokens = new StringTokenizer(markers, ",");
        int expectedSets = tokens.countTokens() - 1;
        this.sets = expectedSets < 0 ? new ArrayList(1) : new ArrayList(expectedSets);
        String end = tokens.nextToken();
        do {
            String logEnd;
            String logStart;
            Collection entries;
            String start = end;
            end = tokens.hasMoreTokens() ? tokens.nextToken() : null;
            this.setMarkerStart(start);
            this.setMarkerEnd(end);
            ChangeLogParser parser = factory.createParser();
            if (this.getDateFormat() != null) {
                parser.setDateFormatInFile(this.getDateFormat());
            }
            parser.init(this);
            ChangeLogGenerator generator = factory.createGenerator();
            generator.init(this);
            try {
                entries = generator.getEntries(parser);
                logStart = generator.getLogStart();
                logEnd = generator.getLogEnd();
            }
            catch (IOException e) {
                ChangeLog.getLog().warn((CharSequence)e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            finally {
                generator.cleanup();
                parser.cleanup();
            }
            if (entries == null) {
                entries = Collections.EMPTY_LIST;
            }
            this.sets.add(new ChangeLogSet(entries, logStart, logEnd));
            if (!ChangeLog.getLog().isInfoEnabled()) continue;
            ChangeLog.getLog().info((CharSequence)("ChangeSet between " + logStart + " and " + logEnd + ": " + entries.size() + " entries"));
        } while (this.sets.size() < expectedSets);
    }

    private ChangeLogFactory createFactory() throws IOException {
        if (this.clFactoryClass == null) {
            if (this.connection == null || this.connection.length() < 7 || !this.connection.startsWith("scm:")) {
                ChangeLog.getLog().warn((CharSequence)"Connection does not appear valid");
            } else {
                int idx = this.connection.indexOf(58, 4);
                if (idx > 4) {
                    this.clFactoryClass = (String)FACTORIES.get(this.connection.substring(4, idx));
                } else {
                    ChangeLog.getLog().warn((CharSequence)"Connectiong does not appear to be valid");
                }
            }
            if (this.clFactoryClass == null) {
                ChangeLog.getLog().warn((CharSequence)("Could not derive factory from connection: using default CVS (valid factories are: " + FACTORIES.keySet() + ")"));
                this.clFactoryClass = "org.apache.maven.cvslib.CvsChangeLogFactory";
            }
        }
        try {
            Class<?> clazz = Class.forName(this.clFactoryClass);
            return (ChangeLogFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Cannot find class " + this.clFactoryClass + " " + cnfe.toString());
        }
        catch (IllegalAccessException iae) {
            throw new IOException("Cannot access class " + this.clFactoryClass + " " + iae.toString());
        }
        catch (InstantiationException ie) {
            throw new IOException("Cannot instantiate class " + this.clFactoryClass + " " + ie.toString());
        }
    }

    private Properties getUserList() {
        Properties userList = new Properties();
        Developer developer = null;
        Iterator i = this.getDevelopers().iterator();
        while (i.hasNext()) {
            developer = (Developer)i.next();
            ((Hashtable)userList).put(developer.getId(), developer.getName());
        }
        return userList;
    }

    private void replaceAuthorIdWithName() {
        Properties userList = this.getUserList();
        ChangeLogEntry entry = null;
        Iterator iSets = this.getChangeSets().iterator();
        while (iSets.hasNext()) {
            ChangeLogSet set = (ChangeLogSet)iSets.next();
            Iterator iEntries = set.getEntries().iterator();
            while (iEntries.hasNext()) {
                entry = (ChangeLogEntry)iEntries.next();
                if (!((Hashtable)userList).containsKey(entry.getAuthor())) continue;
                entry.setAuthor(userList.getProperty(entry.getAuthor()));
            }
        }
    }

    private void createDocument() throws FileNotFoundException, UnsupportedEncodingException {
        File dir = this.output.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), this.getOutputEncoding()));
        out.println(this.toXML());
        out.flush();
        out.close();
    }

    private String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"").append(this.getOutputEncoding()).append("\" ?>\n").append("<changelog>\n");
        Iterator i = this.getChangeSets().iterator();
        while (i.hasNext()) {
            buffer.append(((ChangeLogSet)i.next()).toXML());
        }
        buffer.append("</changelog>\n");
        return buffer.toString();
    }

    public Collection getChangeSets() {
        if (this.sets == null) {
            this.sets = Collections.EMPTY_LIST;
        }
        return this.sets;
    }

    public void setChangeSets(Collection sets) {
        this.sets = sets;
    }

    public List getDevelopers() {
        return this.developers;
    }

    public void setDevelopers(List developers) {
        this.developers = developers;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String getCommentFormat() {
        return this.commentFormat;
    }

    public void setCommentFormat(String commentFormat) {
        this.commentFormat = commentFormat;
    }

    public static Collection loadChangedSets(InputStream stream, String dateFormat) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        LinkedList changeLogSets = new LinkedList();
        parser.parse(stream, (DefaultHandler)new ChangeLogHandler(changeLogSets, dateFormat));
        return changeLogSets;
    }

    public static Log getLog() {
        return LOG;
    }

    public static void setLog(Log logger) {
        LOG = logger;
    }

    static {
        FACTORIES.put("cvs", "org.apache.maven.cvslib.CvsChangeLogFactory");
        FACTORIES.put("svn", "org.apache.maven.svnlib.SvnChangeLogFactory");
        FACTORIES.put("clearcase", "org.apache.maven.clearcaselib.ClearcaseChangeLogFactory");
        FACTORIES.put("perforce", "org.apache.maven.perforcelib.PerforceChangeLogFactory");
        FACTORIES.put("starteam", "org.apache.maven.starteamlib.StarteamChangeLogFactory");
        FACTORIES.put("vss", "org.apache.maven.vsslib.VssChangeLogFactory");
    }
}

