/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.stax;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.model.VersionDefinition;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.stax.AbstractStaxGenerator;
import org.codehaus.modello.plugin.stax.GeneratorNode;
import org.codehaus.modello.plugins.xml.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;
import org.codehaus.plexus.util.WriterFactory;

public class StaxReaderGenerator
extends AbstractStaxGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            String versions;
            this.generateStaxReaders();
            VersionDefinition versionDefinition = model.getVersionDefinition();
            if (versionDefinition != null && (versions = parameters.getProperty("modello.all.versions")) != null) {
                this.generateStaxReaderDelegate(Arrays.asList(versions.split(",")));
            }
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating StAX Reader.", (Throwable)ex);
        }
    }

    private void generateStaxReaders() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = this.isPackageWithVersion() ? objectModel.getDefaultPackageName(true, this.getGeneratedVersion()) : objectModel.getDefaultPackageName(false, null);
        packageName = packageName + ".io.stax";
        String unmarshallerName = this.getFileName("StaxReader");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, unmarshallerName);
        JClass jClass = new JClass(unmarshallerName);
        jClass.setPackageName(packageName);
        jClass.addImport("java.io.IOException");
        jClass.addImport("java.io.Reader");
        jClass.addImport("java.io.File");
        jClass.addImport("java.io.FileInputStream");
        jClass.addImport("java.io.StringWriter");
        jClass.addImport("java.io.StringReader");
        jClass.addImport("java.io.ByteArrayInputStream");
        jClass.addImport("java.io.InputStreamReader");
        jClass.addImport("java.text.DateFormat");
        jClass.addImport("java.text.ParsePosition");
        jClass.addImport("java.util.regex.Matcher");
        jClass.addImport("java.util.regex.Pattern");
        jClass.addImport("java.util.Locale");
        jClass.addImport("javax.xml.stream.*");
        jClass.addImport("org.codehaus.plexus.util.xml.Xpp3Dom");
        this.addModelImports(jClass, null);
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        GeneratorNode rootNode = this.findRequiredReferenceResolvers(root, null);
        this.writeReferenceResolvers(rootNode, jClass);
        Iterator i = rootNode.getNodesWithReferencableChildren().values().iterator();
        while (i.hasNext()) {
            GeneratorNode node = (GeneratorNode)i.next();
            this.writeReferenceResolvers(node, jClass);
        }
        JClass returnType = new JClass(root.getName());
        JMethod method = new JMethod((JType)returnType, "read");
        method.addParameter(new JParameter((JType)new JClass("Reader"), "reader"));
        method.addParameter(new JParameter(JType.Boolean, "strict"));
        method.addException(new JClass("IOException"));
        method.addException(new JClass("XMLStreamException"));
        JSourceCode sc = method.getSourceCode();
        sc.add("XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );");
        sc.add("");
        sc.add("String encoding = xmlStreamReader.getCharacterEncodingScheme();");
        sc.add(returnType + " value = parse" + root.getName() + "( \"" + this.getTagName(root) + "\", xmlStreamReader, strict, encoding );");
        sc.add("resolveReferences( value );");
        sc.add("return value;");
        jClass.addMethod(method);
        method = new JMethod((JType)returnType, "read");
        method.addParameter(new JParameter((JType)new JClass("Reader"), "reader"));
        method.addException(new JClass("IOException"));
        method.addException(new JClass("XMLStreamException"));
        sc = method.getSourceCode();
        sc.add("return read( reader, true );");
        jClass.addMethod(method);
        method = new JMethod((JType)returnType, "read");
        method.addParameter(new JParameter((JType)new JClass("String"), "filePath"));
        method.addParameter(new JParameter(JType.Boolean, "strict"));
        method.addException(new JClass("IOException"));
        method.addException(new JClass("XMLStreamException"));
        sc = method.getSourceCode();
        sc.add("File file = new File(filePath);");
        sc.add("XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( file.toURL().toExternalForm(), new FileInputStream(file) );");
        sc.add("");
        sc.add("String encoding = xmlStreamReader.getCharacterEncodingScheme();");
        sc.add(returnType + " value = parse" + root.getName() + "( \"" + this.getTagName(root) + "\", xmlStreamReader, strict, encoding );");
        sc.add("resolveReferences( value );");
        sc.add("return value;");
        jClass.addMethod(method);
        method = new JMethod((JType)returnType, "read");
        method.addParameter(new JParameter((JType)new JClass("String"), "filePath"));
        method.addException(new JClass("IOException"));
        method.addException(new JClass("XMLStreamException"));
        sc = method.getSourceCode();
        sc.add("return read( filePath, true );");
        jClass.addMethod(method);
        VersionDefinition versionDefinition = objectModel.getVersionDefinition();
        if (versionDefinition != null) {
            this.writeDetermineVersionMethod(jClass, objectModel);
        }
        this.writeAllClassesParser(objectModel, jClass);
        this.writeHelpers(jClass);
        this.writeBuildDomMethod(jClass);
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void generateStaxReaderDelegate(List versions) throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = objectModel.getDefaultPackageName(false, null);
        packageName = packageName + ".io.stax";
        String directory = packageName.replace('.', '/');
        String unmarshallerName = this.getFileName("StaxReaderDelegate");
        File f = new File(new File(this.getOutputDirectory(), directory), unmarshallerName + ".java");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        Writer writer = WriterFactory.newPlatformWriter((File)f);
        JSourceWriter sourceWriter = new JSourceWriter(writer);
        JClass jClass = new JClass(unmarshallerName);
        jClass.setPackageName(packageName);
        jClass.addImport("java.io.File");
        jClass.addImport("java.io.IOException");
        jClass.addImport("java.io.Reader");
        jClass.addImport("javax.xml.stream.*");
        jClass.addImport("org.codehaus.plexus.util.IOUtil");
        jClass.addImport("org.codehaus.plexus.util.ReaderFactory");
        JMethod method = new JMethod((JType)new JClass("Object"), "read");
        method.addParameter(new JParameter((JType)new JClass("File"), "f"));
        method.addParameter(new JParameter(JType.Boolean, "strict"));
        method.addException(new JClass("IOException"));
        method.addException(new JClass("XMLStreamException"));
        jClass.addMethod(method);
        JSourceCode sc = method.getSourceCode();
        sc.add("String modelVersion;");
        sc.add("Reader reader = ReaderFactory.newXmlReader( f );");
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add("modelVersion = determineVersion( reader );");
        sc.unindent();
        sc.add("}");
        sc.add("finally");
        sc.add("{");
        sc.indent();
        sc.add("IOUtil.close( reader );");
        sc.unindent();
        sc.add("}");
        sc.add("reader = ReaderFactory.newXmlReader( f );");
        sc.add("try");
        sc.add("{");
        sc.indent();
        StaxReaderGenerator.writeModelVersionHack(sc);
        String prefix = "";
        Iterator i = versions.iterator();
        while (i.hasNext()) {
            String version = (String)i.next();
            sc.add(prefix + "if ( \"" + version + "\".equals( modelVersion ) )");
            sc.add("{");
            sc.indent();
            sc.add("return new " + this.getModel().getDefaultPackageName(true, new Version(version)) + ".io.stax." + this.getFileName("StaxReader") + "().read( reader, strict );");
            sc.unindent();
            sc.add("}");
            prefix = "else ";
        }
        sc.add("else");
        sc.add("{");
        sc.indent();
        sc.add("throw new XMLStreamException( \"Document version '\" + modelVersion + \"' has no corresponding reader.\" );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("finally");
        sc.add("{");
        sc.indent();
        sc.add("IOUtil.close( reader );");
        sc.unindent();
        sc.add("}");
        method = new JMethod((JType)new JClass("Object"), "read");
        method.addParameter(new JParameter((JType)new JClass("File"), "f"));
        method.addException(new JClass("IOException"));
        method.addException(new JClass("XMLStreamException"));
        sc = method.getSourceCode();
        sc.add("return read( f, true );");
        jClass.addMethod(method);
        this.writeDetermineVersionMethod(jClass, objectModel);
        jClass.print(sourceWriter);
        writer.flush();
        writer.close();
    }

    private static void writeModelVersionHack(JSourceCode sc) {
        sc.add("// legacy hack for pomVersion == 3");
        sc.add("if ( modelVersion.equals( \"3\" ) ) modelVersion = \"3.0.0\";");
    }

    private void writeDetermineVersionMethod(JClass jClass, Model objectModel) throws ModelloException {
        VersionDefinition versionDefinition = objectModel.getVersionDefinition();
        JMethod method = new JMethod((JType)new JClass("String"), "determineVersion");
        method.addParameter(new JParameter((JType)new JClass("Reader"), "reader"));
        method.addException(new JClass("IOException"));
        method.addException(new JClass("XMLStreamException"));
        JSourceCode sc = method.getSourceCode();
        sc.add("XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );");
        sc.add("while ( xmlStreamReader.hasNext() )");
        sc.add("{");
        sc.indent();
        sc.add("int eventType = xmlStreamReader.next();");
        sc.add("if ( eventType == XMLStreamConstants.START_ELEMENT )");
        sc.add("{");
        sc.indent();
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        if ("namespace".equals(versionDefinition.getType())) {
            XmlClassMetadata metadata = (XmlClassMetadata)root.getMetadata(XmlClassMetadata.ID);
            String namespace = metadata.getNamespace();
            if (namespace == null || namespace.indexOf("${version}") < 0) {
                throw new ModelloException("versionDefinition is namespace, but the model does not declare xml.namespace on the root element");
            }
            sc.add("return getVersionFromRootNamespace( xmlStreamReader );");
            StaxReaderGenerator.writeNamespaceVersionGetMethod(namespace, jClass);
        } else {
            String value = versionDefinition.getValue();
            ModelField field = root.getField(value, this.getGeneratedVersion());
            if (field == null) {
                throw new ModelloException("versionDefinition is field, but the model root element does not declare a field '" + value + "'.");
            }
            if (!"String".equals(field.getType())) {
                throw new ModelloException("versionDefinition is field, but the field is not of type String");
            }
            sc.add("return getVersionFromField( xmlStreamReader );");
            StaxReaderGenerator.writeFieldVersionGetMethod(field, jClass);
        }
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("throw new XMLStreamException( \"Version not found in document\", xmlStreamReader.getLocation() );");
        jClass.addMethod(method);
    }

    private static void writeFieldVersionGetMethod(ModelField field, JClass jClass) {
        JMethod method = new JMethod(new JType("String"), "getVersionFromField");
        method.addParameter(new JParameter(new JType("XMLStreamReader"), "xmlStreamReader"));
        method.addException(new JClass("XMLStreamException"));
        jClass.addMethod(method);
        JSourceCode sc = method.getSourceCode();
        XmlFieldMetadata metadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
        String value = metadata.getTagName();
        if (value == null) {
            value = field.getName();
        }
        sc.add("int depth = 0;");
        sc.add("while ( depth >= 0 )");
        sc.add("{");
        sc.indent();
        sc.add("int eventType = xmlStreamReader.next();");
        sc.add("if ( eventType == XMLStreamConstants.START_ELEMENT )");
        sc.add("{");
        sc.indent();
        sc.add("if ( depth == 0 && \"" + value + "\".equals( xmlStreamReader.getLocalName() ) )");
        sc.add("{");
        sc.indent();
        sc.add("return xmlStreamReader.getElementText();");
        sc.unindent();
        sc.add("}");
        if (field.getAlias() != null) {
            sc.add("if ( depth == 0 && \"" + field.getAlias() + "\".equals( xmlStreamReader.getLocalName() ) )");
            sc.add("{");
            sc.indent();
            sc.add("return xmlStreamReader.getElementText();");
            sc.unindent();
            sc.add("}");
        }
        sc.add("depth++;");
        sc.unindent();
        sc.add("}");
        sc.add("if ( eventType == XMLStreamConstants.END_ELEMENT )");
        sc.add("{");
        sc.indent();
        sc.add("depth--;");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("throw new XMLStreamException( \"Field: '" + value + "' does not exist in the document.\", xmlStreamReader.getLocation() );");
    }

    private static void writeNamespaceVersionGetMethod(String namespace, JClass jClass) {
        JMethod method = new JMethod(new JType("String"), "getVersionFromRootNamespace");
        method.addParameter(new JParameter(new JType("XMLStreamReader"), "xmlStreamReader"));
        method.addException(new JClass("XMLStreamException"));
        jClass.addMethod(method);
        JSourceCode sc = method.getSourceCode();
        sc.add("String uri = xmlStreamReader.getNamespaceURI( \"\" );");
        sc.add("if ( uri == null )");
        sc.add("{");
        sc.indent();
        sc.add("throw new XMLStreamException( \"No namespace specified, but versionDefinition requires it\", xmlStreamReader.getLocation() );");
        sc.unindent();
        sc.add("}");
        int index = namespace.indexOf("${version}");
        sc.add("String uriPrefix = \"" + namespace.substring(0, index) + "\";");
        sc.add("String uriSuffix = \"" + namespace.substring(index + 10) + "\";");
        sc.add("if ( !uri.startsWith( uriPrefix ) || !uri.endsWith( uriSuffix ) )");
        sc.add("{");
        sc.indent();
        sc.add("throw new XMLStreamException( \"Namespace URI: '\" + uri + \"' does not match pattern '" + namespace + "'\", xmlStreamReader.getLocation() );");
        sc.unindent();
        sc.add("}");
        sc.add("return uri.substring( uriPrefix.length(), uri.length() - uriSuffix.length() );");
    }

    private String getTagName(ModelClass root) {
        XmlClassMetadata metadata = (XmlClassMetadata)root.getMetadata(XmlClassMetadata.ID);
        String tagName = metadata.getTagName();
        if (tagName != null) {
            return tagName;
        }
        return StaxReaderGenerator.uncapitalise((String)root.getName());
    }

    private void writeAllClassesParser(Model objectModel, JClass jClass) throws ModelloException {
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        Iterator i = objectModel.getClasses(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelClass clazz = (ModelClass)i.next();
            if (root.getName().equals(clazz.getName())) {
                this.writeClassParser(clazz, jClass, true);
                continue;
            }
            this.writeClassParser(clazz, jClass, false);
        }
    }

    private void writeClassParser(ModelClass modelClass, JClass jClass, boolean rootElement) throws ModelloException {
        List identifierFields;
        ModelField field;
        String className = modelClass.getName();
        String capClassName = this.capitalise(className);
        String uncapClassName = StaxReaderGenerator.uncapitalise((String)className);
        JClass returnType = new JClass(className);
        JMethod unmarshall = new JMethod((JType)returnType, "parse" + capClassName);
        unmarshall.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        unmarshall.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        unmarshall.addParameter(new JParameter(JType.Boolean, "strict"));
        unmarshall.addParameter(new JParameter((JType)new JClass("String"), "encoding"));
        unmarshall.addException(new JClass("IOException"));
        unmarshall.addException(new JClass("XMLStreamException"));
        unmarshall.getModifiers().makePrivate();
        JSourceCode sc = unmarshall.getSourceCode();
        sc.add(className + " " + uncapClassName + " = new " + className + "();");
        sc.add(uncapClassName + ".setModelEncoding( encoding );");
        sc.add("java.util.Set parsed = new java.util.HashSet();");
        String instanceFieldName = StaxReaderGenerator.getInstanceFieldName(className);
        if (rootElement) {
            sc.add("boolean foundRoot = false;");
            sc.add("while ( xmlStreamReader.hasNext() )");
            sc.add("{");
            sc.indent();
            sc.add("int eventType = xmlStreamReader.next();");
            sc.add("if ( eventType == XMLStreamConstants.START_ELEMENT )");
        } else {
            this.writeAttributes(modelClass, uncapClassName, sc);
            if (this.isAssociationPartToClass(modelClass)) {
                jClass.addField(new JField(new JType("java.util.Map"), instanceFieldName));
                sc.add("if ( " + instanceFieldName + " == null )");
                sc.add("{");
                sc.indent();
                sc.add(instanceFieldName + " = new java.util.HashMap();");
                sc.unindent();
                sc.add("}");
                sc.add("String v = xmlStreamReader.getAttributeValue( null, \"modello.id\" );");
                sc.add("if ( v != null )");
                sc.add("{");
                sc.indent();
                sc.add(instanceFieldName + ".put( v, " + uncapClassName + ");");
                sc.unindent();
                sc.add("}");
            }
            sc.add("while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )");
        }
        sc.add("{");
        sc.indent();
        String statement = "if";
        if (rootElement) {
            sc.add("if ( xmlStreamReader.getLocalName().equals( tagName ) )");
            sc.add("{");
            sc.indent();
            VersionDefinition versionDefinition = modelClass.getModel().getVersionDefinition();
            if (versionDefinition != null && "namespace".equals(versionDefinition.getType())) {
                sc.add("String modelVersion = getVersionFromRootNamespace( xmlStreamReader );");
                this.writeModelVersionCheck(sc);
            }
            this.writeAttributes(modelClass, uncapClassName, sc);
            sc.add("foundRoot = true;");
            sc.unindent();
            sc.add("}");
            statement = "else if";
        }
        Iterator i = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (i.hasNext()) {
            field = (ModelField)i.next();
            XmlFieldMetadata fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (fieldMetadata.isAttribute()) continue;
            this.processField(fieldMetadata, field, statement, sc, uncapClassName, modelClass, rootElement, jClass);
            statement = "else if";
        }
        if (!rootElement) {
            if (statement.startsWith("else")) {
                sc.add("else");
                sc.add("{");
                sc.indent();
            }
            sc.add("if ( strict )");
            sc.add("{");
            sc.indent();
            sc.add("throw new XMLStreamException( \"Unrecognised tag: '\" + xmlStreamReader.getLocalName() + \"'\", xmlStreamReader.getLocation() );");
            sc.unindent();
            sc.add("}");
            if (statement.startsWith("else")) {
                sc.unindent();
                sc.add("}");
            }
        } else {
            sc.add("else");
            sc.add("{");
            sc.indent();
            sc.add("if ( foundRoot )");
            sc.add("{");
            sc.indent();
            sc.add("if ( strict )");
            sc.add("{");
            sc.indent();
            sc.add("throw new XMLStreamException( \"Unrecognised tag: '\" + xmlStreamReader.getLocalName() + \"'\", xmlStreamReader.getLocation() );");
            sc.unindent();
            sc.add("}");
            sc.unindent();
            sc.add("}");
            sc.unindent();
            sc.add("}");
            sc.unindent();
            sc.add("}");
        }
        sc.unindent();
        sc.add("}");
        if (this.isAssociationPartToClass(modelClass) && (identifierFields = modelClass.getIdentifierFields(this.getGeneratedVersion())).size() == 1) {
            field = (ModelField)identifierFields.get(0);
            String v = uncapClassName + ".get" + this.capitalise(field.getName()) + "()";
            v = StaxReaderGenerator.getValue(field.getType(), v, (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID));
            sc.add(instanceFieldName + ".put( " + v + ", " + uncapClassName + ");");
        }
        sc.add("return " + uncapClassName + ";");
        jClass.addMethod(unmarshall);
    }

    private GeneratorNode findRequiredReferenceResolvers(ModelClass modelClass, GeneratorNode parent) throws ModelloException {
        String className = modelClass.getName();
        GeneratorNode value = new GeneratorNode(className, parent);
        Iterator i = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (i.hasNext()) {
            ModelAssociation association;
            ModelField field = (ModelField)i.next();
            if (!(field instanceof ModelAssociation) || !this.isClassInModel((association = (ModelAssociation)field).getTo(), this.getModel())) continue;
            ModelField referenceIdentifierField = this.getReferenceIdentifierField(association);
            GeneratorNode child = null;
            if (referenceIdentifierField != null) {
                child = new GeneratorNode(association, parent);
                child.setReferencable(true);
            } else if (!value.getChain().contains(association.getTo())) {
                child = this.findRequiredReferenceResolvers(association.getToClass(), value);
                child.setAssociation(association);
            }
            if (child == null) continue;
            value.addChild(child);
        }
        i = value.getChildren().iterator();
        while (i.hasNext()) {
            GeneratorNode child = (GeneratorNode)i.next();
            if (child.isReferencable() || child.isReferencableChildren()) {
                value.setReferencableChildren(true);
            }
            value.addNodesWithReferencableChildren(child.getNodesWithReferencableChildren());
        }
        return value;
    }

    private void writeReferenceResolvers(GeneratorNode node, JClass jClass) {
        JMethod unmarshall = new JMethod("resolveReferences");
        unmarshall.addParameter(new JParameter((JType)new JClass(node.getTo()), "value"));
        unmarshall.getModifiers().makePrivate();
        JSourceCode sc = unmarshall.getSourceCode();
        sc.add("java.util.Map refs;");
        Iterator i = node.getChildren().iterator();
        while (i.hasNext()) {
            ModelAssociation association;
            GeneratorNode child = (GeneratorNode)i.next();
            if (child.isReferencable()) {
                association = child.getAssociation();
                String refFieldName = StaxReaderGenerator.getRefFieldName(association);
                String to = association.getTo();
                String instanceFieldName = StaxReaderGenerator.getInstanceFieldName(to);
                sc.add("if ( " + refFieldName + " != null )");
                sc.add("{");
                sc.indent();
                sc.add("refs = (java.util.Map) " + refFieldName + ".get( value );");
                sc.add("if ( refs != null )");
                sc.add("{");
                sc.indent();
                String capAssocName = this.capitalise(association.getName());
                if ("1".equals(association.getMultiplicity())) {
                    sc.add("String id = (String) refs.get( \"" + association.getName() + "\" );");
                    sc.add(to + " ref = (" + to + ") " + instanceFieldName + ".get( id );");
                    sc.add("if ( ref != null && !ref.equals( value.get" + capAssocName + "() ) )");
                    sc.add("{");
                    sc.indent();
                    sc.add("value.set" + capAssocName + "( ref );");
                    sc.unindent();
                    sc.add("}");
                } else {
                    sc.add("for ( int i = 0; i < value.get" + capAssocName + "().size(); i++ )");
                    sc.add("{");
                    sc.indent();
                    sc.add("String id = (String) refs.get( \"" + association.getName() + ".\" + i );");
                    sc.add(to + " ref = (" + to + ") " + instanceFieldName + ".get( id );");
                    sc.add("if ( ref != null )");
                    sc.add("{");
                    sc.indent();
                    sc.add("value.get" + capAssocName + "().set( i, ref );");
                    sc.unindent();
                    sc.add("}");
                    sc.unindent();
                    sc.add("}");
                }
                sc.unindent();
                sc.add("}");
                sc.unindent();
                sc.add("}");
            }
            if (!child.isReferencableChildren()) continue;
            association = child.getAssociation();
            if ("1".equals(association.getMultiplicity())) {
                sc.add("resolveReferences( value.get" + this.capitalise(association.getName()) + "() );");
                continue;
            }
            sc.add("for ( java.util.Iterator i = value.get" + this.capitalise(association.getName()) + "().iterator(); i.hasNext(); )");
            sc.add("{");
            sc.indent();
            sc.add("resolveReferences( (" + association.getTo() + ") i.next() );");
            sc.unindent();
            sc.add("}");
        }
        jClass.addMethod(unmarshall);
    }

    private static String getRefFieldName(ModelAssociation association) {
        return StaxReaderGenerator.uncapitalise((String)association.getTo()) + "References";
    }

    private static String getInstanceFieldName(String to) {
        return StaxReaderGenerator.uncapitalise((String)to) + "Instances";
    }

    private void writeAttributes(ModelClass modelClass, String uncapClassName, JSourceCode sc) throws ModelloException {
        Iterator i = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (i.hasNext()) {
            ModelField field = (ModelField)i.next();
            XmlFieldMetadata fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (!fieldMetadata.isAttribute()) continue;
            this.writePrimitiveField(field, field.getType(), uncapClassName, "set" + this.capitalise(field.getName()), sc);
        }
    }

    private void processField(XmlFieldMetadata fieldMetadata, ModelField field, String statement, JSourceCode sc, String uncapClassName, ModelClass modelClass, boolean rootElement, JClass jClass) throws ModelloException {
        String singularTagName;
        String tagName = fieldMetadata.getTagName();
        if (tagName == null) {
            tagName = field.getName();
        }
        if ((singularTagName = fieldMetadata.getAssociationTagName()) == null) {
            singularTagName = this.singular(tagName);
        }
        boolean wrappedList = "wrapped".equals(fieldMetadata.getListStyle());
        String capFieldName = this.capitalise(field.getName());
        String singularName = this.singular(field.getName());
        String optionalCheck = "";
        if (field.getAlias() != null && field.getAlias().length() > 0) {
            optionalCheck = "|| xmlStreamReader.getLocalName().equals( \"" + field.getAlias() + "\" ) ";
        }
        String tagComparison = statement + " ( xmlStreamReader.getLocalName().equals( \"" + tagName + "\" ) " + optionalCheck + " )";
        if (field instanceof ModelAssociation) {
            ModelAssociation association = (ModelAssociation)field;
            String associationName = association.getName();
            if ("1".equals(association.getMultiplicity())) {
                sc.add(tagComparison);
                sc.add("{");
                sc.indent();
                this.addCodeToCheckIfParsed(sc, tagName);
                ModelField referenceIdentifierField = this.getReferenceIdentifierField(association);
                if (referenceIdentifierField != null) {
                    StaxReaderGenerator.addCodeToAddReferences(association, jClass, sc, referenceIdentifierField, uncapClassName);
                    sc.add("while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )");
                    sc.add("{");
                    sc.indent();
                    sc.add("xmlStreamReader.next();");
                    sc.unindent();
                    sc.add("}");
                } else {
                    sc.add(uncapClassName + ".set" + capFieldName + "( parse" + association.getTo() + "( \"" + tagName + "\", xmlStreamReader, strict, encoding ) );");
                }
                sc.unindent();
                sc.add("}");
            } else {
                String type = association.getType();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    if (wrappedList) {
                        sc.add(tagComparison);
                        sc.add("{");
                        sc.indent();
                        this.addCodeToCheckIfParsed(sc, tagName);
                        sc.add(type + " " + associationName + " = " + association.getDefaultValue() + ";");
                        sc.add(uncapClassName + ".set" + capFieldName + "( " + associationName + " );");
                        sc.add("while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )");
                        sc.add("{");
                        sc.indent();
                        sc.add("if ( xmlStreamReader.getLocalName().equals( \"" + singularTagName + "\" ) )");
                        sc.add("{");
                        sc.indent();
                    } else {
                        sc.add(statement + " ( xmlStreamReader.getLocalName().equals( \"" + singularTagName + "\" ) )");
                        sc.add("{");
                        sc.indent();
                        sc.add(type + " " + associationName + " = " + uncapClassName + ".get" + capFieldName + "();");
                        sc.add("if ( " + associationName + " == null )");
                        sc.add("{");
                        sc.indent();
                        sc.add(associationName + " = " + association.getDefaultValue() + ";");
                        sc.add(uncapClassName + ".set" + capFieldName + "( " + associationName + " );");
                        sc.unindent();
                        sc.add("}");
                    }
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        ModelField referenceIdentifierField = this.getReferenceIdentifierField(association);
                        if (referenceIdentifierField != null) {
                            StaxReaderGenerator.addCodeToAddReferences(association, jClass, sc, referenceIdentifierField, uncapClassName);
                        }
                        if (association.getTo().equals(modelClass.getName())) {
                            sc.add(associationName + ".add( parse" + association.getTo() + "( \"" + singularTagName + "\", xmlStreamReader, strict, encoding ) );");
                        } else {
                            sc.add(uncapClassName + ".add" + this.capitalise(this.singular(associationName)) + "( parse" + association.getTo() + "( \"" + singularTagName + "\", xmlStreamReader, strict, encoding ) );");
                        }
                    } else {
                        this.writePrimitiveField((ModelField)association, association.getTo(), associationName, "add", sc);
                    }
                    if (wrappedList) {
                        sc.unindent();
                        sc.add("}");
                        sc.add("else");
                        sc.add("{");
                        sc.indent();
                        sc.add("throw new XMLStreamException( \"Unrecognised tag: '\" + xmlStreamReader.getLocalName() + \"'\", xmlStreamReader.getLocation() );");
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                    } else {
                        sc.unindent();
                        sc.add("}");
                    }
                } else {
                    sc.add(tagComparison);
                    sc.add("{");
                    sc.indent();
                    this.addCodeToCheckIfParsed(sc, tagName);
                    XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                    if ("explode".equals(xmlAssociationMetadata.getMapStyle())) {
                        sc.add("while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )");
                        sc.add("{");
                        sc.indent();
                        sc.add("if ( xmlStreamReader.getLocalName().equals( \"" + singularTagName + "\" ) )");
                        sc.add("{");
                        sc.indent();
                        sc.add("String key = null;");
                        sc.add("String value = null;");
                        sc.add("//" + xmlAssociationMetadata.getMapStyle() + " mode.");
                        sc.add("while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )");
                        sc.add("{");
                        sc.indent();
                        sc.add("if ( xmlStreamReader.getLocalName().equals( \"key\" ) )");
                        sc.add("{");
                        sc.indent();
                        sc.add("key = xmlStreamReader.getElementText();");
                        sc.unindent();
                        sc.add("}");
                        sc.add("else if ( xmlStreamReader.getLocalName().equals( \"value\" ) )");
                        sc.add("{");
                        sc.indent();
                        sc.add("value = xmlStreamReader.getElementText()");
                        if (fieldMetadata.isTrim()) {
                            sc.add(".trim()");
                        }
                        sc.add(";");
                        sc.unindent();
                        sc.add("}");
                        sc.add("else");
                        sc.add("{");
                        sc.indent();
                        sc.add("xmlStreamReader.getText();");
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                        sc.add(uncapClassName + ".add" + this.capitalise(singularName) + "( key, value );");
                        sc.unindent();
                        sc.add("}");
                        sc.add("xmlStreamReader.next();");
                        sc.unindent();
                        sc.add("}");
                    } else {
                        sc.add("while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )");
                        sc.add("{");
                        sc.indent();
                        sc.add("String key = xmlStreamReader.getLocalName();");
                        sc.add("String value = xmlStreamReader.getElementText()");
                        if (fieldMetadata.isTrim()) {
                            sc.add(".trim()");
                        }
                        sc.add(";");
                        sc.add(uncapClassName + ".add" + this.capitalise(singularName) + "( key, value );");
                        sc.unindent();
                        sc.add("}");
                    }
                    sc.unindent();
                    sc.add("}");
                }
            }
        } else {
            sc.add(tagComparison);
            sc.add("{");
            sc.indent();
            this.addCodeToCheckIfParsed(sc, tagName);
            this.writePrimitiveField(field, field.getType(), uncapClassName, "set" + this.capitalise(field.getName()), sc);
            if (rootElement && field.isModelVersionField()) {
                sc.add("String modelVersion = " + uncapClassName + ".get" + this.capitalise(field.getName()) + "();");
                this.writeModelVersionCheck(sc);
            }
            sc.unindent();
            sc.add("}");
        }
    }

    private static void addCodeToAddReferences(ModelAssociation association, JClass jClass, JSourceCode sc, ModelField referenceIdentifierField, String referredFromClass) {
        String refFieldName = StaxReaderGenerator.getRefFieldName(association);
        if (jClass.getField(refFieldName) == null) {
            jClass.addField(new JField(new JType("java.util.Map"), refFieldName));
        }
        sc.add("String value = xmlStreamReader.getAttributeValue( null, \"" + referenceIdentifierField.getName() + "\" );");
        sc.add("if ( value != null )");
        sc.add("{");
        sc.indent();
        sc.add("// This is a reference to an element elsewhere in the model");
        sc.add("if ( " + refFieldName + " == null )");
        sc.add("{");
        sc.indent();
        sc.add(refFieldName + " = new java.util.HashMap();");
        sc.unindent();
        sc.add("}");
        sc.add("java.util.Map refs = (java.util.Map) " + refFieldName + ".get( " + referredFromClass + " );");
        sc.add("if ( refs == null )");
        sc.add("{");
        sc.indent();
        sc.add("refs = new java.util.HashMap();");
        sc.add(refFieldName + ".put( " + referredFromClass + ", refs );");
        sc.unindent();
        sc.add("}");
        if ("1".equals(association.getMultiplicity())) {
            sc.add("refs.put( \"" + association.getName() + "\", value );");
        } else {
            sc.add("refs.put( \"" + association.getName() + ".\" + " + association.getName() + ".size(), value );");
        }
        sc.unindent();
        sc.add("}");
    }

    private void writeModelVersionCheck(JSourceCode sc) {
        StaxReaderGenerator.writeModelVersionHack(sc);
        sc.add("if ( !modelVersion.equals( \"" + this.getGeneratedVersion() + "\" ) )");
        sc.add("{");
        sc.indent();
        sc.add("throw new XMLStreamException( \"Document model version of '\" + modelVersion + \"' doesn't match reader version of '" + this.getGeneratedVersion() + "'\", xmlStreamReader.getLocation() );");
        sc.unindent();
        sc.add("}");
    }

    private void addCodeToCheckIfParsed(JSourceCode sc, String tagName) {
        sc.add("if ( parsed.contains( \"" + tagName + "\" ) )");
        sc.add("{");
        sc.indent();
        sc.add("throw new XMLStreamException( \"Duplicated tag: '\" + xmlStreamReader.getLocalName() + \"'\", xmlStreamReader.getLocation() );");
        sc.unindent();
        sc.add("}");
        sc.add("parsed.add( \"" + tagName + "\" );");
    }

    private void writePrimitiveField(ModelField field, String type, String objectName, String setterName, JSourceCode sc) {
        XmlFieldMetadata fieldMetaData = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
        String tagName = fieldMetaData.getTagName();
        if (tagName == null) {
            tagName = field.getName();
        }
        String parserGetter = fieldMetaData.isAttribute() ? "xmlStreamReader.getAttributeValue( null, \"" + tagName + "\" )" : "xmlStreamReader.getElementText()";
        if (field.getDefaultValue() != null) {
            parserGetter = "getDefaultValue( " + parserGetter + ", \"" + field.getDefaultValue() + "\" )";
        }
        if (fieldMetaData.isTrim()) {
            parserGetter = "getTrimmedValue( " + parserGetter + ")";
        }
        if ("boolean".equals(type)) {
            sc.add(objectName + "." + setterName + "( getBooleanValue( " + parserGetter + ", \"" + tagName + "\", xmlStreamReader ) );");
        } else if ("char".equals(type)) {
            sc.add(objectName + "." + setterName + "( getCharacterValue( " + parserGetter + ", \"" + tagName + "\", xmlStreamReader ) );");
        } else if ("double".equals(type)) {
            sc.add(objectName + "." + setterName + "( getDoubleValue( " + parserGetter + ", \"" + tagName + "\", xmlStreamReader, strict ) );");
        } else if ("float".equals(type)) {
            sc.add(objectName + "." + setterName + "( getFloatValue( " + parserGetter + ", \"" + tagName + "\", xmlStreamReader, strict ) );");
        } else if ("int".equals(type)) {
            sc.add(objectName + "." + setterName + "( getIntegerValue( " + parserGetter + ", \"" + tagName + "\", xmlStreamReader, strict ) );");
        } else if ("long".equals(type)) {
            sc.add(objectName + "." + setterName + "( getLongValue( " + parserGetter + ", \"" + tagName + "\", xmlStreamReader, strict ) );");
        } else if ("short".equals(type)) {
            sc.add(objectName + "." + setterName + "( getShortValue( " + parserGetter + ", \"" + tagName + "\", xmlStreamReader, strict ) );");
        } else if ("String".equals(type) || "Boolean".equals(type)) {
            sc.add(objectName + "." + setterName + "( " + parserGetter + " );");
        } else if ("Date".equals(type)) {
            sc.add("String dateFormat = " + (fieldMetaData.getFormat() != null ? "\"" + fieldMetaData.getFormat() + "\"" : "null") + ";");
            sc.add(objectName + "." + setterName + "( getDateValue( " + parserGetter + ", \"" + tagName + "\", dateFormat, xmlStreamReader ) );");
        } else if ("DOM".equals(type)) {
            sc.add(objectName + "." + setterName + "( buildDom( xmlStreamReader ) );");
        } else {
            throw new IllegalArgumentException("Unknown type: " + type);
        }
    }

    private void writeBuildDomMethod(JClass jClass) {
        JMethod method = new JMethod(new JType("Xpp3Dom"), "buildDom");
        method.addParameter(new JParameter(new JType("XMLStreamReader"), "xmlStreamReader"));
        method.addException(new JClass("XMLStreamException"));
        JSourceCode sc = method.getSourceCode();
        sc.add("java.util.List elements = new java.util.ArrayList();");
        sc.add("java.util.List values = new java.util.ArrayList();");
        sc.add("int eventType = xmlStreamReader.getEventType();");
        sc.add("while ( xmlStreamReader.hasNext() )");
        sc.add("{");
        sc.indent();
        sc.add("if ( eventType == XMLStreamConstants.START_ELEMENT )");
        sc.add("{");
        sc.indent();
        sc.add("String rawName = xmlStreamReader.getLocalName();");
        sc.add("Xpp3Dom childConfiguration = new Xpp3Dom( rawName );");
        sc.add("int depth = elements.size();");
        sc.add("if ( depth > 0 )");
        sc.add("{");
        sc.indent();
        sc.add("Xpp3Dom parent = (Xpp3Dom) elements.get( depth - 1 );");
        sc.add("parent.addChild( childConfiguration );");
        sc.unindent();
        sc.add("}");
        sc.add("elements.add( childConfiguration );");
        sc.add("if ( xmlStreamReader.isEndElement() )");
        sc.add("{");
        sc.indent();
        sc.add("values.add( null );");
        sc.unindent();
        sc.add("}");
        sc.add("else");
        sc.add("{");
        sc.indent();
        sc.add("values.add( new StringBuffer() );");
        sc.unindent();
        sc.add("}");
        sc.add("int attributesSize = xmlStreamReader.getAttributeCount();");
        sc.add("for ( int i = 0; i < attributesSize; i++ )");
        sc.add("{");
        sc.indent();
        sc.add("String name = xmlStreamReader.getAttributeLocalName( i );");
        sc.add("String value = xmlStreamReader.getAttributeValue( i );");
        sc.add("childConfiguration.setAttribute( name, value );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("else if ( eventType == XMLStreamConstants.CHARACTERS )");
        sc.add("{");
        sc.indent();
        sc.add("int depth = values.size() - 1;");
        sc.add("StringBuffer valueBuffer = (StringBuffer) values.get( depth );");
        sc.add("String text = xmlStreamReader.getText();");
        sc.add("text = text.trim();");
        sc.add("valueBuffer.append( text );");
        sc.unindent();
        sc.add("}");
        sc.add("else if ( eventType == XMLStreamConstants.END_ELEMENT )");
        sc.add("{");
        sc.indent();
        sc.add("int depth = elements.size() - 1;");
        sc.add("Xpp3Dom finishedConfiguration = (Xpp3Dom) elements.remove( depth );");
        sc.add("// this Object could be null if it is a singleton tag");
        sc.add("Object accumulatedValue = values.remove( depth );");
        sc.add("if ( finishedConfiguration.getChildCount() == 0 )");
        sc.add("{");
        sc.indent();
        sc.add("if ( accumulatedValue == null )");
        sc.add("{");
        sc.indent();
        sc.add("finishedConfiguration.setValue( null );");
        sc.unindent();
        sc.add("}");
        sc.add("else");
        sc.add("{");
        sc.indent();
        sc.add("finishedConfiguration.setValue( accumulatedValue.toString() );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("if ( depth == 0 )");
        sc.add("{");
        sc.indent();
        sc.add("return finishedConfiguration;");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("eventType = xmlStreamReader.next();");
        sc.unindent();
        sc.add("}");
        sc.add("throw new IllegalStateException( \"End of document found before returning to 0 depth\" );");
        jClass.addMethod(method);
    }

    private void writeHelpers(JClass jClass) {
        JMethod method = new JMethod((JType)new JClass("String"), "getTrimmedValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        JSourceCode sc = method.getSourceCode();
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("s = s.trim();");
        sc.unindent();
        sc.add("}");
        sc.add("return s;");
        jClass.addMethod(method);
        method = new JMethod((JType)new JClass("String"), "getDefaultValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "v"));
        sc = method.getSourceCode();
        sc.add("if ( s == null )");
        sc.add("{");
        sc.indent();
        sc.add("s = v;");
        sc.unindent();
        sc.add("}");
        sc.add("return s;");
        jClass.addMethod(method);
        method = new JMethod((JType)new JClass("String"), "getRequiredAttributeValue");
        method.addException(new JClass("XMLStreamException"));
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        method.addParameter(new JParameter(JType.Boolean, "strict"));
        sc = method.getSourceCode();
        sc.add("if ( s == null )");
        sc.add("{");
        sc.indent();
        sc.add("if ( strict )");
        sc.add("{");
        sc.indent();
        sc.add("throw new XMLStreamException( \"Missing required value for attribute '\" + attribute + \"'\", xmlStreamReader.getLocation() );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("return s;");
        jClass.addMethod(method);
        method = new JMethod(JType.Boolean, "getBooleanValue");
        method.addException(new JClass("XMLStreamException"));
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        sc = method.getSourceCode();
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("return Boolean.valueOf( s ).booleanValue();");
        sc.unindent();
        sc.add("}");
        sc.add("return false;");
        jClass.addMethod(method);
        method = new JMethod(JType.Char, "getCharacterValue");
        method.addException(new JClass("XMLStreamException"));
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        sc = method.getSourceCode();
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("return s.charAt( 0 );");
        sc.unindent();
        sc.add("}");
        sc.add("return 0;");
        jClass.addMethod(method);
        method = new JMethod(JType.Int, "getIntegerValue");
        method.addException(new JClass("XMLStreamException"));
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        method.addParameter(new JParameter(JType.Boolean, "strict"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Integer.valueOf( s ).intValue()", "an integer");
        jClass.addMethod(method);
        method = new JMethod(JType.Short, "getShortValue");
        method.addException(new JClass("XMLStreamException"));
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        method.addParameter(new JParameter(JType.Boolean, "strict"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Short.valueOf( s ).shortValue()", "a short integer");
        jClass.addMethod(method);
        method = new JMethod(JType.Long, "getLongValue");
        method.addException(new JClass("XMLStreamException"));
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        method.addParameter(new JParameter(JType.Boolean, "strict"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Long.valueOf( s ).longValue()", "a long integer");
        jClass.addMethod(method);
        method = new JMethod(JType.Float, "getFloatValue");
        method.addException(new JClass("XMLStreamException"));
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        method.addParameter(new JParameter(JType.Boolean, "strict"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Float.valueOf( s ).floatValue()", "a floating point number");
        jClass.addMethod(method);
        method = new JMethod(JType.Double, "getDoubleValue");
        method.addException(new JClass("XMLStreamException"));
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        method.addParameter(new JParameter(JType.Boolean, "strict"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Double.valueOf( s ).doubleValue()", "a floating point number");
        jClass.addMethod(method);
        method = new JMethod((JType)new JClass("java.util.Date"), "getDateValue");
        method.addException(new JClass("XMLStreamException"));
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("String"), "dateFormat"));
        method.addParameter(new JParameter((JType)new JClass("XMLStreamReader"), "xmlStreamReader"));
        method.addException(new JClass("XMLStreamException"));
        sc = method.getSourceCode();
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("if ( dateFormat == null )");
        sc.add("{");
        sc.indent();
        sc.add("return new java.util.Date( Long.valueOf( s ).longValue() );");
        sc.unindent();
        sc.add("}");
        sc.add("else");
        sc.add("{");
        sc.indent();
        sc.add("DateFormat dateParser = new java.text.SimpleDateFormat( dateFormat, Locale.US );");
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add("return dateParser.parse( s );");
        sc.unindent();
        sc.add("}");
        sc.add("catch ( java.text.ParseException e )");
        sc.add("{");
        sc.indent();
        sc.add("throw new XMLStreamException( e.getMessage() );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("return null;");
        jClass.addMethod(method);
    }

    private void convertNumericalType(JSourceCode sc, String expression, String typeDesc) {
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add("return " + expression + ";");
        sc.unindent();
        sc.add("}");
        sc.add("catch ( NumberFormatException e )");
        sc.add("{");
        sc.indent();
        sc.add("if ( strict )");
        sc.add("{");
        sc.indent();
        sc.add("throw new XMLStreamException( \"Unable to parse element '\" + attribute + \"', must be " + typeDesc + " but was '\" + s + \"'\", xmlStreamReader.getLocation() );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("return 0;");
    }
}

