/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.chorem.pollen.votecounting.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.Voter;

public class CoombsVoteCountingStrategy
extends AbstractVoteCountingStrategy {
    public VoteCountingResult votecount(Set<Voter> voters) {
        Map scores = this.newEmptyChoiceScoreMap(voters);
        double totalWeight = 0.0;
        for (Voter voter : voters) {
            totalWeight += voter.getWeight();
        }
        Map topRankChoices = this.buildVoterSortedChoices(voters);
        HashSet choiceIdsToExclude = Sets.newHashSet();
        HashSet choiceIdsToKeep = Sets.newHashSet(scores.keySet());
        this.round(topRankChoices, choiceIdsToExclude, choiceIdsToKeep, scores, totalWeight /= 2.0);
        VoteCountingResult result = this.orderByValues(scores.values());
        return result;
    }

    protected void round(Map<Voter, List<Set<String>>> topRankChoices, Set<String> idsToExclude, Set<String> idsToInclude, Map<String, ChoiceScore> resultByChoice, double totalWeight) {
        double max;
        List<ChoiceScore> results = this.applyScores(topRankChoices, idsToExclude, idsToInclude, resultByChoice);
        if (!results.isEmpty() && (max = results.get(results.size() - 1).getScoreValue().doubleValue()) < totalWeight) {
            this.guessChoiceIdsToRemove(idsToInclude, idsToExclude, topRankChoices);
            idsToInclude.removeAll(idsToExclude);
            this.round(topRankChoices, idsToExclude, idsToInclude, resultByChoice, totalWeight);
        }
    }

    protected List<ChoiceScore> applyScores(Map<Voter, List<Set<String>>> topRankChoices, Set<String> idsToExclude, Set<String> idsToInclude, Map<String, ChoiceScore> resultByChoice) {
        ChoiceScore choiceScore;
        if (CollectionUtils.isNotEmpty(idsToExclude)) {
            for (List list : topRankChoices.values()) {
                Iterator itr = list.iterator();
                while (itr.hasNext()) {
                    Set choiceIds = (Set)itr.next();
                    choiceIds.removeAll(idsToExclude);
                    if (!choiceIds.isEmpty()) continue;
                    itr.remove();
                }
            }
        }
        for (String string : idsToInclude) {
            resultByChoice.get(string).setScoreValue(null);
        }
        for (Map.Entry entry : topRankChoices.entrySet()) {
            List idsByLevel = (List)entry.getValue();
            if (idsByLevel.isEmpty()) continue;
            Set winnerIds = (Set)idsByLevel.get(0);
            Voter voter = (Voter)entry.getKey();
            double voterWeight = voter.getWeight();
            for (String id : winnerIds) {
                if (!idsToInclude.contains(id)) continue;
                ChoiceScore choiceScore2 = resultByChoice.get(id);
                choiceScore2.addScoreValue(voterWeight);
            }
        }
        ArrayList results = Lists.newArrayList();
        for (String id : idsToInclude) {
            results.add(resultByChoice.get(id));
        }
        Collections.sort(results);
        Iterator iterator = results.iterator();
        while (iterator.hasNext() && ((choiceScore = (ChoiceScore)iterator.next()).getScoreValue() == null || ZERO_D.equals(choiceScore.getScoreValue()))) {
            iterator.remove();
        }
        return results;
    }

    protected void guessChoiceIdsToRemove(Set<String> idsToInclude, Set<String> idsToExclude, Map<Voter, List<Set<String>>> results) {
        ChoiceScore choiceScore;
        TreeMap badScores = Maps.newTreeMap();
        for (String string : idsToInclude) {
            badScores.put(string, ChoiceScore.newScore((String)string, null));
        }
        for (Map.Entry entry : results.entrySet()) {
            Voter voter = (Voter)entry.getKey();
            List idsChoices = (List)entry.getValue();
            if (idsChoices.isEmpty()) continue;
            Set lastIds = (Set)idsChoices.get(idsChoices.size() - 1);
            double voterWeight = voter.getWeight();
            for (String lastId : lastIds) {
                ((ChoiceScore)badScores.get(lastId)).addScoreValue(voterWeight);
            }
        }
        ArrayList scores = Lists.newArrayList(badScores.values());
        Collections.sort(scores);
        Collections.reverse(scores);
        double d = ((ChoiceScore)scores.get(0)).getScoreValue().doubleValue();
        idsToExclude.clear();
        Iterator i$ = scores.iterator();
        while (i$.hasNext() && d == (choiceScore = (ChoiceScore)i$.next()).getScoreValue().doubleValue()) {
            idsToExclude.add(choiceScore.getChoiceId());
        }
    }
}

