/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.utils;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FeedUtil {
    private static final Log log = LogFactory.getLog(FeedUtil.class);

    public static void createFeed(String filename, String type, String title, String link, String description) {
        FeedUtil.createFeed((File)new File(filename), (String)type, (String)title, (String)link, (String)description);
    }

    public static void createFeed(File file, String type, String title, String link, String description) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(type);
            feed.setTitle(title);
            feed.setLink(link);
            feed.setDescription(description);
            FileWriter writer = new FileWriter(file);
            SyndFeedOutput output = new SyndFeedOutput();
            output.output((SyndFeed)feed, (Writer)writer);
            ((Writer)writer).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Feed created: " + file.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Feed creation error", (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    public static void deleteFeed(String filename) {
        FeedUtil.deleteFeed((File)new File(filename));
    }

    public static void deleteFeed(File file) {
        file.delete();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Feed deleted: " + file.getAbsolutePath()));
        }
    }

    public static void feedFeed(String filename, String title, String link, String content) {
        FeedUtil.feedFeed((File)new File(filename), (String)title, (String)link, (String)content);
    }

    public static void feedFeed(File file, String title, String link, String content) {
        try {
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)new XmlReader(file));
            entries.addAll(feed.getEntries());
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(title);
            entry.setLink(link);
            entry.setPublishedDate(new Date());
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(content);
            entry.setDescription((SyndContent)description);
            entries.add(entry);
            feed.setEntries(entries);
            FileWriter writer = new FileWriter(file);
            SyndFeedOutput output = new SyndFeedOutput();
            output.output(feed, (Writer)writer);
            ((Writer)writer).close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Feed updated: " + file.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Feed feeding error", (Throwable)e);
            }
            e.printStackTrace();
        }
    }
}

