/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.pages.user;

import java.util.List;

import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.ui.base.Polls;

/**
 * Classe de la page d'affichage des sondages auxquels l'utilisateur a
 * participé. Si l'utilisateur n'est pas identifié, on lui demande d'abord de
 * s'identifier via un formulaire.
 *
 * @author rannou
 * @version $Id: UserPollsParticipated.java 2741 2009-08-24 14:08:45Z nrannou $
 */
@IncludeStylesheet("context:css/pollsParticipated.css")
public class UserPollsParticipated extends Polls {

    /**
     * Objet de session représentant l'utilisateur identifié.
     */
    @SessionState
    private UserDTO user;
    private boolean userExists;

    /**
     * Liste des sondages auxquels l'utilisateur a participé
     */
    @SuppressWarnings("unused")
    @Property
    private List<PollDTO> participatedPolls;

    /**
     * Liste des sondages auxquels l'utilisateur est invité
     */
    @SuppressWarnings("unused")
    @Property
    private List<PollDTO> invitedPolls;

    /** Injection des services */
    @Inject
    private ServicePoll servicePoll;

    /**
     * Récupération de l'identifiant de vote du sondage.
     *
     * @return l'identifiant.
     */
    public String getVoteId(PollDTO poll) {
        for (VotingListDTO list : poll.getVotingListDTOs()) {
            for (PollAccountDTO account : list.getPollAccountDTOs()) {
                if (account.getEmail().equals(user.getEmail())) {
                    return poll.getPollId() + ":" + account.getAccountId();
                }
            }
        }
        return poll.getPollId();
    }

    /**
     * Méthode d'initialisation des sondages
     */
    @Override
    public void onActivate() {
        super.onActivate();
        if (userExists) {
            participatedPolls = servicePoll.findParticipatedPolls(user.getId());
            invitedPolls = servicePoll.findInvitedPolls(user.getId());
        }
    }
}
