/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.ui.data.uio.ImageChoiceUIO;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageUtil {
    private static final Log log = LogFactory.getLog(ImageUtil.class);

    public static void saveImage(ImageChoiceUIO imgChoice, File dir) {
        ArrayList<ImageChoiceUIO> imgChoices = new ArrayList<ImageChoiceUIO>();
        imgChoices.add(imgChoice);
        ImageUtil.saveImages(imgChoices, (File)dir);
    }

    public static void saveImages(List<ImageChoiceUIO> imgChoices, File dir) {
        if (imgChoices != null && imgChoices.size() > 0) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Destination folder: " + dir.getAbsolutePath()));
            }
            for (ImageChoiceUIO imgChoice : imgChoices) {
                if (imgChoice.getImg() == null || !imgChoice.getImg().getContentType().contains("image") && !imgChoice.getImg().getContentType().contains("IMAGE")) continue;
                File img = new File(dir, imgChoice.getName());
                imgChoice.getImg().write(img);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Image saved: " + imgChoice.getImg().getFileName() + " (size=" + imgChoice.getImg().getSize() + ")"));
                }
                ImageUtil.createThumbnail((File)dir, (File)img, (int)100);
            }
        }
    }

    private static void createThumbnail(File dir, File img, int width) {
        ImageIcon ii = new ImageIcon(img.getAbsolutePath());
        Image image = ii.getImage();
        double imageRatio = (double)image.getHeight(null) / (double)image.getWidth(null);
        int height = (int)((double)width * imageRatio);
        BufferedImage thumbImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        File thumbCopied = new File(dir, "thumb_" + img.getName());
        try {
            ImageIO.write((RenderedImage)thumbImage, "jpg", thumbCopied);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Thumbnail created: " + thumbCopied.getName() + " (size=" + thumbCopied.length() + ")"));
        }
    }
}

