/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.user;

import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.Retain;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.BeanModelSource;
import org.chorem.pollen.business.ServicePoll;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.data.EvenOdd;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.pages.poll.ClosePoll;

@IncludeStylesheet(value={"context:css/polls.css"})
public class UserPolls {
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;
    @Property
    private List<PollDTO> polls;
    @Property
    private PollDTO poll;
    @Property
    private EvenOdd evenOdd;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources componentResources;
    @Property
    @Retain
    private BeanModel pollsModel;
    @InjectPage
    private ClosePoll closePoll;
    @Inject
    private ServicePoll servicePoll;

    public String getAdminId() {
        return this.poll.getPollId() + ":" + MD5.encode((String)this.poll.getCreatorId());
    }

    Object onActionFromClose(String id) {
        this.closePoll.setPoll(this.servicePoll.findPollByPollId(id));
        return this.closePoll;
    }

    void onActivate() {
        this.evenOdd = new EvenOdd();
        if (this.userExists) {
            this.polls = this.servicePoll.findPollsByUser(this.user.getId());
        }
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        this.pollsModel = this.beanModelSource.createDisplayModel(PollDTO.class, this.componentResources.getMessages());
        this.pollsModel.add("functions", null);
        this.pollsModel.include(new String[]{"title", "description", "beginChoiceDate", "beginDate", "endDate", "functions"});
    }
}

