/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.poll;

import java.util.Date;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chenillekit.tapestry.core.components.DateTimeField;
import org.chorem.pollen.business.ServiceList;
import org.chorem.pollen.business.ServicePoll;
import org.chorem.pollen.business.ServicePollAccount;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.data.PollStep;
import org.chorem.pollen.ui.pages.poll.ClosePoll;
import org.chorem.pollen.ui.pages.poll.ModificationValidation;
import org.chorem.pollen.ui.pages.poll.PollModification;

@IncludeStylesheet(value={"context:css/pollcreation.css"})
public class PollModification {
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Component(id="feedback")
    private FeedBack feedback;
    @Persist
    private PollStep step;
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField beginChoiceDate;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField beginDate;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField endDate;
    @Property
    @Persist
    private PollDTO poll;
    @Property
    @Persist
    private PollAccountDTO pollAccount;
    @Property
    private boolean userAllowed = false;
    private Date beginDateValidation;
    @InjectComponent
    private Zone pollCreationZone;
    @InjectPage
    private ClosePoll closePoll;
    @Property
    @Persist
    private boolean notificationCheckBox;
    @Property
    @Persist
    private PreventRuleDTO newRule;
    @Property
    private VotingListDTO votingList;
    @Property
    private PollAccountDTO votingListPerson;
    @Property
    private ChoiceDTO choice;
    @InjectPage
    private ModificationValidation modificationValidation;
    @Inject
    private Messages messages;
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServicePollAccount servicePollAccount;
    @Inject
    private ServiceList serviceList;

    Object onSuccessFromPollCreationForm() {
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 1: {
                this.step = PollStep.OPTIONS;
                break;
            }
            case 2: {
                if (this.poll.isContinuousResults()) {
                    this.poll.setPublicResults(true);
                }
                if (this.isFreePoll()) {
                    this.step = PollStep.CHOICES;
                    break;
                }
                this.step = PollStep.LISTS;
                break;
            }
            case 3: {
                this.step = PollStep.CHOICES;
                break;
            }
            case 4: {
                PreventRuleDTO oldRule = null;
                for (PreventRuleDTO rule : this.poll.getPreventRuleDTOs()) {
                    if (!rule.getId().equals(this.newRule.getId())) continue;
                    oldRule = rule;
                }
                if (oldRule != null) {
                    this.poll.getPreventRuleDTOs().remove(oldRule);
                    if (this.notificationCheckBox) {
                        this.poll.getPreventRuleDTOs().add(this.newRule);
                    }
                } else {
                    this.poll.getPreventRuleDTOs().add(this.newRule);
                }
                this.servicePollAccount.updatePollAccount(this.pollAccount);
                for (VotingListDTO votingList : this.poll.getVotingListDTOs()) {
                    for (PollAccountDTO account : votingList.getPollAccountDTOs()) {
                        this.servicePollAccount.updatePollAccount(account);
                    }
                    this.serviceList.updateVotingList(votingList);
                }
                if (this.poll.isContinuousResults()) {
                    this.poll.setPublicResults(true);
                }
                for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                    choice.setValidate(true);
                }
                this.servicePoll.updatePoll(this.poll);
                this.modificationValidation.setPoll(this.poll);
                return this.modificationValidation;
            }
            default: {
                this.step = PollStep.POLL;
            }
        }
        return this.pollCreationZone.getBody();
    }

    Object onSubmitFromPollCreationForm() {
        return this.pollCreationZone.getBody();
    }

    Object onPrevious() {
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 2: {
                this.step = PollStep.POLL;
                break;
            }
            case 3: {
                this.step = PollStep.OPTIONS;
                break;
            }
            case 4: {
                if (this.isFreePoll()) {
                    this.step = PollStep.OPTIONS;
                    break;
                }
                this.step = PollStep.LISTS;
                break;
            }
            default: {
                this.step = PollStep.POLL;
            }
        }
        return this.pollCreationZone.getBody();
    }

    void onValidateFromEndDate(Date value) throws ValidationException {
        if (this.beginDateValidation == null) {
            this.beginDateValidation = new Date();
        }
        if (value != null && value.before(this.beginDateValidation)) {
            throw new ValidationException(this.messages.get("endDate-validate"));
        }
    }

    void onValidateFromBeginChoiceDate(Date value) throws ValidationException {
        if (this.beginDateValidation == null) {
            this.beginDateValidation = new Date();
        }
        if (value != null && value.after(this.beginDateValidation)) {
            throw new ValidationException(this.messages.get("beginChoiceDate-validate"));
        }
    }

    void onValidateFormFromPollCreationForm() throws ValidationException {
        int nbEqual = 0;
        int nbNotNull = 0;
        if (this.step == PollStep.LISTS) {
            for (VotingListDTO votingList : this.poll.getVotingListDTOs()) {
                for (PollAccountDTO account1 : votingList.getPollAccountDTOs()) {
                    if (account1.getVotingId() == null) continue;
                    ++nbNotNull;
                    for (PollAccountDTO account2 : votingList.getPollAccountDTOs()) {
                        if (!account1.getVotingId().equals(account2.getVotingId())) continue;
                        ++nbEqual;
                    }
                }
            }
            if (nbEqual > nbNotNull) {
                throw new ValidationException(this.messages.get("list-validate"));
            }
        }
    }

    Object onActionFromCloseButton() {
        this.closePoll.setPoll(this.poll);
        return this.closePoll;
    }

    public String getChoiceDateDisplay() {
        return this.poll.isChoiceAddAllowed() ? "display: block;" : "display: none;";
    }

    public String getNotificationDisplay() {
        return this.notificationCheckBox ? "display: block;" : "display: none;";
    }

    public Date getChoiceNameAsDate() {
        return new Date(Long.valueOf(this.choice.getName()));
    }

    public String getStepLegend() {
        Integer index = this.step.getIndex();
        if (this.poll.getPollType() == PollType.FREE && this.step == PollStep.CHOICES) {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index - 1);
        }
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 1: {
                return this.messages.format("pollLegend", new Object[]{index});
            }
            case 2: {
                return this.messages.format("optionsLegend", new Object[]{index});
            }
            case 3: {
                return this.messages.format("listsLegend", new Object[]{index});
            }
            case 4: {
                return this.messages.format("choicesLegend", new Object[]{index});
            }
        }
        return "";
    }

    public boolean isInPoll() {
        return this.step == PollStep.POLL;
    }

    public boolean isInLists() {
        return this.step == PollStep.LISTS;
    }

    public boolean isInChoices() {
        return this.step == PollStep.CHOICES;
    }

    public boolean isInOptions() {
        return this.step == PollStep.OPTIONS;
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextChoices() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateChoices() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImgChoices() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    Object onActionFromPrevOptions() {
        this.step = PollStep.POLL;
        return this.pollCreationZone.getBody();
    }

    Object onActionFromPrevLists() {
        this.step = PollStep.OPTIONS;
        return this.pollCreationZone.getBody();
    }

    Object onActionFromPrevChoices() {
        this.step = this.isFreePoll() ? PollStep.OPTIONS : PollStep.LISTS;
        return this.pollCreationZone.getBody();
    }

    void onActivate(String id) {
        if (id != null && !"".equals(id) && id.split(":", 2).length == 2) {
            String pollId = id.split(":", 2)[0];
            String creatorId = id.split(":", 2)[1];
            this.poll = this.servicePoll.findPollByPollId(pollId);
            if (this.poll != null) {
                if (creatorId.equals(MD5.encode((String)this.poll.getCreatorId()))) {
                    this.pollAccount = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
                    this.userAllowed = true;
                }
                this.notificationCheckBox = false;
                this.newRule = new PreventRuleDTO("vote", 0, true, "emailAction");
                this.newRule.setPollId(this.poll.getId());
                for (PreventRuleDTO rule : this.poll.getPreventRuleDTOs()) {
                    if (!"vote".equals(rule.getScope())) continue;
                    this.notificationCheckBox = true;
                    this.newRule = rule;
                }
            }
        }
        if (this.poll == null) {
            this.feedback.addError(this.messages.get("pollNotFound"));
        } else if (this.poll.isClosed()) {
            this.feedback.addError(this.messages.get("pollClosed"));
        } else if (!this.userAllowed) {
            this.feedback.addError(this.messages.get("userNotAllowed"));
        }
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        this.step = PollStep.POLL;
    }
}

