/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.poll;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.json.JSONObject;
import org.chenillekit.tapestry.core.components.DateTimeField;
import org.chorem.pollen.business.ServiceList;
import org.chorem.pollen.business.ServicePoll;
import org.chorem.pollen.business.business.PreventRuleManager;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PersonListDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.ui.data.GenericSelectModel;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.data.PollStep;
import org.chorem.pollen.ui.data.uio.DateChoiceUIO;
import org.chorem.pollen.ui.data.uio.ImageChoiceUIO;
import org.chorem.pollen.ui.pages.poll.CreationValidation;
import org.chorem.pollen.ui.pages.poll.PollCreation;
import org.chorem.pollen.ui.services.Configuration;
import org.chorem.pollen.ui.utils.ImageUtil;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/pollcreation.css"})
public class PollCreation {
    @Persist
    private PollStep step;
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;
    @SessionState
    @Property
    private String siteURL;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField beginChoiceDate;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField beginDate;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField endDate;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField dateDTF;
    private Date beginDateValidation;
    @InjectComponent
    private Zone pollCreationZone;
    @Property
    @Persist
    private PollDTO poll;
    private boolean addPersonSelected;
    @Persist
    private boolean addChoiceSelected;
    @Property
    @Persist
    private boolean choiceNbCheckBox;
    @Property
    @Persist
    private boolean notificationCheckBox;
    @Property
    @Persist
    private boolean reminderCheckBox;
    @Property
    @Persist
    private PreventRuleDTO notificationPreventRule;
    @Property
    @Persist
    private PreventRuleDTO reminderPreventRule;
    @Property
    @Persist
    private PollAccountDTO pollAccount;
    @Property
    private int nbVotingListPersons = 5;
    @Property
    private PollAccountDTO votingListPerson;
    @Property
    @Persist
    private List<PollAccountDTO> votingListPersons;
    @Property
    @Persist
    private GenericSelectModel<PersonListDTO> personLists;
    @Property
    @Persist
    private PersonListDTO personList;
    @Property
    private int nbChoices = 5;
    @Property
    private ChoiceDTO choice;
    @Property
    private DateChoiceUIO dateTypeChoice;
    @Property
    private ImageChoiceUIO imgTypeChoice;
    @Property
    @Persist
    private List<ChoiceDTO> choices;
    @Property
    @Persist
    private List<DateChoiceUIO> dateTypeChoices;
    @Property
    @Persist
    private List<ImageChoiceUIO> imgTypeChoices;
    @Component(id="pollCreationForm")
    private Form pollCreationForm;
    @Component(id="choicesCreationForm")
    private Form choicesCreationForm;
    @InjectPage
    private CreationValidation creationValidation;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Inject
    private PropertyAccess _propertyAccess;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Inject
    private Configuration conf;
    @Inject
    private Logger logger;
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServiceList serviceList;

    Object onSuccessFromPollCreationForm() {
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 1: {
                this.step = PollStep.OPTIONS;
                break;
            }
            case 2: {
                if (this.poll.isAnonymous()) {
                    this.poll.setAnonymousVoteAllowed(true);
                }
                if (this.poll.isContinuousResults()) {
                    this.poll.setPublicResults(true);
                }
                if (this.isFreePoll()) {
                    this.step = PollStep.CHOICES;
                    break;
                }
                this.step = PollStep.LISTS;
                break;
            }
            case 3: {
                if (this.addPersonSelected) break;
                this.step = PollStep.CHOICES;
                break;
            }
            case 4: {
                break;
            }
            default: {
                this.step = PollStep.POLL;
            }
        }
        return this.pollCreationZone.getBody();
    }

    Object onSubmitFromPollCreationForm() {
        return this.pollCreationZone.getBody();
    }

    Object onSuccessFromChoicesCreationForm() {
        if (!this.addChoiceSelected) {
            if (!this.isFreePoll()) {
                VotingListDTO restrictedList = new VotingListDTO();
                for (PollAccountDTO person : this.votingListPersons) {
                    if (person.getVotingId() == null) continue;
                    restrictedList.getPollAccountDTOs().add(person);
                }
                this.poll.getVotingListDTOs().add(restrictedList);
            }
            if (this.isTextChoices()) {
                for (ChoiceDTO choice : this.choices) {
                    if (choice.getName() == null) continue;
                    choice.setValidate(true);
                    this.poll.getChoiceDTOs().add(choice);
                }
            } else if (this.isDateChoices()) {
                for (ChoiceDTO choice : this.dateTypeChoices) {
                    if (choice.getDate() == null) continue;
                    choice.setValidate(true);
                    choice.setName(String.valueOf(choice.getDate().getTime()));
                    this.poll.getChoiceDTOs().add(choice);
                }
            } else if (this.isImgChoices()) {
                for (ImageChoiceUIO imgChoice : this.imgTypeChoices) {
                    if (imgChoice.getImg() == null) continue;
                    System.out.println(imgChoice.getImg().getFileName());
                    if (imgChoice.getImg().getContentType().contains("image") || imgChoice.getImg().getContentType().contains("IMAGE")) {
                        imgChoice.setValidate(true);
                        imgChoice.setName(imgChoice.getImg().getFileName().replace(' ', '_'));
                        this.poll.getChoiceDTOs().add(imgChoice);
                        continue;
                    }
                    return this;
                }
            }
            this.updatePoll();
            this.creationValidation.setPoll(this.poll);
            return this.creationValidation;
        }
        return this;
    }

    Object onPrevious() {
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 2: {
                this.step = PollStep.POLL;
                break;
            }
            case 3: {
                this.step = PollStep.OPTIONS;
                break;
            }
            case 4: {
                if (this.isFreePoll()) {
                    this.step = PollStep.OPTIONS;
                    break;
                }
                this.step = PollStep.LISTS;
                break;
            }
            default: {
                this.step = PollStep.POLL;
            }
        }
        return this.pollCreationZone.getBody();
    }

    void onValidateFromBeginDate(Date value) throws ValidationException {
        this.beginDateValidation = value;
        if (value != null && value.before(new Date())) {
            throw new ValidationException(this.messages.get("beginDate-validate"));
        }
    }

    void onValidateFromEndDate(Date value) throws ValidationException {
        if (this.beginDateValidation == null) {
            this.beginDateValidation = new Date();
        }
        if (value != null && value.before(this.beginDateValidation)) {
            throw new ValidationException(this.messages.get("endDate-validate"));
        }
    }

    void onValidateFromBeginChoiceDate(Date value) throws ValidationException {
        if (this.beginDateValidation == null) {
            this.beginDateValidation = new Date();
        }
        if (value != null && value.after(this.beginDateValidation)) {
            throw new ValidationException(this.messages.get("beginChoiceDate-validate"));
        }
    }

    void onValidateFormFromPollCreationForm() throws ValidationException {
        int nbEqual = 0;
        int nbNotNull = 0;
        if (this.step == PollStep.LISTS) {
            for (PollAccountDTO account1 : this.votingListPersons) {
                if (account1.getVotingId() == null) continue;
                ++nbNotNull;
                for (PollAccountDTO account2 : this.votingListPersons) {
                    if (!account1.getVotingId().equals(account2.getVotingId())) continue;
                    ++nbEqual;
                }
            }
            if (nbEqual > nbNotNull) {
                throw new ValidationException(this.messages.get("list-validate"));
            }
        }
    }

    void onValidateFormFromChoicesCreationForm() throws ValidationException {
        int nbEqual = 0;
        int nbNotNull = 0;
        if (this.step == PollStep.CHOICES) {
            if (this.isTextChoices()) {
                for (ChoiceDTO choice1 : this.choices) {
                    if (choice1.getName() == null) continue;
                    ++nbNotNull;
                    for (ChoiceDTO choice2 : this.choices) {
                        if (choice2.getName() == null || !choice1.getName().equals(choice2.getName())) continue;
                        ++nbEqual;
                    }
                }
            } else if (this.isDateChoices()) {
                for (DateChoiceUIO choice1 : this.dateTypeChoices) {
                    if (choice1.getDate() == null) continue;
                    ++nbNotNull;
                    for (DateChoiceUIO choice2 : this.dateTypeChoices) {
                        if (choice2.getDate() == null || !choice1.getDate().equals(choice2.getDate())) continue;
                        ++nbEqual;
                    }
                }
            } else if (this.isImgChoices()) {
                for (ImageChoiceUIO choice1 : this.imgTypeChoices) {
                    if (choice1.getImg() == null) continue;
                    ++nbNotNull;
                    for (ImageChoiceUIO choice2 : this.imgTypeChoices) {
                        if (choice2.getImg() == null || !choice1.getImg().getFileName().equals(choice2.getImg().getFileName())) continue;
                        ++nbEqual;
                    }
                }
            }
            if (nbEqual > nbNotNull) {
                throw new ValidationException(this.messages.get("choice-validate"));
            }
        }
    }

    Object onUploadException(FileUploadException e) {
        this.pollCreationForm.recordError("Upload exception: " + e.getMessage());
        return this;
    }

    private boolean updatePoll() {
        if (!this.poll.getChoiceDTOs().isEmpty()) {
            if (this.userExists) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("user.getId() : " + this.user.getId());
                }
                this.poll.setUserId(this.user.getId());
            }
            for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                choice.setValidate(true);
            }
            if (this.notificationCheckBox) {
                this.poll.getPreventRuleDTOs().add(this.notificationPreventRule);
            }
            if (this.reminderCheckBox) {
                this.poll.getPreventRuleDTOs().add(this.reminderPreventRule);
            }
            if (this.poll.getBeginDate() == null) {
                this.poll.setBeginDate(new Date());
            }
            this.poll.setPollId(UUID.randomUUID().toString().replaceAll("-", ""));
            this.poll.setId(this.servicePoll.createPoll(this.poll));
            if (this.poll.isAnonymous()) {
                this.poll.setAnonymousVoteAllowed(true);
            }
            if (this.poll.isContinuousResults()) {
                this.poll.setPublicResults(true);
            }
            if (this.poll.getMaxChoiceNb() < 1 || this.poll.getMaxChoiceNb() > this.poll.getChoiceDTOs().size()) {
                this.poll.setMaxChoiceNb(this.poll.getChoiceDTOs().size());
            }
            if (this.servicePoll.updatePoll(this.poll)) {
                if (this.poll.getChoiceType() == ChoiceType.IMAGE) {
                    ImageUtil.saveImages((List)this.imgTypeChoices, (File)new File(this.conf.getProperty("upImgDir"), this.poll.getPollId()));
                }
                this.poll = this.servicePoll.findPollById(this.poll.getId());
                this.sendMailNotification();
                return true;
            }
            return false;
        }
        return false;
    }

    private void sendMailNotification() {
        String voteURL = this.siteURL + "poll/VoteFor/" + this.poll.getPollId();
        String modifURL = this.siteURL + "poll/Modification/" + this.poll.getPollId() + ":" + MD5.encode((String)this.poll.getCreatorId());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("host", this.conf.getProperty("email_host"));
        data.put("port", this.conf.getProperty("email_port"));
        data.put("from", this.conf.getProperty("email_from"));
        if (this.poll.getCreatorEmail() != null) {
            data.put("to", this.poll.getCreatorEmail());
            data.put("title", this.messages.format("creatorEmail_subject", new Object[]{this.poll.getTitle()}));
            data.put("msg", this.messages.format("creatorEmail_msg", new Object[]{this.poll.getTitle(), voteURL, modifURL}));
            PreventRuleManager.emailAction(data);
        }
        for (VotingListDTO list : this.poll.getVotingListDTOs()) {
            for (PollAccountDTO account : list.getPollAccountDTOs()) {
                if (account.getEmail() == null) continue;
                data.put("to", account.getEmail());
                data.put("title", this.messages.format("votingEmail_subject", new Object[]{this.poll.getTitle()}));
                data.put("msg", this.messages.format("votingEmail_msg", new Object[]{this.poll.getTitle(), account.getVotingId(), voteURL}));
                PreventRuleManager.emailAction(data);
            }
        }
    }

    public String getChoiceDateDisplay() {
        return this.poll.isChoiceAddAllowed() ? "display: block;" : "display: none;";
    }

    public String getChoiceNbDisplay() {
        return this.choiceNbCheckBox ? "display: block;" : "display: none;";
    }

    public String getNotificationDisplay() {
        return this.notificationCheckBox ? "display: block;" : "display: none;";
    }

    public String getReminderDisplay() {
        return this.reminderCheckBox ? "display: block;" : "display: none;";
    }

    public String getStepLegend() {
        Integer index = this.step.getIndex();
        if (this.isFreePoll() && this.step == PollStep.CHOICES) {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index - 1);
        }
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollStep[this.step.ordinal()]) {
            case 1: {
                return this.messages.format("pollLegend", new Object[]{index});
            }
            case 2: {
                return this.messages.format("optionsLegend", new Object[]{index});
            }
            case 3: {
                return this.messages.format("listsLegend", new Object[]{index});
            }
            case 4: {
                return this.messages.format("choicesLegend", new Object[]{index});
            }
        }
        return "";
    }

    public boolean isInPoll() {
        return this.step == PollStep.POLL;
    }

    public boolean isInLists() {
        return this.step == PollStep.LISTS;
    }

    public boolean isInChoices() {
        return this.step == PollStep.CHOICES;
    }

    public boolean isInOptions() {
        return this.step == PollStep.OPTIONS;
    }

    public boolean isNormalVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.NORMAL;
    }

    public boolean isPercentageVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.PERCENTAGE;
    }

    public boolean isCondorcetVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.CONDORCET;
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextChoices() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateChoices() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImgChoices() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public JSONObject onChangeFromListSelect(String value) {
        if (!"".equals(value)) {
            this.personList = this.serviceList.findPersonListById(value);
            for (PollAccountDTO account : this.personList.getPollAccountDTOs()) {
                account.setId("");
                account.setPersonListId("");
            }
            this.votingListPersons = this.personList.getPollAccountDTOs();
        }
        return this.createParamsForCallback();
    }

    public JSONObject onChangeFromChoiceType(String value) {
        this.poll.setChoiceType(ChoiceType.valueOf((String)value));
        return this.createParamsForCallback();
    }

    private JSONObject createParamsForCallback() {
        JSONObject json = new JSONObject();
        Link link = this.resources.createEventLink("updatePollCreationZone", new Object[0]);
        json.put("link", (Object)link.toAbsoluteURI());
        json.put("zoneId", (Object)"pollCreationZone");
        return json;
    }

    public Object onUpdatePollCreationZone() {
        return this.pollCreationZone.getBody();
    }

    void onSelectedFromAddPerson() {
        this.votingListPersons.add(new PollAccountDTO());
        this.addPersonSelected = true;
    }

    void onSelectedFromAddChoice() {
        if (this.poll.getChoiceType() == ChoiceType.DATE) {
            this.dateTypeChoices.add(new DateChoiceUIO());
        } else if (this.poll.getChoiceType() == ChoiceType.IMAGE) {
            this.imgTypeChoices.add(new ImageChoiceUIO());
        } else {
            this.choices.add(new ChoiceDTO());
        }
        this.addChoiceSelected = true;
    }

    public boolean isPersonListsExists() {
        return this.personLists != null && !this.personLists.getList().isEmpty();
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        if (!this.addChoiceSelected && !this.choicesCreationForm.getHasErrors()) {
            this.initPoll();
        }
        this.addChoiceSelected = false;
    }

    private void initPoll() {
        int i;
        this.step = PollStep.POLL;
        this.poll = new PollDTO();
        this.pollAccount = new PollAccountDTO();
        if (this.userExists) {
            this.poll.setCreatorId(this.user.getLogin());
            this.poll.setCreatorEmail(this.user.getEmail());
        }
        this.notificationPreventRule = new PreventRuleDTO("vote", 0, true, "emailAction");
        this.reminderPreventRule = new PreventRuleDTO("rappel", 0, false, "emailAction");
        this.notificationCheckBox = false;
        this.reminderCheckBox = false;
        this.choiceNbCheckBox = false;
        this.choices = new ArrayList();
        this.dateTypeChoices = new ArrayList();
        this.imgTypeChoices = new ArrayList();
        for (i = 0; i < this.nbChoices; ++i) {
            this.choices.add(new ChoiceDTO());
            this.dateTypeChoices.add(new DateChoiceUIO());
            this.imgTypeChoices.add(new ImageChoiceUIO());
        }
        this.addPersonSelected = false;
        this.votingListPersons = new ArrayList();
        for (i = 0; i < this.nbVotingListPersons; ++i) {
            this.votingListPersons.add(new PollAccountDTO());
        }
        this.personList = null;
        if (this.userExists) {
            List _personLists = this.serviceList.findPersonListByUser(this.user.getId());
            this.personLists = new GenericSelectModel(_personLists, PersonListDTO.class, "name", "id", this._propertyAccess);
        }
    }
}

