/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.components;

import java.util.Date;
import java.util.Locale;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PersistentLocale;
import org.apache.tapestry5.services.Request;
import org.chorem.pollen.business.ServiceAuth;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.data.Lien;

@IncludeStylesheet(value={"context:css/main.css"})
public class Border {
    @Component(id="borderFeedback")
    private FeedBack feedback;
    @SessionState
    private String siteURL;
    @Parameter(required=false)
    @Property
    private Lien[] address;
    @Parameter(required=true, defaultPrefix="literal")
    @Property
    private String pageLogo;
    @Property
    private String logo;
    @Property
    private Lien lien;
    @Property
    private String login;
    @Property
    private String password;
    @SessionState
    @Property
    private UserDTO user;
    @Property
    private boolean userExists;
    @Inject
    private PersistentLocale localeService;
    @Inject
    private Request request;
    @Inject
    private Messages messages;
    @Inject
    private ServiceAuth serviceAuth;

    Object onSuccessFromLoginForm() {
        UserDTO userDTO = this.serviceAuth.isLoginRight(this.login, MD5.encode((String)this.password));
        if (userDTO != null) {
            this.user = userDTO;
            this.feedback.addInfo(this.messages.get("loginOk"));
        } else {
            this.feedback.addError(this.messages.get("loginFailed"));
        }
        return null;
    }

    Object onActionFromLogout() {
        this.user = null;
        return "Index";
    }

    void onActionFromLocaleFr() {
        this.localeService.set(Locale.FRENCH);
    }

    void onActionFromLocaleEn() {
        this.localeService.set(Locale.ENGLISH);
    }

    public Date getCurrentTime() {
        return new Date();
    }

    void setupRender() {
        this.siteURL = "http://" + this.request.getHeader("host") + this.request.getContextPath() + "/";
        this.logo = this.localeService != null && this.localeService.get() != null && Locale.FRENCH.equals(this.localeService.get()) ? "pollen" + this.pageLogo + "_fr.png" : "pollen" + this.pageLogo + "_en.png";
    }
}

