/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.admin;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.ui.actions.PollUriAware;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

/**
 * Deletes an existing poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DeletePoll extends PollenActionSupport implements PollenUserSecurityAware, PollUriAware {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(DeletePoll.class);

    protected String redirectUrl;

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    public String execute() throws Exception {

        // must be poll creator/admin to perform this action
        Preconditions.checkState(getUserSecurityContext().isCreator());

        Poll poll = getUserSecurityContext().getPoll();

        String title = getUserSecurityContext().getPoll().getTitle();

        if (log.isDebugEnabled()) {
            log.debug(String.format("Will delete poll %s", title));
        }
        getPollService().deletePoll(poll.getPollId());

        addFlashMessage(_("pollen.information.poll.deleted", title));
        return SUCCESS;
    }

}
