/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: GetPollComments.java 3702 2012-09-23 13:48:42Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetPollComments.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.nuiton.util.beans.Binder;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Get paginated list of poll comments.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetPollComments extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] data;

    protected String pollId;

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    @Override
    public Map<String, Object>[] getData() {
        return data;
    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(pollId);

        List<Comment> commentList = getPollCommentService().getComments(
                pager, pollId);

        //TODO-tchemit-2012-06-03 Should use also pollAccountId (if specified in url)...
        Poll poll = getPollService().getExistingPollByPollId(pollId);
        PollenUserSecurityContext securityContext =
                PollenUserSecurityContext.newContext(
                        getPollenUserAccount(), pollId, null, poll);
        securityContext.loadUserRoles(getSecurityService());

        data = new Map[commentList.size()];
        Binder<Comment, Comment> binder =
                PollenBinderHelper.getSimpleTopiaBinder(Comment.class);
        int index = 0;
        for (Comment comment : commentList) {

            Map<String, Object> map = binder.obtainProperties(
                    comment,
                    Comment.PROPERTY_TEXT,
                    Comment.PROPERTY_POST_DATE,
                    Comment.PROPERTY_AUTHOR
            );
            map.put("id", comment.getTopiaId());
            Set<String> functions = getCommentFunctions(
                    comment,
                    securityContext);
            map.put("functions", functions);
            data[index++] = map;
        }
        return SUCCESS;
    }

    private Set<String> getCommentFunctions(Comment comment,
                                            PollenUserSecurityContext securityContext) {
        Set<String> result = Sets.newHashSet();
        boolean canDelete = getSecurityService().isCanDeleteComment(
                securityContext, comment);
        if (canDelete) {
            result.add("delete");
        }
        return result;
    }


}
