<%--
  #%L
  Pollen :: UI (struts2)
  $Id: favoriteList.jsp 3522 2012-06-19 10:18:41Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/user/favoriteList.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<script type="text/javascript"
        src="<s:url value='/js/favoriteList.js' />"></script>

<s:url id="loadPollAccounts" action="getFavoriteListPollAccounts"
       namespace="/json" escapeAmp="false">
  <s:param name="favoriteListId" value="%{favoriteList.topiaId}"/>
</s:url>

<s:url id="editPollAccounts" action="editPollAccount" namespace="/user">
  <s:param name="favoriteListId" value="%{favoriteList.topiaId}"/>
</s:url>

<script type="text/javascript">

  var favoriteListId = '<s:property value="favoriteList.topiaId"/>';
  var redirectUrl = "<s:property value='%{editPollAccounts}'/>";
  var deleteTitle = '<s:text name="pollen.action.deletePollAccount"/>';
  var deleteUrl = '<s:url action="confirmDeletePollAccount" namespace="/user" />';
  var loadPollActionUrl = '<s:url action="getFavoriteListPollAccount" namespace="/json"/>';
  var editImg = '<s:url value='/img/edit.png'/>';
  var editTitle = '<s:text name="pollen.action.editPollAccount"/>';
  var deleteImg = '<s:url value='/img/delete.png'/>';

  jQuery(document).ready(function () {

    initFavoritePage("<s:property value='%{#action.action}'/>");
  });
</script>

<title>
  <s:text name="pollen.title.editFavoriteList"/> <s:property
  value="favoriteList.name"/>
</title>

<h1 class="title<s:property value='%{pageLogo}'/>">
  <s:text name="pollen.title.editFavoriteList"/> <s:property
  value="favoriteList.name"/>
</h1>

<sjg:grid id="pollAccounts" dataType="json" href="%{loadPollAccounts}"
          gridModel="pollAccounts" sortable="true" pager="true"
          pagerButtons="true" pagerInput="true"
          navigator="true" rownumbers="false" autowidth="true"
          onSelectRowTopics='pollAccounts-rowSelect' editinline="false"
          onCompleteTopics='pollAccounts-clearSelect'
          navigatorEdit="false" navigatorDelete="false"
          navigatorSearch="false" navigatorRefresh="false"
          navigatorAdd="false" viewrecords="true"
          rowList="10,15,20,50,100" rowNum="10"
          navigatorExtraButtons="{
                add:   { title: '%{getText(\"pollen.action.createPollAccount\")}', icon: 'ui-icon-plus',   topic: 'pollAccounts-addRow'   }}">

  <sjg:gridColumn name="id" title="id" hidden="true"/>
  <sjg:gridColumn name="votingId" title='%{getText("pollen.common.name")}'/>
  <sjg:gridColumn name="email" title='%{getText("pollen.common.email")}'/>
  <sjg:gridColumn name="functions" title='%{getText("pollen.common.functions")}'
                  formatter="favoriteListFunctions" width="40"
                  sortable="false"/>
</sjg:grid>

<br/>

<s:form id='createForm' method="POST" namespace="/user"
        cssClass="hidden pollAccountForm">

  <s:hidden name="action" value="create"/>
  <s:hidden key="favoriteListId" label=""/>
  <fieldset>
    <legend>
      <s:text name="pollen.fieldset.pollAccount.toAddToFavoriteList"/>
    </legend>
    <s:textfield key="createPollAccount.votingId" required="true"
                 label="%{getText('pollen.common.name')}" size="40"/>
    <s:textfield key="createPollAccount.email" required="true"
                 label="%{getText('pollen.common.email')}" size="40"/>

  </fieldset>
  <br/>
  <s:submit action="addPollAccount"
            key="pollen.action.create" align="center"/>
</s:form>

<s:form id='editForm' method="POST" namespace="/user"
        cssClass="hidden pollAccountForm">

  <s:hidden name="action" value="edit"/>
  <s:hidden key="editPollAccount.topiaId" label=""/>
  <s:hidden key="favoriteListId" label=""/>

  <fieldset>
    <legend>
      <s:text name="pollen.fieldset.pollAccount.toEditToFavoriteList"/>
    </legend>
    <s:textfield key="editPollAccount.votingId" required="true"
                 label="%{getText('pollen.common.name')}" size="40"/>
    <s:textfield key="editPollAccount.email" required="true"
                 label="%{getText('pollen.common.email')}" size="40"/>
  </fieldset>
  <br/>
  <s:submit action="editPollAccount" key="pollen.action.validate"
            align="center"/>
</s:form>

<br/>
<s:form method="POST" namespace="/user">

  <s:submit action="favoriteLists"
            key="pollen.action.backToFavoriteLists" align="center"/>
</s:form>

<sj:dialog id="confirmDialog" autoOpen="false" modal="true" width="500"/>
