/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.ParameterAware;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.services.exceptions.FavoriteListNotFoundException;
import org.chorem.pollen.services.exceptions.FavoriteListNotOwnedByUserException;
import org.chorem.pollen.services.exceptions.ParticipantAlreadyFoundInListException;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.util.StringUtil;

public class ManageFavoriteList
extends PollenActionSupport
implements Preparable,
ParameterAware {
    private static final long serialVersionUID = 1L;
    private Map<String, String[]> parameters;
    protected String action;
    protected PersonList favoriteList;
    protected PollAccount pollAccount;

    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public PollAccount getCreatePollAccount() {
        return this.getPollAccount();
    }

    public PollAccount getEditPollAccount() {
        return this.getPollAccount();
    }

    public PollAccount getDeletePollAccount() {
        return this.getPollAccount();
    }

    public PersonList getFavoriteList() {
        return this.favoriteList;
    }

    public String getFavoriteListId() {
        return this.favoriteList.getTopiaId();
    }

    public String getAction() {
        return this.action;
    }

    public void prepare() throws Exception {
        String[] favoriteListIds = (String[])this.parameters.get("favoriteListId");
        Preconditions.checkNotNull((Object)favoriteListIds);
        Preconditions.checkArgument((favoriteListIds.length == 1 ? 1 : 0) != 0);
        String favoriteListId = favoriteListIds[0];
        String[] actions = (String[])this.parameters.get("action");
        if (actions != null && actions.length == 1) {
            this.action = actions[0];
        }
        try {
            this.favoriteList = this.getFavoriteService().getFavoriteList(this.getPollenUserAccount(), favoriteListId);
        }
        catch (FavoriteListNotFoundException e) {
            this.addFlashError(this._("pollen.error.favoriteList.not.found", new Object[0]));
        }
        catch (FavoriteListNotOwnedByUserException e) {
            this.addFlashError(this._("pollen.error.favoriteList.not.owned.by.user", new Object[0]));
        }
    }

    public void validate() {
        if ("create".equals(this.action)) {
            PollAccount account = this.getCreatePollAccount();
            if (StringUtils.isBlank((CharSequence)account.getVotingId())) {
                this.addFieldError("createPollAccount.votingId", this._("pollen.error.pollAccount.votingId.required", new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)account.getEmail())) {
                this.addFieldError("createPollAccount.email", this._("pollen.error.email.required", new Object[0]));
            } else if (!StringUtil.isEmail((String)account.getEmail())) {
                this.addFieldError("createPollAccount.email", this._("pollen.error.email.invalid", new Object[0]));
            }
        } else if ("edit".equals(this.action)) {
            PollAccount account = this.getEditPollAccount();
            if (StringUtils.isBlank((CharSequence)account.getVotingId())) {
                this.addFieldError("editPollAccount.votingId", this._("pollen.error.pollAccount.votingId.required", new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)account.getEmail())) {
                this.addFieldError("editPollAccount.email", this._("pollen.error.email.required", new Object[0]));
            } else if (!StringUtil.isEmail((String)account.getEmail())) {
                this.addFieldError("editPollAccount.email", this._("pollen.error.email.invalid", new Object[0]));
            }
        }
    }

    public String create() throws Exception {
        Preconditions.checkNotNull((Object)this.favoriteList);
        Preconditions.checkNotNull((Object)this.pollAccount);
        String result = "input";
        try {
            this.getFavoriteService().addPollAccountToFavoriteList(this.favoriteList, this.pollAccount);
            this.addFlashMessage(this._("pollen.information.pollAccount.addedTofavoriteList", new Object[]{this.pollAccount.getVotingId()}));
            this.pollAccount = null;
            this.action = null;
            result = "success";
        }
        catch (ParticipantAlreadyFoundInListException e) {
            this.addFieldError("createPollAccount.email", this._("pollen.error.favoriteList.participant.already.found.in.list", new Object[0]));
        }
        return result;
    }

    public String edit() throws Exception {
        Preconditions.checkNotNull((Object)this.favoriteList);
        Preconditions.checkNotNull((Object)this.pollAccount);
        String result = "input";
        try {
            this.getFavoriteService().editPollAccountToFavoriteList(this.favoriteList, this.pollAccount);
            this.addFlashMessage(this._("pollen.information.pollAccount.updatedTofavoriteList", new Object[]{this.pollAccount.getVotingId()}));
            this.pollAccount = null;
            this.action = null;
            result = "success";
        }
        catch (ParticipantAlreadyFoundInListException e) {
            this.addFieldError("editPollAccount.email", this._("pollen.error.favoriteList.participant.already.found.in.list", new Object[0]));
        }
        return result;
    }

    public String delete() throws Exception {
        Preconditions.checkNotNull((Object)this.favoriteList);
        Preconditions.checkNotNull((Object)this.pollAccount);
        Preconditions.checkNotNull((Object)this.pollAccount.getTopiaId());
        this.getFavoriteService().removePollAccountToFavoriteList(this.favoriteList, this.pollAccount);
        this.addFlashMessage(this._("pollen.information.pollAccount.removedFromFavoriteList", new Object[]{this.pollAccount.getVotingId()}));
        this.action = null;
        this.pollAccount = null;
        return "success";
    }

    protected PollAccount getPollAccount() {
        if (this.pollAccount == null) {
            this.pollAccount = this.getFavoriteService().newPollAccountForFavoriteList();
        }
        return this.pollAccount;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }
}

