/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.ui.actions.poll.AbstractPollUriIdAction;

public class DeleteVote
extends AbstractPollUriIdAction {
    private static final long serialVersionUID = 1L;
    protected String voteId;
    protected String reason;

    public void setVoteId(String voteId) {
        this.voteId = voteId;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.getPollId());
        Preconditions.checkNotNull((Object)this.voteId);
        Poll poll = this.getPollService().getExistingPollByPollId(this.getPollId());
        this.getVoteService().deleteVote(poll, this.voteId, this.reason);
        this.addFlashMessage(this._("pollen.information.vote.deleted", new Object[0]));
        if (poll.getPollType() == PollType.FREE && this.getUriId().isAccountIdNotBlank() && !poll.getCreator().getAccountId().equals(this.getAccountId())) {
            this.getUriId().setAccountId(null);
        }
        return "success";
    }
}

