/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.ui.actions.json.AbstractJSONPaginedAction;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class GetPollComments
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, Object>[] comments;
    protected String pollId;

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public Map<String, Object>[] getComments() {
        return this.comments;
    }

    public Integer getRows() {
        return this.pager.getPageSize();
    }

    public Integer getPage() {
        return this.pager.getPageIndex();
    }

    public Integer getTotal() {
        return this.pager.getPagesNumber();
    }

    public Integer getRecords() {
        return this.pager.getRecords();
    }

    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.pollId);
        List commentList = this.getPollCommentService().getComments(this.pager, this.pollId);
        UserAccount userAccount = this.getPollenUserAccount();
        this.comments = new Map[commentList.size()];
        TopiaEntityBinder binder = PollenBinderHelper.getSimpleTopiaBinder(Comment.class);
        int index = 0;
        for (Comment comment : commentList) {
            Map map = binder.obtainProperties((Object)comment, new String[]{"text", "postDate", "author"});
            map.put("id", comment.getTopiaId());
            Set functions = this.getCommentFunctions(comment, userAccount);
            map.put("functions", functions);
            this.comments[index++] = map;
        }
        return "success";
    }

    private Set<String> getCommentFunctions(Comment comment, UserAccount userAccount) {
        HashSet result = Sets.newHashSet();
        boolean canDelete = this.getSecurityService().isCanDeleteComment(comment, null, null, userAccount);
        if (canDelete) {
            result.add("delete");
        }
        return result;
    }
}

