/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.io;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class GetPollImageChoice
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected String choiceTokenId;
    protected String pollId;
    protected String choiceId;
    protected boolean thumb;
    protected transient InputStream inputStream;
    protected String contentType;

    public void setChoiceTokenId(String choiceTokenId) {
        this.choiceTokenId = choiceTokenId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    public void setThumb(boolean thumb) {
        this.thumb = thumb;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String execute() throws Exception {
        File file;
        if (StringUtils.isNotBlank((CharSequence)this.choiceTokenId)) {
            file = (File)this.getPollenSession().getDynamicData(this.choiceTokenId);
        } else {
            Preconditions.checkNotNull((Object)this.pollId);
            Preconditions.checkNotNull((Object)this.choiceId);
            file = this.getPollService().getPollChoiceImageFile(this.pollId, this.choiceId);
            if (this.thumb) {
                file = this.getPollService().getImageThumbFile(file);
            }
        }
        MimetypesFileTypeMap mimes = new MimetypesFileTypeMap();
        this.contentType = mimes.getContentType(file);
        this.inputStream = new FileInputStream(file);
        return "success";
    }
}

