/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.impl.SecurityService;

public class PollenUserSecurityContext
implements Serializable {
    private static final long serialVersionUID = 5348851531764083245L;
    protected final UserAccount userAccount;
    protected final PollUri pollUri;
    protected Poll poll;
    protected Set<PollenUserSecurityRole> userRoles;

    public static PollenUserSecurityContext newContext(UserAccount userAccount, PollUri pollUri) {
        return PollenUserSecurityContext.newContext(userAccount, pollUri, null);
    }

    public static PollenUserSecurityContext newContext(UserAccount userAccount, String pollId, String accountId, Poll poll) {
        return PollenUserSecurityContext.newContext(userAccount, PollUri.newPollUri(pollId, accountId), poll);
    }

    public static PollenUserSecurityContext newContext(UserAccount userAccount, PollUri pollUri, Poll poll) {
        PollenUserSecurityContext result = new PollenUserSecurityContext(userAccount, pollUri);
        if (poll != null) {
            result.setPoll(poll);
        }
        return result;
    }

    protected PollenUserSecurityContext(UserAccount userAccount, PollUri pollUri) {
        this.userAccount = userAccount;
        this.pollUri = pollUri;
    }

    public boolean isPollExists() {
        return this.poll != null;
    }

    public boolean isAdmin() {
        return this.userAccount != null && this.userAccount.isAdministrator();
    }

    public boolean isWithAccountId() {
        return this.pollUri != null && this.pollUri.isAccountIdNotBlank();
    }

    public boolean isCreator() {
        return this.userRoles != null && this.userRoles.contains((Object)PollenUserSecurityRole.CREATOR);
    }

    public boolean isVoter() {
        return this.userRoles != null && this.userRoles.contains((Object)PollenUserSecurityRole.VOTER);
    }

    public boolean isRestrictedVoter() {
        return this.userRoles != null && this.userRoles.contains((Object)PollenUserSecurityRole.RESTRICTED_VOTER);
    }

    public boolean hasNoRole() {
        return CollectionUtils.isEmpty(this.userRoles);
    }

    public Set<PollenUserSecurityRole> getUserRoles() {
        return CollectionUtils.isEmpty(this.userRoles) ? Collections.emptySet() : ImmutableSet.copyOf(this.userRoles);
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    public PollUri getPollUri() {
        return this.pollUri;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public void setPoll(Poll poll) {
        this.poll = poll;
    }

    public void loadUserRoles(SecurityService securityService) {
        Preconditions.checkNotNull((Object)securityService);
        Preconditions.checkNotNull((Object)this.pollUri);
        Preconditions.checkNotNull((Object)this.poll);
        this.userRoles = securityService.getUserRoles(this.poll, this.getAccountId(), this.userAccount);
    }

    public String getAccountId() {
        return this.pollUri == null ? null : this.pollUri.getAccountId();
    }

    public void removeAccountIdWhenConnected(PollUrl url) {
        if (this.userAccount != null) {
            url.getPollUri().setAccountId(null);
        }
    }

    public boolean isConnected() {
        return this.userAccount != null;
    }

    public static enum PollenUserSecurityRole {
        CREATOR,
        VOTER,
        RESTRICTED_VOTER;

    }
}

