/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.services.impl.PreventRuleService;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class PollenNotifierWorker
implements Runnable,
Closeable {
    private static final Log log = LogFactory.getLog(PollenNotifierWorker.class);
    public static final int ONE_MINUTE = 60000;
    public static final int ONE_HOUR = 3600000;
    protected final PollenServiceContext serviceContext;
    private final Timer timer;
    private final TopiaContext rootContext;

    public PollenNotifierWorker(PollenServiceContext serviceContext, TopiaContext rootContext) {
        Preconditions.checkNotNull((Object)serviceContext);
        Preconditions.checkNotNull((Object)rootContext);
        Preconditions.checkState((!rootContext.isClosed() ? 1 : 0) != 0);
        this.rootContext = rootContext;
        this.serviceContext = serviceContext;
        this.timer = new Timer();
    }

    @Override
    public void run() {
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("New round of " + PollenNotifierWorker.this));
                    }
                    TopiaContext transaction = PollenNotifierWorker.this.rootContext.beginTransaction();
                    try {
                        PollenNotifierWorker.this.serviceContext.setTransaction(transaction);
                        PollService pollService = PollenNotifierWorker.this.serviceContext.newService(PollService.class);
                        PreventRuleService preventRuleService = PollenNotifierWorker.this.serviceContext.newService(PreventRuleService.class);
                        Date now = PollenNotifierWorker.this.serviceContext.getCurrentTime();
                        List<Poll> polls = pollService.getRunningPollsWithEndTime(now);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found " + polls.size() + " running polls with end date to scan"));
                        }
                        for (Poll poll : polls) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Tests for poll " + poll.getTitle()));
                            }
                            preventRuleService.onPollToRemind(poll, now);
                        }
                    }
                    finally {
                        PollenNotifierWorker.this.serviceContext.setTransaction(null);
                        transaction.closeContext();
                    }
                }
                catch (TopiaException e) {
                    throw new PollenTechnicalException("Topia problem", (Throwable)e);
                }
            }
        }, 0L, 600000L);
    }

    @Override
    public void close() throws IOException {
        this.timer.cancel();
    }
}

