/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class PersonListAbstract
extends TopiaEntityAbstract
implements PersonList {
    protected String name;
    protected UserAccount owner;
    protected List<PollAccount> pollAccount;
    private static final long serialVersionUID = 7233403756282655586L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "owner", UserAccount.class, (Object)this.owner);
        visitor.visit((TopiaEntity)this, "pollAccount", List.class, PollAccount.class, this.pollAccount);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setOwner(UserAccount owner) {
        UserAccount oldValue = this.owner;
        this.fireOnPreWrite("owner", oldValue, owner);
        this.owner = owner;
        this.fireOnPostWrite("owner", oldValue, owner);
    }

    @Override
    public UserAccount getOwner() {
        this.fireOnPreRead("owner", this.owner);
        UserAccount result = this.owner;
        this.fireOnPostRead("owner", this.owner);
        return result;
    }

    @Override
    public void addPollAccount(PollAccount pollAccount) {
        this.fireOnPreWrite("pollAccount", null, pollAccount);
        if (this.pollAccount == null) {
            this.pollAccount = new ArrayList<PollAccount>();
        }
        pollAccount.setPersonList(this);
        this.pollAccount.add(pollAccount);
        this.fireOnPostWrite("pollAccount", this.pollAccount.size(), null, pollAccount);
    }

    @Override
    public void addAllPollAccount(List<PollAccount> pollAccount) {
        if (pollAccount == null) {
            return;
        }
        for (PollAccount item : pollAccount) {
            this.addPollAccount(item);
        }
    }

    @Override
    public void setPollAccount(List<PollAccount> pollAccount) {
        ArrayList<PollAccount> oldValue = this.pollAccount != null ? new ArrayList<PollAccount>(this.pollAccount) : null;
        this.fireOnPreWrite("pollAccount", oldValue, pollAccount);
        this.pollAccount = pollAccount;
        this.fireOnPostWrite("pollAccount", oldValue, pollAccount);
    }

    @Override
    public void removePollAccount(PollAccount pollAccount) {
        this.fireOnPreWrite("pollAccount", pollAccount, null);
        if (this.pollAccount == null || !this.pollAccount.remove(pollAccount)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        pollAccount.setPersonList(null);
        this.fireOnPostWrite("pollAccount", this.pollAccount.size() + 1, pollAccount, null);
    }

    @Override
    public void clearPollAccount() {
        if (this.pollAccount == null) {
            return;
        }
        for (PollAccount item : this.pollAccount) {
            item.setPersonList(null);
        }
        ArrayList<PollAccount> oldValue = new ArrayList<PollAccount>(this.pollAccount);
        this.fireOnPreWrite("pollAccount", oldValue, this.pollAccount);
        this.pollAccount.clear();
        this.fireOnPostWrite("pollAccount", oldValue, this.pollAccount);
    }

    @Override
    public List<PollAccount> getPollAccount() {
        return this.pollAccount;
    }

    @Override
    public PollAccount getPollAccountByTopiaId(String topiaId) {
        return (PollAccount)TopiaEntityHelper.getEntityByTopiaId(this.pollAccount, (String)topiaId);
    }

    @Override
    public int sizePollAccount() {
        if (this.pollAccount == null) {
            return 0;
        }
        return this.pollAccount.size();
    }

    @Override
    public boolean isPollAccountEmpty() {
        int size = this.sizePollAccount();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }
}

