/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAOAbstract;
import org.chorem.pollen.business.persistence.UserAccount;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class PollAccountDAOImpl<E extends PollAccount>
extends PollAccountDAOAbstract<E> {
    public E findRestrictedPollAccount(String pollId, String accountId, UserAccount user) throws TopiaException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pollId));
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)accountId) || user != null ? 1 : 0) != 0);
        String hql = "SELECT p.pollAccount FROM PersonToListImpl p, PollImpl poll WHERE poll.pollId = :pollId AND p in elements (poll.votingList.pollAccountPersonToList) AND ";
        boolean withAccountId = StringUtils.isNotBlank((CharSequence)accountId);
        boolean withEmail = user != null;
        ArrayList params = Lists.newArrayList((Object[])new String[]{"pollId", pollId});
        if (withAccountId && withEmail) {
            params.add("accountId");
            params.add(accountId);
            params.add("email");
            params.add(user.getEmail());
            hql = hql + "(p.pollAccount.accountId = :accountId OR p.pollAccount.email = :email)";
        } else if (withAccountId) {
            params.add("accountId");
            params.add(accountId);
            hql = hql + "p.pollAccount.accountId = :accountId";
        } else {
            params.add("email");
            params.add(user.getEmail());
            hql = hql + "p.pollAccount.email = :email";
        }
        PollAccount result = (PollAccount)this.findByQuery(hql, params.toArray());
        return (E)result;
    }

    public E findVoterPollAccount(String pollId, String accountId, UserAccount user) throws TopiaException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pollId));
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)accountId) || user != null ? 1 : 0) != 0);
        String hql = "SELECT distinct(e) FROM PollAccountImpl e, PollImpl p, VoteImpl v WHERE p.pollId = :pollId AND v in elements (p.vote) AND e = v.pollAccount AND ";
        boolean withAccountId = StringUtils.isNotBlank((CharSequence)accountId);
        boolean withEmail = user != null;
        ArrayList params = Lists.newArrayList((Object[])new Object[]{"pollId", pollId});
        if (withAccountId && withEmail) {
            params.add("accountId");
            params.add(accountId);
            params.add("user");
            params.add(user);
            hql = hql + "(e.accountId = :accountId OR e.userAccount = :user)";
        } else if (withAccountId) {
            params.add("accountId");
            params.add(accountId);
            hql = hql + "e.accountId = :accountId";
        } else {
            params.add("user");
            params.add(user);
            hql = hql + "e.userAccount = :user";
        }
        PollAccount result = (PollAccount)this.findByQuery(hql, params.toArray());
        return (E)result;
    }

    public List<E> findFavoriteListUsers(PersonList favoriteList, TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        Preconditions.checkNotNull((Object)favoriteList);
        Preconditions.checkNotNull((Object)pager);
        int records = favoriteList.sizePollAccount();
        pager.setRecords(records);
        String hql = "FROM PollAccountImpl e WHERE e.personList = :owner";
        List result = this.findAllByQueryAndPager(hql, pager, new Object[]{"owner", favoriteList});
        return result;
    }

    public boolean isPollAccountExists(PersonList personListToUpdate, PollAccount pollAccount) throws TopiaException {
        Preconditions.checkNotNull((Object)personListToUpdate);
        Preconditions.checkNotNull((Object)pollAccount);
        String hql = "FROM PollAccountImpl e WHERE e.personList = :person AND e.email = :email";
        String pollAccountId = pollAccount.getTopiaId();
        ArrayList params = Lists.newArrayList((Object[])new Object[]{"person", personListToUpdate, "email", pollAccount.getEmail()});
        if (StringUtils.isNotBlank((CharSequence)pollAccountId)) {
            hql = hql + " AND e.topiaId = :topiaId";
            params.add("topiaId");
            params.add(pollAccountId);
        }
        boolean result = this.existsByQuery(hql, params.toArray());
        return result;
    }
}

