/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import java.util.List;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.CommentDAOAbstract;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class CommentDAOImpl<E extends Comment>
extends CommentDAOAbstract<E> {
    public List<E> findComments(TopiaFilterPagerUtil.FilterPagerBean pager, String pollId) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)pollId);
        String countHql = "SELECT COUNT(e) FROM CommentImpl e, PollImpl p WHERE p.pollId = :pollId AND e IN ELEMENTS(p.comment)";
        this.computeAndAddRecordsToPager(countHql, pager, new Object[]{"pollId", pollId});
        String hql = "SELECT e FROM CommentImpl e, PollImpl p WHERE p.pollId = :pollId AND e IN ELEMENTS(p.comment)";
        List result = this.findAllByQueryAndPager(hql, pager, new Object[]{"pollId", pollId});
        return result;
    }

    public List<E> findAllComments(String pollId) throws TopiaException {
        Preconditions.checkNotNull((Object)pollId);
        String hql = "SELECT e FROM CommentImpl e, PollImpl p WHERE p.pollId = :pollId AND e IN ELEMENTS(p.comment)";
        List result = this.findAllByQuery(hql, new Object[]{"pollId", pollId});
        return result;
    }
}

