/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité Vote.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class VoteDAOAbstract<E extends Vote> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)Vote.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.pollen.business.persistence.VotingList> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.VotingList.class)
                            .findAllByProperties("vote", entity);
                    for (org.chorem.pollen.business.persistence.VotingList item : list) {
                        item.setVote(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut weight
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * weight le paramètre
     * @param v la valeur que doit avoir weight
     * @return un element ou null
     */
    public E findByWeight(java.lang.Double v) throws TopiaException {
        E result = findByProperty("weight", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * weight le paramètre
     * @param v la valeur que doit avoir weight
     * @return une liste
     */
    public List<E> findAllByWeight(java.lang.Double v) throws TopiaException {
        List<E> result = findAllByProperty("weight", v);
        return result;
    }
    /**
     * Recherche sur l'attribut comment
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * comment le paramètre
     * @param v la valeur que doit avoir comment
     * @return un element ou null
     */
    public E findByComment(java.lang.String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * comment le paramètre
     * @param v la valeur que doit avoir comment
     * @return une liste
     */
    public List<E> findAllByComment(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }
    /**
     * Recherche sur l'attribut anonymous
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * anonymous le paramètre
     * @param v la valeur que doit avoir anonymous
     * @return un element ou null
     */
    public E findByAnonymous(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("anonymous", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * anonymous le paramètre
     * @param v la valeur que doit avoir anonymous
     * @return une liste
     */
    public List<E> findAllByAnonymous(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("anonymous", v);
        return result;
    }
    /**
     * Recherche sur l'attribut choice
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * choice contient le paramètre
     * @param v la valeur que doit contenir choice
     * @return un element ou null
     */
    public E findContainsChoice(org.chorem.pollen.business.persistence.Choice ... v) throws TopiaException {
        E result = findContainsProperties("choice", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * choice contient le paramètre
     * @param v la valeur que doit contenir choice
     * @return une liste
     */
    public List<E> findAllContainsChoice(org.chorem.pollen.business.persistence.Choice ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("choice", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut poll
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * poll le paramètre
     * @param v la valeur que doit avoir poll
     * @return un element ou null
     */
    public E findByPoll(org.chorem.pollen.business.persistence.Poll v) throws TopiaException {
        E result = findByProperty("poll", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * poll le paramètre
     * @param v la valeur que doit avoir poll
     * @return une liste
     */
    public List<E> findAllByPoll(org.chorem.pollen.business.persistence.Poll v) throws TopiaException {
        List<E> result = findAllByProperty("poll", v);
        return result;
    }
    /**
     * Recherche sur l'attribut pollAccount
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * pollAccount le paramètre
     * @param v la valeur que doit avoir pollAccount
     * @return un element ou null
     */
    public E findByPollAccount(org.chorem.pollen.business.persistence.PollAccount v) throws TopiaException {
        E result = findByProperty("pollAccount", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * pollAccount le paramètre
     * @param v la valeur que doit avoir pollAccount
     * @return une liste
     */
    public List<E> findAllByPollAccount(org.chorem.pollen.business.persistence.PollAccount v) throws TopiaException {
        List<E> result = findAllByProperty("pollAccount", v);
        return result;
    }
    /**
     * Recherche sur l'attribut votingList
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * votingList le paramètre
     * @param v la valeur que doit avoir votingList
     * @return un element ou null
     */
    public E findByVotingList(org.chorem.pollen.business.persistence.VotingList v) throws TopiaException {
        E result = findByProperty("votingList", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * votingList le paramètre
     * @param v la valeur que doit avoir votingList
     * @return une liste
     */
    public List<E> findAllByVotingList(org.chorem.pollen.business.persistence.VotingList v) throws TopiaException {
        List<E> result = findAllByProperty("votingList", v);
        return result;
    }

} // VoteDAOAbstract
