/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.dto;

import java.io.Serializable;

import org.chorem.pollen.votecounting.dto.PollChoiceDTO;

/**
 * Classe DTO représentant un choix de sondage.
 *
 * @author amine
 * @author rannou
 * @version $Id: ChoiceDTO.java 2836 2010-01-11 12:46:59Z schorlet $
 */
public class ChoiceDTO implements Serializable {
    
    public static final String HIDDEN_PREFIX = PollChoiceDTO.HIDDEN_PREFIX;

    private static final long serialVersionUID = 1L;

    private String id = "";

    private String name = "";

    private String description = "";

    private int value = 0;

    private boolean validate = false;

    private String voteId = "";

    private String pollId = "";

    public ChoiceDTO() {

    }

    public ChoiceDTO(String id) {
        this.id = id;
    }

    public ChoiceDTO(String name, String voteId, String pollId) {
        this.name = name;
        this.voteId = voteId;
        this.pollId = pollId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean isValidate() {
        return validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getVoteId() {
        return voteId;
    }

    public void setVoteId(String voteId) {
        this.voteId = voteId;
    }

    public String getPollId() {
        return pollId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public boolean isHidden() {
        if (name != null) {
            return name.startsWith(HIDDEN_PREFIX);
        }
        
        return false;
    }

}