/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.converters.EnumController;
import org.chorem.pollen.business.dto.ResultDTO;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.persistence.ResultDAO;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class DataResultConverter
extends DataConverter {
    public DataResultConverter(TopiaContext transaction) {
        super(transaction);
    }

    public void populateResultEntities(VoteCountingResultDTO dto) throws TopiaException {
        Iterator i$ = dto.getChoices().iterator();
        while (i$.hasNext()) {
            ChoiceDTO o;
            ChoiceDTO choice = o = (ChoiceDTO)i$.next();
            ResultDAO daoResult = PollenModelDAOHelper.getResultDAO(this.transaction);
            Result eResult = (Result)daoResult.create(new Object[0]);
            ChoiceDAO daoChoice = PollenModelDAOHelper.getChoiceDAO(this.transaction);
            Choice eChoice = (Choice)daoChoice.findByTopiaId(choice.getIdChoice());
            PollDAO daoPoll = PollenModelDAOHelper.getPollDAO(this.transaction);
            Object ePoll = daoPoll.findByPollId(dto.getIdPoll());
            ePoll.addResult(eResult);
            eResult.setName(eChoice.getName());
            eResult.setByGroup(dto.isByGroup());
            eResult.setPoll((Poll)ePoll);
            eResult.setResultValue(String.valueOf(choice.getValue()));
            EnumController enumCtrl = new EnumController(this.transaction);
            enumCtrl.setVoteCounting(dto.getTypeVoteCounting(), eResult);
        }
    }

    public List<ResultDTO> createResultDTOs(Poll ePoll) {
        ArrayList<ResultDTO> results = new ArrayList<ResultDTO>();
        for (Result res : ePoll.getResult()) {
            ResultDTO dto = new ResultDTO();
            dto.setId(res.getTopiaId());
            dto.setPollId(ePoll.getPollId());
            dto.setName(res.getName());
            dto.setValue(res.getResultValue());
            dto.setByGroup(res.getByGroup());
            dto.setChoiceType(EnumController.getChoiceType(ePoll));
            dto.setVoteCounting(EnumController.getVoteCountingType(ePoll));
            results.add(dto);
        }
        return results;
    }
}

