/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.nuiton.topia.TopiaException;

public class DataChoiceConverter
extends DataConverter {
    public void populateChoiceEntity(ChoiceDTO choiceDTO, Choice eChoice) throws TopiaException {
        eChoice.setName(choiceDTO.getName());
        eChoice.setDescription(choiceDTO.getDescription());
        eChoice.setValidate(choiceDTO.isValidate());
        if (choiceDTO.getPollId().length() > 0) {
            PollDAO pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)pollDAO.findByTopiaId(choiceDTO.getPollId());
            eChoice.setPoll(pollEntity);
        }
    }

    public ChoiceDTO createChoiceDTO(Choice eChoice) {
        ChoiceDTO choiceDTO = new ChoiceDTO();
        choiceDTO.setId(eChoice.getTopiaId());
        choiceDTO.setName(eChoice.getName());
        choiceDTO.setDescription(eChoice.getDescription());
        choiceDTO.setValidate(eChoice.getValidate());
        if (eChoice.getPoll() != null) {
            choiceDTO.setPollId(eChoice.getPoll().getTopiaId());
        }
        return choiceDTO;
    }

    public List<ChoiceDTO> createChoiceDTOs(Collection<Choice> cChoices) {
        ArrayList<ChoiceDTO> results = new ArrayList<ChoiceDTO>();
        for (Choice c : cChoices) {
            ChoiceDTO dto = this.createChoiceDTO(c);
            results.add(dto);
        }
        return results;
    }
}

