/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataUserConverter;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * Implémentation du service d'authentification.
 *
 * @author kmorin
 * @author rannou
 * @version $Id: ServiceAuthImpl.java 2621 2009-07-03 15:09:23Z nrannou $
 */
public class ServiceAuthImpl implements ServiceAuth {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private UserAccountDAO userDAO = null;
    private DataUserConverter converter = new DataUserConverter();

    /** log. */
    private static final Log log = LogFactory.getLog(ServiceAuthImpl.class);

    public ServiceAuthImpl() {
    }

    @Override
    public UserDTO isLoginRight(String login, String password) {
        UserDTO result = null;
        try {
            transaction = rootContext.beginTransaction();

            userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);

            UserAccount userEntity = userDAO.findByLogin(login);
            if (userEntity != null && password.equals(userEntity.getPassword())) {
                result = converter.createUserDTO(userEntity);
            } else {
                result = null;
            }

            transaction.commitTransaction();
            transaction.closeContext();

            if (log.isInfoEnabled()) {
                log.info("Entity found: "
                        + ((result == null) ? "null" : result.getLogin()));
            }

            return result;
        } catch (TopiaException e) {
            doCatch(e);
            return null;
        }
    }

    /**
     * Méthode exécutée lorsqu'une exception est détéctée.
     *
     * @param e l'exception
     */
    private void doCatch(TopiaException e) {

        // rollback de la transaction courante
        try {
            if (transaction != null) {
                transaction.rollbackTransaction();
                transaction.closeContext();
            }
        } catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}