/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.google.utils.geocode;

import org.chenillekit.google.utils.JSONException;
import org.chenillekit.google.utils.JSONObject;

public class AddressDetails {
    private Integer accuracy;
    private String administrativeAreaName;
    private String dependentLocalityName;
    private String postalCodeNumber;
    private String thoroughfareName;
    private String localityName;
    private String subAdministrativeAreaName;
    private String countryNameCode;

    public AddressDetails(JSONObject json) {
        this.buildFromJSON(json);
    }

    private void buildFromJSON(JSONObject json) {
        try {
            this.accuracy = (Integer)this.getValue(json, "Accuracy");
            this.administrativeAreaName = (String)this.getValue(json, "Country", "AdministrativeArea", "AdministrativeAreaName");
            this.countryNameCode = (String)this.getValue(json, "Country", "CountryNameCode");
            this.dependentLocalityName = (String)this.getValue(json, "Country", "AdministrativeArea", "SubAdministrativeArea", "Locality", "DependentLocality", "DependentLocalityName");
            this.postalCodeNumber = (String)this.getValue(json, "Country", "AdministrativeArea", "SubAdministrativeArea", "Locality", "DependentLocality", "PostalCode", "PostalCodeNumber");
            this.thoroughfareName = (String)this.getValue(json, "Country", "AdministrativeArea", "SubAdministrativeArea", "Locality", "DependentLocality", "Thoroughfare", "ThoroughfareName");
            this.localityName = (String)this.getValue(json, "Country", "AdministrativeArea", "SubAdministrativeArea", "Locality", "LocalityName");
            this.subAdministrativeAreaName = (String)this.getValue(json, "Country", "AdministrativeArea", "SubAdministrativeArea", "SubAdministrativeAreaName");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public String getAdministrativeAreaName() {
        return this.administrativeAreaName;
    }

    public String getDependentLocalityName() {
        return this.dependentLocalityName;
    }

    public String getPostalCodeNumber() {
        return this.postalCodeNumber;
    }

    public String getThoroughfareName() {
        return this.thoroughfareName;
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public String getSubAdministrativeAreaName() {
        return this.subAdministrativeAreaName;
    }

    public String getCountryNameCode() {
        return this.countryNameCode;
    }

    public Object getValue(JSONObject jsonObject, String ... keys) {
        String key;
        JSONObject tempObject = jsonObject;
        Object value = null;
        for (int i = 0; i < keys.length && tempObject.has(key = keys[i]); ++i) {
            if (i + 1 == keys.length) {
                value = tempObject.get(key);
                continue;
            }
            tempObject = tempObject.getJSONObject(key);
        }
        return value;
    }
}

