// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;
import org.bytedeco.cuda.nppc.*;
import static org.bytedeco.cuda.global.nppc.*;

public class nppif extends org.bytedeco.cuda.presets.nppif {
    static { Loader.load(); }

// Parsed from <nppi_filtering_functions.h>

 /* Copyright 2009-2021 NVIDIA Corporation.  All rights reserved. 
  * 
  * NOTICE TO LICENSEE: 
  * 
  * The source code and/or documentation ("Licensed Deliverables") are                                                          
  * subject to NVIDIA intellectual property rights under U.S. and                                                          
  * international Copyright laws.                                                                                              
  * 
  * The Licensed Deliverables contained herein are PROPRIETARY and 
  * CONFIDENTIAL to NVIDIA and are being provided under the terms and 
  * conditions of a form of NVIDIA software license agreement by and 
  * between NVIDIA and Licensee ("License Agreement") or electronically 
  * accepted by Licensee.  Notwithstanding any terms or conditions to 
  * the contrary in the License Agreement, reproduction or disclosure 
  * of the Licensed Deliverables to any third party without the express 
  * written consent of NVIDIA is prohibited. 
  * 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE 
  * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  THEY ARE 
  * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND. 
  * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED                                                   
  * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, 
  * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE. 
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE 
  * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY 
  * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY 
  * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
  * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
  * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
  * OF THESE LICENSED DELIVERABLES. 
  * 
  * U.S. Government End Users.  These Licensed Deliverables are a 
  * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT 
  * 1995), consisting of "commercial computer software" and "commercial 
  * computer software documentation" as such terms are used in 48 
  * C.F.R. 12.212 (SEPT 1995) and are provided to the U.S. Government 
  * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and 
  * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all 
  * U.S. Government End Users acquire the Licensed Deliverables with 
  * only those rights set forth herein. 
  * 
  * Any use of the Licensed Deliverables in individual and commercial 
  * software must include, in the user documentation and internal 
  * comments to the code, the above Disclaimer and U.S. Government End 
  * Users Notice. 
  */ 
// #ifndef NV_NPPI_FILTERING_FUNCTIONS_H
// #define NV_NPPI_FILTERING_FUNCTIONS_H
 
/**
 * \file nppi_filtering_functions.h
 * NPP Image Processing Functionality.
 */
 
// #include "nppdefs.h"


// #ifdef __cplusplus
// #endif

/** \defgroup image_filtering_functions Filtering Functions
 *  \ingroup nppi
 *
 * Linear and non-linear image filtering functions.
 *
 * Filtering functions are classified as \ref neighborhood_operations. It is the user's 
 * responsibility to avoid \ref sampling_beyond_image_boundaries. 
 *
 * \{
 *
 * These functions can be found in the nppif library. Linking to only the sub-libraries that you use can significantly
 * save link time, application load time, and CUDA runtime startup time when using dynamic libraries.
 *
 */

/** \defgroup image_1D_linear_filter 1D Linear Filter
 * The set of 1D linear filtering functions available in the library.
 * \{
 *
 */

/** \defgroup image_filter_column FilterColumn
 * Apply convolution filter with user specified 1D column of weights.
 *  
 * Result pixel is equal to the sum of the products between the kernel
 * coefficients (pKernel array) and corresponding neighboring column pixel
 * values in the source image defined by nKernelDim and nAnchorY, divided by
 * nDivisor. 
 * 
 * <h3><a name="CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *                Coefficients are expected to be stored in reverse order.
 * @param nMaskSize Length of the linear kernel array.
 * @param nAnchor Y offset of the kernel origin frame of reference relative to the
 *                 source pixel.
 * @param nDivisor The factor by which the convolved summation from the Filter
 *                 operation should be divided.  If equal to the sum of
 *                 coefficients, this will keep the maximum result value within
 *                 full scale.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */


/**
 * 8-bit unsigned single-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 8-bit unsigned three-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 8-bit unsigned four-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 8-bit unsigned four-channel 1D column convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit unsigned single-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit unsigned three-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit unsigned four-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit unsigned four-channel 1D column convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit single-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit three-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit four-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit four-channel 1D column convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterColumn_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 32-bit float single-channel 1D column convolution.
 *
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 32-bit float three-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 32-bit float four-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 32-bit float four-channel 1D column convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 64-bit float single-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnParameters">Common parameters for nppiFilterColumn functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumn_64f_C1R_Ctx(@Cast("const Npp64f*") DoublePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoublePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp64f*") DoublePointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_64f_C1R_Ctx(@Cast("const Npp64f*") DoubleBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoubleBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp64f*") DoubleBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn_64f_C1R_Ctx(@Cast("const Npp64f*") double[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") double[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp64f*") double[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn_64f_C1R(@Cast("const Npp64f*") DoublePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoublePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp64f*") DoublePointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_64f_C1R(@Cast("const Npp64f*") DoubleBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoubleBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp64f*") DoubleBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn_64f_C1R(@Cast("const Npp64f*") double[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") double[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp64f*") double[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);


/** \} image_filter_column */

/** \defgroup image_filter_column_border FilterColumnBorder
 * General purpose 1D convolution column filter with border control.
 *
 * Pixels under the mask are multiplied by the respective weights in the mask
 * and the results are summed. Before writing the result pixel the sum is scaled
 * back via division by nDivisor. If any portion of the mask overlaps the source
 * image boundary the requested border type operation is applied to all mask pixels
 * which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * <h3><a name="CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *        Coeffcients are expected to be stored in reverse order.
 * @param nMaskSize Width of the kernel.
 * @param nAnchor X offset of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param nDivisor The factor by which the convolved summation from the Filter
 *        operation should be divided.  If equal to the sum of coefficients,
 *        this will keep the maximum result value within full scale.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
  
/**
 * Three channel 8-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
                 
/**
 * Four channel channel 8-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned convolution 1D column filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit unsigned convolution 1D column filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
  
/**
 * Three channel 16-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
                 
/**
 * Four channel channel 16-bit 1D column unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned 1D column convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
  
/**
 * Three channel 16-bit 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
                 
/**
 * Four channel channel 16-bit 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit 1D column convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
 
/**
 * Single channel 32-bit float 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 32-bit float 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit float 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit float 1D column convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorderParameters">Common parameters for nppiFilterColumnBorder functions</a>.
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_column_border */

/** \defgroup image_filter_column_32f FilterColumn32f
 * 
 * FilterColumn using floating-point weights.
 * 
 * <h3><a name="CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *                Coefficients are expected to be stored in reverse order.
 * @param nMaskSize Length of the linear kernel array.
 * @param nAnchor Y offset of the kernel origin frame of reference relative to the
 *                 source pixel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * 8-bit unsigned single-channel 1D column convolution.
 *
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 8-bit unsigned three-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 8-bit unsigned four-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 8-bit unsigned four-channel 1D column convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit unsigned single-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit unsigned three-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit unsigned four-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit unsigned four-channel 1D column convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                 @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                 @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                 @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit single-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit three-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit four-channel 1D column convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit four-channel 1D column convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumn32fParameters">Common parameters for nppiFilterColumn32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                 @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                 @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                 @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterColumn32f_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/** \} image_filter_column_32f */

/** \defgroup image_filter_column_border_32f FilterColumnBorder32f
 * General purpose 1D column convolution filter using floating-point weights with border control.
 *
 * Pixels under the mask are multiplied by the respective weights in the mask
 * and the results are summed.  If any portion of the mask overlaps the source
 * image boundary the requested border type operation is applied to all mask pixels
 * which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * <h3><a name="CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *        Coeffcients are expected to be stored in reverse order.
 * @param nMaskSize Width of the kernel.
 * @param nAnchor X offset of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */


/**
 * Single channel 8-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Three channel 8-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Four channel 8-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                     @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Four channel 8-bit unsigned 1D column convolution filter with border control, ignorint alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned 1D column convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit 1D column convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit 1D column convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterColumnBorder32fParameters">Common parameters for nppiFilterColumnBorder32f functions</a>.
 * 
 */
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                       @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterColumnBorder32f_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_column_border_32f */

/** \defgroup image_filter_row FilterRow
 * Apply convolution filter with user specified 1D row of weights.
 *  
 * Result pixel is equal to the sum of the products between the kernel
 * coefficients (pKernel array) and corresponding neighboring row pixel
 * values in the source image defined by nKernelDim and nAnchorX, divided by
 * nDivisor. 
 * 
 * <h3><a name="CommonFilterRowParameters">Common parameters for nppiFilterRow functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *                Coefficients are expected to be stored in reverse order.
 * @param nMaskSize Length of the linear kernel array.
 * @param nAnchor X offset of the kernel origin frame of reference relative to the
 *                 source pixel.
 * @param nDivisor The factor by which the convolved summation from the Filter
 *                 operation should be divided.  If equal to the sum of
 *                 coefficients, this will keep the maximum result value within
 *                 full scale.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * 8-bit unsigned single-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                     @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                     @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                     @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 8-bit unsigned three-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                     @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                     @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                     @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 8-bit unsigned four-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                     @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                     @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                     @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 8-bit unsigned four-channel 1D row convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit unsigned single-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit unsigned three-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit unsigned four-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit unsigned four-channel 1D row convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                       @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                       @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                       @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit single-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit three-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit four-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 16-bit four-channel 1D row convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                       @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                       @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilterRow_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                       @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor);

/**
 * 32-bit float single-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 32-bit float three-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 32-bit float four-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 32-bit float four-channel 1D row convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                           @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                       @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                       @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                       @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 64-bit float single-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowParameters">Common parameters for nppiFilterRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow_64f_C1R_Ctx(@Cast("const Npp64f*") DoublePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoublePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp64f*") DoublePointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_64f_C1R_Ctx(@Cast("const Npp64f*") DoubleBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoubleBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp64f*") DoubleBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow_64f_C1R_Ctx(@Cast("const Npp64f*") double[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") double[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp64f*") double[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow_64f_C1R(@Cast("const Npp64f*") DoublePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoublePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp64f*") DoublePointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_64f_C1R(@Cast("const Npp64f*") DoubleBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoubleBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp64f*") DoubleBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow_64f_C1R(@Cast("const Npp64f*") double[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") double[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                      @Cast("const Npp64f*") double[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);


/** \} image_filter_row */

/** \defgroup image_filter_row_border FilterRowBorder
 * General purpose 1D convolution row filter with border control.
 *
 * Pixels under the mask are multiplied by the respective weights in the mask
 * and the results are summed. Before writing the result pixel the sum is scaled
 * back via division by nDivisor. If any portion of the mask overlaps the source
 * image boundary the requested border type operation is applied to all mask pixels
 * which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * <h3><a name="CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *        Coeffcients are expected to be stored in reverse order.
 * @param nMaskSize Width of the kernel.
 * @param nAnchor X offset of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param nDivisor The factor by which the convolved summation from the Filter
 *        operation should be divided.  If equal to the sum of coefficients,
 *        this will keep the maximum result value within full scale.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
  
/**
 * Three channel 8-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
                 
/**
 * Four channel channel 8-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned convolution 1D row filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit unsigned convolution 1D row filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
  
/**
 * Three channel 16-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
                 
/**
 * Four channel channel 16-bit 1D row unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned 1D row convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
  
/**
 * Three channel 16-bit 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
                 
/**
 * Four channel channel 16-bit 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit 1D row convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") int[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
 
/**
 * Single channel 32-bit float 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 32-bit float 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit float 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit float 1D row convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorderParameters">Common parameters for nppiFilterRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_row_border */

/** \defgroup image_filter_row_32f FilterRow32f
 * 
 * FilterRow using floating-point weights.
 * 
 * <h3><a name="CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *                Coefficients are expected to be stored in reverse order.
 * @param nMaskSize Length of the linear kernel array.
 * @param nAnchor X offset of the kernel origin frame of reference relative to the
 *                 source pixel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * 8-bit unsigned single-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 8-bit unsigned three-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 8-bit unsigned four-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                            @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                        @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 8-bit unsigned four-channel 1D row convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit unsigned single-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit unsigned three-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit unsigned four-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit unsigned four-channel 1D row convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit single-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit three-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit four-channel 1D row convolution.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                             @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                         @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * 16-bit four-channel 1D row convolution ignoring alpha-channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRow32fParameters">Common parameters for nppiFilterRow32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                              @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRow32f_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiFilterRow32f_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                          @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/** \} image_filter_row_32f */

/** \defgroup image_filter_row_border_32f FilterRowBorder32f
 * General purpose 1D row convolution filter using floating-point weights with border control.
 *
 * Pixels under the mask are multiplied by the respective weights in the mask
 * and the results are summed.  If any portion of the mask overlaps the source
 * image boundary the requested border type operation is applied to all mask pixels
 * which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * <h3><a name="CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *        Coeffcients are expected to be stored in reverse order.
 * @param nMaskSize Width of the kernel.
 * @param nAnchor X offset of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */


/**
 * Single channel 8-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Three channel 8-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Four channel 8-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Four channel 8-bit unsigned 1D row convolution filter with border control, ignorint alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned 1D row convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit 1D row convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit 1D row convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterRowBorder32fParameters">Common parameters for nppiFilterRowBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                    @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterRowBorder32f_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_row_border_32f */

/** \} image_1D_linear_filter */

/** \defgroup image_1D_window_sum 1D Window Sum
 * The set of 1D window sum functions available in the library.
 * \{
 *
 */

/** \defgroup image_1D_window_column_sum 1D Window Column Sum
 *  1D mask Window Column Sum for 8 and 16 bit images.
 *
 * <h3><a name="CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oROI \ref roi_specification.
 * @param nMaskSize Length of the linear kernel array.
 * @param nAnchor Y offset of the kernel origin frame of reference relative to the
 *        source pixel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * One channel 8-bit unsigned 1D (column) sum to 32f.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 1-channel 8 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                  @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                            @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                  @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                            @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                                  @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                            @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                              @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                              @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                              @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);


/**
 * Three channel 8-bit unsigned 1D (column) sum to 32f.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 3-channel 8 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                  @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                            @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                  @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                            @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                                  @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                            @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                              @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                              @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                              @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);


/**
 * Four channel 8-bit unsigned 1D (column) sum to 32f.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 4-channel 8 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                  @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                            @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                  @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                            @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                                  @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                            @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                              @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                              @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_8u32f_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                              @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * One channel 16-bit unsigned 1D (column) sum to 32f.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 1-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Three channel 16-bit unsigned 1D (column) sum to 32f.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 3-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Four channel 16-bit unsigned 1D (column) sum to 32f.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 4-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16u32f_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * One channel 16-bit signed 1D (column) sum to 32f.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 1-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Three channel 16-bit signed 1D (column) sum to 32f.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 1-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Four channel 16-bit signed 1D (column) sum to 32f.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 4-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnParameters">Common parameters for nppiSumWindowColumn functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                                   @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                             @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowColumn_16s32f_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                               @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/** \} image_filter_1D_window_column_sum */

/** \defgroup image_filter_1D_window_row_sum 1D Window Row Sum
 *  1D mask Window Row Sum for 8 and 16 bit images.
 *
 * <h3><a name="CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oROI \ref roi_specification.
 * @param nMaskSize Length of the linear kernel array.
 * @param nAnchor X offset of the kernel origin frame of reference relative to the
 *        source pixel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * One channel 8-bit unsigned 1D (row) sum to 32f.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 1-channel 8-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                     @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                               @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                     @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                               @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                     @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                               @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                 @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                 @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                 @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Three channel 8-bit unsigned 1D (row) sum to 32f.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 3-channel 8-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                     @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                               @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                     @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                               @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                     @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                               @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                 @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                 @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                 @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Four channel 8-bit unsigned 1D (row) sum to 32f.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 4-channel 8-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                     @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                               @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                     @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                               @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                     @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                               @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                 @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                 @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_8u32f_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                 @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * One channel 16-bit unsigned 1D (row) sum to 32f.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 1-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Three channel 16-bit unsigned 1D (row) sum to 32f.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 3-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Four channel 16-bit unsigned 1D (row) sum to 32f.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 4-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16u32f_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * One channel 16-bit signed 1D (row) sum to 32f.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 1-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Three channel 16-bit signed 1D (row) sum to 32f.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 3-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/**
 * Four channel 16-bit signed 1D (row) sum to 32f.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 4-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowParameters">Common parameters for nppiSumWindowRow functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                      @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);
public static native @Cast("NppStatus") int nppiSumWindowRow_16s32f_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, 
                                  @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor);

/** \} image_filter_1D_window_row_sum */

/** \} image_1D_window_sum */

/** \defgroup image_1D_window_sum_border 1D Window Sum with Border Control
 * The set of 1D window sum functions with border control available in the library.
 * \{
 *
 */

/** \defgroup image_filter_1D_window_column_sum_border 1D Window Column Sum Border
 * 1D mask Window Column Sum for 8 and 16 bit images with border control.
 * 
 * If any portion of the mask overlaps the source image boundary the requested border type operation 
 * is applied to all mask pixels which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * <h3><a name="CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oROI \ref roi_specification.
 * @param nMaskSize Length of the linear kernel array.
 * @param nAnchor Y offset of the kernel origin frame of reference relative to the
 *        source pixel.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * One channel 8-bit unsigned 1D (column) sum to 32f with border control.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 1-channel 8 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                        @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                        @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                        @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                    @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                    @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                    @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                    @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                    @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                    @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);


/**
 * Three channel 8-bit unsigned 1D (column) sum to 32f with border control.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 3-channel 8 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                        @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                        @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                        @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                    @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                    @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                    @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                    @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                    @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                    @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);


/**
 * Four channel 8-bit unsigned 1D (column) sum to 32f with border control.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 4-channel 8 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                        @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                        @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                        @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                        @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                    @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                    @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                    @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                    @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_8u32f_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                    @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                    @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * One channel 16-bit unsigned 1D (column) sum to 32f with border control.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 1-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit unsigned 1D (column) sum to 32f with border control.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 3-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned 1D (column) sum to 32f with border control.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 4-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16u32f_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * One channel 16-bit signed 1D (column) sum to 32f with border control.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 1-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit signed 1D (column) sum to 32f with border control.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 1-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit signed 1D (column) sum to 32f with border control.
 *
 * Apply Column Window Summation filter over a 1D mask region around each
 * source pixel for 4-channel 16 bit/pixel input images with 32-bit floating point
 * output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring column pixel values in a mask region of the source image defined by
 * nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowColumnBorderParameters">Common parameters for nppiSumWindowColumnBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                         @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                         @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowColumnBorder_16s32f_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                                     @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oROI, 
                                                     @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_1D_window_column_sum_border */

/** \defgroup image_filter_1D_window_row_sum_border 1D Window Row Sum Border
 * 1D mask Window Row Sum for 8 and 16 bit images with border control.
 *
 * <h3><a name="CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oROI \ref roi_specification.
 * @param nMaskSize Length of the linear kernel array.
 * @param nAnchor X offset of the kernel origin frame of reference relative to the
 *        source pixel.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * One channel 8-bit unsigned 1D (row) sum to 32f with border control.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 1-channel 8-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                           @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                           @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                           @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                       @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                       @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                       @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                       @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                       @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                       @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 8-bit unsigned 1D (row) sum to 32f with border control.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 3-channel 8-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                           @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                           @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                           @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                       @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                       @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                       @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                       @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                       @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                       @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned 1D (row) sum to 32f with border control.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 4-channel 8-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                           @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                           @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                           @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                           @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                       @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                       @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                       @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                       @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_8u32f_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                       @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                       @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * One channel 16-bit unsigned 1D (row) sum to 32f with border control.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 1-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit unsigned 1D (row) sum to 32f with border control.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 3-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned 1D (row) sum to 32f with border control.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 4-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16u32f_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * One channel 16-bit signed 1D (row) sum to 32f with border control.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 1-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit signed 1D (row) sum to 32f with border control.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 3-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit signed 1D (row) sum to 32f with border control.
 *
 * Apply Row Window Summation filter over a 1D mask region around each source
 * pixel for 4-channel 16-bit pixel input images with 32-bit floating point output.  
 * Result 32-bit floating point pixel is equal to the sum of the corresponding and
 * neighboring row pixel values in a mask region of the source image defined
 * by nMaskSize and nAnchor. 
 *
 * For common parameter descriptions, see <a href="#CommonFilterSumWindowRowBorderParameters">Common parameters for nppiSumWindowRowBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                            @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                            @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiSumWindowRowBorder_16s32f_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, 
                                        @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, 
                                        @ByVal NppiSize oROI, @Cast("Npp32s") int nMaskSize, @Cast("Npp32s") int nAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_1D_window_row_sum_border */

/** \} image_1D_window_sum_border */

/** \defgroup image_convolution Convolution
 * The set convolution functions available in the library.
 * \{
 *
 */

/** \defgroup image_filter Filter
 * General purpose 2D convolution filter.
 *
 * Pixels under the mask are multiplied by the respective weights in the mask
 * and the results are summed. Before writing the result pixel the sum is scaled
 * back via division by nDivisor.
 *
 * <h3><a name="CommonFilterParameters">Common parameters for nppiFilter functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *        Coeffcients are expected to be stored in reverse order.
 * @param oKernelSize Width and Height of the rectangular kernel.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param nDivisor The factor by which the convolved summation from the Filter
 *        operation should be divided.  If equal to the sum of coefficients,
 *        this will keep the maximum result value within full scale.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned convolution filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilter_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
  
/**
 * Three channel 8-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilter_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
                 
/**
 * Four channel channel 8-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                  @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);

/**
 * Four channel 8-bit unsigned convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);

/**
 * Single channel 16-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilter_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
  
/**
 * Three channel 16-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilter_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
                 
/**
 * Four channel channel 16-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);

/**
 * Four channel 16-bit unsigned convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);

/**
 * Single channel 16-bit convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilter_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
  
/**
 * Three channel 16-bit convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilter_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
                 
/**
 * Four channel channel 16-bit convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);

/**
 * Four channel 16-bit convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiFilter_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
public static native @Cast("NppStatus") int nppiFilter_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor);
 
/**
 * Single channel 32-bit float convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Two channel 32-bit float convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_32f_C2R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_C2R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_C2R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_32f_C2R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_C2R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_C2R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 32-bit float convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit float convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit float convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                    @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 64-bit float convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterParameters">Common parameters for nppiFilter functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter_64f_C1R_Ctx(@Cast("const Npp64f*") DoublePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoublePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp64f*") DoublePointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_64f_C1R_Ctx(@Cast("const Npp64f*") DoubleBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoubleBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp64f*") DoubleBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter_64f_C1R_Ctx(@Cast("const Npp64f*") double[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") double[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp64f*") double[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter_64f_C1R(@Cast("const Npp64f*") DoublePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoublePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp64f*") DoublePointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_64f_C1R(@Cast("const Npp64f*") DoubleBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoubleBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp64f*") DoubleBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter_64f_C1R(@Cast("const Npp64f*") double[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") double[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                   @Cast("const Npp64f*") double[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);


/** \} image_filter */

/** \defgroup image_filter_32f Filter32f
 * General purpose 2D convolution filter using floating point weights.
 *
 * Pixels under the mask are multiplied by the respective weights in the mask
 * and the results are summed. 
 *
 * <h3><a name="CommonFilter32fParameters">Common parameters for nppiFilter32f functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *        Coeffcients are expected to be stored in reverse order.
 * @param oKernelSize Width and Height of the rectangular kernel.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */


/**
 * Single channel 8-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilter32f_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
        
/**
 * Two channel 8-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8u_C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilter32f_8u_C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
        
/**
 * Three channel 8-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilter32f_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
        
/**
 * Four channel 8-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilter32f_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
        
/**
 * Four channel 8-bit unsigned convolution filter, ignorint alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 8-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8s_C1R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C1R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C1R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8s_C1R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C1R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C1R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Two channel 8-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8s_C2R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C2R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C2R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8s_C2R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C2R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C2R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 8-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8s_C3R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C3R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C3R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8s_C3R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C3R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C3R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8s_C4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8s_C4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_C4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                     @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit signed convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8s_AC4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_AC4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s_AC4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8s_AC4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_AC4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s_AC4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 16-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 16-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit unsigned convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit unsigned convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 16-bit convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 16-bit convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);


/**
 * Single channel 32-bit convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_32s_C1R_Ctx(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C1R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C1R_Ctx(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_32s_C1R(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C1R(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C1R(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 32-bit convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_32s_C3R_Ctx(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C3R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C3R_Ctx(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_32s_C3R(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C3R(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C3R(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_32s_C4R_Ctx(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C4R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C4R_Ctx(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_32s_C4R(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C4R(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_32s_C4R(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_32s_AC4R_Ctx(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_32s_AC4R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_32s_AC4R_Ctx(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_32s_AC4R(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_32s_AC4R(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_32s_AC4R(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                       @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 16-bit floating point convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16f_C1R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C1R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C1R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16f_C1R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C1R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C1R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 16-bit floating point convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16f_C3R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C3R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C3R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16f_C3R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C3R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C3R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit floating point convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_16f_C4R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C4R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_16f_C4R(@Const Npp16f pSrc, int nSrcStep, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                      @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 8-bit unsigned to 16-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 8-bit unsigned to 16-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit unsigned to 16-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit unsigned to 16-bit signed convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8u16s_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8u16s_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 8-bit to 16-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C1R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C1R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C1R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C1R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C1R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C1R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 8-bit to 16-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C3R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C3R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C3R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C3R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C3R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C3R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit to 16-bit signed convolution filter.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_C4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit to 16-bit signed convolution filter, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilter32fParameters">Common parameters for nppiFilter32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_AC4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_AC4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_AC4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilter32f_8s16s_AC4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_AC4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilter32f_8s16s_AC4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor);


/** \} image_filter_32f */

/** \defgroup image_filter_border FilterBorder
 * General purpose 2D convolution filter with border control.
 *
 * Pixels under the mask are multiplied by the respective weights in the mask
 * and the results are summed. Before writing the result pixel the sum is scaled
 * back via division by nDivisor. If any portion of the mask overlaps the source
 * image boundary the requested border type operation is applied to all mask pixels
 * which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * <h3><a name="CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *        Coeffcients are expected to be stored in reverse order.
 * @param oKernelSize Width and Height of the rectangular kernel.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param nDivisor The factor by which the convolved summation from the Filter
 *        operation should be divided.  If equal to the sum of coefficients,
 *        this will keep the maximum result value within full scale.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
  
/**
 * Three channel 8-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
                 
/**
 * Four channel channel 8-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
  
/**
 * Three channel 16-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
                 
/**
 * Four channel channel 16-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
  
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
  
/**
 * Three channel 16-bit convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
                 
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
                 
/**
 * Four channel channel 16-bit convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit convolution filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */ 
public static native @Cast("NppStatus") int nppiFilterBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
 
public static native @Cast("NppStatus") int nppiFilterBorder_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32s*") IntPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32s*") IntBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32s*") int[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("Npp32s") int nDivisor, @Cast("NppiBorderType") int eBorderType);
 
/**
 * Single channel 32-bit float convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Two channel 32-bit float convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C2R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C2R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C2R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_32f_C2R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C2R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C2R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 32-bit float convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit float convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit float convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorderParameters">Common parameters for nppiFilterBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_border */

/** \defgroup image_filter_border_32f FilterBorder32f
 * General purpose 2D convolution filter using floating-point weights with border control.
 *
 * Pixels under the mask are multiplied by the respective weights in the mask
 * and the results are summed. Before writing the result pixel the sum is scaled
 * back via division by nDivisor. If any portion of the mask overlaps the source
 * image boundary the requested border type operation is applied to all mask pixels
 * which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * <h3><a name="CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions include:</a></h3>
 *
 * @param pSrc  \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param pKernel Pointer to the start address of the kernel coefficient array.
 *        Coeffcients are expected to be stored in reverse order.
 * @param oKernelSize Width and Height of the rectangular kernel.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */


/**
 * Single channel 8-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Two channel 8-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C2R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C2R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C2R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C2R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C2R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C2R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Three channel 8-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Four channel 8-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
        
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
        
/**
 * Four channel 8-bit unsigned convolution filter with border control, ignorint alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */ 
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 8-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C1R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C1R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C1R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C1R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C1R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C1R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Two channel 8-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C2R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C2R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C2R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C2R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C2R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C2R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 8-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C3R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C3R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C3R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C3R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C3R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C3R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_C4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                           @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit signed convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_AC4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_AC4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_AC4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_AC4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") BytePointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_AC4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") ByteBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s_AC4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8s*") byte[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C1R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C3R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_C4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C1R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C3R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_C4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 32-bit convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C1R_Ctx(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C1R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C1R_Ctx(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C1R(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C1R(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C1R(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 32-bit convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C3R_Ctx(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C3R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C3R_Ctx(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C3R(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C3R(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C3R(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C4R_Ctx(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C4R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C4R_Ctx(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C4R(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C4R(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_C4R(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_AC4R_Ctx(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_AC4R_Ctx(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_AC4R_Ctx(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_AC4R(@Cast("const Npp32s*") IntPointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_AC4R(@Cast("const Npp32s*") IntBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") IntBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_32s_AC4R(@Cast("const Npp32s*") int[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32s*") int[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                             @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit floating point convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C1R_Ctx(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C1R_Ctx(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C1R_Ctx(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C1R(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C1R(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C1R(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit floating point convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C3R_Ctx(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C3R_Ctx(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C3R_Ctx(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C3R(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C3R(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C3R(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit floating point convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C4R_Ctx(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C4R(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C4R(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_16f_C4R(@Const Npp16f pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, Npp16f pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                            @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 8-bit unsigned to 16-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C1R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C1R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 8-bit unsigned to 16-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C3R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C3R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned to 16-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_C4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned to 16-bit signed convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_AC4R(@Cast("const Npp8u*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8u16s_AC4R(@Cast("const Npp8u*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 8-bit to 16-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C1R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C1R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C1R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C1R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C1R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C1R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 8-bit to 16-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C3R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C3R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C3R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C3R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C3R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C3R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit to 16-bit signed convolution filter with border control.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                  @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_C4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                              @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit to 16-bit signed convolution filter with border control, ignoring alpha channel.
 * 
 * For common parameter descriptions, see <a href="#CommonFilterBorder32fParameters">Common parameters for nppiFilterBorder32f functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_AC4R_Ctx(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_AC4R_Ctx(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_AC4R_Ctx(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                                   @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_AC4R(@Cast("const Npp8s*") BytePointer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatPointer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_AC4R(@Cast("const Npp8s*") ByteBuffer pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") FloatBuffer pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBorder32f_8s16s_AC4R(@Cast("const Npp8s*") byte[] pSrc, int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, int nDstStep, @ByVal NppiSize oSizeROI, 
                               @Cast("const Npp32f*") float[] pKernel, @ByVal NppiSize oKernelSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_border_32f */

/** \} image_convolution */

/** \defgroup image_2D_fixed_linear_filters 2D Fixed Linear Filters
 * The set of 2D fixed linear filtering functions available in the library.
 * \{
 *
 */

/** \defgroup image_filter_box FilterBox
 * Computes the average pixel values of the pixels under a rectangular mask.
 *
 * <h3><a name="CommonFilterBoxParameters">Common parameters for nppiFilterBox functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param oMaskSize Width and Height of the neighborhood region for the local
 *        Avg operation.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference relative to
 *        the source pixel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 8-bit unsigned box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit unsigned box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit unsigned box filter, ignorting alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 16-bit unsigned box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 16-bit unsigned box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit unsigned box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit unsigned box filter, ignorting alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 16-bit box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 16-bit box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit box filter, ignorting alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 32-bit floating-point box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 32-bit floating-point box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit floating-point box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit floating-point box filter, ignorting alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 64-bit floating-point box filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxParameters">Common parameters for nppiFilterBox functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBox_64f_C1R_Ctx(@Cast("const Npp64f*") DoublePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoublePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_64f_C1R_Ctx(@Cast("const Npp64f*") DoubleBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoubleBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBox_64f_C1R_Ctx(@Cast("const Npp64f*") double[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") double[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBox_64f_C1R(@Cast("const Npp64f*") DoublePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoublePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_64f_C1R(@Cast("const Npp64f*") DoubleBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") DoubleBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterBox_64f_C1R(@Cast("const Npp64f*") double[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp64f*") double[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/** \} image_filter_box */

/** \defgroup image_filter_box_border FilterBoxBorder
 *
 * Computes the average pixel values of the pixels under a rectangular mask with border control.
 * If any portion of the mask overlaps the source image boundary the requested 
 * border type operation is applied to all mask pixels which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported. *
 *
 * <h3><a name="CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param oMaskSize Width and Height of the neighborhood region for the local
 *        Avg operation.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference relative to
 *        the source pixel.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 8-bit unsigned box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned box filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit unsigned box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit unsigned box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned box filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit box filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 32-bit floating-point box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 32-bit floating-point box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit floating-point box filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit floating-point box filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterBoxBorderParameters">Common parameters for nppiFilterBoxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterBoxBorder_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_box_border */

/** \defgroup image_filter_threshold_adaptive_box_border FilterThresholdAdaptiveBoxBorder
 *
 * Computes the average pixel values of the pixels under a square mask with border control.
 * If any portion of the mask overlaps the source image boundary the requested 
 * border type operation is applied to all mask pixels which fall outside of the source image.
 * Once the neighborhood average around a source pixel is determined the souce pixel is compared to the average - nDelta
 * and if the source pixel is greater than that average the corresponding destination pixel is set to nValGT, otherwise nValLE.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param oMaskSize Width and Height of the neighborhood region for the local
 *        Avg operation, Width and Height must be equal and odd.
 * @param nDelta Neighborhood average adjustment value
 * @param nValGT Destination output value if source pixel is greater than average.
 * @param nValLE Destination output value if source pixel is less than or equal to average.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned threshold adaptive box filter with border control.
 *
 */
public static native @Cast("NppStatus") int nppiFilterThresholdAdaptiveBoxBorder_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                                @ByVal NppiSize oMaskSize, @Cast("Npp32f") float nDelta, @Cast("Npp8u") byte nValGT, @Cast("Npp8u") byte nValLE, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterThresholdAdaptiveBoxBorder_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                                @ByVal NppiSize oMaskSize, @Cast("Npp32f") float nDelta, @Cast("Npp8u") byte nValGT, @Cast("Npp8u") byte nValLE, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterThresholdAdaptiveBoxBorder_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                                @ByVal NppiSize oMaskSize, @Cast("Npp32f") float nDelta, @Cast("Npp8u") byte nValGT, @Cast("Npp8u") byte nValLE, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterThresholdAdaptiveBoxBorder_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                            @ByVal NppiSize oMaskSize, @Cast("Npp32f") float nDelta, @Cast("Npp8u") byte nValGT, @Cast("Npp8u") byte nValLE, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterThresholdAdaptiveBoxBorder_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                            @ByVal NppiSize oMaskSize, @Cast("Npp32f") float nDelta, @Cast("Npp8u") byte nValGT, @Cast("Npp8u") byte nValLE, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterThresholdAdaptiveBoxBorder_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                            @ByVal NppiSize oMaskSize, @Cast("Npp32f") float nDelta, @Cast("Npp8u") byte nValGT, @Cast("Npp8u") byte nValLE, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_threshold_adaptive_box_border */

/** \} image_2D_fixed_linear_filters */

/** \defgroup image_rank_filters Rank Filters
 * The set of functions providing min/max/median values for rectangular mask region with/without border available in the library.
 * \{
 *
 */

/** \defgroup image_filter_max FilterMax
 * Result pixel value is the maximum of pixel values under the rectangular mask region.
 *
 * <h3><a name="CommonFilterMaxParameters">Common parameters for nppiFilterMax functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param oMaskSize Width and Height of the neighborhood region for the local
 *        Max operation.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 8-bit unsigned maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit unsigned maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit unsigned maximum filter, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 16-bit unsigned maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 16-bit unsigned maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit unsigned maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit unsigned maximum filter, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 16-bit signed maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 16-bit signed maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit signed maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit signed maximum filter, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 32-bit floating-point maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 32-bit floating-point maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit floating-point maximum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit floating-point maximum filter, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxParameters">Common parameters for nppiFilterMax functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMax_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMax_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMax_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMax_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/** \} image_filter_max */

/** \defgroup image_filter_max_border FilterMaxBorder
 * Result pixel value is the maximum of pixel values under the rectangular mask region with border control.
 * 
 * If any portion of the mask overlaps the source
 * image boundary the requested border type operation is applied to all mask pixels
 * which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * <h3><a name="CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param oMaskSize Width and Height of the neighborhood region for the local
 *        Max operation.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 8-bit unsigned maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned maximum filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit unsigned maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit unsigned maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned maximum filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit signed maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit signed maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit signed maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit signed maximum filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 32-bit floating-point maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 32-bit floating-point maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit floating-point maximum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit floating-point maximum filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMaxBorderParameters">Common parameters for nppiFilterMaxBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMaxBorder_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_max_border */

/** \defgroup image_filter_min FilterMin
 * Result pixel value is the minimum of pixel values under the rectangular mask region.
 *
 * <h3><a name="CommonFilterMinParameters">Common parameters for nppiFilterMin functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param oMaskSize Width and Height of the neighborhood region for the local
 *        Min operation.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 8-bit unsigned minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit unsigned minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                         @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                     @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 8-bit unsigned minimum filter, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 16-bit unsigned minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 16-bit unsigned minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit unsigned minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit unsigned minimum filter, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Single channel 16-bit signed minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 16-bit signed minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit signed minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 16-bit signed minimum filter, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);


/**
 * Single channel 32-bit floating-point minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Three channel 32-bit floating-point minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit floating-point minimum filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                          @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                      @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/**
 * Four channel 32-bit floating-point minimum filter, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinParameters">Common parameters for nppiFilterMin functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMin_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMin_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMin_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);
public static native @Cast("NppStatus") int nppiFilterMin_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                       @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor);

/** \} image_filter_min */

/** \defgroup image_filter_min_border FilterMinBorder
 * Result pixel value is the minimum of pixel values under the rectangular mask region with border control. 
 *
 * If any portion of the mask overlaps the source
 * image boundary the requested border type operation is applied to all mask pixels
 * which fall outside of the source image.
 *
 * Currently only the NPP_BORDER_REPLICATE border type operation is supported.
 *
 * <h3><a name="CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param oSrcSize Source image width and height in pixels relative to pSrc.
 * @param oSrcOffset The pixel offset that pSrc points to relative to the origin of the source image. 
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param oMaskSize Width and Height of the neighborhood region for the local
 *        Min operation.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param eBorderType The border type operation to be applied at source image border boundaries.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 8-bit unsigned minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                               @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                           @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 8-bit unsigned minimum filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_AC4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_AC4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_AC4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_8u_AC4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit unsigned minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C1R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C1R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C1R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C1R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C1R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit unsigned minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C3R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C3R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C3R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C3R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C3R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_C4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit unsigned minimum filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_AC4R_Ctx(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_AC4R(@Cast("const Npp16u*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_AC4R(@Cast("const Npp16u*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16u_AC4R(@Cast("const Npp16u*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16u*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 16-bit signed minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C1R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C1R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C1R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C1R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C1R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 16-bit signed minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C3R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C3R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C3R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C3R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C3R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit signed minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_C4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 16-bit signed minimum filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_AC4R_Ctx(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_AC4R(@Cast("const Npp16s*") ShortPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_AC4R(@Cast("const Npp16s*") ShortBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") ShortBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_16s_AC4R(@Cast("const Npp16s*") short[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp16s*") short[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Single channel 32-bit floating-point minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C1R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C1R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C1R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C1R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C1R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Three channel 32-bit floating-point minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C3R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C3R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C3R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C3R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C3R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit floating-point minimum filter with border control.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_C4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/**
 * Four channel 32-bit floating-point minimum filter with border control, ignoring alpha channel.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMinBorderParameters">Common parameters for nppiFilterMinBorder functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_AC4R_Ctx(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                                 @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_AC4R(@Cast("const Npp32f*") FloatPointer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatPointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_AC4R(@Cast("const Npp32f*") FloatBuffer pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") FloatBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);
public static native @Cast("NppStatus") int nppiFilterMinBorder_32f_AC4R(@Cast("const Npp32f*") float[] pSrc, @Cast("Npp32s") int nSrcStep, @ByVal NppiSize oSrcSize, @ByVal NppiPoint oSrcOffset, @Cast("Npp32f*") float[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                             @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("NppiBorderType") int eBorderType);

/** \} image_filter_min_border */

/** \defgroup image_filter_median FilterMedian
 * Result pixel value is the median of pixel values under the rectangular mask region.
 *
 * <h3><a name="CommonFilterMedianParameters">Common parameters for nppiFilterMedian functions include:</a></h3>
 *
 * @param pSrc \ref source_image_pointer.
 * @param nSrcStep \ref source_image_line_step.
 * @param pDst \ref destination_image_pointer.
 * @param nDstStep \ref destination_image_line_step.
 * @param oSizeROI \ref roi_specification.
 * @param oMaskSize Width and Height of the neighborhood region for the local
 *        Median operation.
 * @param oAnchor X and Y offsets of the kernel origin frame of reference
 *        relative to the source pixel.
 * @param pBuffer Pointer to the user-allocated scratch buffer required for the Median operation.
 * @param nppStreamCtx \ref application_managed_stream_context. 
 * @return \ref image_data_error_codes, \ref roi_error_codes
 *
 * <h3><a name="CommonFilterMedianGetBufferSizeParameters">Common parameters for nppiFilterMedianGetBufferSize functions include:</a></h3>
 *
 * @param oSizeROI \ref roi_specification.
 * @param oMaskSize Width and Height of the neighborhood region for the local Median operation.
 * @param nBufferSize Pointer to the size of the scratch buffer required for the Median operation.
 * @return \ref image_data_error_codes
 *
 * \{
 *
 */

/**
 * Single channel 8-bit unsigned median filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMedianParameters">Common parameters for nppiFilterMedian functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C1R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") BytePointer pBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C1R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") ByteBuffer pBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C1R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") byte[] pBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMedian_8u_C1R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") BytePointer pBuffer);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C1R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") ByteBuffer pBuffer);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C1R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") byte[] pBuffer);

/**
 * Three channel 8-bit unsigned median filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMedianParameters">Common parameters for nppiFilterMedian functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C3R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") BytePointer pBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C3R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") ByteBuffer pBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C3R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") byte[] pBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMedian_8u_C3R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") BytePointer pBuffer);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C3R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") ByteBuffer pBuffer);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C3R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") byte[] pBuffer);

/**
 * Four channel 8-bit unsigned median filter.
 *
 * For common parameter descriptions, see <a href="#CommonFilterMedianParameters">Common parameters for nppiFilterMedian functions</a>.
 *
 */
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C4R_Ctx(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") BytePointer pBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C4R_Ctx(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") ByteBuffer pBuffer, @ByVal NppStreamContext nppStreamCtx);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C4R_Ctx(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") byte[] pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                            @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") byte[] pBuffer, @ByVal NppStreamContext nppStreamCtx);

public static native @Cast("NppStatus") int nppiFilterMedian_8u_C4R(@Cast("const Npp8u*") BytePointer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") BytePointer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") BytePointer pBuffer);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C4R(@Cast("const Npp8u*") ByteBuffer pSrc, @Cast("Npp32s") int nSrcStep, @Cast("Npp8u*") ByteBuffer pDst, @Cast("Npp32s") int nDstStep, @ByVal NppiSize oSizeROI, 
                        @ByVal NppiSize oMaskSize, @ByVal NppiPoint oAnchor, @Cast("Npp8u*") ByteBuffer pBuffer);
public static native @Cast("NppStatus") int nppiFilterMedian_8u_C4R(@Cast("const Npp8u*") byte[] pSrc, @Cast("Npp32s") int nSrcStep