// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nppc;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nppc.*;



/**
 * Provides contour (boundary) direction and geometry info of uniquely labeled pixel regions returned 
 * by nppiCompressedMarkerLabelsUFInfo function in host memory. 
 */

@Properties(inherit = org.bytedeco.cuda.presets.nppc.class)
public class NppiContourPixelGeometryInfo extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public NppiContourPixelGeometryInfo() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NppiContourPixelGeometryInfo(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NppiContourPixelGeometryInfo(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NppiContourPixelGeometryInfo position(long position) {
        return (NppiContourPixelGeometryInfo)super.position(position);
    }
    @Override public NppiContourPixelGeometryInfo getPointer(long i) {
        return new NppiContourPixelGeometryInfo((Pointer)this).position(position + i);
    }

    /** image geometry X and Y location of current contour pixel */
    public native @ByRef NppiPoint oContourPixelLocation(); public native NppiContourPixelGeometryInfo oContourPixelLocation(NppiPoint setter);
    /** information about region interior and connected contour pixels directions */
    public native @ByRef NppiContourPixelDirectionInfo oContourPixelDirectionInfo(); public native NppiContourPixelGeometryInfo oContourPixelDirectionInfo(NppiContourPixelDirectionInfo setter);
}
