// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nppc;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nppc.*;


@Properties(inherit = org.bytedeco.cuda.presets.nppc.class)
public class NppiContourPixelDirectionInfo extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public NppiContourPixelDirectionInfo() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NppiContourPixelDirectionInfo(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NppiContourPixelDirectionInfo(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NppiContourPixelDirectionInfo position(long position) {
        return (NppiContourPixelDirectionInfo)super.position(position);
    }
    @Override public NppiContourPixelDirectionInfo getPointer(long i) {
        return new NppiContourPixelDirectionInfo((Pointer)this).position(position + i);
    }

    /** provides current contour pixel input and output direction info */
    public native @Cast("unsigned char") byte nContourDirection(); public native NppiContourPixelDirectionInfo nContourDirection(byte setter);
    /** provides current contour pixel region interior direction info */
    public native @Cast("unsigned char") byte nContourInteriorDirection(); public native NppiContourPixelDirectionInfo nContourInteriorDirection(byte setter);
    /** reserved for future use */
    public native @Cast("unsigned short") short nReserved(); public native NppiContourPixelDirectionInfo nReserved(short setter);
    /** MarkerLabelID of contour interior connected region */
    public native @Cast("unsigned int") int nMarkerLabelID(); public native NppiContourPixelDirectionInfo nMarkerLabelID(int setter);
}
