// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.global;

import org.bytedeco.cuda.cudnn.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

public class cudnn extends org.bytedeco.cuda.presets.cudnn {
    static { Loader.load(); }

// Parsed from <cudnn.h>

/*
 * Copyright 1993-2020 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*   cudnn : Neural Networks Library

*/

// #if !defined(CUDNN_H_)
// #define CUDNN_H_

// #include <cuda_runtime.h>
// #include <stdint.h>

// #include "cudnn_version.h"
// #include "cudnn_ops_infer.h"
// #include "cudnn_ops_train.h"
// #include "cudnn_adv_infer.h"
// #include "cudnn_adv_train.h"
// #include "cudnn_cnn_infer.h"
// #include "cudnn_cnn_train.h"

// #include "cudnn_backend.h"

// #if defined(__cplusplus)
// #endif

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_H_ */


// Parsed from <cudnn_version.h>

/*
 * Copyright 2019 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/**
 * \file: The master cuDNN version file.
 */

// #ifndef CUDNN_VERSION_H_
// #define CUDNN_VERSION_H_

public static final int CUDNN_MAJOR = 8;
public static final int CUDNN_MINOR = 1;
public static final int CUDNN_PATCHLEVEL = 1;

public static final int CUDNN_VERSION = (CUDNN_MAJOR * 1000 + CUDNN_MINOR * 100 + CUDNN_PATCHLEVEL);

// #endif /* CUDNN_VERSION_H */


// Parsed from <cudnn_ops_infer.h>

/*
 * Copyright 1993-2020 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*
 *  cudnn_ops_infer : cuDNN's basic definitions and inference operations.
 */

// #if !defined(CUDNN_OPS_INFER_H_)
// #define CUDNN_OPS_INFER_H_

// #include <cuda_runtime.h>
// #include <stdint.h>

// #include "cudnn_version.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_OPS_INFER_MAJOR = 8;
public static final int CUDNN_OPS_INFER_MINOR = 1;
public static final int CUDNN_OPS_INFER_PATCH = 1;

// #if (CUDNN_OPS_INFER_MAJOR != CUDNN_MAJOR) || (CUDNN_OPS_INFER_MINOR != CUDNN_MINOR) ||
//     (CUDNN_OPS_INFER_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN OPS INFER!!!
// #endif

// #ifndef CUDNNWINAPI
// #ifdef _WIN32
// #define CUDNNWINAPI __stdcall
// #else
// #define CUDNNWINAPI
// #endif
// #endif

/* Warnings for deprecated API-s are enabled using the CUDNN_WARN_DEPRECATED macro */
// #if defined(CUDNN_WARN_DEPRECATED) && (defined(__GNUC__) || defined(__clang__))
/* GCC, Intel C/C++, Cray C/C++, CLANG, IBM XL C/C++ little endian */
// #define CUDNN_DEPRECATED __attribute__((deprecated))
// #elif defined(CUDNN_WARN_DEPRECATED) && defined(_MSC_VER)
/* Microsoft Visual C++ */
// #define CUDNN_DEPRECATED __declspec(deprecated)
// #elif defined(CUDNN_WARN_DEPRECATED) && (__cplusplus >= 201402L)
/* C++14 compilers */
// #define CUDNN_DEPRECATED [[deprecated]]
// #else
/* No support for the deprecated attribute */
// #define CUDNN_DEPRECATED
// #endif

// #if defined(__cplusplus)
// Targeting ../cudnn/cudnnContext.java



public static native @Cast("size_t") long cudnnGetVersion();

/* Returns CUDA Runtime version statically linked against cudnn */
public static native @Cast("size_t") long cudnnGetCudartVersion();

/*
 * CUDNN return codes
 */
/** enum cudnnStatus_t */
public static final int
    CUDNN_STATUS_SUCCESS                      = 0,
    CUDNN_STATUS_NOT_INITIALIZED              = 1,
    CUDNN_STATUS_ALLOC_FAILED                 = 2,
    CUDNN_STATUS_BAD_PARAM                    = 3,
    CUDNN_STATUS_INTERNAL_ERROR               = 4,
    CUDNN_STATUS_INVALID_VALUE                = 5,
    CUDNN_STATUS_ARCH_MISMATCH                = 6,
    CUDNN_STATUS_MAPPING_ERROR                = 7,
    CUDNN_STATUS_EXECUTION_FAILED             = 8,
    CUDNN_STATUS_NOT_SUPPORTED                = 9,
    CUDNN_STATUS_LICENSE_ERROR                = 10,
    CUDNN_STATUS_RUNTIME_PREREQUISITE_MISSING = 11,
    CUDNN_STATUS_RUNTIME_IN_PROGRESS          = 12,
    CUDNN_STATUS_RUNTIME_FP_OVERFLOW          = 13,
    CUDNN_STATUS_VERSION_MISMATCH             = 14;

/* human-readable error messages */
public static native @Cast("const char*") BytePointer cudnnGetErrorString(@Cast("cudnnStatus_t") int status);
// Targeting ../cudnn/cudnnRuntimeTag_t.java



/** enum cudnnErrQueryMode_t */
public static final int
    CUDNN_ERRQUERY_RAWCODE     = 0,
    CUDNN_ERRQUERY_NONBLOCKING = 1,
    CUDNN_ERRQUERY_BLOCKING    = 2;

public static native @Cast("cudnnStatus_t") int cudnnQueryRuntimeError(cudnnContext handle, @Cast("cudnnStatus_t*") IntPointer rstatus, @Cast("cudnnErrQueryMode_t") int mode, cudnnRuntimeTag_t tag);
public static native @Cast("cudnnStatus_t") int cudnnQueryRuntimeError(cudnnContext handle, @Cast("cudnnStatus_t*") IntBuffer rstatus, @Cast("cudnnErrQueryMode_t") int mode, cudnnRuntimeTag_t tag);
public static native @Cast("cudnnStatus_t") int cudnnQueryRuntimeError(cudnnContext handle, @Cast("cudnnStatus_t*") int[] rstatus, @Cast("cudnnErrQueryMode_t") int mode, cudnnRuntimeTag_t tag);

// #ifndef __LIBRARY_TYPES_H__

/** enum libraryPropertyType_t */
public static final int MAJOR_VERSION = 0, MINOR_VERSION = 1, PATCH_LEVEL = 2;

// #endif

public static native @Cast("cudnnStatus_t") int cudnnGetProperty(@Cast("libraryPropertyType") int type, IntPointer value);
public static native @Cast("cudnnStatus_t") int cudnnGetProperty(@Cast("libraryPropertyType") int type, IntBuffer value);
public static native @Cast("cudnnStatus_t") int cudnnGetProperty(@Cast("libraryPropertyType") int type, int[] value);

public static native @Cast("cudnnStatus_t") int cudnnCreate(@ByPtrPtr cudnnContext handle);
public static native @Cast("cudnnStatus_t") int cudnnDestroy(cudnnContext handle);
public static native @Cast("cudnnStatus_t") int cudnnSetStream(cudnnContext handle, CUstream_st streamId);
public static native @Cast("cudnnStatus_t") int cudnnGetStream(cudnnContext handle, @ByPtrPtr CUstream_st streamId);
// Targeting ../cudnn/cudnnTensorStruct.java


// Targeting ../cudnn/cudnnPoolingStruct.java


// Targeting ../cudnn/cudnnFilterStruct.java


// Targeting ../cudnn/cudnnLRNStruct.java


// Targeting ../cudnn/cudnnActivationStruct.java


// Targeting ../cudnn/cudnnSpatialTransformerStruct.java


// Targeting ../cudnn/cudnnOpTensorStruct.java


// Targeting ../cudnn/cudnnReduceTensorStruct.java


// Targeting ../cudnn/cudnnCTCLossStruct.java


// Targeting ../cudnn/cudnnTensorTransformStruct.java


/*
 * CUDNN data type
 */
/** enum cudnnDataType_t */
public static final int
    CUDNN_DATA_FLOAT    = 0,
    CUDNN_DATA_DOUBLE   = 1,
    CUDNN_DATA_HALF     = 2,
    CUDNN_DATA_INT8     = 3,
    CUDNN_DATA_INT32    = 4,
    CUDNN_DATA_INT8x4   = 5,
    CUDNN_DATA_UINT8    = 6,
    CUDNN_DATA_UINT8x4  = 7,
    CUDNN_DATA_INT8x32  = 8,
    CUDNN_DATA_BFLOAT16 = 9,
    CUDNN_DATA_INT64    = 10;

/*
 * CUDNN math type
 */
/** enum cudnnMathType_t */
public static final int
    CUDNN_DEFAULT_MATH                    = 0,
    CUDNN_TENSOR_OP_MATH                  = 1,
    CUDNN_TENSOR_OP_MATH_ALLOW_CONVERSION = 2,
    CUDNN_FMA_MATH                        = 3;

/*
 * CUDNN propagate Nan
 */
/** enum cudnnNanPropagation_t */
public static final int
    CUDNN_NOT_PROPAGATE_NAN = 0,
    CUDNN_PROPAGATE_NAN     = 1;

/*
 * CUDNN Determinism
 */
/** enum cudnnDeterminism_t */
public static final int
    CUDNN_NON_DETERMINISTIC = 0,
    CUDNN_DETERMINISTIC     = 1;

/* Maximum supported number of tensor dimensions */
public static final int CUDNN_DIM_MAX = 8;

/* Create an instance of a generic Tensor descriptor */
public static native @Cast("cudnnStatus_t") int cudnnCreateTensorDescriptor(@Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct tensorDesc);
public static native @Cast("cudnnStatus_t") int cudnnCreateTensorDescriptor(@Cast("cudnnTensorStruct**") PointerPointer tensorDesc);

/** enum cudnnTensorFormat_t */
public static final int
    CUDNN_TENSOR_NCHW        = 0, /* row major (wStride = 1, hStride = w) */
    CUDNN_TENSOR_NHWC        = 1, /* feature maps interleaved ( cStride = 1 )*/
    CUDNN_TENSOR_NCHW_VECT_C = 2; /* each image point is vector of element of C, vector length in data type */

public static native @Cast("cudnnStatus_t") int cudnnSetTensor4dDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnTensorFormat_t") int format,
                           @Cast("cudnnDataType_t") int dataType,
                           int n,
                           int c,
                           int h,
                           int w);                   /* width of input section */

public static native @Cast("cudnnStatus_t") int cudnnSetTensor4dDescriptorEx(cudnnTensorStruct tensorDesc,
                             @Cast("cudnnDataType_t") int dataType,
                             int n,
                             int c,
                             int h,
                             int w,
                             int nStride,
                             int cStride,
                             int hStride,
                             int wStride);

public static native @Cast("cudnnStatus_t") int cudnnGetTensor4dDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t*") IntPointer dataType,
                           IntPointer n,
                           IntPointer c,
                           IntPointer h,
                           IntPointer w,
                           IntPointer nStride,
                           IntPointer cStride,
                           IntPointer hStride,
                           IntPointer wStride);
public static native @Cast("cudnnStatus_t") int cudnnGetTensor4dDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t*") IntBuffer dataType,
                           IntBuffer n,
                           IntBuffer c,
                           IntBuffer h,
                           IntBuffer w,
                           IntBuffer nStride,
                           IntBuffer cStride,
                           IntBuffer hStride,
                           IntBuffer wStride);
public static native @Cast("cudnnStatus_t") int cudnnGetTensor4dDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t*") int[] dataType,
                           int[] n,
                           int[] c,
                           int[] h,
                           int[] w,
                           int[] nStride,
                           int[] cStride,
                           int[] hStride,
                           int[] wStride);

public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           int nbDims,
                           @Const IntPointer dimA,
                           @Const IntPointer strideA);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           int nbDims,
                           @Const IntBuffer dimA,
                           @Const IntBuffer strideA);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           int nbDims,
                           @Const int[] dimA,
                           @Const int[] strideA);

public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptorEx(cudnnTensorStruct tensorDesc,
                             @Cast("cudnnTensorFormat_t") int format,
                             @Cast("cudnnDataType_t") int dataType,
                             int nbDims,
                             @Const IntPointer dimA);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptorEx(cudnnTensorStruct tensorDesc,
                             @Cast("cudnnTensorFormat_t") int format,
                             @Cast("cudnnDataType_t") int dataType,
                             int nbDims,
                             @Const IntBuffer dimA);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorNdDescriptorEx(cudnnTensorStruct tensorDesc,
                             @Cast("cudnnTensorFormat_t") int format,
                             @Cast("cudnnDataType_t") int dataType,
                             int nbDims,
                             @Const int[] dimA);

public static native @Cast("cudnnStatus_t") int cudnnGetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") IntPointer dataType,
                           IntPointer nbDims,
                           IntPointer dimA,
                           IntPointer strideA);
public static native @Cast("cudnnStatus_t") int cudnnGetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") IntBuffer dataType,
                           IntBuffer nbDims,
                           IntBuffer dimA,
                           IntBuffer strideA);
public static native @Cast("cudnnStatus_t") int cudnnGetTensorNdDescriptor(cudnnTensorStruct tensorDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") int[] dataType,
                           int[] nbDims,
                           int[] dimA,
                           int[] strideA);

public static native @Cast("cudnnStatus_t") int cudnnGetTensorSizeInBytes(cudnnTensorStruct tensorDesc, @Cast("size_t*") SizeTPointer size);

/* PixelOffset( n, c, h, w ) = n *input_stride + c * feature_stride + h * h_stride + w * w_stride

   1)Example of all images in row major order one batch of features after the other (with an optional padding on row)
   input_stride :  c x h x h_stride
   feature_stride : h x h_stride
   h_stride  :  >= w  ( h_stride = w if no padding)
   w_stride  : 1


   2)Example of all images in row major with features maps interleaved
   input_stride :  c x h x h_stride
   feature_stride : 1
   h_stride  :  w x c
   w_stride  : c

   3)Example of all images in column major order one batch of features after the other (with optional padding on column)
   input_stride :  c x w x w_stride
   feature_stride : w x w_stride
   h_stride  :  1
   w_stride  :  >= h

*/

/* Destroy an instance of Tensor4d descriptor */
public static native @Cast("cudnnStatus_t") int cudnnDestroyTensorDescriptor(cudnnTensorStruct tensorDesc);

/* Fold/unfold transforms */
/** enum cudnnFoldingDirection_t */
public static final int
    CUDNN_TRANSFORM_FOLD   = 0,
    CUDNN_TRANSFORM_UNFOLD = 1;

/** Create a destination descriptor for cudnnTransformTensor */
public static native @Cast("cudnnStatus_t") int cudnnInitTransformDest(cudnnTensorTransformStruct transformDesc,
                       cudnnTensorStruct srcDesc,
                       cudnnTensorStruct destDesc,
                       @Cast("size_t*") SizeTPointer destSizeInBytes);

/** Create an empty tensor transform descriptor */
public static native @Cast("cudnnStatus_t") int cudnnCreateTensorTransformDescriptor(@ByPtrPtr cudnnTensorTransformStruct transformDesc);

/** Initialize a previously created tensor transform descriptor. */
public static native @Cast("cudnnStatus_t") int cudnnSetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("const uint32_t") int nbDims,
                                  @Cast("const cudnnTensorFormat_t") int destFormat,
                                  @Const IntPointer padBeforeA,
                                  @Const IntPointer padAfterA,
                                  @Cast("const uint32_t*") IntPointer foldA,
                                  @Cast("const cudnnFoldingDirection_t") int direction);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("const uint32_t") int nbDims,
                                  @Cast("const cudnnTensorFormat_t") int destFormat,
                                  @Const IntBuffer padBeforeA,
                                  @Const IntBuffer padAfterA,
                                  @Cast("const uint32_t*") IntBuffer foldA,
                                  @Cast("const cudnnFoldingDirection_t") int direction);
public static native @Cast("cudnnStatus_t") int cudnnSetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("const uint32_t") int nbDims,
                                  @Cast("const cudnnTensorFormat_t") int destFormat,
                                  @Const int[] padBeforeA,
                                  @Const int[] padAfterA,
                                  @Cast("const uint32_t*") int[] foldA,
                                  @Cast("const cudnnFoldingDirection_t") int direction);

/**
 * Retrieves the values stored in a previously initialized tensor transform
 * descriptor.
 */
public static native @Cast("cudnnStatus_t") int cudnnGetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("uint32_t") int nbDimsRequested,
                                  @Cast("cudnnTensorFormat_t*") IntPointer destFormat,
                                  IntPointer padBeforeA,
                                  IntPointer padAfterA,
                                  @Cast("uint32_t*") IntPointer foldA,
                                  @Cast("cudnnFoldingDirection_t*") IntPointer direction);
public static native @Cast("cudnnStatus_t") int cudnnGetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("uint32_t") int nbDimsRequested,
                                  @Cast("cudnnTensorFormat_t*") IntBuffer destFormat,
                                  IntBuffer padBeforeA,
                                  IntBuffer padAfterA,
                                  @Cast("uint32_t*") IntBuffer foldA,
                                  @Cast("cudnnFoldingDirection_t*") IntBuffer direction);
public static native @Cast("cudnnStatus_t") int cudnnGetTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc,
                                  @Cast("uint32_t") int nbDimsRequested,
                                  @Cast("cudnnTensorFormat_t*") int[] destFormat,
                                  int[] padBeforeA,
                                  int[] padAfterA,
                                  @Cast("uint32_t*") int[] foldA,
                                  @Cast("cudnnFoldingDirection_t*") int[] direction);

/**
 * Destroys a previously created tensor transform descriptor.
 */
public static native @Cast("cudnnStatus_t") int cudnnDestroyTensorTransformDescriptor(cudnnTensorTransformStruct transformDesc);

/* Tensor layout conversion helper (y = alpha * x + beta * y) */
public static native @Cast("cudnnStatus_t") int cudnnTransformTensor(cudnnContext handle,
                     @Const Pointer alpha,
                     cudnnTensorStruct xDesc,
                     @Const Pointer x,
                     @Const Pointer beta,
                     cudnnTensorStruct yDesc,
                     Pointer y);

public static native @Cast("cudnnStatus_t") int cudnnTransformTensorEx(cudnnContext handle,
                       cudnnTensorTransformStruct transDesc,
                       @Const Pointer alpha,
                       cudnnTensorStruct srcDesc,
                       @Const Pointer srcData,
                       @Const Pointer beta,
                       cudnnTensorStruct destDesc,
                       Pointer destData);

/* Tensor Bias addition : C = alpha * A + beta * C  */
public static native @Cast("cudnnStatus_t") int cudnnAddTensor(cudnnContext handle,
               @Const Pointer alpha,
               cudnnTensorStruct aDesc,
               @Const Pointer A,
               @Const Pointer beta,
               cudnnTensorStruct cDesc,
               Pointer C);

/*
 * CUDNN OpTensor op type
 */
/** enum cudnnOpTensorOp_t */
public static final int
    CUDNN_OP_TENSOR_ADD  = 0,
    CUDNN_OP_TENSOR_MUL  = 1,
    CUDNN_OP_TENSOR_MIN  = 2,
    CUDNN_OP_TENSOR_MAX  = 3,
    CUDNN_OP_TENSOR_SQRT = 4,
    CUDNN_OP_TENSOR_NOT  = 5;

public static native @Cast("cudnnStatus_t") int cudnnCreateOpTensorDescriptor(@ByPtrPtr cudnnOpTensorStruct opTensorDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc,
                           @Cast("cudnnOpTensorOp_t") int opTensorOp,
                           @Cast("cudnnDataType_t") int opTensorCompType,
                           @Cast("cudnnNanPropagation_t") int opTensorNanOpt);

public static native @Cast("cudnnStatus_t") int cudnnGetOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc,
                           @Cast("cudnnOpTensorOp_t*") IntPointer opTensorOp,
                           @Cast("cudnnDataType_t*") IntPointer opTensorCompType,
                           @Cast("cudnnNanPropagation_t*") IntPointer opTensorNanOpt);
public static native @Cast("cudnnStatus_t") int cudnnGetOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc,
                           @Cast("cudnnOpTensorOp_t*") IntBuffer opTensorOp,
                           @Cast("cudnnDataType_t*") IntBuffer opTensorCompType,
                           @Cast("cudnnNanPropagation_t*") IntBuffer opTensorNanOpt);
public static native @Cast("cudnnStatus_t") int cudnnGetOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc,
                           @Cast("cudnnOpTensorOp_t*") int[] opTensorOp,
                           @Cast("cudnnDataType_t*") int[] opTensorCompType,
                           @Cast("cudnnNanPropagation_t*") int[] opTensorNanOpt);

public static native @Cast("cudnnStatus_t") int cudnnDestroyOpTensorDescriptor(cudnnOpTensorStruct opTensorDesc);

/* Tensor operation : C = op( alpha1 * A, alpha2 * B ) + beta * C */
/* B tensor is ignored for CUDNN_OP_TENSOR_SQRT, CUDNN_OP_TENSOR_NOT. */
public static native @Cast("cudnnStatus_t") int cudnnOpTensor(cudnnContext handle,
              cudnnOpTensorStruct opTensorDesc,
              @Const Pointer alpha1,
              cudnnTensorStruct aDesc,
              @Const Pointer A,
              @Const Pointer alpha2,
              cudnnTensorStruct bDesc,
              @Const Pointer B,
              @Const Pointer beta,
              cudnnTensorStruct cDesc,
              Pointer C);

/*
 * CUDNN ReduceTensor op type
 */
/** enum cudnnReduceTensorOp_t */
public static final int
    CUDNN_REDUCE_TENSOR_ADD          = 0,
    CUDNN_REDUCE_TENSOR_MUL          = 1,
    CUDNN_REDUCE_TENSOR_MIN          = 2,
    CUDNN_REDUCE_TENSOR_MAX          = 3,
    CUDNN_REDUCE_TENSOR_AMAX         = 4,
    CUDNN_REDUCE_TENSOR_AVG          = 5,
    CUDNN_REDUCE_TENSOR_NORM1        = 6,
    CUDNN_REDUCE_TENSOR_NORM2        = 7,
    CUDNN_REDUCE_TENSOR_MUL_NO_ZEROS = 8;

/*
 * CUDNN ReduceTensor indices type
 */
/** enum cudnnReduceTensorIndices_t */
public static final int
    CUDNN_REDUCE_TENSOR_NO_INDICES        = 0,
    CUDNN_REDUCE_TENSOR_FLATTENED_INDICES = 1;

/*
 * CUDNN tensor indices type size (all unsigned)
 * Currently not supported, default is 32 bit unsigned.
 */
/** enum cudnnIndicesType_t */
public static final int
    CUDNN_32BIT_INDICES = 0,
    CUDNN_64BIT_INDICES = 1,
    CUDNN_16BIT_INDICES = 2,
    CUDNN_8BIT_INDICES  = 3;

public static native @Cast("cudnnStatus_t") int cudnnCreateReduceTensorDescriptor(@ByPtrPtr cudnnReduceTensorStruct reduceTensorDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc,
                               @Cast("cudnnReduceTensorOp_t") int reduceTensorOp,
                               @Cast("cudnnDataType_t") int reduceTensorCompType,
                               @Cast("cudnnNanPropagation_t") int reduceTensorNanOpt,
                               @Cast("cudnnReduceTensorIndices_t") int reduceTensorIndices,
                               @Cast("cudnnIndicesType_t") int reduceTensorIndicesType);

public static native @Cast("cudnnStatus_t") int cudnnGetReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc,
                               @Cast("cudnnReduceTensorOp_t*") IntPointer reduceTensorOp,
                               @Cast("cudnnDataType_t*") IntPointer reduceTensorCompType,
                               @Cast("cudnnNanPropagation_t*") IntPointer reduceTensorNanOpt,
                               @Cast("cudnnReduceTensorIndices_t*") IntPointer reduceTensorIndices,
                               @Cast("cudnnIndicesType_t*") IntPointer reduceTensorIndicesType);
public static native @Cast("cudnnStatus_t") int cudnnGetReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc,
                               @Cast("cudnnReduceTensorOp_t*") IntBuffer reduceTensorOp,
                               @Cast("cudnnDataType_t*") IntBuffer reduceTensorCompType,
                               @Cast("cudnnNanPropagation_t*") IntBuffer reduceTensorNanOpt,
                               @Cast("cudnnReduceTensorIndices_t*") IntBuffer reduceTensorIndices,
                               @Cast("cudnnIndicesType_t*") IntBuffer reduceTensorIndicesType);
public static native @Cast("cudnnStatus_t") int cudnnGetReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc,
                               @Cast("cudnnReduceTensorOp_t*") int[] reduceTensorOp,
                               @Cast("cudnnDataType_t*") int[] reduceTensorCompType,
                               @Cast("cudnnNanPropagation_t*") int[] reduceTensorNanOpt,
                               @Cast("cudnnReduceTensorIndices_t*") int[] reduceTensorIndices,
                               @Cast("cudnnIndicesType_t*") int[] reduceTensorIndicesType);

public static native @Cast("cudnnStatus_t") int cudnnDestroyReduceTensorDescriptor(cudnnReduceTensorStruct reduceTensorDesc);

/* Helper function to return the minimum size of the index space to be passed to the reduction given the input and
 * output tensors */
public static native @Cast("cudnnStatus_t") int cudnnGetReductionIndicesSize(cudnnContext handle,
                             cudnnReduceTensorStruct reduceTensorDesc,
                             cudnnTensorStruct aDesc,
                             cudnnTensorStruct cDesc,
                             @Cast("size_t*") SizeTPointer sizeInBytes);

/* Helper function to return the minimum size of the workspace to be passed to the reduction given the input and output
 * tensors */
public static native @Cast("cudnnStatus_t") int cudnnGetReductionWorkspaceSize(cudnnContext handle,
                               cudnnReduceTensorStruct reduceTensorDesc,
                               cudnnTensorStruct aDesc,
                               cudnnTensorStruct cDesc,
                               @Cast("size_t*") SizeTPointer sizeInBytes);

/* Tensor operation : C = reduce op( alpha * A ) + beta * C */
/* The NaN propagation enum applies to only the min and max reduce ops; the other reduce ops propagate NaN as usual. */
/* The indices space is ignored for reduce ops other than min or max. */
public static native @Cast("cudnnStatus_t") int cudnnReduceTensor(cudnnContext handle,
                  cudnnReduceTensorStruct reduceTensorDesc,
                  Pointer indices,
                  @Cast("size_t") long indicesSizeInBytes,
                  Pointer workspace,
                  @Cast("size_t") long workspaceSizeInBytes,
                  @Const Pointer alpha,
                  cudnnTensorStruct aDesc,
                  @Const Pointer A,
                  @Const Pointer beta,
                  cudnnTensorStruct cDesc,
                  Pointer C);

/* Set all values of a tensor to a given value : y[i] = value[0] */
public static native @Cast("cudnnStatus_t") int cudnnSetTensor(cudnnContext handle, cudnnTensorStruct yDesc, Pointer y, @Const Pointer valuePtr);

/* Scale all values of a tensor by a given factor : y[i] = alpha * y[i] */
public static native @Cast("cudnnStatus_t") int cudnnScaleTensor(cudnnContext handle, cudnnTensorStruct yDesc, Pointer y, @Const Pointer alpha);

/* Create an instance of FilterStruct */
public static native @Cast("cudnnStatus_t") int cudnnCreateFilterDescriptor(@ByPtrPtr cudnnFilterStruct filterDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetFilter4dDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           @Cast("cudnnTensorFormat_t") int format,
                           int k,
                           int c,
                           int h,
                           int w); /* width of  each input filter */

public static native @Cast("cudnnStatus_t") int cudnnGetFilter4dDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t*") IntPointer dataType,
                           @Cast("cudnnTensorFormat_t*") IntPointer format,
                           IntPointer k,
                           IntPointer c,
                           IntPointer h,
                           IntPointer w);
public static native @Cast("cudnnStatus_t") int cudnnGetFilter4dDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t*") IntBuffer dataType,
                           @Cast("cudnnTensorFormat_t*") IntBuffer format,
                           IntBuffer k,
                           IntBuffer c,
                           IntBuffer h,
                           IntBuffer w);
public static native @Cast("cudnnStatus_t") int cudnnGetFilter4dDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t*") int[] dataType,
                           @Cast("cudnnTensorFormat_t*") int[] format,
                           int[] k,
                           int[] c,
                           int[] h,
                           int[] w); /* width of  each input filter */

public static native @Cast("cudnnStatus_t") int cudnnSetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           @Cast("cudnnTensorFormat_t") int format,
                           int nbDims,
                           @Const IntPointer filterDimA);
public static native @Cast("cudnnStatus_t") int cudnnSetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           @Cast("cudnnTensorFormat_t") int format,
                           int nbDims,
                           @Const IntBuffer filterDimA);
public static native @Cast("cudnnStatus_t") int cudnnSetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           @Cast("cudnnDataType_t") int dataType,
                           @Cast("cudnnTensorFormat_t") int format,
                           int nbDims,
                           @Const int[] filterDimA);

public static native @Cast("cudnnStatus_t") int cudnnGetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") IntPointer dataType,
                           @Cast("cudnnTensorFormat_t*") IntPointer format,
                           IntPointer nbDims,
                           IntPointer filterDimA);
public static native @Cast("cudnnStatus_t") int cudnnGetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") IntBuffer dataType,
                           @Cast("cudnnTensorFormat_t*") IntBuffer format,
                           IntBuffer nbDims,
                           IntBuffer filterDimA);
public static native @Cast("cudnnStatus_t") int cudnnGetFilterNdDescriptor(cudnnFilterStruct filterDesc,
                           int nbDimsRequested,
                           @Cast("cudnnDataType_t*") int[] dataType,
                           @Cast("cudnnTensorFormat_t*") int[] format,
                           int[] nbDims,
                           int[] filterDimA);
public static native @Cast("cudnnStatus_t") int cudnnGetFilterSizeInBytes(cudnnFilterStruct filterDesc, @Cast("size_t*") SizeTPointer size);

public static native @Cast("cudnnStatus_t") int cudnnTransformFilter(cudnnContext handle,
                     cudnnTensorTransformStruct transDesc,
                     @Const Pointer alpha,
                     cudnnFilterStruct srcDesc,
                     @Const Pointer srcData,
                     @Const Pointer beta,
                     cudnnFilterStruct destDesc,
                     Pointer destData);

public static native @Cast("cudnnStatus_t") int cudnnDestroyFilterDescriptor(cudnnFilterStruct filterDesc);

/*
 *  softmax algorithm
 */
/** enum cudnnSoftmaxAlgorithm_t */
public static final int
    CUDNN_SOFTMAX_FAST     = 0, /* straightforward implementation */
    CUDNN_SOFTMAX_ACCURATE = 1, /* subtract max from every point to avoid overflow */
    CUDNN_SOFTMAX_LOG      = 2;

/** enum cudnnSoftmaxMode_t */
public static final int
    CUDNN_SOFTMAX_MODE_INSTANCE = 0, /* compute the softmax over all C, H, W for each N */
    CUDNN_SOFTMAX_MODE_CHANNEL  = 1;  /* compute the softmax over all C for each H, W, N */

/* Softmax functions: All of the form "output = alpha * Op(inputs) + beta * output" */

/* Function to perform forward softmax */
public static native @Cast("cudnnStatus_t") int cudnnSoftmaxForward(cudnnContext handle,
                    @Cast("cudnnSoftmaxAlgorithm_t") int algo,
                    @Cast("cudnnSoftmaxMode_t") int mode,
                    @Const Pointer alpha,
                    cudnnTensorStruct xDesc,
                    @Const Pointer x,
                    @Const Pointer beta,
                    cudnnTensorStruct yDesc,
                    Pointer y);

/*
 *  pooling mode
 */
/** enum cudnnPoolingMode_t */
public static final int
    CUDNN_POOLING_MAX                           = 0,
    CUDNN_POOLING_AVERAGE_COUNT_INCLUDE_PADDING = 1, /* count for average includes padded values */
    CUDNN_POOLING_AVERAGE_COUNT_EXCLUDE_PADDING = 2, /* count for average does not include padded values */
    CUDNN_POOLING_MAX_DETERMINISTIC             = 3;

/* Create an instance of pooling descriptor */
public static native @Cast("cudnnStatus_t") int cudnnCreatePoolingDescriptor(@ByPtrPtr cudnnPoolingStruct poolingDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetPooling2dDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("cudnnPoolingMode_t") int mode,
                            @Cast("cudnnNanPropagation_t") int maxpoolingNanOpt,
                            int windowHeight,
                            int windowWidth,
                            int verticalPadding,
                            int horizontalPadding,
                            int verticalStride,
                            int horizontalStride);

public static native @Cast("cudnnStatus_t") int cudnnGetPooling2dDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("cudnnPoolingMode_t*") IntPointer mode,
                            @Cast("cudnnNanPropagation_t*") IntPointer maxpoolingNanOpt,
                            IntPointer windowHeight,
                            IntPointer windowWidth,
                            IntPointer verticalPadding,
                            IntPointer horizontalPadding,
                            IntPointer verticalStride,
                            IntPointer horizontalStride);
public static native @Cast("cudnnStatus_t") int cudnnGetPooling2dDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("cudnnPoolingMode_t*") IntBuffer mode,
                            @Cast("cudnnNanPropagation_t*") IntBuffer maxpoolingNanOpt,
                            IntBuffer windowHeight,
                            IntBuffer windowWidth,
                            IntBuffer verticalPadding,
                            IntBuffer horizontalPadding,
                            IntBuffer verticalStride,
                            IntBuffer horizontalStride);
public static native @Cast("cudnnStatus_t") int cudnnGetPooling2dDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("cudnnPoolingMode_t*") int[] mode,
                            @Cast("cudnnNanPropagation_t*") int[] maxpoolingNanOpt,
                            int[] windowHeight,
                            int[] windowWidth,
                            int[] verticalPadding,
                            int[] horizontalPadding,
                            int[] verticalStride,
                            int[] horizontalStride);

public static native @Cast("cudnnStatus_t") int cudnnSetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("const cudnnPoolingMode_t") int mode,
                            @Cast("const cudnnNanPropagation_t") int maxpoolingNanOpt,
                            int nbDims,
                            @Const IntPointer windowDimA,
                            @Const IntPointer paddingA,
                            @Const IntPointer strideA);
public static native @Cast("cudnnStatus_t") int cudnnSetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("const cudnnPoolingMode_t") int mode,
                            @Cast("const cudnnNanPropagation_t") int maxpoolingNanOpt,
                            int nbDims,
                            @Const IntBuffer windowDimA,
                            @Const IntBuffer paddingA,
                            @Const IntBuffer strideA);
public static native @Cast("cudnnStatus_t") int cudnnSetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            @Cast("const cudnnPoolingMode_t") int mode,
                            @Cast("const cudnnNanPropagation_t") int maxpoolingNanOpt,
                            int nbDims,
                            @Const int[] windowDimA,
                            @Const int[] paddingA,
                            @Const int[] strideA);

public static native @Cast("cudnnStatus_t") int cudnnGetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            int nbDimsRequested,
                            @Cast("cudnnPoolingMode_t*") IntPointer mode,
                            @Cast("cudnnNanPropagation_t*") IntPointer maxpoolingNanOpt,
                            IntPointer nbDims,
                            IntPointer windowDimA,
                            IntPointer paddingA,
                            IntPointer strideA);
public static native @Cast("cudnnStatus_t") int cudnnGetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            int nbDimsRequested,
                            @Cast("cudnnPoolingMode_t*") IntBuffer mode,
                            @Cast("cudnnNanPropagation_t*") IntBuffer maxpoolingNanOpt,
                            IntBuffer nbDims,
                            IntBuffer windowDimA,
                            IntBuffer paddingA,
                            IntBuffer strideA);
public static native @Cast("cudnnStatus_t") int cudnnGetPoolingNdDescriptor(cudnnPoolingStruct poolingDesc,
                            int nbDimsRequested,
                            @Cast("cudnnPoolingMode_t*") int[] mode,
                            @Cast("cudnnNanPropagation_t*") int[] maxpoolingNanOpt,
                            int[] nbDims,
                            int[] windowDimA,
                            int[] paddingA,
                            int[] strideA);

public static native @Cast("cudnnStatus_t") int cudnnGetPoolingNdForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  int nbDims,
                                  IntPointer outputTensorDimA);
public static native @Cast("cudnnStatus_t") int cudnnGetPoolingNdForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  int nbDims,
                                  IntBuffer outputTensorDimA);
public static native @Cast("cudnnStatus_t") int cudnnGetPoolingNdForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  int nbDims,
                                  int[] outputTensorDimA);

public static native @Cast("cudnnStatus_t") int cudnnGetPooling2dForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  IntPointer n,
                                  IntPointer c,
                                  IntPointer h,
                                  IntPointer w);
public static native @Cast("cudnnStatus_t") int cudnnGetPooling2dForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  IntBuffer n,
                                  IntBuffer c,
                                  IntBuffer h,
                                  IntBuffer w);
public static native @Cast("cudnnStatus_t") int cudnnGetPooling2dForwardOutputDim(cudnnPoolingStruct poolingDesc,
                                  cudnnTensorStruct inputTensorDesc,
                                  int[] n,
                                  int[] c,
                                  int[] h,
                                  int[] w);

/* Destroy an instance of pooling descriptor */
public static native @Cast("cudnnStatus_t") int cudnnDestroyPoolingDescriptor(cudnnPoolingStruct poolingDesc);

/* Pooling functions: All of the form "output = alpha * Op(inputs) + beta * output" */

/* Function to perform forward pooling */
public static native @Cast("cudnnStatus_t") int cudnnPoolingForward(cudnnContext handle,
                    cudnnPoolingStruct poolingDesc,
                    @Const Pointer alpha,
                    cudnnTensorStruct xDesc,
                    @Const Pointer x,
                    @Const Pointer beta,
                    cudnnTensorStruct yDesc,
                    Pointer y);

/*
 * activation mode
 */
/** enum cudnnActivationMode_t */
public static final int
    CUDNN_ACTIVATION_SIGMOID      = 0,
    CUDNN_ACTIVATION_RELU         = 1,
    CUDNN_ACTIVATION_TANH         = 2,
    CUDNN_ACTIVATION_CLIPPED_RELU = 3,
    CUDNN_ACTIVATION_ELU          = 4,
    CUDNN_ACTIVATION_IDENTITY     = 5;

/* Activation functions: All of the form "output = alpha * Op(inputs) + beta * output" */
public static native @Cast("cudnnStatus_t") int cudnnCreateActivationDescriptor(@ByPtrPtr cudnnActivationStruct activationDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetActivationDescriptor(cudnnActivationStruct activationDesc,
                             @Cast("cudnnActivationMode_t") int mode,
                             @Cast("cudnnNanPropagation_t") int reluNanOpt,
                             double coef); /* ceiling for clipped RELU, alpha for ELU */

public static native @Cast("cudnnStatus_t") int cudnnGetActivationDescriptor(cudnnActivationStruct activationDesc,
                             @Cast("cudnnActivationMode_t*") IntPointer mode,
                             @Cast("cudnnNanPropagation_t*") IntPointer reluNanOpt,
                             DoublePointer coef);
public static native @Cast("cudnnStatus_t") int cudnnGetActivationDescriptor(cudnnActivationStruct activationDesc,
                             @Cast("cudnnActivationMode_t*") IntBuffer mode,
                             @Cast("cudnnNanPropagation_t*") IntBuffer reluNanOpt,
                             DoubleBuffer coef);
public static native @Cast("cudnnStatus_t") int cudnnGetActivationDescriptor(cudnnActivationStruct activationDesc,
                             @Cast("cudnnActivationMode_t*") int[] mode,
                             @Cast("cudnnNanPropagation_t*") int[] reluNanOpt,
                             double[] coef); /* ceiling for clipped RELU, alpha for ELU */

public static native @Cast("cudnnStatus_t") int cudnnDestroyActivationDescriptor(cudnnActivationStruct activationDesc);

/* Function to perform forward activation  */
public static native @Cast("cudnnStatus_t") int cudnnActivationForward(cudnnContext handle,
                       cudnnActivationStruct activationDesc,
                       @Const Pointer alpha,
                       cudnnTensorStruct xDesc,
                       @Const Pointer x,
                       @Const Pointer beta,
                       cudnnTensorStruct yDesc,
                       Pointer y);

/*
 * Create an instance of LRN (Local Response Normalization) descriptor
 * Uses lrnN=5, lrnAlpha=1e-4, lrnBeta=0.75, lrnK=2.0 as defaults from Krizhevsky'12 ImageNet paper
 */
public static native @Cast("cudnnStatus_t") int cudnnCreateLRNDescriptor(@ByPtrPtr cudnnLRNStruct normDesc);

public static final int CUDNN_LRN_MIN_N = 1;       /* minimum allowed lrnN */
public static final int CUDNN_LRN_MAX_N = 16;      /* maximum allowed lrnN */
public static final double CUDNN_LRN_MIN_K = 1e-5;    /* minimum allowed lrnK */
public static final double CUDNN_LRN_MIN_BETA = 0.01; /* minimum allowed lrnBeta */

/* LRN layer mode */
/** enum cudnnLRNMode_t */
public static final int
    CUDNN_LRN_CROSS_CHANNEL_DIM1 = 0; /* Normalize across tensor's dimA[1] dimension */

/*
 * Uses a window [center-lookBehind, center+lookAhead], where
 * lookBehind = floor( (lrnN-1)/2 ), lookAhead = lrnN-lookBehind-1.
 * Values of double parameters cast to tensor data type.
 */
public static native @Cast("cudnnStatus_t") int cudnnSetLRNDescriptor(cudnnLRNStruct normDesc, @Cast("unsigned") int lrnN, double lrnAlpha, double lrnBeta, double lrnK);
/*
 * Retrieve the settings currently stored in an LRN layer descriptor
 * Any of the provided pointers can be NULL (no corresponding value will be returned)
 */
public static native @Cast("cudnnStatus_t") int cudnnGetLRNDescriptor(cudnnLRNStruct normDesc, @Cast("unsigned*") IntPointer lrnN, DoublePointer lrnAlpha, DoublePointer lrnBeta, DoublePointer lrnK);
public static native @Cast("cudnnStatus_t") int cudnnGetLRNDescriptor(cudnnLRNStruct normDesc, @Cast("unsigned*") IntBuffer lrnN, DoubleBuffer lrnAlpha, DoubleBuffer lrnBeta, DoubleBuffer lrnK);
public static native @Cast("cudnnStatus_t") int cudnnGetLRNDescriptor(cudnnLRNStruct normDesc, @Cast("unsigned*") int[] lrnN, double[] lrnAlpha, double[] lrnBeta, double[] lrnK);

/* Destroy an instance of LRN descriptor */
public static native @Cast("cudnnStatus_t") int cudnnDestroyLRNDescriptor(cudnnLRNStruct lrnDesc);

/* LRN functions: output = alpha * normalize(x) + beta * old_y */

/* LRN cross-channel forward computation. Double parameters cast to tensor data type */
public static native @Cast("cudnnStatus_t") int cudnnLRNCrossChannelForward(cudnnContext handle,
                            cudnnLRNStruct normDesc,
                            @Cast("cudnnLRNMode_t") int lrnMode,
                            @Const Pointer alpha,
                            cudnnTensorStruct xDesc,
                            @Const Pointer x,
                            @Const Pointer beta,
                            cudnnTensorStruct yDesc,
                            Pointer y);

/** enum cudnnDivNormMode_t */
public static final int
    CUDNN_DIVNORM_PRECOMPUTED_MEANS = 0;

/* LCN/divisive normalization functions: y = alpha * normalize(x) + beta * y */
public static native @Cast("cudnnStatus_t") int cudnnDivisiveNormalizationForward(cudnnContext handle,
                                  cudnnLRNStruct normDesc,
                                  @Cast("cudnnDivNormMode_t") int mode,
                                  @Const Pointer alpha,
                                  cudnnTensorStruct xDesc,
                                  @Const Pointer x,
                                  @Const Pointer means,
                                  Pointer temp,
                                  Pointer temp2,
                                  @Const Pointer beta,
                                  cudnnTensorStruct yDesc,
                                  Pointer y);

/** enum cudnnBatchNormMode_t */
public static final int
    /* bnScale, bnBias tensor dims are 1xCxHxWx.. (one value per CHW...-slice, normalized over N slice) */
    CUDNN_BATCHNORM_PER_ACTIVATION = 0,

    /* bnScale, bnBias tensor dims are 1xCx1x1 (one value per C-dim normalized over Nx1xHxW subtensors) */
    CUDNN_BATCHNORM_SPATIAL = 1,

    /*
     * bnScale, bnBias tensor dims are 1xCx1x1 (one value per C-dim normalized over Nx1xHxW subtensors).
     * May be faster than CUDNN_BATCHNORM_SPATIAL but imposes some limits on the range of values
     */
    CUDNN_BATCHNORM_SPATIAL_PERSISTENT = 2;

public static final double CUDNN_BN_MIN_EPSILON = 0.0; /* Minimum epsilon allowed to be used in the Batch Normalization formula */

/*
 * Derives a tensor descriptor from layer data descriptor for BatchNormalization
 * scale, invVariance, bnBias, bnScale tensors. Use this tensor desc for
 * bnScaleBiasMeanVarDesc and bnScaleBiasDiffDesc in Batch Normalization forward and backward functions.
 */
public static native @Cast("cudnnStatus_t") int cudnnDeriveBNTensorDescriptor(cudnnTensorStruct derivedBnDesc,
                              cudnnTensorStruct xDesc,
                              @Cast("cudnnBatchNormMode_t") int mode);

/** enum cudnnBatchNormOps_t */
public static final int
    CUDNN_BATCHNORM_OPS_BN                = 0, /* do batch normalization only */
    CUDNN_BATCHNORM_OPS_BN_ACTIVATION     = 1, /* do batchNorm, then activation */
    CUDNN_BATCHNORM_OPS_BN_ADD_ACTIVATION = 2; /* do batchNorm, then elemWiseAdd, then activation */

/*
 * Performs Batch Normalization during Inference:
 * y[i] = bnScale[k]*(x[i]-estimatedMean[k])/sqrt(epsilon+estimatedVariance[k]) + bnBias[k]
 * with bnScale, bnBias, runningMean, runningInvVariance tensors indexed
 * according to spatial or per-activation mode. Refer to cudnnBatchNormalizationForwardTraining
 * above for notes on function arguments.
 */
public static native @Cast("cudnnStatus_t") int cudnnBatchNormalizationForwardInference(cudnnContext handle,
                                        @Cast("cudnnBatchNormMode_t") int mode,
                                        @Const Pointer alpha,
                                        @Const Pointer beta,
                                        cudnnTensorStruct xDesc,
                                        @Const Pointer x,
                                        cudnnTensorStruct yDesc,
                                        Pointer y,
                                        cudnnTensorStruct bnScaleBiasMeanVarDesc,
                                        @Const Pointer bnScale,
                                        @Const Pointer bnBias,
                                        @Const Pointer estimatedMean,
                                        @Const Pointer estimatedVariance,
                                        double epsilon);

/** enum cudnnNormMode_t */
public static final int
    /* bnScale, bnBias tensor dims are 1xCxHxWx.. (one value per CHW...-slice, normalized over N slice) */
    CUDNN_NORM_PER_ACTIVATION = 0,

    /* bnScale, bnBias tensor dims are 1xCx1x1 (one value per C-dim normalized over Nx1xHxW subtensors) */
    CUDNN_NORM_PER_CHANNEL = 1;

/** enum cudnnNormAlgo_t */
public static final int CUDNN_NORM_ALGO_STANDARD = 0, CUDNN_NORM_ALGO_PERSIST = 1;

/*
 * Derives a tensor descriptor from layer data descriptor for Normalization
 * scale, invVariance, bnBias, bnScale tensors. Use this tensor desc for
 * normScaleBiasMeanVarDesc and normScaleBiasDiffDesc in Normalization forward and backward functions.
 */
public static native @Cast("cudnnStatus_t") int cudnnDeriveNormTensorDescriptor(cudnnTensorStruct derivedNormScaleBiasDesc,
                                cudnnTensorStruct derivedNormMeanVarDesc,
                                cudnnTensorStruct xDesc,
                                @Cast("cudnnNormMode_t") int mode,
                                int groupCnt); /* Place hold for future work, should be set to 1 now*/

/** enum cudnnNormOps_t */
public static final int
    CUDNN_NORM_OPS_NORM                = 0, /* do normalization only */
    CUDNN_NORM_OPS_NORM_ACTIVATION     = 1, /* do Norm, then activation */
    CUDNN_NORM_OPS_NORM_ADD_ACTIVATION = 2; /* do Norm, then elemWiseAdd, then activation */

/*
 * Performs Normalization during Inference:
 * y[i] = normScale[k]*(x[i]-estimatedMean[k])/sqrt(epsilon+estimatedVariance[k]) + normBias[k]
 * with normScale, normBias, runningMean, runningInvVariance tensors indexed
 * according to per-channel or per-activation mode. Refer to cudnnNormalizationForwardTraining
 * above for notes on function arguments.
 */
public static native @Cast("cudnnStatus_t") int cudnnNormalizationForwardInference(cudnnContext handle,
                                   @Cast("cudnnNormMode_t") int mode,
                                   @Cast("cudnnNormOps_t") int normOps,
                                   @Cast("cudnnNormAlgo_t") int algo,
                                   @Const Pointer alpha,
                                   @Const Pointer beta,
                                   cudnnTensorStruct xDesc,
                                   @Const Pointer x,
                                   cudnnTensorStruct normScaleBiasDesc,
                                   @Const Pointer normScale,
                                   @Const Pointer normBias,
                                   cudnnTensorStruct normMeanVarDesc,
                                   @Const Pointer estimatedMean,
                                   @Const Pointer estimatedVariance,
                                   cudnnTensorStruct zDesc,
                                   @Const Pointer z,
                                   cudnnActivationStruct activationDesc,
                                   cudnnTensorStruct yDesc,
                                   Pointer y,
                                   double epsilon,
                                   int groupCnt); /* Place hold for future work*/

/* APIs for spatial transformer network*/
/** enum cudnnSamplerType_t */
public static final int
    CUDNN_SAMPLER_BILINEAR = 0;

public static native @Cast("cudnnStatus_t") int cudnnCreateSpatialTransformerDescriptor(@ByPtrPtr cudnnSpatialTransformerStruct stDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetSpatialTransformerNdDescriptor(cudnnSpatialTransformerStruct stDesc,
                                       @Cast("cudnnSamplerType_t") int samplerType,
                                       @Cast("cudnnDataType_t") int dataType,
                                       int nbDims,
                                       @Const IntPointer dimA);
public static native @Cast("cudnnStatus_t") int cudnnSetSpatialTransformerNdDescriptor(cudnnSpatialTransformerStruct stDesc,
                                       @Cast("cudnnSamplerType_t") int samplerType,
                                       @Cast("cudnnDataType_t") int dataType,
                                       int nbDims,
                                       @Const IntBuffer dimA);
public static native @Cast("cudnnStatus_t") int cudnnSetSpatialTransformerNdDescriptor(cudnnSpatialTransformerStruct stDesc,
                                       @Cast("cudnnSamplerType_t") int samplerType,
                                       @Cast("cudnnDataType_t") int dataType,
                                       int nbDims,
                                       @Const int[] dimA);

public static native @Cast("cudnnStatus_t") int cudnnDestroySpatialTransformerDescriptor(cudnnSpatialTransformerStruct stDesc);

public static native @Cast("cudnnStatus_t") int cudnnSpatialTfGridGeneratorForward(cudnnContext handle,
                                   cudnnSpatialTransformerStruct stDesc,
                                   @Const Pointer theta,
                                   Pointer grid);

public static native @Cast("cudnnStatus_t") int cudnnSpatialTfSamplerForward(cudnnContext handle,
                             cudnnSpatialTransformerStruct stDesc,
                             @Const Pointer alpha,
                             cudnnTensorStruct xDesc,
                             @Const Pointer x,
                             @Const Pointer grid,
                             @Const Pointer beta,
                             cudnnTensorStruct yDesc,
                             Pointer y);
// Targeting ../cudnn/cudnnDropoutStruct.java



public static native @Cast("cudnnStatus_t") int cudnnCreateDropoutDescriptor(@ByPtrPtr cudnnDropoutStruct dropoutDesc);

public static native @Cast("cudnnStatus_t") int cudnnDestroyDropoutDescriptor(cudnnDropoutStruct dropoutDesc);

/*helper function to determine size of the states to be passed to cudnnSetDropoutDescriptor */
public static native @Cast("cudnnStatus_t") int cudnnDropoutGetStatesSize(cudnnContext handle, @Cast("size_t*") SizeTPointer sizeInBytes);

/*helper function to determine size of the reserve space to be passed to dropout forward/backward calls */
public static native @Cast("cudnnStatus_t") int cudnnDropoutGetReserveSpaceSize(cudnnTensorStruct xdesc, @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnSetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          float dropout,
                          Pointer states,
                          @Cast("size_t") long stateSizeInBytes,
                          @Cast("unsigned long long") long seed);

/* Restores the dropout descriptor to a previously saved-off state */
public static native @Cast("cudnnStatus_t") int cudnnRestoreDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                              cudnnContext handle,
                              float dropout,
                              Pointer states,
                              @Cast("size_t") long stateSizeInBytes,
                              @Cast("unsigned long long") long seed);

public static native @Cast("cudnnStatus_t") int cudnnGetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          FloatPointer dropout,
                          @Cast("void**") PointerPointer states,
                          @Cast("unsigned long long*") LongPointer seed);
public static native @Cast("cudnnStatus_t") int cudnnGetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          FloatPointer dropout,
                          @Cast("void**") @ByPtrPtr Pointer states,
                          @Cast("unsigned long long*") LongPointer seed);
public static native @Cast("cudnnStatus_t") int cudnnGetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          FloatBuffer dropout,
                          @Cast("void**") @ByPtrPtr Pointer states,
                          @Cast("unsigned long long*") LongBuffer seed);
public static native @Cast("cudnnStatus_t") int cudnnGetDropoutDescriptor(cudnnDropoutStruct dropoutDesc,
                          cudnnContext handle,
                          float[] dropout,
                          @Cast("void**") @ByPtrPtr Pointer states,
                          @Cast("unsigned long long*") long[] seed);

public static native @Cast("cudnnStatus_t") int cudnnDropoutForward(cudnnContext handle,
                    cudnnDropoutStruct dropoutDesc,
                    cudnnTensorStruct xdesc,
                    @Const Pointer x,
                    cudnnTensorStruct ydesc,
                    Pointer y,
                    Pointer reserveSpace,
                    @Cast("size_t") long reserveSpaceSizeInBytes);
// Targeting ../cudnn/cudnnAlgorithmStruct.java


// Targeting ../cudnn/cudnnAlgorithmPerformanceStruct.java



/* TODO: move these enums out to the appropriate submodule */
/** enum cudnnConvolutionFwdAlgo_t */
public static final int
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_GEMM         = 0,
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_PRECOMP_GEMM = 1,
    CUDNN_CONVOLUTION_FWD_ALGO_GEMM                  = 2,
    CUDNN_CONVOLUTION_FWD_ALGO_DIRECT                = 3,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT                   = 4,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT_TILING            = 5,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD              = 6,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD_NONFUSED     = 7,
    CUDNN_CONVOLUTION_FWD_ALGO_COUNT                 = 8;

/** enum cudnnConvolutionBwdFilterAlgo_t */
public static final int
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_0                 = 0, /* non-deterministic */
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_1                 = 1,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT               = 2,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_3                 = 3, /* non-deterministic */
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD          = 4, /* not implemented */
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT_TILING        = 6,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_COUNT             = 7;

/** enum cudnnConvolutionBwdDataAlgo_t */
public static final int
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_0                 = 0, /* non-deterministic */
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_1                 = 1,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT               = 2,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT_TILING        = 3,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD          = 4,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_COUNT             = 6;

/** enum cudnnRNNAlgo_t */
public static final int
    CUDNN_RNN_ALGO_STANDARD               = 0,
    CUDNN_RNN_ALGO_PERSIST_STATIC         = 1,
    CUDNN_RNN_ALGO_PERSIST_DYNAMIC        = 2,
    CUDNN_RNN_ALGO_PERSIST_STATIC_SMALL_H = 3,
    CUDNN_RNN_ALGO_COUNT                  = 4;

/** enum cudnnCTCLossAlgo_t */
public static final int CUDNN_CTC_LOSS_ALGO_DETERMINISTIC = 0, CUDNN_CTC_LOSS_ALGO_NON_DETERMINISTIC = 1;
// Targeting ../cudnn/cudnnAlgorithm_t.java



public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateAlgorithmDescriptor(@ByPtrPtr cudnnAlgorithmStruct algoDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetAlgorithmDescriptor(cudnnAlgorithmStruct algoDesc, @ByVal cudnnAlgorithm_t algorithm);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetAlgorithmDescriptor(cudnnAlgorithmStruct algoDesc, cudnnAlgorithm_t algorithm);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCopyAlgorithmDescriptor(cudnnAlgorithmStruct src, cudnnAlgorithmStruct dest);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyAlgorithmDescriptor(cudnnAlgorithmStruct algoDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreateAlgorithmPerformance(@ByPtrPtr cudnnAlgorithmPerformanceStruct algoPerf, int numberToCreate);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetAlgorithmPerformance(cudnnAlgorithmPerformanceStruct algoPerf,
                             cudnnAlgorithmStruct algoDesc,
                             @Cast("cudnnStatus_t") int status,
                             float time,
                             @Cast("size_t") long memory);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetAlgorithmPerformance(cudnnAlgorithmPerformanceStruct algoPerf,
                             @ByPtrPtr cudnnAlgorithmStruct algoDesc,
                             @Cast("cudnnStatus_t*") IntPointer status,
                             FloatPointer time,
                             @Cast("size_t*") SizeTPointer memory);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetAlgorithmPerformance(cudnnAlgorithmPerformanceStruct algoPerf,
                             @ByPtrPtr cudnnAlgorithmStruct algoDesc,
                             @Cast("cudnnStatus_t*") IntBuffer status,
                             FloatBuffer time,
                             @Cast("size_t*") SizeTPointer memory);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetAlgorithmPerformance(cudnnAlgorithmPerformanceStruct algoPerf,
                             @ByPtrPtr cudnnAlgorithmStruct algoDesc,
                             @Cast("cudnnStatus_t*") int[] status,
                             float[] time,
                             @Cast("size_t*") SizeTPointer memory);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyAlgorithmPerformance(@ByPtrPtr cudnnAlgorithmPerformanceStruct algoPerf, int numberToDestroy);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetAlgorithmSpaceSize(cudnnContext handle, cudnnAlgorithmStruct algoDesc, @Cast("size_t*") SizeTPointer algoSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSaveAlgorithm(cudnnContext handle,
                   cudnnAlgorithmStruct algoDesc,
                   Pointer algoSpace,
                   @Cast("size_t") long algoSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRestoreAlgorithm(cudnnContext handle,
                      Pointer algoSpace,
                      @Cast("size_t") long algoSpaceSizeInBytes,
                      cudnnAlgorithmStruct algoDesc);

/** enum cudnnSeverity_t */
public static final int
    CUDNN_SEV_FATAL   = 0,
    CUDNN_SEV_ERROR   = 1,
    CUDNN_SEV_WARNING = 2,
    CUDNN_SEV_INFO    = 3;

/* Message masks to be used with cudnnSetCallback() */
public static final int CUDNN_SEV_ERROR_EN = (1 << CUDNN_SEV_ERROR);
public static final int CUDNN_SEV_WARNING_EN = (1 << CUDNN_SEV_WARNING);
public static final int CUDNN_SEV_INFO_EN = (1 << CUDNN_SEV_INFO);
// Targeting ../cudnn/cudnnDebug_t.java


// Targeting ../cudnn/cudnnCallback_t.java



public static native @Cast("cudnnStatus_t") int cudnnSetCallback(@Cast("unsigned") int mask, Pointer udata, cudnnCallback_t fptr);

public static native @Cast("cudnnStatus_t") int cudnnGetCallback(@Cast("unsigned*") IntPointer mask, @Cast("void**") PointerPointer udata, @ByPtrPtr cudnnCallback_t fptr);
public static native @Cast("cudnnStatus_t") int cudnnGetCallback(@Cast("unsigned*") IntPointer mask, @Cast("void**") @ByPtrPtr Pointer udata, @ByPtrPtr cudnnCallback_t fptr);
public static native @Cast("cudnnStatus_t") int cudnnGetCallback(@Cast("unsigned*") IntBuffer mask, @Cast("void**") @ByPtrPtr Pointer udata, @ByPtrPtr cudnnCallback_t fptr);
public static native @Cast("cudnnStatus_t") int cudnnGetCallback(@Cast("unsigned*") int[] mask, @Cast("void**") @ByPtrPtr Pointer udata, @ByPtrPtr cudnnCallback_t fptr);

/*
 * \brief Cross-library version checker.
 * This function is implemented differently in each sub-library. Each sublib
 * checks whether its own version matches that of its dependencies.
 * \returns CUDNN_STATUS_SUCCESS if the version check passes,
 *          CUDNN_STATUS_VERSION_MISMATCH if the versions are inconsistent.
 */
public static native @Cast("cudnnStatus_t") int cudnnOpsInferVersionCheck();

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_OPS_INFER_H_ */


// Parsed from <cudnn_ops_train.h>

/*
 * Copyright 1993-2020 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*
 *  cudnn_ops_train : cuDNN's basic training operations and algorithms.
 */

// #if !defined(CUDNN_OPS_TRAIN_H_)
// #define CUDNN_OPS_TRAIN_H_

// #include <cuda_runtime.h>
// #include <stdint.h>

// #include "cudnn_version.h"
// #include "cudnn_ops_infer.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_OPS_TRAIN_MAJOR = 8;
public static final int CUDNN_OPS_TRAIN_MINOR = 1;
public static final int CUDNN_OPS_TRAIN_PATCH = 1;

// #if (CUDNN_OPS_TRAIN_MAJOR != CUDNN_MAJOR) || (CUDNN_OPS_TRAIN_MINOR != CUDNN_MINOR) ||
//     (CUDNN_OPS_TRAIN_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN OPS TRAIN!!!
// #endif

// #if defined(__cplusplus)
// #endif

/* Function to perform backward softmax */
public static native @Cast("cudnnStatus_t") int cudnnSoftmaxBackward(cudnnContext handle,
                     @Cast("cudnnSoftmaxAlgorithm_t") int algo,
                     @Cast("cudnnSoftmaxMode_t") int mode,
                     @Const Pointer alpha,
                     cudnnTensorStruct yDesc,
                     @Const Pointer y,
                     cudnnTensorStruct dyDesc,
                     @Const Pointer dy,
                     @Const Pointer beta,
                     cudnnTensorStruct dxDesc,
                     Pointer dx);

/* Function to perform backward pooling */
public static native @Cast("cudnnStatus_t") int cudnnPoolingBackward(cudnnContext handle,
                     cudnnPoolingStruct poolingDesc,
                     @Const Pointer alpha,
                     cudnnTensorStruct yDesc,
                     @Const Pointer y,
                     cudnnTensorStruct dyDesc,
                     @Const Pointer dy,
                     cudnnTensorStruct xDesc,
                     @Const Pointer x,
                     @Const Pointer beta,
                     cudnnTensorStruct dxDesc,
                     Pointer dx);

/* Function to perform backward activation  */
public static native @Cast("cudnnStatus_t") int cudnnActivationBackward(cudnnContext handle,
                        cudnnActivationStruct activationDesc,
                        @Const Pointer alpha,
                        cudnnTensorStruct yDesc,
                        @Const Pointer y,
                        cudnnTensorStruct dyDesc,
                        @Const Pointer dy,
                        cudnnTensorStruct xDesc,
                        @Const Pointer x,
                        @Const Pointer beta,
                        cudnnTensorStruct dxDesc,
                        Pointer dx);

/* LRN cross-channel backward computation. Double parameters cast to tensor data type */
public static native @Cast("cudnnStatus_t") int cudnnLRNCrossChannelBackward(cudnnContext handle,
                             cudnnLRNStruct normDesc,
                             @Cast("cudnnLRNMode_t") int lrnMode,
                             @Const Pointer alpha,
                             cudnnTensorStruct yDesc,
                             @Const Pointer y,
                             cudnnTensorStruct dyDesc,
                             @Const Pointer dy,
                             cudnnTensorStruct xDesc,
                             @Const Pointer x,
                             @Const Pointer beta,
                             cudnnTensorStruct dxDesc,
                             Pointer dx);

public static native @Cast("cudnnStatus_t") int cudnnDivisiveNormalizationBackward(cudnnContext handle,
                                   cudnnLRNStruct normDesc,
                                   @Cast("cudnnDivNormMode_t") int mode,
                                   @Const Pointer alpha,
                                   cudnnTensorStruct xDesc,
                                   @Const Pointer x,
                                   @Const Pointer means,
                                   @Const Pointer dy,
                                   Pointer temp,
                                   Pointer temp2,
                                   @Const Pointer beta,
                                   cudnnTensorStruct dXdMeansDesc,
                                   Pointer dx,
                                   Pointer dMeans); /* output means differential, can be NULL */

public static native @Cast("cudnnStatus_t") int cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize(cudnnContext handle,
                                                         @Cast("cudnnBatchNormMode_t") int mode,
                                                         @Cast("cudnnBatchNormOps_t") int bnOps,
                                                         cudnnTensorStruct xDesc,
                                                         cudnnTensorStruct zDesc,
                                                         cudnnTensorStruct yDesc,
                                                         cudnnTensorStruct bnScaleBiasMeanVarDesc,
                                                         cudnnActivationStruct activationDesc,
                                                         @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnGetBatchNormalizationBackwardExWorkspaceSize(cudnnContext handle,
                                                  @Cast("cudnnBatchNormMode_t") int mode,
                                                  @Cast("cudnnBatchNormOps_t") int bnOps,
                                                  cudnnTensorStruct xDesc,
                                                  cudnnTensorStruct yDesc,
                                                  cudnnTensorStruct dyDesc,
                                                  cudnnTensorStruct dzDesc,
                                                  cudnnTensorStruct dxDesc,
                                                  cudnnTensorStruct dBnScaleBiasDesc,
                                                  cudnnActivationStruct activationDesc,
                                                  @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnGetBatchNormalizationTrainingExReserveSpaceSize(cudnnContext handle,
                                                     @Cast("cudnnBatchNormMode_t") int mode,
                                                     @Cast("cudnnBatchNormOps_t") int bnOps,
                                                     cudnnActivationStruct activationDesc,
                                                     cudnnTensorStruct xDesc,
                                                     @Cast("size_t*") SizeTPointer sizeInBytes);

/* Computes y = BN(x). Also accumulates moving averages of mean and inverse variances */
public static native @Cast("cudnnStatus_t") int cudnnBatchNormalizationForwardTraining(
    cudnnContext handle,
    @Cast("cudnnBatchNormMode_t") int mode,

    @Const Pointer alpha,
    @Const Pointer beta,

    cudnnTensorStruct xDesc,
    @Const Pointer x,
    cudnnTensorStruct yDesc,
    Pointer y,
    cudnnTensorStruct bnScaleBiasMeanVarDesc,
    @Const Pointer bnScale,
    @Const Pointer bnBias,
    double exponentialAverageFactor,
    Pointer resultRunningMean,
    Pointer resultRunningVariance,
    double epsilon,
    Pointer resultSaveMean,
    Pointer resultSaveInvVariance);

/* Computes y = relu(BN(x) + z). Also accumulates moving averages of mean and inverse variances */
public static native @Cast("cudnnStatus_t") int cudnnBatchNormalizationForwardTrainingEx(
    cudnnContext handle,
    @Cast("cudnnBatchNormMode_t") int mode,
    @Cast("cudnnBatchNormOps_t") int bnOps,

    @Const Pointer alpha,
    @Const Pointer beta,

    cudnnTensorStruct xDesc,
    @Const Pointer xData,
    cudnnTensorStruct zDesc,
    @Const Pointer zData,
    cudnnTensorStruct yDesc,
    Pointer yData,

    cudnnTensorStruct bnScaleBiasMeanVarDesc,
    @Const Pointer bnScale,
    @Const Pointer bnBias,

    double exponentialAverageFactor,
    Pointer resultRunningMean,
    Pointer resultRunningVariance,
    double epsilon,
    Pointer resultSaveMean,
    Pointer resultSaveInvVariance,

    cudnnActivationStruct activationDesc,
    Pointer workspace,
    @Cast("size_t") long workSpaceSizeInBytes,
    Pointer reserveSpace,
    @Cast("size_t") long reserveSpaceSizeInBytes);

/* Performs backward pass of Batch Normalization layer. Returns x gradient,
* bnScale gradient and bnBias gradient */
public static native @Cast("cudnnStatus_t") int cudnnBatchNormalizationBackward(cudnnContext handle,
                                @Cast("cudnnBatchNormMode_t") int mode,
                                @Const Pointer alphaDataDiff,
                                @Const Pointer betaDataDiff,
                                @Const Pointer alphaParamDiff,
                                @Const Pointer betaParamDiff,
                                cudnnTensorStruct xDesc,
                                @Const Pointer x,
                                cudnnTensorStruct dyDesc,
                                @Const Pointer dy,
                                cudnnTensorStruct dxDesc,
                                Pointer dx,
                                cudnnTensorStruct dBnScaleBiasDesc,
                                @Const Pointer bnScale,
                                Pointer dBnScaleResult,
                                Pointer dBnBiasResult,
                                double epsilon,
                                @Const Pointer savedMean,
                                @Const Pointer savedInvVariance);

public static native @Cast("cudnnStatus_t") int cudnnBatchNormalizationBackwardEx(cudnnContext handle,
                                  @Cast("cudnnBatchNormMode_t") int mode,
                                  @Cast("cudnnBatchNormOps_t") int bnOps,

                                  @Const Pointer alphaDataDiff,
                                  @Const Pointer betaDataDiff,
                                  @Const Pointer alphaParamDiff,
                                  @Const Pointer betaParamDiff,
                                  cudnnTensorStruct xDesc,
                                  @Const Pointer xData,
                                  cudnnTensorStruct yDesc,
                                  @Const Pointer yData,
                                  cudnnTensorStruct dyDesc,
                                  @Const Pointer dyData,
                                  cudnnTensorStruct dzDesc,
                                  Pointer dzData,
                                  cudnnTensorStruct dxDesc,
                                  Pointer dxData,
                                  cudnnTensorStruct dBnScaleBiasDesc,
                                  @Const Pointer bnScaleData,
                                  @Const Pointer bnBiasData,
                                  Pointer dBnScaleData,
                                  Pointer dBnBiasData,
                                  double epsilon,
                                  @Const Pointer savedMean,
                                  @Const Pointer savedInvVariance,
                                  cudnnActivationStruct activationDesc,
                                  Pointer workSpace,
                                  @Cast("size_t") long workSpaceSizeInBytes,
                                  Pointer reserveSpace,
                                  @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnGetNormalizationForwardTrainingWorkspaceSize(cudnnContext handle,
                                                  @Cast("cudnnNormMode_t") int mode,
                                                  @Cast("cudnnNormOps_t") int normOps,
                                                  @Cast("cudnnNormAlgo_t") int algo,
                                                  cudnnTensorStruct xDesc,
                                                  cudnnTensorStruct zDesc,
                                                  cudnnTensorStruct yDesc,
                                                  cudnnTensorStruct normScaleBiasDesc,
                                                  cudnnActivationStruct activationDesc,
                                                  cudnnTensorStruct normMeanVarDesc,
                                                  @Cast("size_t*") SizeTPointer sizeInBytes,
                                                  int groupCnt); /* Place hold for future work, should be set to 1 now*/

public static native @Cast("cudnnStatus_t") int cudnnGetNormalizationBackwardWorkspaceSize(cudnnContext handle,
                                           @Cast("cudnnNormMode_t") int mode,
                                           @Cast("cudnnNormOps_t") int normOps,
                                           @Cast("cudnnNormAlgo_t") int algo,
                                           cudnnTensorStruct xDesc,
                                           cudnnTensorStruct yDesc,
                                           cudnnTensorStruct dyDesc,
                                           cudnnTensorStruct dzDesc,
                                           cudnnTensorStruct dxDesc,
                                           cudnnTensorStruct dNormScaleBiasDesc,
                                           cudnnActivationStruct activationDesc,
                                           cudnnTensorStruct normMeanVarDesc,
                                           @Cast("size_t*") SizeTPointer sizeInBytes,
                                           int groupCnt); /* Place hold for future work, should be set to 1 now*/

public static native @Cast("cudnnStatus_t") int cudnnGetNormalizationTrainingReserveSpaceSize(cudnnContext handle,
                                              @Cast("cudnnNormMode_t") int mode,
                                              @Cast("cudnnNormOps_t") int normOps,
                                              @Cast("cudnnNormAlgo_t") int algo,
                                              cudnnActivationStruct activationDesc,
                                              cudnnTensorStruct xDesc,
                                              @Cast("size_t*") SizeTPointer sizeInBytes,
                                              int groupCnt); /* Place hold for future work, should be set to 1 now*/

/* Computes y = relu(Norm(x) + z). Also accumulates moving averages of mean and inverse variances */
public static native @Cast("cudnnStatus_t") int cudnnNormalizationForwardTraining(cudnnContext handle,
                                  @Cast("cudnnNormMode_t") int mode,
                                  @Cast("cudnnNormOps_t") int normOps,
                                  @Cast("cudnnNormAlgo_t") int algo,
                                  @Const Pointer alpha,
                                  @Const Pointer beta,
                                  cudnnTensorStruct xDesc,
                                  @Const Pointer xData,
                                  cudnnTensorStruct normScaleBiasDesc,
                                  @Const Pointer normScale,
                                  @Const Pointer normBias,
                                  double exponentialAverageFactor,
                                  cudnnTensorStruct normMeanVarDesc,
                                  Pointer resultRunningMean,
                                  Pointer resultRunningVariance,
                                  double epsilon,
                                  Pointer resultSaveMean,
                                  Pointer resultSaveInvVariance,
                                  cudnnActivationStruct activationDesc,
                                  cudnnTensorStruct zDesc,
                                  @Const Pointer zData,
                                  cudnnTensorStruct yDesc,
                                  Pointer yData,
                                  Pointer workspace,
                                  @Cast("size_t") long workSpaceSizeInBytes,
                                  Pointer reserveSpace,
                                  @Cast("size_t") long reserveSpaceSizeInBytes,
                                  int groupCnt); /* Place hold for future work, should be set to 1 now*/

public static native @Cast("cudnnStatus_t") int cudnnNormalizationBackward(cudnnContext handle,
                           @Cast("cudnnNormMode_t") int mode,
                           @Cast("cudnnNormOps_t") int normOps,
                           @Cast("cudnnNormAlgo_t") int algo,
                           @Const Pointer alphaDataDiff,
                           @Const Pointer betaDataDiff,
                           @Const Pointer alphaParamDiff,
                           @Const Pointer betaParamDiff,
                           cudnnTensorStruct xDesc,
                           @Const Pointer xData,
                           cudnnTensorStruct yDesc,
                           @Const Pointer yData,
                           cudnnTensorStruct dyDesc,
                           @Const Pointer dyData,
                           cudnnTensorStruct dzDesc,
                           Pointer dzData,
                           cudnnTensorStruct dxDesc,
                           Pointer dxData,
                           cudnnTensorStruct dNormScaleBiasDesc,
                           @Const Pointer normScaleData,
                           @Const Pointer normBiasData,
                           Pointer dNormScaleData,
                           Pointer dNormBiasData,
                           double epsilon,
                           cudnnTensorStruct normMeanVarDesc,
                           @Const Pointer savedMean,
                           @Const Pointer savedInvVariance,
                           cudnnActivationStruct activationDesc,
                           Pointer workSpace,
                           @Cast("size_t") long workSpaceSizeInBytes,
                           Pointer reserveSpace,
                           @Cast("size_t") long reserveSpaceSizeInBytes,
                           int groupCnt); /* Place hold for future work, should be set to 1 now*/

public static native @Cast("cudnnStatus_t") int cudnnSpatialTfGridGeneratorBackward(cudnnContext handle,
                                    cudnnSpatialTransformerStruct stDesc,
                                    @Const Pointer dgrid,
                                    Pointer dtheta);

public static native @Cast("cudnnStatus_t") int cudnnSpatialTfSamplerBackward(cudnnContext handle,
                              cudnnSpatialTransformerStruct stDesc,
                              @Const Pointer alpha,
                              cudnnTensorStruct xDesc,
                              @Const Pointer x,
                              @Const Pointer beta,
                              cudnnTensorStruct dxDesc,
                              Pointer dx,
                              @Const Pointer alphaDgrid,
                              cudnnTensorStruct dyDesc,
                              @Const Pointer dy,
                              @Const Pointer grid,
                              @Const Pointer betaDgrid,
                              Pointer dgrid);

public static native @Cast("cudnnStatus_t") int cudnnDropoutBackward(cudnnContext handle,
                     cudnnDropoutStruct dropoutDesc,
                     cudnnTensorStruct dydesc,
                     @Const Pointer dy,
                     cudnnTensorStruct dxdesc,
                     Pointer dx,
                     Pointer reserveSpace,
                     @Cast("size_t") long reserveSpaceSizeInBytes);

/*
 * \brief Cross-library version checker.
 * This function is implemented differently in each sub-library. Each sublib
 * checks whether its own version matches that of its dependencies.
 * \returns CUDNN_STATUS_SUCCESS if the version check passes,
 *          CUDNN_STATUS_VERSION_MISMATCH if the versions are inconsistent.
 */
public static native @Cast("cudnnStatus_t") int cudnnOpsTrainVersionCheck();

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_OPS_TRAIN_H_ */


// Parsed from <cudnn_adv_infer.h>

/*
 * Copyright 1993-2020 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*   cudnn_adv_infer : cuDNN's advanced and experimental features.

*/

// #if !defined(CUDNN_ADV_INFER_H_)
// #define CUDNN_ADV_INFER_H_

// #include <cuda_runtime.h>
// #include <stdint.h>

// #include "cudnn_version.h"
// #include "cudnn_ops_infer.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_ADV_INFER_MAJOR = 8;
public static final int CUDNN_ADV_INFER_MINOR = 1;
public static final int CUDNN_ADV_INFER_PATCH = 1;

// #if (CUDNN_ADV_INFER_MAJOR != CUDNN_MAJOR) || (CUDNN_ADV_INFER_MINOR != CUDNN_MINOR) ||
//     (CUDNN_ADV_INFER_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN ADV INFER!!!
// #endif

// #if defined(__cplusplus)
// #endif

/* BASIC RNN API */

/** enum cudnnForwardMode_t */
public static final int
    CUDNN_FWD_MODE_INFERENCE = 0,
    CUDNN_FWD_MODE_TRAINING  = 1;

/** enum cudnnRNNMode_t */
public static final int
    CUDNN_RNN_RELU = 0, /* basic RNN cell type with ReLu activation */
    CUDNN_RNN_TANH = 1, /* basic RNN cell type with tanh activation */
    CUDNN_LSTM     = 2, /* LSTM with optional recurrent projection and clipping */
    CUDNN_GRU      = 3; /* Using h' = tanh(r * Uh(t-1) + Wx) and h = (1 - z) * h' + z * h(t-1); */

/** enum cudnnRNNBiasMode_t */
public static final int
    CUDNN_RNN_NO_BIAS         = 0, /* rnn cell formulas do not use biases */
    CUDNN_RNN_SINGLE_INP_BIAS = 1, /* rnn cell formulas use one input bias in input GEMM */
    CUDNN_RNN_DOUBLE_BIAS     = 2, /* default, rnn cell formulas use two bias vectors */
    CUDNN_RNN_SINGLE_REC_BIAS = 3;  /* rnn cell formulas use one recurrent bias in recurrent GEMM */

/** enum cudnnDirectionMode_t */
public static final int
    CUDNN_UNIDIRECTIONAL = 0, /* single direction network */
    CUDNN_BIDIRECTIONAL  = 1; /* output concatination at each layer */

/** enum cudnnRNNInputMode_t */
public static final int
    CUDNN_LINEAR_INPUT = 0, /* adjustable weight matrix in first layer input GEMM */
    CUDNN_SKIP_INPUT   = 1; /* fixed identity matrix in the first layer input GEMM */

/** enum cudnnRNNClipMode_t */
public static final int
    CUDNN_RNN_CLIP_NONE   = 0, /* disables LSTM cell clipping */
    CUDNN_RNN_CLIP_MINMAX = 1; /* enables LSTM cell clipping */

/** enum cudnnRNNDataLayout_t */
public static final int
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_UNPACKED   = 0, /* padded, outer stride from one time-step to the next */
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_PACKED     = 1, /* sequence length sorted and packed as in basic RNN api */
    CUDNN_RNN_DATA_LAYOUT_BATCH_MAJOR_UNPACKED = 2; /* padded, outer stride from one batch to the next */

/* Legacy type for backward compatibility */

/* For auxFlags in cudnnSetRNNDescriptor_v8() and cudnnSetRNNPaddingMode() */
public static final int CUDNN_RNN_PADDED_IO_DISABLED = 0;
public static final int CUDNN_RNN_PADDED_IO_ENABLED = (1 << 0);
// Targeting ../cudnn/cudnnRNNStruct.java


// Targeting ../cudnn/cudnnPersistentRNNPlan.java


// Targeting ../cudnn/cudnnRNNDataStruct.java



public static native @Cast("cudnnStatus_t") int cudnnCreateRNNDescriptor(@ByPtrPtr cudnnRNNStruct rnnDesc);

public static native @Cast("cudnnStatus_t") int cudnnDestroyRNNDescriptor(cudnnRNNStruct rnnDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetRNNDescriptor_v8(cudnnRNNStruct rnnDesc,
                         @Cast("cudnnRNNAlgo_t") int algo,
                         @Cast("cudnnRNNMode_t") int cellMode,
                         @Cast("cudnnRNNBiasMode_t") int biasMode,
                         @Cast("cudnnDirectionMode_t") int dirMode,
                         @Cast("cudnnRNNInputMode_t") int inputMode,
                         @Cast("cudnnDataType_t") int dataType,
                         @Cast("cudnnDataType_t") int mathPrec,
                         @Cast("cudnnMathType_t") int mathType,
                         int inputSize,
                         int hiddenSize,
                         int projSize,
                         int numLayers,
                         cudnnDropoutStruct dropoutDesc,
                         @Cast("uint32_t") int auxFlags);

public static native @Cast("cudnnStatus_t") int cudnnGetRNNDescriptor_v8(cudnnRNNStruct rnnDesc,
                         @Cast("cudnnRNNAlgo_t*") IntPointer algo,
                         @Cast("cudnnRNNMode_t*") IntPointer cellMode,
                         @Cast("cudnnRNNBiasMode_t*") IntPointer biasMode,
                         @Cast("cudnnDirectionMode_t*") IntPointer dirMode,
                         @Cast("cudnnRNNInputMode_t*") IntPointer inputMode,
                         @Cast("cudnnDataType_t*") IntPointer dataType,
                         @Cast("cudnnDataType_t*") IntPointer mathPrec,
                         @Cast("cudnnMathType_t*") IntPointer mathType,
                         IntPointer inputSize,
                         IntPointer hiddenSize,
                         IntPointer projSize,
                         IntPointer numLayers,
                         @ByPtrPtr cudnnDropoutStruct dropoutDesc,
                         @Cast("uint32_t*") IntPointer auxFlags);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNDescriptor_v8(cudnnRNNStruct rnnDesc,
                         @Cast("cudnnRNNAlgo_t*") IntBuffer algo,
                         @Cast("cudnnRNNMode_t*") IntBuffer cellMode,
                         @Cast("cudnnRNNBiasMode_t*") IntBuffer biasMode,
                         @Cast("cudnnDirectionMode_t*") IntBuffer dirMode,
                         @Cast("cudnnRNNInputMode_t*") IntBuffer inputMode,
                         @Cast("cudnnDataType_t*") IntBuffer dataType,
                         @Cast("cudnnDataType_t*") IntBuffer mathPrec,
                         @Cast("cudnnMathType_t*") IntBuffer mathType,
                         IntBuffer inputSize,
                         IntBuffer hiddenSize,
                         IntBuffer projSize,
                         IntBuffer numLayers,
                         @ByPtrPtr cudnnDropoutStruct dropoutDesc,
                         @Cast("uint32_t*") IntBuffer auxFlags);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNDescriptor_v8(cudnnRNNStruct rnnDesc,
                         @Cast("cudnnRNNAlgo_t*") int[] algo,
                         @Cast("cudnnRNNMode_t*") int[] cellMode,
                         @Cast("cudnnRNNBiasMode_t*") int[] biasMode,
                         @Cast("cudnnDirectionMode_t*") int[] dirMode,
                         @Cast("cudnnRNNInputMode_t*") int[] inputMode,
                         @Cast("cudnnDataType_t*") int[] dataType,
                         @Cast("cudnnDataType_t*") int[] mathPrec,
                         @Cast("cudnnMathType_t*") int[] mathType,
                         int[] inputSize,
                         int[] hiddenSize,
                         int[] projSize,
                         int[] numLayers,
                         @ByPtrPtr cudnnDropoutStruct dropoutDesc,
                         @Cast("uint32_t*") int[] auxFlags);

/*
 * mathPrec in cudnnSetRNNDescriptor_v6() specifies compute precision
 * compute precision is further modified by cudnnSetRNNMatrixMathType()
 * dataType in cudnnGetRNNParamsSize() and wDesc specify weight storage
 * dropout is between RNN layers, not between recurrent steps
 */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetRNNDescriptor_v6(cudnnContext handle,
                         cudnnRNNStruct rnnDesc,
                         int hiddenSize,
                         int numLayers,
                         cudnnDropoutStruct dropoutDesc,
                         @Cast("cudnnRNNInputMode_t") int inputMode,
                         @Cast("cudnnDirectionMode_t") int direction,
                         @Cast("cudnnRNNMode_t") int cellMode,
                         @Cast("cudnnRNNAlgo_t") int algo,
                         @Cast("cudnnDataType_t") int mathPrec);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNDescriptor_v6(cudnnContext handle,
                         cudnnRNNStruct rnnDesc,
                         IntPointer hiddenSize,
                         IntPointer numLayers,
                         @ByPtrPtr cudnnDropoutStruct dropoutDesc,
                         @Cast("cudnnRNNInputMode_t*") IntPointer inputMode,
                         @Cast("cudnnDirectionMode_t*") IntPointer direction,
                         @Cast("cudnnRNNMode_t*") IntPointer cellMode,
                         @Cast("cudnnRNNAlgo_t*") IntPointer algo,
                         @Cast("cudnnDataType_t*") IntPointer mathPrec);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNDescriptor_v6(cudnnContext handle,
                         cudnnRNNStruct rnnDesc,
                         IntBuffer hiddenSize,
                         IntBuffer numLayers,
                         @ByPtrPtr cudnnDropoutStruct dropoutDesc,
                         @Cast("cudnnRNNInputMode_t*") IntBuffer inputMode,
                         @Cast("cudnnDirectionMode_t*") IntBuffer direction,
                         @Cast("cudnnRNNMode_t*") IntBuffer cellMode,
                         @Cast("cudnnRNNAlgo_t*") IntBuffer algo,
                         @Cast("cudnnDataType_t*") IntBuffer mathPrec);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNDescriptor_v6(cudnnContext handle,
                         cudnnRNNStruct rnnDesc,
                         int[] hiddenSize,
                         int[] numLayers,
                         @ByPtrPtr cudnnDropoutStruct dropoutDesc,
                         @Cast("cudnnRNNInputMode_t*") int[] inputMode,
                         @Cast("cudnnDirectionMode_t*") int[] direction,
                         @Cast("cudnnRNNMode_t*") int[] cellMode,
                         @Cast("cudnnRNNAlgo_t*") int[] algo,
                         @Cast("cudnnDataType_t*") int[] mathPrec);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetRNNMatrixMathType(cudnnRNNStruct rnnDesc, @Cast("cudnnMathType_t") int mType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNMatrixMathType(cudnnRNNStruct rnnDesc, @Cast("cudnnMathType_t*") IntPointer mType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNMatrixMathType(cudnnRNNStruct rnnDesc, @Cast("cudnnMathType_t*") IntBuffer mType);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNMatrixMathType(cudnnRNNStruct rnnDesc, @Cast("cudnnMathType_t*") int[] mType);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetRNNBiasMode(cudnnRNNStruct rnnDesc, @Cast("cudnnRNNBiasMode_t") int biasMode);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNBiasMode(cudnnRNNStruct rnnDesc, @Cast("cudnnRNNBiasMode_t*") IntPointer biasMode);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNBiasMode(cudnnRNNStruct rnnDesc, @Cast("cudnnRNNBiasMode_t*") IntBuffer biasMode);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNBiasMode(cudnnRNNStruct rnnDesc, @Cast("cudnnRNNBiasMode_t*") int[] biasMode);

public static native @Cast("cudnnStatus_t") int cudnnRNNSetClip_v8(cudnnRNNStruct rnnDesc,
                   @Cast("cudnnRNNClipMode_t") int clipMode,
                   @Cast("cudnnNanPropagation_t") int clipNanOpt,
                   double lclip,
                   double rclip);

public static native @Cast("cudnnStatus_t") int cudnnRNNGetClip_v8(cudnnRNNStruct rnnDesc,
                   @Cast("cudnnRNNClipMode_t*") IntPointer clipMode,
                   @Cast("cudnnNanPropagation_t*") IntPointer clipNanOpt,
                   DoublePointer lclip,
                   DoublePointer rclip);
public static native @Cast("cudnnStatus_t") int cudnnRNNGetClip_v8(cudnnRNNStruct rnnDesc,
                   @Cast("cudnnRNNClipMode_t*") IntBuffer clipMode,
                   @Cast("cudnnNanPropagation_t*") IntBuffer clipNanOpt,
                   DoubleBuffer lclip,
                   DoubleBuffer rclip);
public static native @Cast("cudnnStatus_t") int cudnnRNNGetClip_v8(cudnnRNNStruct rnnDesc,
                   @Cast("cudnnRNNClipMode_t*") int[] clipMode,
                   @Cast("cudnnNanPropagation_t*") int[] clipNanOpt,
                   double[] lclip,
                   double[] rclip);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNSetClip(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnRNNClipMode_t") int clipMode,
                @Cast("cudnnNanPropagation_t") int clipNanOpt,
                double lclip,
                double rclip);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNGetClip(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnRNNClipMode_t*") IntPointer clipMode,
                @Cast("cudnnNanPropagation_t*") IntPointer clipNanOpt,
                DoublePointer lclip,
                DoublePointer rclip);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNGetClip(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnRNNClipMode_t*") IntBuffer clipMode,
                @Cast("cudnnNanPropagation_t*") IntBuffer clipNanOpt,
                DoubleBuffer lclip,
                DoubleBuffer rclip);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNGetClip(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnRNNClipMode_t*") int[] clipMode,
                @Cast("cudnnNanPropagation_t*") int[] clipNanOpt,
                double[] lclip,
                double[] rclip);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetRNNProjectionLayers(cudnnContext handle,
                            cudnnRNNStruct rnnDesc,
                            int recProjSize,
                            int outProjSize);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNProjectionLayers(cudnnContext handle,
                            cudnnRNNStruct rnnDesc,
                            IntPointer recProjSize,
                            IntPointer outProjSize);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNProjectionLayers(cudnnContext handle,
                            cudnnRNNStruct rnnDesc,
                            IntBuffer recProjSize,
                            IntBuffer outProjSize);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNProjectionLayers(cudnnContext handle,
                            cudnnRNNStruct rnnDesc,
                            int[] recProjSize,
                            int[] outProjSize);

/* Expensive. Creates the plan for the specific settings. */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnCreatePersistentRNNPlan(cudnnRNNStruct rnnDesc,
                             int minibatch,
                             @Cast("const cudnnDataType_t") int dataType,
                             @ByPtrPtr cudnnPersistentRNNPlan plan);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnDestroyPersistentRNNPlan(cudnnPersistentRNNPlan plan);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetPersistentRNNPlan(cudnnRNNStruct rnnDesc, cudnnPersistentRNNPlan plan);

public static native @Cast("cudnnStatus_t") int cudnnBuildRNNDynamic(cudnnContext handle, cudnnRNNStruct rnnDesc, int miniBatch);

/* dataType in weight descriptors and input descriptors is used to describe storage */
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNWorkspaceSize(cudnnContext handle,
                         cudnnRNNStruct rnnDesc,
                         int seqLength,
                         @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                         @Cast("size_t*") SizeTPointer sizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNWorkspaceSize(cudnnContext handle,
                         cudnnRNNStruct rnnDesc,
                         int seqLength,
                         @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                         @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNTrainingReserveSize(cudnnContext handle,
                               cudnnRNNStruct rnnDesc,
                               int seqLength,
                               @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                               @Cast("size_t*") SizeTPointer sizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNTrainingReserveSize(cudnnContext handle,
                               cudnnRNNStruct rnnDesc,
                               int seqLength,
                               @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                               @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnGetRNNTempSpaceSizes(cudnnContext handle,
                          cudnnRNNStruct rnnDesc,
                          @Cast("cudnnForwardMode_t") int fMode,
                          cudnnRNNDataStruct xDesc,
                          @Cast("size_t*") SizeTPointer workSpaceSize,
                          @Cast("size_t*") SizeTPointer reserveSpaceSize);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNParamsSize(cudnnContext handle,
                      cudnnRNNStruct rnnDesc,
                      cudnnTensorStruct xDesc,
                      @Cast("size_t*") SizeTPointer sizeInBytes,
                      @Cast("cudnnDataType_t") int dataType);

public static native @Cast("cudnnStatus_t") int cudnnGetRNNWeightSpaceSize(cudnnContext handle, cudnnRNNStruct rnnDesc, @Cast("size_t*") SizeTPointer weightSpaceSize);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNLinLayerMatrixParams(cudnnContext handle,
                                cudnnRNNStruct rnnDesc,
                                int pseudoLayer,
                                cudnnTensorStruct xDesc,
                                cudnnFilterStruct wDesc,
                                @Const Pointer w,
                                int linLayerID,
                                cudnnFilterStruct linLayerMatDesc,
                                @Cast("void**") PointerPointer linLayerMat);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNLinLayerMatrixParams(cudnnContext handle,
                                cudnnRNNStruct rnnDesc,
                                int pseudoLayer,
                                cudnnTensorStruct xDesc,
                                cudnnFilterStruct wDesc,
                                @Const Pointer w,
                                int linLayerID,
                                cudnnFilterStruct linLayerMatDesc,
                                @Cast("void**") @ByPtrPtr Pointer linLayerMat);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNLinLayerBiasParams(cudnnContext handle,
                              cudnnRNNStruct rnnDesc,
                              int pseudoLayer,
                              cudnnTensorStruct xDesc,
                              cudnnFilterStruct wDesc,
                              @Const Pointer w,
                              int linLayerID,
                              cudnnFilterStruct linLayerBiasDesc,
                              @Cast("void**") PointerPointer linLayerBias);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNLinLayerBiasParams(cudnnContext handle,
                              cudnnRNNStruct rnnDesc,
                              int pseudoLayer,
                              cudnnTensorStruct xDesc,
                              cudnnFilterStruct wDesc,
                              @Const Pointer w,
                              int linLayerID,
                              cudnnFilterStruct linLayerBiasDesc,
                              @Cast("void**") @ByPtrPtr Pointer linLayerBias);

public static native @Cast("cudnnStatus_t") int cudnnGetRNNWeightParams(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        int pseudoLayer,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        int linLayerID,
                        cudnnTensorStruct mDesc,
                        @Cast("void**") PointerPointer mAddr,
                        cudnnTensorStruct bDesc,
                        @Cast("void**") PointerPointer bAddr);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNWeightParams(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        int pseudoLayer,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        int linLayerID,
                        cudnnTensorStruct mDesc,
                        @Cast("void**") @ByPtrPtr Pointer mAddr,
                        cudnnTensorStruct bDesc,
                        @Cast("void**") @ByPtrPtr Pointer bAddr);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNForwardInference(cudnnContext handle,
                         cudnnRNNStruct rnnDesc,
                         int seqLength,
                         @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                         @Const Pointer x,
                         cudnnTensorStruct hxDesc,
                         @Const Pointer hx,
                         cudnnTensorStruct cxDesc,
                         @Const Pointer cx,
                         cudnnFilterStruct wDesc,
                         @Const Pointer w,
                         @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                         Pointer y,
                         cudnnTensorStruct hyDesc,
                         Pointer hy,
                         cudnnTensorStruct cyDesc,
                         Pointer cy,
                         Pointer workSpace,
                         @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNForwardInference(cudnnContext handle,
                         cudnnRNNStruct rnnDesc,
                         int seqLength,
                         @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                         @Const Pointer x,
                         cudnnTensorStruct hxDesc,
                         @Const Pointer hx,
                         cudnnTensorStruct cxDesc,
                         @Const Pointer cx,
                         cudnnFilterStruct wDesc,
                         @Const Pointer w,
                         @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                         Pointer y,
                         cudnnTensorStruct hyDesc,
                         Pointer hy,
                         cudnnTensorStruct cyDesc,
                         Pointer cy,
                         Pointer workSpace,
                         @Cast("size_t") long workSpaceSizeInBytes);

/* RNN EX API */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetRNNPaddingMode(cudnnRNNStruct rnnDesc, @Cast("unsigned") int paddingMode);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNPaddingMode(cudnnRNNStruct rnnDesc, @Cast("unsigned*") IntPointer paddingMode);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNPaddingMode(cudnnRNNStruct rnnDesc, @Cast("unsigned*") IntBuffer paddingMode);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNPaddingMode(cudnnRNNStruct rnnDesc, @Cast("unsigned*") int[] paddingMode);

public static native @Cast("cudnnStatus_t") int cudnnCreateRNNDataDescriptor(@ByPtrPtr cudnnRNNDataStruct rnnDataDesc);

public static native @Cast("cudnnStatus_t") int cudnnDestroyRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          @Cast("cudnnRNNDataLayout_t") int layout,
                          int maxSeqLength,
                          int batchSize,
                          int vectorSize,
                          @Const IntPointer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnSetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          @Cast("cudnnRNNDataLayout_t") int layout,
                          int maxSeqLength,
                          int batchSize,
                          int vectorSize,
                          @Const IntBuffer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnSetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          @Cast("cudnnRNNDataLayout_t") int layout,
                          int maxSeqLength,
                          int batchSize,
                          int vectorSize,
                          @Const int[] seqLengthArray,
                          Pointer paddingFill);         /* symbol for filling padding position in output */

public static native @Cast("cudnnStatus_t") int cudnnGetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t*") IntPointer dataType,
                          @Cast("cudnnRNNDataLayout_t*") IntPointer layout,
                          IntPointer maxSeqLength,
                          IntPointer batchSize,
                          IntPointer vectorSize,
                          int arrayLengthRequested,
                          IntPointer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t*") IntBuffer dataType,
                          @Cast("cudnnRNNDataLayout_t*") IntBuffer layout,
                          IntBuffer maxSeqLength,
                          IntBuffer batchSize,
                          IntBuffer vectorSize,
                          int arrayLengthRequested,
                          IntBuffer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnGetRNNDataDescriptor(cudnnRNNDataStruct rnnDataDesc,
                          @Cast("cudnnDataType_t*") int[] dataType,
                          @Cast("cudnnRNNDataLayout_t*") int[] layout,
                          int[] maxSeqLength,
                          int[] batchSize,
                          int[] vectorSize,
                          int arrayLengthRequested,
                          int[] seqLengthArray,
                          Pointer paddingFill);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNForwardInferenceEx(cudnnContext handle,
                           cudnnRNNStruct rnnDesc,
                           cudnnRNNDataStruct xDesc,
                           @Const Pointer x,
                           cudnnTensorStruct hxDesc,
                           @Const Pointer hx,
                           cudnnTensorStruct cxDesc,
                           @Const Pointer cx,
                           cudnnFilterStruct wDesc,
                           @Const Pointer w,
                           cudnnRNNDataStruct yDesc,
                           Pointer y,
                           cudnnTensorStruct hyDesc,
                           Pointer hy,
                           cudnnTensorStruct cyDesc,
                           Pointer cy,
                           cudnnRNNDataStruct kDesc,
                           @Const Pointer keys,
                           cudnnRNNDataStruct cDesc,
                           Pointer cAttn,
                           cudnnRNNDataStruct iDesc,
                           Pointer iAttn,
                           cudnnRNNDataStruct qDesc,
                           Pointer queries,
                           Pointer workSpace,
                           @Cast("size_t") long workSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnRNNForward(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnForwardMode_t") int fwdMode,
                @Const IntPointer devSeqLengths,
                cudnnRNNDataStruct xDesc,
                @Const Pointer x,
                cudnnRNNDataStruct yDesc,
                Pointer y,
                cudnnTensorStruct hDesc,
                @Const Pointer hx,
                Pointer hy,
                cudnnTensorStruct cDesc,
                @Const Pointer cx,
                Pointer cy,
                @Cast("size_t") long weightSpaceSize,
                @Const Pointer weightSpace,
                @Cast("size_t") long workSpaceSize,
                Pointer workSpace,
                @Cast("size_t") long reserveSpaceSize,
                Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNForward(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnForwardMode_t") int fwdMode,
                @Const IntBuffer devSeqLengths,
                cudnnRNNDataStruct xDesc,
                @Const Pointer x,
                cudnnRNNDataStruct yDesc,
                Pointer y,
                cudnnTensorStruct hDesc,
                @Const Pointer hx,
                Pointer hy,
                cudnnTensorStruct cDesc,
                @Const Pointer cx,
                Pointer cy,
                @Cast("size_t") long weightSpaceSize,
                @Const Pointer weightSpace,
                @Cast("size_t") long workSpaceSize,
                Pointer workSpace,
                @Cast("size_t") long reserveSpaceSize,
                Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNForward(cudnnContext handle,
                cudnnRNNStruct rnnDesc,
                @Cast("cudnnForwardMode_t") int fwdMode,
                @Const int[] devSeqLengths,
                cudnnRNNDataStruct xDesc,
                @Const Pointer x,
                cudnnRNNDataStruct yDesc,
                Pointer y,
                cudnnTensorStruct hDesc,
                @Const Pointer hx,
                Pointer hy,
                cudnnTensorStruct cDesc,
                @Const Pointer cx,
                Pointer cy,
                @Cast("size_t") long weightSpaceSize,
                @Const Pointer weightSpace,
                @Cast("size_t") long workSpaceSize,
                Pointer workSpace,
                @Cast("size_t") long reserveSpaceSize,
                Pointer reserveSpace);

/* RNN FIND API */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnSetRNNAlgorithmDescriptor(cudnnContext handle, cudnnRNNStruct rnnDesc, cudnnAlgorithmStruct algoDesc);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNForwardInferenceAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, IntPointer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNForwardInferenceAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, IntBuffer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNForwardInferenceAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, int[] count);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardInferenceAlgorithmEx(cudnnContext handle,
                                        cudnnRNNStruct rnnDesc,
                                        int seqLength,
                                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                                        @Const Pointer x,
                                        cudnnTensorStruct hxDesc,
                                        @Const Pointer hx,
                                        cudnnTensorStruct cxDesc,
                                        @Const Pointer cx,
                                        cudnnFilterStruct wDesc,
                                        @Const Pointer w,
                                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                        Pointer y,
                                        cudnnTensorStruct hyDesc,
                                        Pointer hy,
                                        cudnnTensorStruct cyDesc,
                                        Pointer cy,
                                        float findIntensity,
                                        int requestedAlgoCount,
                                        IntPointer returnedAlgoCount,
                                        @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                        Pointer workspace,
                                        @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardInferenceAlgorithmEx(cudnnContext handle,
                                        cudnnRNNStruct rnnDesc,
                                        int seqLength,
                                        @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                                        @Const Pointer x,
                                        cudnnTensorStruct hxDesc,
                                        @Const Pointer hx,
                                        cudnnTensorStruct cxDesc,
                                        @Const Pointer cx,
                                        cudnnFilterStruct wDesc,
                                        @Const Pointer w,
                                        @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                        Pointer y,
                                        cudnnTensorStruct hyDesc,
                                        Pointer hy,
                                        cudnnTensorStruct cyDesc,
                                        Pointer cy,
                                        float findIntensity,
                                        int requestedAlgoCount,
                                        IntBuffer returnedAlgoCount,
                                        @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                        Pointer workspace,
                                        @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardInferenceAlgorithmEx(cudnnContext handle,
                                        cudnnRNNStruct rnnDesc,
                                        int seqLength,
                                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                                        @Const Pointer x,
                                        cudnnTensorStruct hxDesc,
                                        @Const Pointer hx,
                                        cudnnTensorStruct cxDesc,
                                        @Const Pointer cx,
                                        cudnnFilterStruct wDesc,
                                        @Const Pointer w,
                                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                        Pointer y,
                                        cudnnTensorStruct hyDesc,
                                        Pointer hy,
                                        cudnnTensorStruct cyDesc,
                                        Pointer cy,
                                        float findIntensity,
                                        int requestedAlgoCount,
                                        int[] returnedAlgoCount,
                                        @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                        Pointer workspace,
                                        @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardInferenceAlgorithmEx(cudnnContext handle,
                                        cudnnRNNStruct rnnDesc,
                                        int seqLength,
                                        @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                                        @Const Pointer x,
                                        cudnnTensorStruct hxDesc,
                                        @Const Pointer hx,
                                        cudnnTensorStruct cxDesc,
                                        @Const Pointer cx,
                                        cudnnFilterStruct wDesc,
                                        @Const Pointer w,
                                        @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                        Pointer y,
                                        cudnnTensorStruct hyDesc,
                                        Pointer hy,
                                        cudnnTensorStruct cyDesc,
                                        Pointer cy,
                                        float findIntensity,
                                        int requestedAlgoCount,
                                        IntPointer returnedAlgoCount,
                                        @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                        Pointer workspace,
                                        @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardInferenceAlgorithmEx(cudnnContext handle,
                                        cudnnRNNStruct rnnDesc,
                                        int seqLength,
                                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                                        @Const Pointer x,
                                        cudnnTensorStruct hxDesc,
                                        @Const Pointer hx,
                                        cudnnTensorStruct cxDesc,
                                        @Const Pointer cx,
                                        cudnnFilterStruct wDesc,
                                        @Const Pointer w,
                                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                        Pointer y,
                                        cudnnTensorStruct hyDesc,
                                        Pointer hy,
                                        cudnnTensorStruct cyDesc,
                                        Pointer cy,
                                        float findIntensity,
                                        int requestedAlgoCount,
                                        IntBuffer returnedAlgoCount,
                                        @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                        Pointer workspace,
                                        @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardInferenceAlgorithmEx(cudnnContext handle,
                                        cudnnRNNStruct rnnDesc,
                                        int seqLength,
                                        @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                                        @Const Pointer x,
                                        cudnnTensorStruct hxDesc,
                                        @Const Pointer hx,
                                        cudnnTensorStruct cxDesc,
                                        @Const Pointer cx,
                                        cudnnFilterStruct wDesc,
                                        @Const Pointer w,
                                        @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                        Pointer y,
                                        cudnnTensorStruct hyDesc,
                                        Pointer hy,
                                        cudnnTensorStruct cyDesc,
                                        Pointer cy,
                                        float findIntensity,
                                        int requestedAlgoCount,
                                        int[] returnedAlgoCount,
                                        @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                        Pointer workspace,
                                        @Cast("size_t") long workSpaceSizeInBytes);

/* Sequence data descriptor */

/** enum cudnnSeqDataAxis_t */
public static final int
    CUDNN_SEQDATA_TIME_DIM  = 0, /* index in time */
    CUDNN_SEQDATA_BATCH_DIM = 1, /* index in batch */
    CUDNN_SEQDATA_BEAM_DIM  = 2, /* index in beam */
    CUDNN_SEQDATA_VECT_DIM  = 3;  /* index in vector */
// Targeting ../cudnn/cudnnSeqDataStruct.java



public static final int CUDNN_SEQDATA_DIM_COUNT = 4; /* dimension count */

public static native @Cast("cudnnStatus_t") int cudnnCreateSeqDataDescriptor(@ByPtrPtr cudnnSeqDataStruct seqDataDesc);

public static native @Cast("cudnnStatus_t") int cudnnDestroySeqDataDescriptor(cudnnSeqDataStruct seqDataDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          int nbDims,
                          @Const IntPointer dimA,
                          @Cast("const cudnnSeqDataAxis_t*") IntPointer axes,
                          @Cast("size_t") long seqLengthArraySize,
                          @Const IntPointer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnSetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          int nbDims,
                          @Const IntBuffer dimA,
                          @Cast("const cudnnSeqDataAxis_t*") IntBuffer axes,
                          @Cast("size_t") long seqLengthArraySize,
                          @Const IntBuffer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnSetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t") int dataType,
                          int nbDims,
                          @Const int[] dimA,
                          @Cast("const cudnnSeqDataAxis_t*") int[] axes,
                          @Cast("size_t") long seqLengthArraySize,
                          @Const int[] seqLengthArray,
                          Pointer paddingFill);

public static native @Cast("cudnnStatus_t") int cudnnGetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t*") IntPointer dataType,
                          IntPointer nbDims,
                          int nbDimsRequested,
                          IntPointer dimA,
                          @Cast("cudnnSeqDataAxis_t*") IntPointer axes,
                          @Cast("size_t*") SizeTPointer seqLengthArraySize,
                          @Cast("size_t") long seqLengthSizeRequested,
                          IntPointer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnGetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t*") IntBuffer dataType,
                          IntBuffer nbDims,
                          int nbDimsRequested,
                          IntBuffer dimA,
                          @Cast("cudnnSeqDataAxis_t*") IntBuffer axes,
                          @Cast("size_t*") SizeTPointer seqLengthArraySize,
                          @Cast("size_t") long seqLengthSizeRequested,
                          IntBuffer seqLengthArray,
                          Pointer paddingFill);
public static native @Cast("cudnnStatus_t") int cudnnGetSeqDataDescriptor(cudnnSeqDataStruct seqDataDesc,
                          @Cast("cudnnDataType_t*") int[] dataType,
                          int[] nbDims,
                          int nbDimsRequested,
                          int[] dimA,
                          @Cast("cudnnSeqDataAxis_t*") int[] axes,
                          @Cast("size_t*") SizeTPointer seqLengthArraySize,
                          @Cast("size_t") long seqLengthSizeRequested,
                          int[] seqLengthArray,
                          Pointer paddingFill);

/* Multihead Attention */

/* Legacy type for backward compatibility */

/*
 * Multi-head attention options passed via 'attnMode' in cudnnSetAttnDescriptor().
 * Use the bitwise OR operator to combine several settings listed below.  Additional
 * minor options can be added here w/o changing or introducing new API functions.
 */
public static final int CUDNN_ATTN_QUERYMAP_ALL_TO_ONE = 0;         /* multiple Q-s map to a single (K,V) set when beam size > 1 */
public static final int CUDNN_ATTN_QUERYMAP_ONE_TO_ONE = (1 << 0); /* multiple Q-s map to multiple (K,V) sets when beam size > 1 */
public static final int CUDNN_ATTN_DISABLE_PROJ_BIASES = 0;         /* no biases in attention input and output projections */
public static final int CUDNN_ATTN_ENABLE_PROJ_BIASES = (1 << 1);
// Targeting ../cudnn/cudnnAttnStruct.java



public static native @Cast("cudnnStatus_t") int cudnnCreateAttnDescriptor(@ByPtrPtr cudnnAttnStruct attnDesc);

public static native @Cast("cudnnStatus_t") int cudnnDestroyAttnDescriptor(cudnnAttnStruct attnDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetAttnDescriptor(cudnnAttnStruct attnDesc,
                       @Cast("unsigned") int attnMode,
                       int nHeads,
                       double smScaler,
                       @Cast("cudnnDataType_t") int dataType,
                       @Cast("cudnnDataType_t") int computePrec,
                       @Cast("cudnnMathType_t") int mathType,
                       cudnnDropoutStruct attnDropoutDesc,
                       cudnnDropoutStruct postDropoutDesc,
                       int qSize,
                       int kSize,
                       int vSize,
                       int qProjSize,
                       int kProjSize,
                       int vProjSize,
                       int oProjSize,
                       int qoMaxSeqLength,
                       int kvMaxSeqLength,
                       int maxBatchSize,
                       int maxBeamSize);

public static native @Cast("cudnnStatus_t") int cudnnGetAttnDescriptor(cudnnAttnStruct attnDesc,
                       @Cast("unsigned*") IntPointer attnMode,
                       IntPointer nHeads,
                       DoublePointer smScaler,
                       @Cast("cudnnDataType_t*") IntPointer dataType,
                       @Cast("cudnnDataType_t*") IntPointer computePrec,
                       @Cast("cudnnMathType_t*") IntPointer mathType,
                       @ByPtrPtr cudnnDropoutStruct attnDropoutDesc,
                       @ByPtrPtr cudnnDropoutStruct postDropoutDesc,
                       IntPointer qSize,
                       IntPointer kSize,
                       IntPointer vSize,
                       IntPointer qProjSize,
                       IntPointer kProjSize,
                       IntPointer vProjSize,
                       IntPointer oProjSize,
                       IntPointer qoMaxSeqLength,
                       IntPointer kvMaxSeqLength,
                       IntPointer maxBatchSize,
                       IntPointer maxBeamSize);
public static native @Cast("cudnnStatus_t") int cudnnGetAttnDescriptor(cudnnAttnStruct attnDesc,
                       @Cast("unsigned*") IntBuffer attnMode,
                       IntBuffer nHeads,
                       DoubleBuffer smScaler,
                       @Cast("cudnnDataType_t*") IntBuffer dataType,
                       @Cast("cudnnDataType_t*") IntBuffer computePrec,
                       @Cast("cudnnMathType_t*") IntBuffer mathType,
                       @ByPtrPtr cudnnDropoutStruct attnDropoutDesc,
                       @ByPtrPtr cudnnDropoutStruct postDropoutDesc,
                       IntBuffer qSize,
                       IntBuffer kSize,
                       IntBuffer vSize,
                       IntBuffer qProjSize,
                       IntBuffer kProjSize,
                       IntBuffer vProjSize,
                       IntBuffer oProjSize,
                       IntBuffer qoMaxSeqLength,
                       IntBuffer kvMaxSeqLength,
                       IntBuffer maxBatchSize,
                       IntBuffer maxBeamSize);
public static native @Cast("cudnnStatus_t") int cudnnGetAttnDescriptor(cudnnAttnStruct attnDesc,
                       @Cast("unsigned*") int[] attnMode,
                       int[] nHeads,
                       double[] smScaler,
                       @Cast("cudnnDataType_t*") int[] dataType,
                       @Cast("cudnnDataType_t*") int[] computePrec,
                       @Cast("cudnnMathType_t*") int[] mathType,
                       @ByPtrPtr cudnnDropoutStruct attnDropoutDesc,
                       @ByPtrPtr cudnnDropoutStruct postDropoutDesc,
                       int[] qSize,
                       int[] kSize,
                       int[] vSize,
                       int[] qProjSize,
                       int[] kProjSize,
                       int[] vProjSize,
                       int[] oProjSize,
                       int[] qoMaxSeqLength,
                       int[] kvMaxSeqLength,
                       int[] maxBatchSize,
                       int[] maxBeamSize);

public static native @Cast("cudnnStatus_t") int cudnnGetMultiHeadAttnBuffers(cudnnContext handle,
                             cudnnAttnStruct attnDesc,
                             @Cast("size_t*") SizeTPointer weightSizeInBytes,
                             @Cast("size_t*") SizeTPointer workSpaceSizeInBytes,
                             @Cast("size_t*") SizeTPointer reserveSpaceSizeInBytes);

/** enum cudnnMultiHeadAttnWeightKind_t */
public static final int
    CUDNN_MH_ATTN_Q_WEIGHTS = 0, /* input projection weights for 'queries' */
    CUDNN_MH_ATTN_K_WEIGHTS = 1, /* input projection weights for 'keys' */
    CUDNN_MH_ATTN_V_WEIGHTS = 2, /* input projection weights for 'values' */
    CUDNN_MH_ATTN_O_WEIGHTS = 3, /* output projection weights */
    CUDNN_MH_ATTN_Q_BIASES  = 4, /* input projection bias tensor for 'queries' */
    CUDNN_MH_ATTN_K_BIASES  = 5, /* input projection bias for 'keys' */
    CUDNN_MH_ATTN_V_BIASES  = 6, /* input projection bias for 'values' */
    CUDNN_MH_ATTN_O_BIASES  = 7; /* output projection biases */

public static final int CUDNN_ATTN_WKIND_COUNT = 8; /* Number of attention weight/bias tensors */

public static native @Cast("cudnnStatus_t") int cudnnGetMultiHeadAttnWeights(cudnnContext handle,
                             cudnnAttnStruct attnDesc,
                             @Cast("cudnnMultiHeadAttnWeightKind_t") int wKind,
                             @Cast("size_t") long weightSizeInBytes,
                             @Const Pointer weights,
                             cudnnTensorStruct wDesc,
                             @Cast("void**") PointerPointer wAddr);
public static native @Cast("cudnnStatus_t") int cudnnGetMultiHeadAttnWeights(cudnnContext handle,
                             cudnnAttnStruct attnDesc,
                             @Cast("cudnnMultiHeadAttnWeightKind_t") int wKind,
                             @Cast("size_t") long weightSizeInBytes,
                             @Const Pointer weights,
                             cudnnTensorStruct wDesc,
                             @Cast("void**") @ByPtrPtr Pointer wAddr);

public static native @Cast("cudnnStatus_t") int cudnnMultiHeadAttnForward(cudnnContext handle,
                          cudnnAttnStruct attnDesc,
                          int currIdx,
                          @Const IntPointer loWinIdx,
                          @Const IntPointer hiWinIdx,
                          @Const IntPointer devSeqLengthsQO,
                          @Const IntPointer devSeqLengthsKV,
                          cudnnSeqDataStruct qDesc,
                          @Const Pointer queries,
                          @Const Pointer residuals,
                          cudnnSeqDataStruct kDesc,
                          @Const Pointer keys,
                          cudnnSeqDataStruct vDesc,
                          @Const Pointer values,
                          cudnnSeqDataStruct oDesc,
                          Pointer out,
                          @Cast("size_t") long weightSizeInBytes,
                          @Const Pointer weights,
                          @Cast("size_t") long workSpaceSizeInBytes,
                          Pointer workSpace,
                          @Cast("size_t") long reserveSpaceSizeInBytes,
                          Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnMultiHeadAttnForward(cudnnContext handle,
                          cudnnAttnStruct attnDesc,
                          int currIdx,
                          @Const IntBuffer loWinIdx,
                          @Const IntBuffer hiWinIdx,
                          @Const IntBuffer devSeqLengthsQO,
                          @Const IntBuffer devSeqLengthsKV,
                          cudnnSeqDataStruct qDesc,
                          @Const Pointer queries,
                          @Const Pointer residuals,
                          cudnnSeqDataStruct kDesc,
                          @Const Pointer keys,
                          cudnnSeqDataStruct vDesc,
                          @Const Pointer values,
                          cudnnSeqDataStruct oDesc,
                          Pointer out,
                          @Cast("size_t") long weightSizeInBytes,
                          @Const Pointer weights,
                          @Cast("size_t") long workSpaceSizeInBytes,
                          Pointer workSpace,
                          @Cast("size_t") long reserveSpaceSizeInBytes,
                          Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnMultiHeadAttnForward(cudnnContext handle,
                          cudnnAttnStruct attnDesc,
                          int currIdx,
                          @Const int[] loWinIdx,
                          @Const int[] hiWinIdx,
                          @Const int[] devSeqLengthsQO,
                          @Const int[] devSeqLengthsKV,
                          cudnnSeqDataStruct qDesc,
                          @Const Pointer queries,
                          @Const Pointer residuals,
                          cudnnSeqDataStruct kDesc,
                          @Const Pointer keys,
                          cudnnSeqDataStruct vDesc,
                          @Const Pointer values,
                          cudnnSeqDataStruct oDesc,
                          Pointer out,
                          @Cast("size_t") long weightSizeInBytes,
                          @Const Pointer weights,
                          @Cast("size_t") long workSpaceSizeInBytes,
                          Pointer workSpace,
                          @Cast("size_t") long reserveSpaceSizeInBytes,
                          Pointer reserveSpace);

/*
 * \brief Cross-library version checker.
 * This function is implemented differently in each sub-library. Each sublib
 * checks whether its own version matches that of its dependencies.
 * \returns CUDNN_STATUS_SUCCESS if the version check passes,
 *          CUDNN_STATUS_VERSION_MISMATCH if the versions are inconsistent.
 */
public static native @Cast("cudnnStatus_t") int cudnnAdvInferVersionCheck();

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_ADV_INFER_H_ */


// Parsed from <cudnn_adv_train.h>

/*
 * Copyright 1993-2020 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*   cudnn_adv_train : cuDNN's advanced and experimental features.

*/

// #if !defined(CUDNN_ADV_TRAIN_H_)
// #define CUDNN_ADV_TRAIN_H_

// #include <cuda_runtime.h>
// #include <stdint.h>

// #include "cudnn_version.h"
// #include "cudnn_ops_infer.h"
// #include "cudnn_ops_train.h"
// #include "cudnn_adv_infer.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_ADV_TRAIN_MAJOR = 8;
public static final int CUDNN_ADV_TRAIN_MINOR = 1;
public static final int CUDNN_ADV_TRAIN_PATCH = 1;

// #if (CUDNN_ADV_TRAIN_MAJOR != CUDNN_MAJOR) || (CUDNN_ADV_TRAIN_MINOR != CUDNN_MINOR) ||
//     (CUDNN_ADV_TRAIN_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN ADV TRAIN!!!
// #endif

// #if defined(__cplusplus)
// #endif

/** enum cudnnWgradMode_t */
public static final int
    CUDNN_WGRAD_MODE_ADD = 0, /* add partial gradients to wgrad output buffers */
    CUDNN_WGRAD_MODE_SET = 1; /* write partial gradients to wgrad output buffers */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNForwardTraining(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        int seqLength,
                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                        @Const Pointer x,
                        cudnnTensorStruct hxDesc,
                        @Const Pointer hx,
                        cudnnTensorStruct cxDesc,
                        @Const Pointer cx,
                        cudnnFilterStruct wDesc,
                        @Const Pointer w,
                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                        Pointer y,
                        cudnnTensorStruct hyDesc,
                        Pointer hy,
                        cudnnTensorStruct cyDesc,
                        Pointer cy,
                        Pointer workSpace,
                        @Cast("size_t") long workSpaceSizeInBytes,
                        Pointer reserveSpace,
                        @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNForwardTraining(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        int seqLength,
                        @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                        @Const Pointer x,
                        cudnnTensorStruct hxDesc,
                        @Const Pointer hx,
                        cudnnTensorStruct cxDesc,
                        @Const Pointer cx,
                        cudnnFilterStruct wDesc,
                        @Const Pointer w,
                        @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                        Pointer y,
                        cudnnTensorStruct hyDesc,
                        Pointer hy,
                        cudnnTensorStruct cyDesc,
                        Pointer cy,
                        Pointer workSpace,
                        @Cast("size_t") long workSpaceSizeInBytes,
                        Pointer reserveSpace,
                        @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNBackwardData(cudnnContext handle,
                     cudnnRNNStruct rnnDesc,
                     int seqLength,
                     @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                     @Const Pointer y,
                     @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct dyDesc,
                     @Const Pointer dy,
                     cudnnTensorStruct dhyDesc,
                     @Const Pointer dhy,
                     cudnnTensorStruct dcyDesc,
                     @Const Pointer dcy,
                     cudnnFilterStruct wDesc,
                     @Const Pointer w,
                     cudnnTensorStruct hxDesc,
                     @Const Pointer hx,
                     cudnnTensorStruct cxDesc,
                     @Const Pointer cx,
                     @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct dxDesc,
                     Pointer dx,
                     cudnnTensorStruct dhxDesc,
                     Pointer dhx,
                     cudnnTensorStruct dcxDesc,
                     Pointer dcx,
                     Pointer workSpace,
                     @Cast("size_t") long workSpaceSizeInBytes,
                     Pointer reserveSpace,
                     @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNBackwardData(cudnnContext handle,
                     cudnnRNNStruct rnnDesc,
                     int seqLength,
                     @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                     @Const Pointer y,
                     @Cast("cudnnTensorStruct**") PointerPointer dyDesc,
                     @Const Pointer dy,
                     cudnnTensorStruct dhyDesc,
                     @Const Pointer dhy,
                     cudnnTensorStruct dcyDesc,
                     @Const Pointer dcy,
                     cudnnFilterStruct wDesc,
                     @Const Pointer w,
                     cudnnTensorStruct hxDesc,
                     @Const Pointer hx,
                     cudnnTensorStruct cxDesc,
                     @Const Pointer cx,
                     @Cast("cudnnTensorStruct**") PointerPointer dxDesc,
                     Pointer dx,
                     cudnnTensorStruct dhxDesc,
                     Pointer dhx,
                     cudnnTensorStruct dcxDesc,
                     Pointer dcx,
                     Pointer workSpace,
                     @Cast("size_t") long workSpaceSizeInBytes,
                     Pointer reserveSpace,
                     @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardData_v8(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        @Const IntPointer devSeqLengths,
                        cudnnRNNDataStruct yDesc,
                        @Const Pointer y,
                        @Const Pointer dy,
                        cudnnRNNDataStruct xDesc,
                        Pointer dx,
                        cudnnTensorStruct hDesc,
                        @Const Pointer hx,
                        @Const Pointer dhy,
                        Pointer dhx,
                        cudnnTensorStruct cDesc,
                        @Const Pointer cx,
                        @Const Pointer dcy,
                        Pointer dcx,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        @Cast("size_t") long workSpaceSize,
                        Pointer workSpace,
                        @Cast("size_t") long reserveSpaceSize,
                        Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardData_v8(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        @Const IntBuffer devSeqLengths,
                        cudnnRNNDataStruct yDesc,
                        @Const Pointer y,
                        @Const Pointer dy,
                        cudnnRNNDataStruct xDesc,
                        Pointer dx,
                        cudnnTensorStruct hDesc,
                        @Const Pointer hx,
                        @Const Pointer dhy,
                        Pointer dhx,
                        cudnnTensorStruct cDesc,
                        @Const Pointer cx,
                        @Const Pointer dcy,
                        Pointer dcx,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        @Cast("size_t") long workSpaceSize,
                        Pointer workSpace,
                        @Cast("size_t") long reserveSpaceSize,
                        Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardData_v8(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        @Const int[] devSeqLengths,
                        cudnnRNNDataStruct yDesc,
                        @Const Pointer y,
                        @Const Pointer dy,
                        cudnnRNNDataStruct xDesc,
                        Pointer dx,
                        cudnnTensorStruct hDesc,
                        @Const Pointer hx,
                        @Const Pointer dhy,
                        Pointer dhx,
                        cudnnTensorStruct cDesc,
                        @Const Pointer cx,
                        @Const Pointer dcy,
                        Pointer dcx,
                        @Cast("size_t") long weightSpaceSize,
                        @Const Pointer weightSpace,
                        @Cast("size_t") long workSpaceSize,
                        Pointer workSpace,
                        @Cast("size_t") long reserveSpaceSize,
                        Pointer reserveSpace);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNBackwardWeights(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        int seqLength,
                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                        @Const Pointer x,
                        cudnnTensorStruct hxDesc,
                        @Const Pointer hx,
                        @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                        @Const Pointer y,
                        @Const Pointer workSpace,
                        @Cast("size_t") long workSpaceSizeInBytes,
                        cudnnFilterStruct dwDesc,
                        Pointer dw,
                        @Const Pointer reserveSpace,
                        @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNBackwardWeights(cudnnContext handle,
                        cudnnRNNStruct rnnDesc,
                        int seqLength,
                        @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                        @Const Pointer x,
                        cudnnTensorStruct hxDesc,
                        @Const Pointer hx,
                        @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                        @Const Pointer y,
                        @Const Pointer workSpace,
                        @Cast("size_t") long workSpaceSizeInBytes,
                        cudnnFilterStruct dwDesc,
                        Pointer dw,
                        @Const Pointer reserveSpace,
                        @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardWeights_v8(cudnnContext handle,
                           cudnnRNNStruct rnnDesc,
                           @Cast("cudnnWgradMode_t") int addGrad,
                           @Const IntPointer devSeqLengths,
                           cudnnRNNDataStruct xDesc,
                           @Const Pointer x,
                           cudnnTensorStruct hDesc,
                           @Const Pointer hx,
                           cudnnRNNDataStruct yDesc,
                           @Const Pointer y,
                           @Cast("size_t") long weightSpaceSize,
                           Pointer dweightSpace,
                           @Cast("size_t") long workSpaceSize,
                           Pointer workSpace,
                           @Cast("size_t") long reserveSpaceSize,
                           Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardWeights_v8(cudnnContext handle,
                           cudnnRNNStruct rnnDesc,
                           @Cast("cudnnWgradMode_t") int addGrad,
                           @Const IntBuffer devSeqLengths,
                           cudnnRNNDataStruct xDesc,
                           @Const Pointer x,
                           cudnnTensorStruct hDesc,
                           @Const Pointer hx,
                           cudnnRNNDataStruct yDesc,
                           @Const Pointer y,
                           @Cast("size_t") long weightSpaceSize,
                           Pointer dweightSpace,
                           @Cast("size_t") long workSpaceSize,
                           Pointer workSpace,
                           @Cast("size_t") long reserveSpaceSize,
                           Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnRNNBackwardWeights_v8(cudnnContext handle,
                           cudnnRNNStruct rnnDesc,
                           @Cast("cudnnWgradMode_t") int addGrad,
                           @Const int[] devSeqLengths,
                           cudnnRNNDataStruct xDesc,
                           @Const Pointer x,
                           cudnnTensorStruct hDesc,
                           @Const Pointer hx,
                           cudnnRNNDataStruct yDesc,
                           @Const Pointer y,
                           @Cast("size_t") long weightSpaceSize,
                           Pointer dweightSpace,
                           @Cast("size_t") long workSpaceSize,
                           Pointer workSpace,
                           @Cast("size_t") long reserveSpaceSize,
                           Pointer reserveSpace);

/* RNN EX API */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNForwardTrainingEx(cudnnContext handle,
                          cudnnRNNStruct rnnDesc,
                          cudnnRNNDataStruct xDesc,
                          @Const Pointer x,
                          cudnnTensorStruct hxDesc,
                          @Const Pointer hx,
                          cudnnTensorStruct cxDesc,
                          @Const Pointer cx,
                          cudnnFilterStruct wDesc,
                          @Const Pointer w,
                          cudnnRNNDataStruct yDesc,
                          Pointer y,
                          cudnnTensorStruct hyDesc,
                          Pointer hy,
                          cudnnTensorStruct cyDesc,
                          Pointer cy,
                          cudnnRNNDataStruct kDesc,
                          @Const Pointer keys,
                          cudnnRNNDataStruct cDesc,
                          Pointer cAttn,
                          cudnnRNNDataStruct iDesc,
                          Pointer iAttn,
                          cudnnRNNDataStruct qDesc,
                          Pointer queries,
                          Pointer workSpace,
                          @Cast("size_t") long workSpaceSizeInBytes,
                          Pointer reserveSpace,
                          @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNBackwardDataEx(cudnnContext handle,
                       cudnnRNNStruct rnnDesc,
                       cudnnRNNDataStruct yDesc,
                       @Const Pointer y,
                       cudnnRNNDataStruct dyDesc,
                       @Const Pointer dy,
                       cudnnRNNDataStruct dcDesc,
                       @Const Pointer dcAttn,
                       cudnnTensorStruct dhyDesc,
                       @Const Pointer dhy,
                       cudnnTensorStruct dcyDesc,
                       @Const Pointer dcy,
                       cudnnFilterStruct wDesc,
                       @Const Pointer w,
                       cudnnTensorStruct hxDesc,
                       @Const Pointer hx,
                       cudnnTensorStruct cxDesc,
                       @Const Pointer cx,
                       cudnnRNNDataStruct dxDesc,
                       Pointer dx,
                       cudnnTensorStruct dhxDesc,
                       Pointer dhx,
                       cudnnTensorStruct dcxDesc,
                       Pointer dcx,
                       cudnnRNNDataStruct dkDesc,
                       Pointer dkeys,
                       Pointer workSpace,
                       @Cast("size_t") long workSpaceSizeInBytes,
                       Pointer reserveSpace,
                       @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnRNNBackwardWeightsEx(cudnnContext handle,
                          cudnnRNNStruct rnnDesc,
                          cudnnRNNDataStruct xDesc,
                          @Const Pointer x,
                          cudnnTensorStruct hxDesc,
                          @Const Pointer hx,
                          cudnnRNNDataStruct yDesc,
                          @Const Pointer y,
                          Pointer workSpace,
                          @Cast("size_t") long workSpaceSizeInBytes,
                          cudnnFilterStruct dwDesc,
                          Pointer dw,
                          Pointer reserveSpace,
                          @Cast("size_t") long reserveSpaceSizeInBytes);

/* RNN FIND API */

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNForwardTrainingAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, IntPointer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNForwardTrainingAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, IntBuffer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNForwardTrainingAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, int[] count);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardTrainingAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       cudnnTensorStruct cxDesc,
                                       @Const Pointer cx,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                       Pointer y,
                                       cudnnTensorStruct hyDesc,
                                       Pointer hy,
                                       cudnnTensorStruct cyDesc,
                                       Pointer cy,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       IntPointer returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardTrainingAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       cudnnTensorStruct cxDesc,
                                       @Const Pointer cx,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                       Pointer y,
                                       cudnnTensorStruct hyDesc,
                                       Pointer hy,
                                       cudnnTensorStruct cyDesc,
                                       Pointer cy,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       IntBuffer returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardTrainingAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       cudnnTensorStruct cxDesc,
                                       @Const Pointer cx,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                       Pointer y,
                                       cudnnTensorStruct hyDesc,
                                       Pointer hy,
                                       cudnnTensorStruct cyDesc,
                                       Pointer cy,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       int[] returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardTrainingAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       cudnnTensorStruct cxDesc,
                                       @Const Pointer cx,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                       Pointer y,
                                       cudnnTensorStruct hyDesc,
                                       Pointer hy,
                                       cudnnTensorStruct cyDesc,
                                       Pointer cy,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       IntPointer returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardTrainingAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       cudnnTensorStruct cxDesc,
                                       @Const Pointer cx,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                       Pointer y,
                                       cudnnTensorStruct hyDesc,
                                       Pointer hy,
                                       cudnnTensorStruct cyDesc,
                                       Pointer cy,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       IntBuffer returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNForwardTrainingAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       cudnnTensorStruct cxDesc,
                                       @Const Pointer cx,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                       Pointer y,
                                       cudnnTensorStruct hyDesc,
                                       Pointer hy,
                                       cudnnTensorStruct cyDesc,
                                       Pointer cy,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       int[] returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNBackwardDataAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, IntPointer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNBackwardDataAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, IntBuffer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNBackwardDataAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, int[] count);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardDataAlgorithmEx(cudnnContext handle,
                                    cudnnRNNStruct rnnDesc,
                                    int seqLength,
                                    @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                    @Const Pointer y,
                                    @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct dyDesc,
                                    @Const Pointer dy,
                                    cudnnTensorStruct dhyDesc,
                                    @Const Pointer dhy,
                                    cudnnTensorStruct dcyDesc,
                                    @Const Pointer dcy,
                                    cudnnFilterStruct wDesc,
                                    @Const Pointer w,
                                    cudnnTensorStruct hxDesc,
                                    @Const Pointer hx,
                                    cudnnTensorStruct cxDesc,
                                    @Const Pointer cx,
                                    @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct dxDesc,
                                    Pointer dx,
                                    cudnnTensorStruct dhxDesc,
                                    Pointer dhx,
                                    cudnnTensorStruct dcxDesc,
                                    Pointer dcx,
                                    float findIntensity,
                                    int requestedAlgoCount,
                                    IntPointer returnedAlgoCount,
                                    @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                    Pointer workspace,
                                    @Cast("size_t") long workSpaceSizeInBytes,
                                    Pointer reserveSpace,
                                    @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardDataAlgorithmEx(cudnnContext handle,
                                    cudnnRNNStruct rnnDesc,
                                    int seqLength,
                                    @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                    @Const Pointer y,
                                    @Cast("cudnnTensorStruct**") PointerPointer dyDesc,
                                    @Const Pointer dy,
                                    cudnnTensorStruct dhyDesc,
                                    @Const Pointer dhy,
                                    cudnnTensorStruct dcyDesc,
                                    @Const Pointer dcy,
                                    cudnnFilterStruct wDesc,
                                    @Const Pointer w,
                                    cudnnTensorStruct hxDesc,
                                    @Const Pointer hx,
                                    cudnnTensorStruct cxDesc,
                                    @Const Pointer cx,
                                    @Cast("cudnnTensorStruct**") PointerPointer dxDesc,
                                    Pointer dx,
                                    cudnnTensorStruct dhxDesc,
                                    Pointer dhx,
                                    cudnnTensorStruct dcxDesc,
                                    Pointer dcx,
                                    float findIntensity,
                                    int requestedAlgoCount,
                                    IntBuffer returnedAlgoCount,
                                    @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                    Pointer workspace,
                                    @Cast("size_t") long workSpaceSizeInBytes,
                                    Pointer reserveSpace,
                                    @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardDataAlgorithmEx(cudnnContext handle,
                                    cudnnRNNStruct rnnDesc,
                                    int seqLength,
                                    @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                    @Const Pointer y,
                                    @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct dyDesc,
                                    @Const Pointer dy,
                                    cudnnTensorStruct dhyDesc,
                                    @Const Pointer dhy,
                                    cudnnTensorStruct dcyDesc,
                                    @Const Pointer dcy,
                                    cudnnFilterStruct wDesc,
                                    @Const Pointer w,
                                    cudnnTensorStruct hxDesc,
                                    @Const Pointer hx,
                                    cudnnTensorStruct cxDesc,
                                    @Const Pointer cx,
                                    @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct dxDesc,
                                    Pointer dx,
                                    cudnnTensorStruct dhxDesc,
                                    Pointer dhx,
                                    cudnnTensorStruct dcxDesc,
                                    Pointer dcx,
                                    float findIntensity,
                                    int requestedAlgoCount,
                                    int[] returnedAlgoCount,
                                    @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                    Pointer workspace,
                                    @Cast("size_t") long workSpaceSizeInBytes,
                                    Pointer reserveSpace,
                                    @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardDataAlgorithmEx(cudnnContext handle,
                                    cudnnRNNStruct rnnDesc,
                                    int seqLength,
                                    @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                    @Const Pointer y,
                                    @Cast("cudnnTensorStruct**") PointerPointer dyDesc,
                                    @Const Pointer dy,
                                    cudnnTensorStruct dhyDesc,
                                    @Const Pointer dhy,
                                    cudnnTensorStruct dcyDesc,
                                    @Const Pointer dcy,
                                    cudnnFilterStruct wDesc,
                                    @Const Pointer w,
                                    cudnnTensorStruct hxDesc,
                                    @Const Pointer hx,
                                    cudnnTensorStruct cxDesc,
                                    @Const Pointer cx,
                                    @Cast("cudnnTensorStruct**") PointerPointer dxDesc,
                                    Pointer dx,
                                    cudnnTensorStruct dhxDesc,
                                    Pointer dhx,
                                    cudnnTensorStruct dcxDesc,
                                    Pointer dcx,
                                    float findIntensity,
                                    int requestedAlgoCount,
                                    IntPointer returnedAlgoCount,
                                    @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                    Pointer workspace,
                                    @Cast("size_t") long workSpaceSizeInBytes,
                                    Pointer reserveSpace,
                                    @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardDataAlgorithmEx(cudnnContext handle,
                                    cudnnRNNStruct rnnDesc,
                                    int seqLength,
                                    @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                    @Const Pointer y,
                                    @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct dyDesc,
                                    @Const Pointer dy,
                                    cudnnTensorStruct dhyDesc,
                                    @Const Pointer dhy,
                                    cudnnTensorStruct dcyDesc,
                                    @Const Pointer dcy,
                                    cudnnFilterStruct wDesc,
                                    @Const Pointer w,
                                    cudnnTensorStruct hxDesc,
                                    @Const Pointer hx,
                                    cudnnTensorStruct cxDesc,
                                    @Const Pointer cx,
                                    @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct dxDesc,
                                    Pointer dx,
                                    cudnnTensorStruct dhxDesc,
                                    Pointer dhx,
                                    cudnnTensorStruct dcxDesc,
                                    Pointer dcx,
                                    float findIntensity,
                                    int requestedAlgoCount,
                                    IntBuffer returnedAlgoCount,
                                    @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                    Pointer workspace,
                                    @Cast("size_t") long workSpaceSizeInBytes,
                                    Pointer reserveSpace,
                                    @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardDataAlgorithmEx(cudnnContext handle,
                                    cudnnRNNStruct rnnDesc,
                                    int seqLength,
                                    @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                    @Const Pointer y,
                                    @Cast("cudnnTensorStruct**") PointerPointer dyDesc,
                                    @Const Pointer dy,
                                    cudnnTensorStruct dhyDesc,
                                    @Const Pointer dhy,
                                    cudnnTensorStruct dcyDesc,
                                    @Const Pointer dcy,
                                    cudnnFilterStruct wDesc,
                                    @Const Pointer w,
                                    cudnnTensorStruct hxDesc,
                                    @Const Pointer hx,
                                    cudnnTensorStruct cxDesc,
                                    @Const Pointer cx,
                                    @Cast("cudnnTensorStruct**") PointerPointer dxDesc,
                                    Pointer dx,
                                    cudnnTensorStruct dhxDesc,
                                    Pointer dhx,
                                    cudnnTensorStruct dcxDesc,
                                    Pointer dcx,
                                    float findIntensity,
                                    int requestedAlgoCount,
                                    int[] returnedAlgoCount,
                                    @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                    Pointer workspace,
                                    @Cast("size_t") long workSpaceSizeInBytes,
                                    Pointer reserveSpace,
                                    @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNBackwardWeightsAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, IntPointer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNBackwardWeightsAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, IntBuffer count);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnGetRNNBackwardWeightsAlgorithmMaxCount(cudnnContext handle, cudnnRNNStruct rnnDesc, int[] count);

public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardWeightsAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                       @Const Pointer y,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       IntPointer returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       @Const Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       cudnnFilterStruct dwDesc,
                                       Pointer dw,
                                       @Const Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardWeightsAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                       @Const Pointer y,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       IntBuffer returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       @Const Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       cudnnFilterStruct dwDesc,
                                       Pointer dw,
                                       @Const Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardWeightsAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                       @Const Pointer y,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       int[] returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       @Const Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       cudnnFilterStruct dwDesc,
                                       Pointer dw,
                                       @Const Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardWeightsAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                       @Const Pointer y,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       IntPointer returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       @Const Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       cudnnFilterStruct dwDesc,
                                       Pointer dw,
                                       @Const Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardWeightsAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       @Cast("cudnnTensorStruct**") @ByPtrPtr cudnnTensorStruct yDesc,
                                       @Const Pointer y,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       IntBuffer returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       @Const Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       cudnnFilterStruct dwDesc,
                                       Pointer dw,
                                       @Const Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") @Deprecated int cudnnFindRNNBackwardWeightsAlgorithmEx(cudnnContext handle,
                                       cudnnRNNStruct rnnDesc,
                                       int seqLength,
                                       @Cast("cudnnTensorStruct**") PointerPointer xDesc,
                                       @Const Pointer x,
                                       cudnnTensorStruct hxDesc,
                                       @Const Pointer hx,
                                       @Cast("cudnnTensorStruct**") PointerPointer yDesc,
                                       @Const Pointer y,
                                       float findIntensity,
                                       int requestedAlgoCount,
                                       int[] returnedAlgoCount,
                                       @ByPtrPtr cudnnAlgorithmPerformanceStruct perfResults,
                                       @Const Pointer workspace,
                                       @Cast("size_t") long workSpaceSizeInBytes,
                                       cudnnFilterStruct dwDesc,
                                       Pointer dw,
                                       @Const Pointer reserveSpace,
                                       @Cast("size_t") long reserveSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnMultiHeadAttnBackwardData(cudnnContext handle,
                               cudnnAttnStruct attnDesc,
                               @Const IntPointer loWinIdx,
                               @Const IntPointer hiWinIdx,
                               @Const IntPointer devSeqLengthsDQDO,
                               @Const IntPointer devSeqLengthsDKDV,
                               cudnnSeqDataStruct doDesc,
                               @Const Pointer dout,
                               cudnnSeqDataStruct dqDesc,
                               Pointer dqueries,
                               @Const Pointer queries,
                               cudnnSeqDataStruct dkDesc,
                               Pointer dkeys,
                               @Const Pointer keys,
                               cudnnSeqDataStruct dvDesc,
                               Pointer dvalues,
                               @Const Pointer values,
                               @Cast("size_t") long weightSizeInBytes,
                               @Const Pointer weights,
                               @Cast("size_t") long workSpaceSizeInBytes,
                               Pointer workSpace,
                               @Cast("size_t") long reserveSpaceSizeInBytes,
                               Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnMultiHeadAttnBackwardData(cudnnContext handle,
                               cudnnAttnStruct attnDesc,
                               @Const IntBuffer loWinIdx,
                               @Const IntBuffer hiWinIdx,
                               @Const IntBuffer devSeqLengthsDQDO,
                               @Const IntBuffer devSeqLengthsDKDV,
                               cudnnSeqDataStruct doDesc,
                               @Const Pointer dout,
                               cudnnSeqDataStruct dqDesc,
                               Pointer dqueries,
                               @Const Pointer queries,
                               cudnnSeqDataStruct dkDesc,
                               Pointer dkeys,
                               @Const Pointer keys,
                               cudnnSeqDataStruct dvDesc,
                               Pointer dvalues,
                               @Const Pointer values,
                               @Cast("size_t") long weightSizeInBytes,
                               @Const Pointer weights,
                               @Cast("size_t") long workSpaceSizeInBytes,
                               Pointer workSpace,
                               @Cast("size_t") long reserveSpaceSizeInBytes,
                               Pointer reserveSpace);
public static native @Cast("cudnnStatus_t") int cudnnMultiHeadAttnBackwardData(cudnnContext handle,
                               cudnnAttnStruct attnDesc,
                               @Const int[] loWinIdx,
                               @Const int[] hiWinIdx,
                               @Const int[] devSeqLengthsDQDO,
                               @Const int[] devSeqLengthsDKDV,
                               cudnnSeqDataStruct doDesc,
                               @Const Pointer dout,
                               cudnnSeqDataStruct dqDesc,
                               Pointer dqueries,
                               @Const Pointer queries,
                               cudnnSeqDataStruct dkDesc,
                               Pointer dkeys,
                               @Const Pointer keys,
                               cudnnSeqDataStruct dvDesc,
                               Pointer dvalues,
                               @Const Pointer values,
                               @Cast("size_t") long weightSizeInBytes,
                               @Const Pointer weights,
                               @Cast("size_t") long workSpaceSizeInBytes,
                               Pointer workSpace,
                               @Cast("size_t") long reserveSpaceSizeInBytes,
                               Pointer reserveSpace);

public static native @Cast("cudnnStatus_t") int cudnnMultiHeadAttnBackwardWeights(cudnnContext handle,
                                  cudnnAttnStruct attnDesc,
                                  @Cast("cudnnWgradMode_t") int addGrad,
                                  cudnnSeqDataStruct qDesc,
                                  @Const Pointer queries,
                                  cudnnSeqDataStruct kDesc,
                                  @Const Pointer keys,
                                  cudnnSeqDataStruct vDesc,
                                  @Const Pointer values,
                                  cudnnSeqDataStruct doDesc,
                                  @Const Pointer dout,
                                  @Cast("size_t") long weightSizeInBytes,
                                  @Const Pointer weights,
                                  Pointer dweights,
                                  @Cast("size_t") long workSpaceSizeInBytes,
                                  Pointer workSpace,
                                  @Cast("size_t") long reserveSpaceSizeInBytes,
                                  Pointer reserveSpace);

/*
* CTC (Connectionist Temporal Classification) loss descriptor create/destory/set/get functions
*/
/* Input normalization mode for loss function */
/** enum cudnnLossNormalizationMode_t */
public static final int
    CUDNN_LOSS_NORMALIZATION_NONE    = 0,
    CUDNN_LOSS_NORMALIZATION_SOFTMAX = 1;

public static native @Cast("cudnnStatus_t") int cudnnCreateCTCLossDescriptor(@ByPtrPtr cudnnCTCLossStruct ctcLossDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc, @Cast("cudnnDataType_t") int compType);

public static native @Cast("cudnnStatus_t") int cudnnSetCTCLossDescriptorEx(cudnnCTCLossStruct ctcLossDesc,
                            @Cast("cudnnDataType_t") int compType,
                            @Cast("cudnnLossNormalizationMode_t") int normMode,
                            @Cast("cudnnNanPropagation_t") int gradMode);

public static native @Cast("cudnnStatus_t") int cudnnSetCTCLossDescriptor_v8(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t") int compType,
                             @Cast("cudnnLossNormalizationMode_t") int normMode,
                             @Cast("cudnnNanPropagation_t") int gradMode,
                             int maxLabelLength);

public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc, @Cast("cudnnDataType_t*") IntPointer compType);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc, @Cast("cudnnDataType_t*") IntBuffer compType);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc, @Cast("cudnnDataType_t*") int[] compType);

public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptorEx(cudnnCTCLossStruct ctcLossDesc,
                            @Cast("cudnnDataType_t*") IntPointer compType,
                            @Cast("cudnnLossNormalizationMode_t*") IntPointer normMode,
                            @Cast("cudnnNanPropagation_t*") IntPointer gradMode);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptorEx(cudnnCTCLossStruct ctcLossDesc,
                            @Cast("cudnnDataType_t*") IntBuffer compType,
                            @Cast("cudnnLossNormalizationMode_t*") IntBuffer normMode,
                            @Cast("cudnnNanPropagation_t*") IntBuffer gradMode);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptorEx(cudnnCTCLossStruct ctcLossDesc,
                            @Cast("cudnnDataType_t*") int[] compType,
                            @Cast("cudnnLossNormalizationMode_t*") int[] normMode,
                            @Cast("cudnnNanPropagation_t*") int[] gradMode);

public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptor_v8(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t*") IntPointer compType,
                             @Cast("cudnnLossNormalizationMode_t*") IntPointer normMode,
                             @Cast("cudnnNanPropagation_t*") IntPointer gradMode,
                             IntPointer maxLabelLength);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptor_v8(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t*") IntBuffer compType,
                             @Cast("cudnnLossNormalizationMode_t*") IntBuffer normMode,
                             @Cast("cudnnNanPropagation_t*") IntBuffer gradMode,
                             IntBuffer maxLabelLength);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossDescriptor_v8(cudnnCTCLossStruct ctcLossDesc,
                             @Cast("cudnnDataType_t*") int[] compType,
                             @Cast("cudnnLossNormalizationMode_t*") int[] normMode,
                             @Cast("cudnnNanPropagation_t*") int[] gradMode,
                             int[] maxLabelLength);

public static native @Cast("cudnnStatus_t") int cudnnDestroyCTCLossDescriptor(cudnnCTCLossStruct ctcLossDesc);

/* return the ctc costs and gradients, given the probabilities and labels */
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const IntPointer hostLabels,
    @Const IntPointer hostLabelLengths,
    @Const IntPointer hostInputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    Pointer workspace,
    @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const IntBuffer hostLabels,
    @Const IntBuffer hostLabelLengths,
    @Const IntBuffer hostInputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    Pointer workspace,
    @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const int[] hostLabels,
    @Const int[] hostLabelLengths,
    @Const int[] hostInputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    Pointer workspace,
    @Cast("size_t") long workSpaceSizeInBytes); /* size of the workspace */

/* return the ctc costs and gradients, given the probabilities and labels */
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss_v8(
    cudnnContext handle,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const IntPointer labels,
    @Const IntPointer labelLengths,
    @Const IntPointer inputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("size_t") long workSpaceSizeInBytes,
    Pointer workspace);
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss_v8(
    cudnnContext handle,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const IntBuffer labels,
    @Const IntBuffer labelLengths,
    @Const IntBuffer inputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("size_t") long workSpaceSizeInBytes,
    Pointer workspace);
public static native @Cast("cudnnStatus_t") int cudnnCTCLoss_v8(
    cudnnContext handle,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    cudnnTensorStruct probsDesc,
    @Const Pointer probs,
    @Const int[] labels,
    @Const int[] labelLengths,
    @Const int[] inputLengths,
    Pointer costs,
    cudnnTensorStruct gradientsDesc,
    Pointer gradients,
    @Cast("size_t") long workSpaceSizeInBytes,
    Pointer workspace);            /* pointer to the workspace, in GPU memory */

/* return the workspace size needed for ctc */
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossWorkspaceSize(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    cudnnTensorStruct gradientsDesc,
    @Const IntPointer labels,
    @Const IntPointer labelLengths,
    @Const IntPointer inputLengths,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    @Cast("size_t*") SizeTPointer sizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossWorkspaceSize(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    cudnnTensorStruct gradientsDesc,
    @Const IntBuffer labels,
    @Const IntBuffer labelLengths,
    @Const IntBuffer inputLengths,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    @Cast("size_t*") SizeTPointer sizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossWorkspaceSize(
    cudnnContext handle,
    cudnnTensorStruct probsDesc,
    cudnnTensorStruct gradientsDesc,
    @Const int[] labels,
    @Const int[] labelLengths,
    @Const int[] inputLengths,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    @Cast("size_t*") SizeTPointer sizeInBytes); /* pointer to the returned workspace size */

/* return the workspace size needed for ctc */
public static native @Cast("cudnnStatus_t") int cudnnGetCTCLossWorkspaceSize_v8(
    cudnnContext handle,
    @Cast("cudnnCTCLossAlgo_t") int algo,
    cudnnCTCLossStruct ctcLossDesc,
    cudnnTensorStruct probsDesc,
    cudnnTensorStruct gradientsDesc,
    @Cast("size_t*") SizeTPointer sizeInBytes);                        /* pointer to the returned workspace size */

/*
 * \brief Cross-library version checker.
 * This function is implemented differently in each sub-library. Each sublib
 * checks whether its own version matches that of its dependencies.
 * \returns CUDNN_STATUS_SUCCESS if the version check passes,
 *          CUDNN_STATUS_VERSION_MISMATCH if the versions are inconsistent.
 */
public static native @Cast("cudnnStatus_t") int cudnnAdvTrainVersionCheck();

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_ADV_TRAIN_H_ */


// Parsed from <cudnn_cnn_infer.h>

/*
 * Copyright 1993-2020 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*
 *  cudnn_cnn_infer : cuDNN's basic definitions and inference CNN functions.
 */

// #if !defined(CUDNN_CNN_INFER_H_)
// #define CUDNN_CNN_INFER_H_

// #pragma once
// #include <cuda_runtime.h>
// #include <stdint.h>

// #include "cudnn_version.h"
// #include "cudnn_ops_infer.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_CNN_INFER_MAJOR = 8;
public static final int CUDNN_CNN_INFER_MINOR = 1;
public static final int CUDNN_CNN_INFER_PATCH = 1;

// #if (CUDNN_CNN_INFER_MAJOR != CUDNN_MAJOR) || (CUDNN_CNN_INFER_MINOR != CUDNN_MINOR) ||
//     (CUDNN_CNN_INFER_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN CNN INFER!!!
// #endif

// #if defined(__cplusplus)
// Targeting ../cudnn/cudnnConvolutionStruct.java



/*
 *  convolution mode
 */
/** enum cudnnConvolutionMode_t */
public static final int CUDNN_CONVOLUTION = 0, CUDNN_CROSS_CORRELATION = 1;

/*
 * CUDNN Reorder
 */
/** enum cudnnReorderType_t */
public static final int
    CUDNN_DEFAULT_REORDER = 0,
    CUDNN_NO_REORDER      = 1;
// Targeting ../cudnn/cudnnConvolutionFwdAlgoPerf_t.java



/* Create an instance of convolution descriptor */
public static native @Cast("cudnnStatus_t") int cudnnCreateConvolutionDescriptor(@ByPtrPtr cudnnConvolutionStruct convDesc);

/* Destroy an instance of convolution descriptor */
public static native @Cast("cudnnStatus_t") int cudnnDestroyConvolutionDescriptor(cudnnConvolutionStruct convDesc);

public static native @Cast("cudnnStatus_t") int cudnnSetConvolutionMathType(cudnnConvolutionStruct convDesc, @Cast("cudnnMathType_t") int mathType);

public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionMathType(cudnnConvolutionStruct convDesc, @Cast("cudnnMathType_t*") IntPointer mathType);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionMathType(cudnnConvolutionStruct convDesc, @Cast("cudnnMathType_t*") IntBuffer mathType);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionMathType(cudnnConvolutionStruct convDesc, @Cast("cudnnMathType_t*") int[] mathType);

public static native @Cast("cudnnStatus_t") int cudnnSetConvolutionGroupCount(cudnnConvolutionStruct convDesc, int groupCount);

public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionGroupCount(cudnnConvolutionStruct convDesc, IntPointer groupCount);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionGroupCount(cudnnConvolutionStruct convDesc, IntBuffer groupCount);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionGroupCount(cudnnConvolutionStruct convDesc, int[] groupCount);

public static native @Cast("cudnnStatus_t") int cudnnSetConvolutionReorderType(cudnnConvolutionStruct convDesc, @Cast("cudnnReorderType_t") int reorderType);

public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionReorderType(cudnnConvolutionStruct convDesc, @Cast("cudnnReorderType_t*") IntPointer reorderType);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionReorderType(cudnnConvolutionStruct convDesc, @Cast("cudnnReorderType_t*") IntBuffer reorderType);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionReorderType(cudnnConvolutionStruct convDesc, @Cast("cudnnReorderType_t*") int[] reorderType);

public static native @Cast("cudnnStatus_t") int cudnnSetConvolution2dDescriptor(cudnnConvolutionStruct convDesc,
                                int pad_h,
                                int pad_w,
                                int u,
                                int v,
                                int dilation_h,
                                int dilation_w,
                                @Cast("cudnnConvolutionMode_t") int mode,
                                @Cast("cudnnDataType_t") int computeType);

public static native @Cast("cudnnStatus_t") int cudnnGetConvolution2dDescriptor(cudnnConvolutionStruct convDesc,
                                IntPointer pad_h,
                                IntPointer pad_w,
                                IntPointer u,
                                IntPointer v,
                                IntPointer dilation_h,
                                IntPointer dilation_w,
                                @Cast("cudnnConvolutionMode_t*") IntPointer mode,
                                @Cast("cudnnDataType_t*") IntPointer computeType);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolution2dDescriptor(cudnnConvolutionStruct convDesc,
                                IntBuffer pad_h,
                                IntBuffer pad_w,
                                IntBuffer u,
                                IntBuffer v,
                                IntBuffer dilation_h,
                                IntBuffer dilation_w,
                                @Cast("cudnnConvolutionMode_t*") IntBuffer mode,
                                @Cast("cudnnDataType_t*") IntBuffer computeType);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolution2dDescriptor(cudnnConvolutionStruct convDesc,
                                int[] pad_h,
                                int[] pad_w,
                                int[] u,
                                int[] v,
                                int[] dilation_h,
                                int[] dilation_w,
                                @Cast("cudnnConvolutionMode_t*") int[] mode,
                                @Cast("cudnnDataType_t*") int[] computeType);

public static native @Cast("cudnnStatus_t") int cudnnSetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLength,
                                @Const IntPointer padA,
                                @Const IntPointer filterStrideA,
                                @Const IntPointer dilationA,
                                @Cast("cudnnConvolutionMode_t") int mode,
                                @Cast("cudnnDataType_t") int computeType);
public static native @Cast("cudnnStatus_t") int cudnnSetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLength,
                                @Const IntBuffer padA,
                                @Const IntBuffer filterStrideA,
                                @Const IntBuffer dilationA,
                                @Cast("cudnnConvolutionMode_t") int mode,
                                @Cast("cudnnDataType_t") int computeType);
public static native @Cast("cudnnStatus_t") int cudnnSetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLength,
                                @Const int[] padA,
                                @Const int[] filterStrideA,
                                @Const int[] dilationA,
                                @Cast("cudnnConvolutionMode_t") int mode,
                                @Cast("cudnnDataType_t") int computeType); /* convolution data type */

/* Helper function to return the dimensions of the output tensor given a convolution descriptor */
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLengthRequested,
                                IntPointer arrayLength,
                                IntPointer padA,
                                IntPointer strideA,
                                IntPointer dilationA,
                                @Cast("cudnnConvolutionMode_t*") IntPointer mode,
                                @Cast("cudnnDataType_t*") IntPointer computeType);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLengthRequested,
                                IntBuffer arrayLength,
                                IntBuffer padA,
                                IntBuffer strideA,
                                IntBuffer dilationA,
                                @Cast("cudnnConvolutionMode_t*") IntBuffer mode,
                                @Cast("cudnnDataType_t*") IntBuffer computeType);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionNdDescriptor(cudnnConvolutionStruct convDesc,
                                int arrayLengthRequested,
                                int[] arrayLength,
                                int[] padA,
                                int[] strideA,
                                int[] dilationA,
                                @Cast("cudnnConvolutionMode_t*") int[] mode,
                                @Cast("cudnnDataType_t*") int[] computeType); /* convolution data type */

public static native @Cast("cudnnStatus_t") int cudnnGetConvolution2dForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      IntPointer n,
                                      IntPointer c,
                                      IntPointer h,
                                      IntPointer w);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolution2dForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      IntBuffer n,
                                      IntBuffer c,
                                      IntBuffer h,
                                      IntBuffer w);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolution2dForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      int[] n,
                                      int[] c,
                                      int[] h,
                                      int[] w);

/* Helper function to return the dimensions of the output tensor given a convolution descriptor */
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionNdForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      int nbDims,
                                      IntPointer tensorOuputDimA);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionNdForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      int nbDims,
                                      IntBuffer tensorOuputDimA);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionNdForwardOutputDim(cudnnConvolutionStruct convDesc,
                                      cudnnTensorStruct inputTensorDesc,
                                      cudnnFilterStruct filterDesc,
                                      int nbDims,
                                      int[] tensorOuputDimA);

/* helper function to provide the convolution forward algo that fit best the requirement */
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionForwardAlgorithmMaxCount(cudnnContext handle, IntPointer count);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionForwardAlgorithmMaxCount(cudnnContext handle, IntBuffer count);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionForwardAlgorithmMaxCount(cudnnContext handle, int[] count);

public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionForwardAlgorithm_v7(cudnnContext handle,
                                       cudnnTensorStruct srcDesc,
                                       cudnnFilterStruct filterDesc,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct destDesc,
                                       int requestedAlgoCount,
                                       IntPointer returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionForwardAlgorithm_v7(cudnnContext handle,
                                       cudnnTensorStruct srcDesc,
                                       cudnnFilterStruct filterDesc,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct destDesc,
                                       int requestedAlgoCount,
                                       IntBuffer returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionForwardAlgorithm_v7(cudnnContext handle,
                                       cudnnTensorStruct srcDesc,
                                       cudnnFilterStruct filterDesc,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct destDesc,
                                       int requestedAlgoCount,
                                       int[] returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults);

public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionForwardAlgorithm(cudnnContext handle,
                                     cudnnTensorStruct xDesc,
                                     cudnnFilterStruct wDesc,
                                     cudnnConvolutionStruct convDesc,
                                     cudnnTensorStruct yDesc,
                                     int requestedAlgoCount,
                                     IntPointer returnedAlgoCount,
                                     cudnnConvolutionFwdAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionForwardAlgorithm(cudnnContext handle,
                                     cudnnTensorStruct xDesc,
                                     cudnnFilterStruct wDesc,
                                     cudnnConvolutionStruct convDesc,
                                     cudnnTensorStruct yDesc,
                                     int requestedAlgoCount,
                                     IntBuffer returnedAlgoCount,
                                     cudnnConvolutionFwdAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionForwardAlgorithm(cudnnContext handle,
                                     cudnnTensorStruct xDesc,
                                     cudnnFilterStruct wDesc,
                                     cudnnConvolutionStruct convDesc,
                                     cudnnTensorStruct yDesc,
                                     int requestedAlgoCount,
                                     int[] returnedAlgoCount,
                                     cudnnConvolutionFwdAlgoPerf_t perfResults);

public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionForwardAlgorithmEx(cudnnContext handle,
                                       cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct yDesc,
                                       Pointer y,
                                       int requestedAlgoCount,
                                       IntPointer returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults,
                                       Pointer workSpace,
                                       @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionForwardAlgorithmEx(cudnnContext handle,
                                       cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct yDesc,
                                       Pointer y,
                                       int requestedAlgoCount,
                                       IntBuffer returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults,
                                       Pointer workSpace,
                                       @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionForwardAlgorithmEx(cudnnContext handle,
                                       cudnnTensorStruct xDesc,
                                       @Const Pointer x,
                                       cudnnFilterStruct wDesc,
                                       @Const Pointer w,
                                       cudnnConvolutionStruct convDesc,
                                       cudnnTensorStruct yDesc,
                                       Pointer y,
                                       int requestedAlgoCount,
                                       int[] returnedAlgoCount,
                                       cudnnConvolutionFwdAlgoPerf_t perfResults,
                                       Pointer workSpace,
                                       @Cast("size_t") long workSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnIm2Col(cudnnContext handle,
            cudnnTensorStruct xDesc,
            @Const Pointer x,
            cudnnFilterStruct wDesc,
            cudnnConvolutionStruct convDesc,
            Pointer colBuffer);

public static native @Cast("cudnnStatus_t") int cudnnReorderFilterAndBias(cudnnContext handle,
                          cudnnFilterStruct filterDesc,
                          @Cast("cudnnReorderType_t") int reorderType,
                          @Const Pointer filterData,
                          Pointer reorderedFilterData,
                          int reorderBias,
                          @Const Pointer biasData,
                          Pointer reorderedBiasData);

/* Helper function to return the minimum size of the workspace to be passed to the convolution given an algo*/
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionForwardWorkspaceSize(cudnnContext handle,
                                        cudnnTensorStruct xDesc,
                                        cudnnFilterStruct wDesc,
                                        cudnnConvolutionStruct convDesc,
                                        cudnnTensorStruct yDesc,
                                        @Cast("cudnnConvolutionFwdAlgo_t") int algo,
                                        @Cast("size_t*") SizeTPointer sizeInBytes);

/* Convolution functions: All of the form "output = alpha * Op(inputs) + beta * output" */

/* Function to perform the forward pass for batch convolution */
public static native @Cast("cudnnStatus_t") int cudnnConvolutionForward(cudnnContext handle,
                        @Const Pointer alpha,
                        cudnnTensorStruct xDesc,
                        @Const Pointer x,
                        cudnnFilterStruct wDesc,
                        @Const Pointer w,
                        cudnnConvolutionStruct convDesc,
                        @Cast("cudnnConvolutionFwdAlgo_t") int algo,
                        Pointer workSpace,
                        @Cast("size_t") long workSpaceSizeInBytes,
                        @Const Pointer beta,
                        cudnnTensorStruct yDesc,
                        Pointer y);

/* Fused conv/bias/activation operation : y = Act( alpha1 * conv(x) + alpha2 * z + bias ) */
public static native @Cast("cudnnStatus_t") int cudnnConvolutionBiasActivationForward(cudnnContext handle,
                                      @Const Pointer alpha1,
                                      cudnnTensorStruct xDesc,
                                      @Const Pointer x,
                                      cudnnFilterStruct wDesc,
                                      @Const Pointer w,
                                      cudnnConvolutionStruct convDesc,
                                      @Cast("cudnnConvolutionFwdAlgo_t") int algo,
                                      Pointer workSpace,
                                      @Cast("size_t") long workSpaceSizeInBytes,
                                      @Const Pointer alpha2,
                                      cudnnTensorStruct zDesc,
                                      @Const Pointer z,
                                      cudnnTensorStruct biasDesc,
                                      @Const Pointer bias,
                                      cudnnActivationStruct activationDesc,
                                      cudnnTensorStruct yDesc,
                                      Pointer y);
// Targeting ../cudnn/cudnnConvolutionBwdDataAlgoPerf_t.java



public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardDataAlgorithmMaxCount(cudnnContext handle, IntPointer count);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardDataAlgorithmMaxCount(cudnnContext handle, IntBuffer count);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardDataAlgorithmMaxCount(cudnnContext handle, int[] count);

public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardDataAlgorithm(cudnnContext handle,
                                          cudnnFilterStruct wDesc,
                                          cudnnTensorStruct dyDesc,
                                          cudnnConvolutionStruct convDesc,
                                          cudnnTensorStruct dxDesc,
                                          int requestedAlgoCount,
                                          IntPointer returnedAlgoCount,
                                          cudnnConvolutionBwdDataAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardDataAlgorithm(cudnnContext handle,
                                          cudnnFilterStruct wDesc,
                                          cudnnTensorStruct dyDesc,
                                          cudnnConvolutionStruct convDesc,
                                          cudnnTensorStruct dxDesc,
                                          int requestedAlgoCount,
                                          IntBuffer returnedAlgoCount,
                                          cudnnConvolutionBwdDataAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardDataAlgorithm(cudnnContext handle,
                                          cudnnFilterStruct wDesc,
                                          cudnnTensorStruct dyDesc,
                                          cudnnConvolutionStruct convDesc,
                                          cudnnTensorStruct dxDesc,
                                          int requestedAlgoCount,
                                          int[] returnedAlgoCount,
                                          cudnnConvolutionBwdDataAlgoPerf_t perfResults);

public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardDataAlgorithmEx(cudnnContext handle,
                                            cudnnFilterStruct wDesc,
                                            @Const Pointer w,
                                            cudnnTensorStruct dyDesc,
                                            @Const Pointer dy,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct dxDesc,
                                            Pointer dx,
                                            int requestedAlgoCount,
                                            IntPointer returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults,
                                            Pointer workSpace,
                                            @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardDataAlgorithmEx(cudnnContext handle,
                                            cudnnFilterStruct wDesc,
                                            @Const Pointer w,
                                            cudnnTensorStruct dyDesc,
                                            @Const Pointer dy,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct dxDesc,
                                            Pointer dx,
                                            int requestedAlgoCount,
                                            IntBuffer returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults,
                                            Pointer workSpace,
                                            @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardDataAlgorithmEx(cudnnContext handle,
                                            cudnnFilterStruct wDesc,
                                            @Const Pointer w,
                                            cudnnTensorStruct dyDesc,
                                            @Const Pointer dy,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct dxDesc,
                                            Pointer dx,
                                            int requestedAlgoCount,
                                            int[] returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults,
                                            Pointer workSpace,
                                            @Cast("size_t") long workSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardDataAlgorithm_v7(cudnnContext handle,
                                            cudnnFilterStruct filterDesc,
                                            cudnnTensorStruct diffDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct gradDesc,
                                            int requestedAlgoCount,
                                            IntPointer returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardDataAlgorithm_v7(cudnnContext handle,
                                            cudnnFilterStruct filterDesc,
                                            cudnnTensorStruct diffDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct gradDesc,
                                            int requestedAlgoCount,
                                            IntBuffer returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardDataAlgorithm_v7(cudnnContext handle,
                                            cudnnFilterStruct filterDesc,
                                            cudnnTensorStruct diffDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnTensorStruct gradDesc,
                                            int requestedAlgoCount,
                                            int[] returnedAlgoCount,
                                            cudnnConvolutionBwdDataAlgoPerf_t perfResults);

/*
 *  convolution algorithm (which requires potentially some workspace)
 */

/* Helper function to return the minimum size of the workspace to be passed to the convolution given an algo*/
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardDataWorkspaceSize(cudnnContext handle,
                                             cudnnFilterStruct wDesc,
                                             cudnnTensorStruct dyDesc,
                                             cudnnConvolutionStruct convDesc,
                                             cudnnTensorStruct dxDesc,
                                             @Cast("cudnnConvolutionBwdDataAlgo_t") int algo,
                                             @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnConvolutionBackwardData(cudnnContext handle,
                             @Const Pointer alpha,
                             cudnnFilterStruct wDesc,
                             @Const Pointer w,
                             cudnnTensorStruct dyDesc,
                             @Const Pointer dy,
                             cudnnConvolutionStruct convDesc,
                             @Cast("cudnnConvolutionBwdDataAlgo_t") int algo,
                             Pointer workSpace,
                             @Cast("size_t") long workSpaceSizeInBytes,
                             @Const Pointer beta,
                             cudnnTensorStruct dxDesc,
                             Pointer dx);

/* Helper function to calculate folding descriptors for dgrad */
public static native @Cast("cudnnStatus_t") int cudnnGetFoldedConvBackwardDataDescriptors(cudnnContext handle,
                                          cudnnFilterStruct filterDesc,
                                          cudnnTensorStruct diffDesc,
                                          cudnnConvolutionStruct convDesc,
                                          cudnnTensorStruct gradDesc,
                                          @Cast("const cudnnTensorFormat_t") int transformFormat,
                                          cudnnFilterStruct foldedFilterDesc,
                                          cudnnTensorStruct paddedDiffDesc,
                                          cudnnConvolutionStruct foldedConvDesc,
                                          cudnnTensorStruct foldedGradDesc,
                                          cudnnTensorTransformStruct filterFoldTransDesc,
                                          cudnnTensorTransformStruct diffPadTransDesc,
                                          cudnnTensorTransformStruct gradFoldTransDesc,
                                          cudnnTensorTransformStruct gradUnfoldTransDesc);
// Targeting ../cudnn/cudnnFusedOpsConstParamStruct.java


// Targeting ../cudnn/cudnnFusedOpsVariantParamStruct.java


// Targeting ../cudnn/cudnnFusedOpsPlanStruct.java



/** enum cudnnFusedOps_t */
public static final int
    /* each op in [ ] can be disabled by passing NULL ptr */
    /* [per channel scale], [per channel bias], [activation], convolution, [generate BN stats] */
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_CONV_BNSTATS = 0,
    /* [per channel scale], [per channel bias], [activation], convolutionBackwardWeights */
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_WGRAD = 1,
    /* utility for BN training in BN-conv fusion */
    /* computes the equivalent scale and bias from ySum ySqSum and learned scale, bias */
    /* optionally update running stats and generate saved stats */
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_TRAINING = 2,
    /* utility for BN inference in BN-conv fusion */
    /* computes the equivalent scale and bias from learned running stats and learned scale, bias */
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_INFERENCE = 3,
    /* reserved for future use: convolution, [per channel scale], [per channel bias], [residual add], [activation] */
    CUDNN_FUSED_CONV_SCALE_BIAS_ADD_ACTIVATION = 4,
    /* reserved for future use: [per channel scale], [per channel bias], [residual add],  activation, bitmask */
    CUDNN_FUSED_SCALE_BIAS_ADD_ACTIVATION_GEN_BITMASK = 5,
    /* reserved for future use */
    CUDNN_FUSED_DACTIVATION_FORK_DBATCHNORM = 6;

/** enum cudnnFusedOpsConstParamLabel_t */
public static final int
    /* set XDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get XDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_XDESC = 0,
    /* set/get XDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_XDATA_PLACEHOLDER = 1,
    /* set/get BN_MODE: pass cudnnBatchNormMode_t* */
    CUDNN_PARAM_BN_MODE = 2,
    /* set CUDNN_PARAM_BN_EQSCALEBIAS_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get CUDNN_PARAM_BN_EQSCALEBIAS_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_BN_EQSCALEBIAS_DESC = 3,
    /* set/get BN_EQSCALE_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_EQSCALE_PLACEHOLDER = 4,
    /* set/get BN_EQBIAS_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_EQBIAS_PLACEHOLDER = 5,
    /* set ACTIVATION_DESC: pass previously initialized cudnnActivationDescriptor_t */
    /* get ACTIVATION_DESC: pass previously created cudnnActivationDescriptor_t */
    CUDNN_PARAM_ACTIVATION_DESC = 6,
    /* set CONV_DESC: pass previously initialized cudnnConvolutionDescriptor_t */
    /* get CONV_DESC: pass previously created cudnnConvolutionDescriptor_t */
    CUDNN_PARAM_CONV_DESC = 7,
    /* set WDESC: pass previously initialized cudnnFilterDescriptor_t */
    /* get WDESC: pass previously created cudnnFilterDescriptor_t */
    CUDNN_PARAM_WDESC = 8,
    /* set/get WDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_WDATA_PLACEHOLDER = 9,
    /* set DWDESC: pass previously initialized cudnnFilterDescriptor_t */
    /* get DWDESC: pass previously created cudnnFilterDescriptor_t */
    CUDNN_PARAM_DWDESC = 10,
    /* set/get DWDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_DWDATA_PLACEHOLDER = 11,
    /* set YDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get YDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_YDESC = 12,
    /* set/get YDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_YDATA_PLACEHOLDER = 13,
    /* set DYDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get DYDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_DYDESC = 14,
    /* set/get DYDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_DYDATA_PLACEHOLDER = 15,
    /* set YSTATS_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get YSTATS_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_YSTATS_DESC = 16,
    /* set/get YSUM_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_YSUM_PLACEHOLDER = 17,
    /* set/get YSQSUM_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_YSQSUM_PLACEHOLDER = 18,
    /* set CUDNN_PARAM_BN_SCALEBIAS_MEANVAR_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get CUDNN_PARAM_BN_SCALEBIAS_MEANVAR_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_BN_SCALEBIAS_MEANVAR_DESC = 19,
    /* set/get CUDNN_PARAM_BN_SCALE_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_SCALE_PLACEHOLDER = 20,
    /* set/get CUDNN_PARAM_BN_BIAS_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_BIAS_PLACEHOLDER = 21,
    /* set/get CUDNN_PARAM_BN_SAVED_MEAN_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_SAVED_MEAN_PLACEHOLDER = 22,
    /* set/get CUDNN_PARAM_BN_SAVED_INVSTD_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_SAVED_INVSTD_PLACEHOLDER = 23,
    /* set/get CUDNN_PARAM_BN_RUNNING_MEAN_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_RUNNING_MEAN_PLACEHOLDER = 24,
    /* set/get CUDNN_PARAM_BN_RUNNING_VAR_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_RUNNING_VAR_PLACEHOLDER = 25,

    /* set ZDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get ZDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_ZDESC = 26,
    /* set/get ZDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_ZDATA_PLACEHOLDER = 27,
    /* set BN_Z_EQSCALEBIAS_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get BN_Z_EQSCALEBIAS_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_BN_Z_EQSCALEBIAS_DESC = 28,
    /* set/get BN_Z_EQSCALE_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_Z_EQSCALE_PLACEHOLDER = 29,
    /* set/get BN_Z_EQBIAS_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_Z_EQBIAS_PLACEHOLDER = 30,

    /* set ACTIVATION_BITMASK_DESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get ACTIVATION_BITMASK_DESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_ACTIVATION_BITMASK_DESC = 31,
    /* set/get ACTIVATION_BITMASK_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_ACTIVATION_BITMASK_PLACEHOLDER = 32,

    /* set DXDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get DXDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_DXDESC = 33,
    /* set/get DXDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_DXDATA_PLACEHOLDER = 34,
    /* set DZDESC: pass previously initialized cudnnTensorDescriptor_t */
    /* get DZDESC: pass previously created cudnnTensorDescriptor_t */
    CUDNN_PARAM_DZDESC = 35,
    /* set/get DZDATA_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_DZDATA_PLACEHOLDER = 36,
    /* set/get CUDNN_PARAM_BN_DSCALE_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_DSCALE_PLACEHOLDER = 37,
    /* set/get CUDNN_PARAM_BN_DBIAS_PLACEHOLDER: pass cudnnFusedOpsPointerPlaceHolder_t* */
    CUDNN_PARAM_BN_DBIAS_PLACEHOLDER = 38;

/** enum cudnnFusedOpsPointerPlaceHolder_t */
public static final int
    CUDNN_PTR_NULL         = 0,
    CUDNN_PTR_ELEM_ALIGNED = 1,
    CUDNN_PTR_16B_ALIGNED  = 2;

/** enum cudnnFusedOpsVariantParamLabel_t */
public static final int
    /* set: pass void* pointing to dev memory */
    /* get: pass void** pointing to host memory */
    CUDNN_PTR_XDATA              = 0,
    CUDNN_PTR_BN_EQSCALE         = 1,
    CUDNN_PTR_BN_EQBIAS          = 2,
    CUDNN_PTR_WDATA              = 3,
    CUDNN_PTR_DWDATA             = 4,
    CUDNN_PTR_YDATA              = 5,
    CUDNN_PTR_DYDATA             = 6,
    CUDNN_PTR_YSUM               = 7,
    CUDNN_PTR_YSQSUM             = 8,
    CUDNN_PTR_WORKSPACE          = 9,
    CUDNN_PTR_BN_SCALE           = 10,
    CUDNN_PTR_BN_BIAS            = 11,
    CUDNN_PTR_BN_SAVED_MEAN      = 12,
    CUDNN_PTR_BN_SAVED_INVSTD    = 13,
    CUDNN_PTR_BN_RUNNING_MEAN    = 14,
    CUDNN_PTR_BN_RUNNING_VAR     = 15,
    CUDNN_PTR_ZDATA              = 16,
    CUDNN_PTR_BN_Z_EQSCALE       = 17,
    CUDNN_PTR_BN_Z_EQBIAS        = 18,
    CUDNN_PTR_ACTIVATION_BITMASK = 19,
    CUDNN_PTR_DXDATA             = 20,
    CUDNN_PTR_DZDATA             = 21,
    CUDNN_PTR_BN_DSCALE          = 22,
    CUDNN_PTR_BN_DBIAS           = 23,

    /* set/get: pass size_t* pointing to host memory */
    CUDNN_SCALAR_SIZE_T_WORKSPACE_SIZE_IN_BYTES = 100,
    /* set/get: pass int64_t* pointing to host memory */
    CUDNN_SCALAR_INT64_T_BN_ACCUMULATION_COUNT = 101,
    /* set/get: pass double* pointing to host memory */
    CUDNN_SCALAR_DOUBLE_BN_EXP_AVG_FACTOR = 102,
    /* set/get: pass double* pointing to host memory */
    CUDNN_SCALAR_DOUBLE_BN_EPSILON = 103;

public static native @Cast("cudnnStatus_t") int cudnnCnnInferVersionCheck();

// #if defined(__cplusplus)
// #endif

// #endif /* CUDNN_CNN_INFER_H_ */


// Parsed from <cudnn_cnn_train.h>

/*
 * Copyright 1993-2020 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */

/*
 *  cudnn_cnn_train : cuDNN's basic definitions and inference CNN functions.
 */

// #pragma once
// #include <cuda_runtime.h>
// #include <stdint.h>

// #include "cudnn_version.h"
// #include "cudnn_ops_infer.h"
// #include "cudnn_ops_train.h"
// #include "cudnn_cnn_infer.h"

/* These version numbers are autogenerated, do not edit manually. */
public static final int CUDNN_CNN_TRAIN_MAJOR = 8;
public static final int CUDNN_CNN_TRAIN_MINOR = 1;
public static final int CUDNN_CNN_TRAIN_PATCH = 1;

// #if (CUDNN_CNN_TRAIN_MAJOR != CUDNN_MAJOR) || (CUDNN_CNN_TRAIN_MINOR != CUDNN_MINOR) ||
//     (CUDNN_CNN_TRAIN_PATCH != CUDNN_PATCHLEVEL)
// #error Version mismatch in cuDNN CNN INFER!!!
// #endif

// #if defined(__cplusplus)
// Targeting ../cudnn/cudnnConvolutionBwdFilterAlgoPerf_t.java



public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(cudnnContext handle, IntPointer count);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(cudnnContext handle, IntBuffer count);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(cudnnContext handle, int[] count);

public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardFilterAlgorithm(cudnnContext handle,
                                            cudnnTensorStruct xDesc,
                                            cudnnTensorStruct dyDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnFilterStruct dwDesc,
                                            int requestedAlgoCount,
                                            IntPointer returnedAlgoCount,
                                            cudnnConvolutionBwdFilterAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardFilterAlgorithm(cudnnContext handle,
                                            cudnnTensorStruct xDesc,
                                            cudnnTensorStruct dyDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnFilterStruct dwDesc,
                                            int requestedAlgoCount,
                                            IntBuffer returnedAlgoCount,
                                            cudnnConvolutionBwdFilterAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardFilterAlgorithm(cudnnContext handle,
                                            cudnnTensorStruct xDesc,
                                            cudnnTensorStruct dyDesc,
                                            cudnnConvolutionStruct convDesc,
                                            cudnnFilterStruct dwDesc,
                                            int requestedAlgoCount,
                                            int[] returnedAlgoCount,
                                            cudnnConvolutionBwdFilterAlgoPerf_t perfResults);

public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardFilterAlgorithmEx(cudnnContext handle,
                                              cudnnTensorStruct xDesc,
                                              @Const Pointer x,
                                              cudnnTensorStruct dyDesc,
                                              @Const Pointer y,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct dwDesc,
                                              Pointer dw,
                                              int requestedAlgoCount,
                                              IntPointer returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults,
                                              Pointer workSpace,
                                              @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardFilterAlgorithmEx(cudnnContext handle,
                                              cudnnTensorStruct xDesc,
                                              @Const Pointer x,
                                              cudnnTensorStruct dyDesc,
                                              @Const Pointer y,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct dwDesc,
                                              Pointer dw,
                                              int requestedAlgoCount,
                                              IntBuffer returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults,
                                              Pointer workSpace,
                                              @Cast("size_t") long workSpaceSizeInBytes);
public static native @Cast("cudnnStatus_t") int cudnnFindConvolutionBackwardFilterAlgorithmEx(cudnnContext handle,
                                              cudnnTensorStruct xDesc,
                                              @Const Pointer x,
                                              cudnnTensorStruct dyDesc,
                                              @Const Pointer y,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct dwDesc,
                                              Pointer dw,
                                              int requestedAlgoCount,
                                              int[] returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults,
                                              Pointer workSpace,
                                              @Cast("size_t") long workSpaceSizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardFilterAlgorithm_v7(cudnnContext handle,
                                              cudnnTensorStruct srcDesc,
                                              cudnnTensorStruct diffDesc,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct gradDesc,
                                              int requestedAlgoCount,
                                              IntPointer returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardFilterAlgorithm_v7(cudnnContext handle,
                                              cudnnTensorStruct srcDesc,
                                              cudnnTensorStruct diffDesc,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct gradDesc,
                                              int requestedAlgoCount,
                                              IntBuffer returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults);
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardFilterAlgorithm_v7(cudnnContext handle,
                                              cudnnTensorStruct srcDesc,
                                              cudnnTensorStruct diffDesc,
                                              cudnnConvolutionStruct convDesc,
                                              cudnnFilterStruct gradDesc,
                                              int requestedAlgoCount,
                                              int[] returnedAlgoCount,
                                              cudnnConvolutionBwdFilterAlgoPerf_t perfResults);

/*
 *  convolution algorithm (which requires potentially some workspace)
 */

/* Helper function to return the minimum size of the workspace to be passed to the convolution given an algo*/
public static native @Cast("cudnnStatus_t") int cudnnGetConvolutionBackwardFilterWorkspaceSize(cudnnContext handle,
                                               cudnnTensorStruct xDesc,
                                               cudnnTensorStruct dyDesc,
                                               cudnnConvolutionStruct convDesc,
                                               cudnnFilterStruct gradDesc,
                                               @Cast("cudnnConvolutionBwdFilterAlgo_t") int algo,
                                               @Cast("size_t*") SizeTPointer sizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnConvolutionBackwardFilter(cudnnContext handle,
                               @Const Pointer alpha,
                               cudnnTensorStruct xDesc,
                               @Const Pointer x,
                               cudnnTensorStruct dyDesc,
                               @Const Pointer dy,
                               cudnnConvolutionStruct convDesc,
                               @Cast("cudnnConvolutionBwdFilterAlgo_t") int algo,
                               Pointer workSpace,
                               @Cast("size_t") long workSpaceSizeInBytes,
                               @Const Pointer beta,
                               cudnnFilterStruct dwDesc,
                               Pointer dw);

/* Function to compute the bias gradient for batch convolution */
public static native @Cast("cudnnStatus_t") int cudnnConvolutionBackwardBias(cudnnContext handle,
                             @Const Pointer alpha,
                             cudnnTensorStruct dyDesc,
                             @Const Pointer dy,
                             @Const Pointer beta,
                             cudnnTensorStruct dbDesc,
                             Pointer db);

public static native @Cast("cudnnStatus_t") int cudnnCreateFusedOpsConstParamPack(@ByPtrPtr cudnnFusedOpsConstParamStruct constPack, @Cast("cudnnFusedOps_t") int ops);

public static native @Cast("cudnnStatus_t") int cudnnDestroyFusedOpsConstParamPack(cudnnFusedOpsConstParamStruct constPack);

public static native @Cast("cudnnStatus_t") int cudnnSetFusedOpsConstParamPackAttribute(cudnnFusedOpsConstParamStruct constPack,
                                        @Cast("cudnnFusedOpsConstParamLabel_t") int paramLabel,
                                        @Const Pointer param);

public static native @Cast("cudnnStatus_t") int cudnnGetFusedOpsConstParamPackAttribute(cudnnFusedOpsConstParamStruct constPack,
                                        @Cast("cudnnFusedOpsConstParamLabel_t") int paramLabel,
                                        Pointer param,
                                        IntPointer isNULL);
public static native @Cast("cudnnStatus_t") int cudnnGetFusedOpsConstParamPackAttribute(cudnnFusedOpsConstParamStruct constPack,
                                        @Cast("cudnnFusedOpsConstParamLabel_t") int paramLabel,
                                        Pointer param,
                                        IntBuffer isNULL);
public static native @Cast("cudnnStatus_t") int cudnnGetFusedOpsConstParamPackAttribute(cudnnFusedOpsConstParamStruct constPack,
                                        @Cast("cudnnFusedOpsConstParamLabel_t") int paramLabel,
                                        Pointer param,
                                        int[] isNULL);

public static native @Cast("cudnnStatus_t") int cudnnCreateFusedOpsVariantParamPack(@ByPtrPtr cudnnFusedOpsVariantParamStruct varPack, @Cast("cudnnFusedOps_t") int ops);

public static native @Cast("cudnnStatus_t") int cudnnDestroyFusedOpsVariantParamPack(cudnnFusedOpsVariantParamStruct varPack);

public static native @Cast("cudnnStatus_t") int cudnnSetFusedOpsVariantParamPackAttribute(cudnnFusedOpsVariantParamStruct varPack,
                                          @Cast("cudnnFusedOpsVariantParamLabel_t") int paramLabel,
                                          Pointer ptr);

public static native @Cast("cudnnStatus_t") int cudnnGetFusedOpsVariantParamPackAttribute(cudnnFusedOpsVariantParamStruct varPack,
                                          @Cast("cudnnFusedOpsVariantParamLabel_t") int paramLabel,
                                          Pointer ptr);

public static native @Cast("cudnnStatus_t") int cudnnCreateFusedOpsPlan(@ByPtrPtr cudnnFusedOpsPlanStruct plan, @Cast("cudnnFusedOps_t") int ops);

public static native @Cast("cudnnStatus_t") int cudnnDestroyFusedOpsPlan(cudnnFusedOpsPlanStruct plan);

public static native @Cast("cudnnStatus_t") int cudnnMakeFusedOpsPlan(cudnnContext handle,
                      cudnnFusedOpsPlanStruct plan,
                      cudnnFusedOpsConstParamStruct constPack,
                      @Cast("size_t*") SizeTPointer workspaceSizeInBytes);

public static native @Cast("cudnnStatus_t") int cudnnFusedOpsExecute(cudnnContext handle, cudnnFusedOpsPlanStruct plan, cudnnFusedOpsVariantParamStruct varPack);

public static native @Cast("cudnnStatus_t") int cudnnCnnTrainVersionCheck();

// #if defined(__cplusplus)
// #endif


}
