// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
* Specifies the allocation properties for a allocation.
*/
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUmemAllocationProp extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUmemAllocationProp() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUmemAllocationProp(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUmemAllocationProp(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUmemAllocationProp position(long position) {
        return (CUmemAllocationProp)super.position(position);
    }
    @Override public CUmemAllocationProp getPointer(long i) {
        return new CUmemAllocationProp((Pointer)this).position(position + i);
    }

    /** Allocation type */
    public native @Cast("CUmemAllocationType") int type(); public native CUmemAllocationProp type(int setter);
    /** requested ::CUmemAllocationHandleType */
    public native @Cast("CUmemAllocationHandleType") int requestedHandleTypes(); public native CUmemAllocationProp requestedHandleTypes(int setter);
    /** Location of allocation */
    public native @ByRef CUmemLocation location(); public native CUmemAllocationProp location(CUmemLocation setter);
    /**
     * Windows-specific LPSECURITYATTRIBUTES required when
     * ::CU_MEM_HANDLE_TYPE_WIN32 is specified.  This security attribute defines
     * the scope of which exported allocations may be tranferred to other
     * processes.  In all other cases, this field is required to be zero.
     */
    public native Pointer win32HandleMetaData(); public native CUmemAllocationProp win32HandleMetaData(Pointer setter);
         /**
         * Allocation hint for requesting compressible memory.
         * On devices that support Compute Data Compression, compressible
         * memory can be used to accelerate accesses to data with unstructured
         * sparsity and other compressible data patterns. Applications are 
         * expected to query allocation property of the handle obtained with 
         * ::cuMemCreate using ::cuMemGetAllocationPropertiesFromHandle to 
         * validate if the obtained allocation is compressible or not. Note that 
         * compressed memory may not be mappable on all devices.
         */
         @Name("allocFlags.compressionType") public native @Cast("unsigned char") byte allocFlags_compressionType(); public native CUmemAllocationProp allocFlags_compressionType(byte setter);
         @Name("allocFlags.gpuDirectRDMACapable") public native @Cast("unsigned char") byte allocFlags_gpuDirectRDMACapable(); public native CUmemAllocationProp allocFlags_gpuDirectRDMACapable(byte setter);
         /** Bitmask indicating intended usage for this allocation */
         @Name("allocFlags.usage") public native @Cast("unsigned short") short allocFlags_usage(); public native CUmemAllocationProp allocFlags_usage(short setter);
         @Name("allocFlags.reserved") public native @Cast("unsigned char") byte allocFlags_reserved(int i); public native CUmemAllocationProp allocFlags_reserved(int i, byte setter);
         @Name("allocFlags.reserved") @MemberGetter public native @Cast("unsigned char*") BytePointer allocFlags_reserved();
}
