// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Specifies an access policy for a window, a contiguous extent of memory
 * beginning at base_ptr and ending at base_ptr + num_bytes.
 * num_bytes is limited by CU_DEVICE_ATTRIBUTE_MAX_ACCESS_POLICY_WINDOW_SIZE.
 * Partition into many segments and assign segments such that:
 * sum of "hit segments" / window == approx. ratio.
 * sum of "miss segments" / window == approx 1-ratio.
 * Segments and ratio specifications are fitted to the capabilities of
 * the architecture.
 * Accesses in a hit segment apply the hitProp access policy.
 * Accesses in a miss segment apply the missProp access policy.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUaccessPolicyWindow extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUaccessPolicyWindow() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUaccessPolicyWindow(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUaccessPolicyWindow(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUaccessPolicyWindow position(long position) {
        return (CUaccessPolicyWindow)super.position(position);
    }
    @Override public CUaccessPolicyWindow getPointer(long i) {
        return new CUaccessPolicyWindow((Pointer)this).position(position + i);
    }

    /** Starting address of the access policy window. CUDA driver may align it. */
    public native Pointer base_ptr(); public native CUaccessPolicyWindow base_ptr(Pointer setter);
    /** Size in bytes of the window policy. CUDA driver may restrict the maximum size and alignment. */
    public native @Cast("size_t") long num_bytes(); public native CUaccessPolicyWindow num_bytes(long setter);
    /** hitRatio specifies percentage of lines assigned hitProp, rest are assigned missProp. */
    public native float hitRatio(); public native CUaccessPolicyWindow hitRatio(float setter);
    /** ::CUaccessProperty set for hit. */
    public native @Cast("CUaccessProperty") int hitProp(); public native CUaccessPolicyWindow hitProp(int setter);
    /** ::CUaccessProperty set for miss. Must be either NORMAL or STREAMING */
    public native @Cast("CUaccessProperty") int missProp(); public native CUaccessPolicyWindow missProp(int setter);
}
