// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * CUDA array sparse properties
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUDA_ARRAY_SPARSE_PROPERTIES extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUDA_ARRAY_SPARSE_PROPERTIES() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUDA_ARRAY_SPARSE_PROPERTIES(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUDA_ARRAY_SPARSE_PROPERTIES(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUDA_ARRAY_SPARSE_PROPERTIES position(long position) {
        return (CUDA_ARRAY_SPARSE_PROPERTIES)super.position(position);
    }
    @Override public CUDA_ARRAY_SPARSE_PROPERTIES getPointer(long i) {
        return new CUDA_ARRAY_SPARSE_PROPERTIES((Pointer)this).position(position + i);
    }

        /** Width of sparse tile in elements */
        @Name("tileExtent.width") public native @Cast("unsigned int") int tileExtent_width(); public native CUDA_ARRAY_SPARSE_PROPERTIES tileExtent_width(int setter);
        /** Height of sparse tile in elements */
        @Name("tileExtent.height") public native @Cast("unsigned int") int tileExtent_height(); public native CUDA_ARRAY_SPARSE_PROPERTIES tileExtent_height(int setter);
        /** Depth of sparse tile in elements */
        @Name("tileExtent.depth") public native @Cast("unsigned int") int tileExtent_depth(); public native CUDA_ARRAY_SPARSE_PROPERTIES tileExtent_depth(int setter);

    /**
     * First mip level at which the mip tail begins.
     */
    public native @Cast("unsigned int") int miptailFirstLevel(); public native CUDA_ARRAY_SPARSE_PROPERTIES miptailFirstLevel(int setter);
    /**
     * Total size of the mip tail.
     */
    public native @Cast("unsigned long long") long miptailSize(); public native CUDA_ARRAY_SPARSE_PROPERTIES miptailSize(long setter);
    /**
     * Flags will either be zero or ::CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL
     */
    public native @Cast("unsigned int") int flags(); public native CUDA_ARRAY_SPARSE_PROPERTIES flags(int setter);
    public native @Cast("unsigned int") int reserved(int i); public native CUDA_ARRAY_SPARSE_PROPERTIES reserved(int i, int setter);
    @MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
}
