/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.dataforms;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.stanza.dataforms.DataForm;
import org.apache.vysper.xmpp.stanza.dataforms.DataFormEncoder;
import org.apache.vysper.xmpp.stanza.dataforms.Field;

public class VoiceRequestForm {
    private static final String TITLE = "Voice request";
    private static final String INSTRUCTION = "To approve this request for voice, select the \"Grant voice to this person?\" checkbox and click OK. To skip this request, click the cancel button.";
    private Entity requestor;
    private String nick;

    public VoiceRequestForm(Entity requestor, String nick) {
        this.requestor = requestor;
        this.nick = nick;
    }

    public DataForm createForm() {
        DataForm form = new DataForm();
        form.setType(DataForm.Type.submit);
        form.setTitle(TITLE);
        form.addInstruction(INSTRUCTION);
        form.addField(new Field("FORM_TYPE", Field.Type.HIDDEN, null, "http://jabber.org/protocol/muc#request"));
        form.addField(new Field("muc#jid", Field.Type.TEXT_SINGLE, "User ID", this.requestor.getFullQualifiedName()));
        form.addField(new Field("muc#roomnick", Field.Type.TEXT_SINGLE, "Room Nickname", this.nick));
        form.addField(new Field("muc#request_allow", Field.Type.BOOLEAN, "Grant voice to this person?", "false"));
        return form;
    }

    public XMLElement createFormXML() {
        return new DataFormEncoder().getXML(this.createForm());
    }
}

