/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import org.apache.tapestry5.ioc.util.UtilMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack<E> {
    private static final int MINIMUM_SIZE = 3;
    private static final int DEFAULT_ARRAY_SIZE = 20;
    private Object[] items;
    private int index = -1;

    public Stack() {
        this(20);
    }

    public Stack(int initialSize) {
        this.items = new Object[Math.max(initialSize, 3)];
    }

    public boolean isEmpty() {
        return this.index < 0;
    }

    public int getDepth() {
        return this.index + 1;
    }

    public void clear() {
        for (int i = 0; i <= this.index; ++i) {
            this.items[i] = null;
        }
        this.index = -1;
    }

    public void push(E item) {
        ++this.index;
        if (this.index == this.items.length) {
            int newCapacity = this.items.length * 3 / 2 + 1;
            Object[] newItems = new Object[newCapacity];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        this.items[this.index] = item;
    }

    public E pop() {
        this.checkIfEmpty();
        Object result = this.items[this.index];
        this.items[this.index] = null;
        --this.index;
        return (E)result;
    }

    private void checkIfEmpty() {
        if (this.index < 0) {
            throw new IllegalStateException(UtilMessages.stackIsEmpty());
        }
    }

    public E peek() {
        this.checkIfEmpty();
        return (E)this.items[this.index];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Stack[");
        for (int i = this.index; i >= 0; --i) {
            if (i != this.index) {
                builder.append(", ");
            }
            builder.append(String.valueOf(this.items[i]));
        }
        builder.append("]");
        return builder.toString();
    }

    public Object[] getSnapshot() {
        Object[] result = new Object[this.index + 1];
        System.arraycopy(this.items, 0, result, 0, this.index + 1);
        return result;
    }
}

