/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ExceptionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionInfoImpl
implements ExceptionInfo {
    private final String className;
    private final String message;
    private final Map<String, Object> properties;
    private final List<StackTraceElement> stackTrace;

    public ExceptionInfoImpl(Throwable t, Map<String, Object> properties, List<StackTraceElement> stackTrace) {
        this.className = t.getClass().getName();
        this.message = t.getMessage() != null ? t.getMessage() : "";
        this.properties = properties;
        this.stackTrace = Collections.unmodifiableList(stackTrace);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public List<String> getPropertyNames() {
        return InternalUtils.sortedKeys(this.properties);
    }

    @Override
    public List<StackTraceElement> getStackTrace() {
        return this.stackTrace;
    }
}

