/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javassist.CtClass;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.tapestry5.ioc.internal.services.CtClassSource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;

public class AnnotationMemberValueVisitor
implements MemberValueVisitor {
    private final ConstPool constPool;
    private final CtClassSource classSource;
    private final Object value;

    public AnnotationMemberValueVisitor(ConstPool constPool, CtClassSource classSource, Object value) {
        this.constPool = constPool;
        this.classSource = classSource;
        this.value = value;
    }

    public void visitAnnotationMemberValue(AnnotationMemberValue mb) {
        Method[] methods;
        Class annotationType = this.getClass(this.value);
        for (Method method : methods = annotationType.getDeclaredMethods()) {
            try {
                Object result = method.invoke(this.value, new Object[0]);
                MemberValue memberValue = javassist.bytecode.annotation.Annotation.createMemberValue((ConstPool)this.constPool, (CtClass)this.classSource.toCtClass(result.getClass()));
                memberValue.accept((MemberValueVisitor)new AnnotationMemberValueVisitor(this.constPool, this.classSource, result));
                mb.getValue().addMemberValue(method.getName(), memberValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void visitArrayMemberValue(ArrayMemberValue mb) {
        Object[] array = (Object[])this.value;
        List<MemberValue> members = CollectionFactory.newList();
        for (Object object : array) {
            try {
                MemberValue memberValue = javassist.bytecode.annotation.Annotation.createMemberValue((ConstPool)this.constPool, (CtClass)this.classSource.toCtClass(this.getClass(object)));
                memberValue.accept((MemberValueVisitor)new AnnotationMemberValueVisitor(this.constPool, this.classSource, object));
                members.add(memberValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        mb.setValue(members.toArray(new MemberValue[0]));
    }

    private Class getClass(Object object) {
        if (object instanceof Annotation) {
            return ((Annotation)object).annotationType();
        }
        return object.getClass();
    }

    public void visitBooleanMemberValue(BooleanMemberValue mb) {
        mb.setValue(((Boolean)this.value).booleanValue());
    }

    public void visitByteMemberValue(ByteMemberValue mb) {
        mb.setValue(((Byte)this.value).byteValue());
    }

    public void visitCharMemberValue(CharMemberValue mb) {
        mb.setValue(((Character)this.value).charValue());
    }

    public void visitDoubleMemberValue(DoubleMemberValue mb) {
        mb.setValue(((Double)this.value).doubleValue());
    }

    public void visitEnumMemberValue(EnumMemberValue mb) {
        Enum enumeration = (Enum)this.value;
        Class type = enumeration.getDeclaringClass();
        mb.setType(type.getName());
        mb.setValue(enumeration.name());
    }

    public void visitFloatMemberValue(FloatMemberValue mb) {
        mb.setValue(((Float)this.value).floatValue());
    }

    public void visitIntegerMemberValue(IntegerMemberValue mb) {
        mb.setValue(((Integer)this.value).intValue());
    }

    public void visitLongMemberValue(LongMemberValue mb) {
        mb.setValue(((Long)this.value).longValue());
    }

    public void visitShortMemberValue(ShortMemberValue mb) {
        mb.setValue(((Short)this.value).shortValue());
    }

    public void visitStringMemberValue(StringMemberValue mb) {
        mb.setValue((String)this.value);
    }

    public void visitClassMemberValue(ClassMemberValue mb) {
        mb.setValue(((Class)this.value).getName());
    }
}

