/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.ServiceActivity;
import org.apache.tapestry5.ioc.services.ServiceActivityScoreboard;
import org.apache.tapestry5.ioc.services.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceActivityTrackerImpl
implements ServiceActivityScoreboard,
ServiceActivityTracker {
    private final PerthreadManager perthreadManager;
    private final Map<String, MutableServiceActivity> serviceIdToServiceStatus = new TreeMap<String, MutableServiceActivity>();

    public ServiceActivityTrackerImpl(PerthreadManager perthreadManager) {
        this.perthreadManager = perthreadManager;
    }

    @Override
    public synchronized List<ServiceActivity> getServiceActivity() {
        List<ServiceActivity> result = CollectionFactory.newList();
        result.addAll(this.serviceIdToServiceStatus.values());
        return result;
    }

    void startup() {
    }

    void shutdown() {
    }

    @Override
    public synchronized void define(ServiceDef serviceDef, Status initialStatus) {
        this.serviceIdToServiceStatus.put(serviceDef.getServiceId(), new MutableServiceActivity(serviceDef, this.perthreadManager, initialStatus));
    }

    @Override
    public synchronized void setStatus(String serviceId, Status status) {
        this.serviceIdToServiceStatus.get(serviceId).setStatus(status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MutableServiceActivity
    implements ServiceActivity {
        private final ServiceDef serviceDef;
        private Status status;
        private final PerThreadValue<Status> perThreadStatus;

        public MutableServiceActivity(ServiceDef serviceDef, PerthreadManager perthreadManager, Status status) {
            this.serviceDef = serviceDef;
            if (serviceDef.getServiceScope().equals("perthread")) {
                this.perThreadStatus = perthreadManager.createValue();
                this.perThreadStatus.set(status);
                this.status = status;
            } else {
                this.perThreadStatus = null;
                this.status = status;
            }
        }

        @Override
        public String getServiceId() {
            return this.serviceDef.getServiceId();
        }

        @Override
        public Class getServiceInterface() {
            return this.serviceDef.getServiceInterface();
        }

        @Override
        public String getScope() {
            return this.serviceDef.getServiceScope();
        }

        @Override
        public Set<Class> getMarkers() {
            return this.serviceDef.getMarkers();
        }

        @Override
        public synchronized Status getStatus() {
            if (this.perThreadStatus != null) {
                if (!this.perThreadStatus.exists()) {
                    this.perThreadStatus.set(this.status);
                }
                return this.perThreadStatus.get();
            }
            return this.status;
        }

        synchronized void setStatus(Status status) {
            if (this.perThreadStatus != null) {
                this.perThreadStatus.set(status);
            } else {
                this.status = status;
            }
        }
    }
}

