/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.List;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.slf4j.Logger;

public class RegistryShutdownHubImpl
implements RegistryShutdownHub {
    private final OneShotLock lock = new OneShotLock();
    private final Logger logger;
    private final List<RegistryShutdownListener> listeners = CollectionFactory.newThreadSafeList();

    public RegistryShutdownHubImpl(Logger logger) {
        this.logger = logger;
    }

    public void addRegistryShutdownListener(RegistryShutdownListener listener) {
        this.lock.check();
        this.listeners.add(listener);
    }

    public void fireRegistryDidShutdown() {
        this.lock.lock();
        for (RegistryShutdownListener l : this.listeners) {
            try {
                l.registryDidShutdown();
            }
            catch (Exception ex) {
                this.logger.error(ServiceMessages.shutdownListenerError(l, ex), (Throwable)ex);
            }
        }
        this.listeners.clear();
    }
}

