/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.slf4j.Logger;

public class AbstractMethodInvokingInstrumenter {
    private final ModuleBuilderSource moduleSource;
    protected final Map<Class, Object> resourcesDefaults = CollectionFactory.newMap();
    private final ServiceResources resources;
    private final PlasticProxyFactory proxyFactory;
    protected final Method method;
    protected final Class serviceInterface;
    protected final String serviceId;
    private final Logger logger;

    public AbstractMethodInvokingInstrumenter(ModuleBuilderSource moduleSource, Method method, ServiceResources resources, PlasticProxyFactory proxyFactory) {
        this.moduleSource = moduleSource;
        this.method = method;
        this.resources = resources;
        this.proxyFactory = proxyFactory;
        this.serviceId = resources.getServiceId();
        this.resourcesDefaults.put(String.class, this.serviceId);
        this.resourcesDefaults.put(ObjectLocator.class, resources);
        this.resourcesDefaults.put(ServiceResources.class, resources);
        this.logger = resources.getLogger();
        this.resourcesDefaults.put(Logger.class, this.logger);
        this.serviceInterface = resources.getServiceInterface();
        this.resourcesDefaults.put(Class.class, this.serviceInterface);
        this.resourcesDefaults.put(OperationTracker.class, resources.getTracker());
    }

    public String toString() {
        return this.proxyFactory.getMethodLocation(this.method).toString();
    }

    private Object getModuleInstance() {
        return InternalUtils.isStatic(this.method) ? null : this.moduleSource.getModuleBuilder();
    }

    protected Object invoke(final InjectionResources injectionResources) {
        final String methodId = this.toString();
        String description = String.format("Invoking method %s", methodId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(description);
        }
        return this.resources.getTracker().invoke(description, new Invokable<Object>(){

            @Override
            public Object invoke() {
                Object result = null;
                Throwable failure = null;
                try {
                    Object[] parameters = InternalUtils.calculateParametersForMethod(AbstractMethodInvokingInstrumenter.this.method, AbstractMethodInvokingInstrumenter.this.resources, injectionResources, AbstractMethodInvokingInstrumenter.this.resources.getTracker());
                    result = AbstractMethodInvokingInstrumenter.this.method.invoke(AbstractMethodInvokingInstrumenter.this.getModuleInstance(), parameters);
                }
                catch (InvocationTargetException ite) {
                    failure = ite.getTargetException();
                }
                catch (Exception ex) {
                    failure = ex;
                }
                if (failure != null) {
                    throw new RuntimeException(String.format("Exception invoking method %s: %s", methodId, InternalUtils.toMessage(failure)), failure);
                }
                return result;
            }
        });
    }
}

