/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassFabUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritanceSearch
implements Iterator<Class>,
Iterable<Class> {
    private Class searchClass;
    private final Set<Class> addedInterfaces = CollectionFactory.newSet();
    private final LinkedList<Class> interfaceQueue = CollectionFactory.newLinkedList();
    private State state;

    public InheritanceSearch(Class searchClass) {
        this.searchClass = searchClass;
        this.queueInterfaces(searchClass);
        this.state = searchClass == Object.class ? State.INTERFACE : State.CLASS;
    }

    private void queueInterfaces(Class searchClass) {
        for (Class<?> intf : searchClass.getInterfaces()) {
            if (this.addedInterfaces.contains(intf)) continue;
            this.interfaceQueue.addLast(intf);
            this.addedInterfaces.add(intf);
        }
    }

    @Override
    public Iterator<Class> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.state != State.DONE;
    }

    @Override
    public Class next() {
        switch (this.state) {
            case CLASS: {
                Class result = this.searchClass;
                this.searchClass = this.parentOf(this.searchClass);
                if (this.searchClass == null) {
                    this.state = State.INTERFACE;
                } else {
                    this.queueInterfaces(this.searchClass);
                }
                return result;
            }
            case INTERFACE: {
                if (this.interfaceQueue.isEmpty()) {
                    this.state = State.DONE;
                    return Object.class;
                }
                Class intf = this.interfaceQueue.removeFirst();
                this.queueInterfaces(intf);
                return intf;
            }
        }
        throw new IllegalStateException();
    }

    private Class parentOf(Class clazz) {
        Class parent;
        if (clazz != Void.TYPE && clazz.isPrimitive()) {
            return ClassFabUtils.getWrapperType(clazz);
        }
        if (clazz.isArray() && clazz != Object[].class) {
            Class<?> componentType = clazz.getComponentType();
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
            }
            if (!componentType.isPrimitive()) {
                return Object[].class;
            }
        }
        return (parent = clazz.getSuperclass()) != Object.class ? parent : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        CLASS,
        INTERFACE,
        DONE;

    }
}

