/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ServiceLifecycle;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.internal.services.PerThreadServiceCreator;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.apache.tapestry5.ioc.services.PerthreadManager;

public class PerThreadServiceLifecycle
implements ServiceLifecycle {
    private static final String PER_THREAD_METHOD_NAME = "_perThreadInstance";
    private final PerthreadManager perthreadManager;
    private final ClassFactory classFactory;

    public PerThreadServiceLifecycle(@Builtin PerthreadManager perthreadManager, @Builtin ClassFactory classFactory) {
        this.perthreadManager = perthreadManager;
        this.classFactory = classFactory;
    }

    public boolean isSingleton() {
        return false;
    }

    public Object createService(ServiceResources resources, ObjectCreator creator) {
        Class proxyClass = this.createProxyClass(resources);
        PerThreadServiceCreator perThreadCreator = new PerThreadServiceCreator(this.perthreadManager, creator);
        try {
            Constructor<?> ctor = proxyClass.getConstructors()[0];
            return ctor.newInstance(perThreadCreator);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Class createProxyClass(ServiceResources resources) {
        Class serviceInterface = resources.getServiceInterface();
        ClassFab cf = this.classFactory.newClass(serviceInterface);
        cf.addField("_creator", 18, ObjectCreator.class);
        cf.addConstructor(new Class[]{ObjectCreator.class}, null, "_creator = $1;");
        String body = String.format("return (%s) _creator.createObject();", serviceInterface.getName());
        MethodSignature sig = new MethodSignature(serviceInterface, PER_THREAD_METHOD_NAME, null, null);
        cf.addMethod(2, sig, body);
        String toString = String.format("<PerThread Proxy for %s(%s)>", resources.getServiceId(), serviceInterface.getName());
        cf.proxyMethodsToDelegate(serviceInterface, "_perThreadInstance()", toString);
        return cf.createClass();
    }
}

