/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.DefaultImplementationBuilder;
import org.apache.tapestry5.ioc.services.MethodIterator;
import org.apache.tapestry5.ioc.services.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultImplementationBuilderImpl
implements DefaultImplementationBuilder {
    private final Map<Class, Object> cache = CollectionFactory.newConcurrentMap();
    private final ClassFactory classFactory;

    public DefaultImplementationBuilderImpl(@Builtin ClassFactory classFactory) {
        this.classFactory = classFactory;
    }

    @Override
    public <S> S createDefaultImplementation(Class<S> serviceInterface) {
        S instance = serviceInterface.cast(this.cache.get(serviceInterface));
        if (instance == null) {
            instance = this.createInstance(serviceInterface);
            this.cache.put(serviceInterface, instance);
        }
        return instance;
    }

    private <S> S createInstance(Class<S> serviceInterface) {
        Class<S> noopClass = this.createClass(serviceInterface);
        try {
            S instance = noopClass.newInstance();
            this.cache.put(serviceInterface, instance);
            return instance;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private <S> Class<S> createClass(Class<S> serviceInterface) {
        ClassFab cf = this.classFactory.newClass(serviceInterface);
        MethodIterator mi = new MethodIterator(serviceInterface);
        while (mi.hasNext()) {
            MethodSignature sig = mi.next();
            cf.addNoOpMethod(sig);
        }
        if (!mi.getToString()) {
            cf.addToString(String.format("<NoOp %s>", serviceInterface.getName()));
        }
        return cf.createClass();
    }
}

